############################################
############ Script for analysis ###########
############################################

#dir=directory with the results obtained with BayesX
#Packages:

library(splines)
library(survival)
library(lattice)
library(foreign)
library(mitools)
library(kmi)
library(mvna)
library(cmprsk)
library(etm)
library(survivalROC)
library(boot)
library(BayesX)
library(R2BayesX)

############################################
########### Exploratory analysis ###########
############################################


ExplMSM <- function (data1) {

	tra.prog=matrix(FALSE, 8, 8, dimnames=list(as.character(0:7), as.character(0:7)))
	tra.prog[1, c(2, 6:8)]=TRUE
	tra.prog[2, 3:5]=TRUE
	tra.prog
	m11=mvna(data1, c("0", "1", "2", "3", "4", "5", "6", "7"), tra.prog, "cens")
	m12=etm(data1, c("0", "1", "2", "3", "4", "5", "6", "7"), tra.prog,"cens", s = 0)
	
	windows()
	layout(matrix(c(1, 1, 1, 1, 2, 1, 3, 4, 5, 6, 7, 8), 2, 6, byrow = TRUE))
	plot(0, type="n", xlab=NULL, ylab=NULL, col.axis="white", col.lab="white", tck=0)
	box(col = "white")
	plot(m11, tr.choice = "0 1", conf.int = TRUE, xlab = "Time",  ylab = "Cumulative transition hazard", main = "Peritonitis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "0 5", conf.int = TRUE, xlab = "Time", ylab = "Cumulative transition hazard", main = "Death", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "0 6", conf.int = TRUE, xlab = "Time", ylab = "", main = "Transfer to haemodialysis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "0 7", conf.int = TRUE, xlab = "Time", ylab = "", main = "Renal transplant", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "1 2", conf.int = TRUE, xlab = "Time", ylab = "", main = "Death", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "1 3", conf.int = TRUE, xlab = "Time", ylab = "", main = "Transfer to haemodialysis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	plot(m11, tr.choice = "1 4", conf.int = TRUE, xlab = "Time", ylab = "", main = "Renal transplant", legend=FALSE, xlim = c(0, 100), ylim = c(0, 3))
	
	windows()
	layout(matrix(c(1, 1, 1, 1, 2, 1, 3, 4, 5, 6, 7, 8), 2, 6, byrow = TRUE))
	plot(0, type="n", xlab=NULL, ylab=NULL, col.axis="white", col.lab="white", tck=0)
	box(col = "white")
	plot(m12, tr.choice = "0 1", conf.int = TRUE, xlab = "Time", ylab = "Transition probability", main = "Peritonitis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))	
	plot(m12, tr.choice = "0 5", conf.int = TRUE, xlab = "Time", ylab = "Transition probability", main = "Death", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
	plot(m12, tr.choice = "0 6", conf.int = TRUE, xlab = "Time", ylab = "", main = "Transfer to haemodialysis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
	plot(m12, tr.choice = "0 7", conf.int = TRUE, xlab = "Time", ylab = "", main = "Renal transplant", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
	plot(m12, tr.choice = "1 2", conf.int = TRUE, xlab = "Time", ylab = "", main = "Death", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
	plot(m12, tr.choice = "1 3", conf.int = TRUE, xlab = "Time", ylab = "", main = "Transfer to haemodialysis", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
	plot(m12, tr.choice = "1 4", conf.int = TRUE, xlab = "Time", ylab = "", main = "Renal transplant", legend=FALSE, xlim = c(0, 100), ylim = c(0, 1))
}


############################################
########## Multivariate analysis ###########
############################################


MultMSM <- function(dir) {
	
	data_bas1=read.csv(paste(dir,"/","m1__f_end_logbaseline.res",sep=""), sep="")
	data_age1=read.csv(paste(dir,"/","m1__f_age_pspline.res",sep=""), sep="")
	data_bas2=read.csv(paste(dir,"/","m1__f_2_end_logbaseline.res",sep=""), sep="")
	data_age2=read.csv(paste(dir,"/","m1__f_2_age_pspline.res",sep=""), sep="")
	data_bas3=read.csv(paste(dir,"/","m1__f_2_end_logbaseline.res",sep=""), sep="")
	data_age3=read.csv(paste(dir,"/","m1__f_3_age_pspline.res",sep=""), sep="")
	data_bas4=read.csv(paste(dir,"/","m1__f_4_end_logbaseline.res",sep=""), sep="")
	data_age4=read.csv(paste(dir,"/","m1__f_4_age_pspline.res",sep=""), sep="")
	data_bas5=read.csv(paste(dir,"/","m1__f_5_end_logbaseline.res",sep=""), sep="")
	data_age5=read.csv(paste(dir,"/","m1__f_5_age_pspline.res",sep=""), sep="")
	data_bas6=read.csv(paste(dir,"/","m1__f_6_end_logbaseline.res",sep=""), sep="")
	data_age6=read.csv(paste(dir,"/","m1__f_6_age_pspline.res",sep=""), sep="")
	data_bas7=read.csv(paste(dir,"/","m1__f_7_end_logbaseline.res",sep=""), sep="")
	data_age7=read.csv(paste(dir,"/","m1__f_7_age_pspline.res",sep=""), sep="")
	
	windows()
	layout(matrix(c(1, 1, 1, 1, 2, 1, 3, 4, 5, 6, 7, 8), 2, 6, byrow = TRUE))
	plot(0, type="n", xlab=NULL, ylab=NULL, col.axis="white", col.lab="white", tck=0)
	box(col = "white")
	plot(data_age1$age,data_age1$ci95lowerref, type="l", xlab="Age", ylab="Log Hazard Ratio",xlim=c(10,90), ylim=c(-8,4), col = "white", main="Peritonitis")
	polygon(c(data_age1$age,rev(data_age1$age)), c(data_age1$ci95lowerref,rev(data_age1$ci95upperref)),col=8, lty=0)
	lines(data_age1$age, data_age1$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age5$age,data_age5$ci95lowerref, type="l", xlab="Age", ylab="Log Hazard Ratio", col.axis="white", xlim=c(10,90),ylim=c(-8,4), col = "white", main="Death")
	polygon(c(data_age5$age,rev(data_age5$age)), c(data_age5$ci95lowerref,rev(data_age5$ci95upperref)),col=8, lty=0)
	lines(data_age5$age, data_age5$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age6$age,data_age6$ci95lowerref, type="l", xlab="Age", ylab="", col.axis="white",xlim=c(10,90),ylim=c(-8,4), col = "white", main="Transfer to haemodialysis")
	polygon(c(data_age6$age,rev(data_age6$age)), c(data_age6$ci95lowerref,rev(data_age6$ci95upperref)),col=8, lty=0)
	lines(data_age6$age, data_age6$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age7$age,data_age7$ci95lowerref, type="l", xlab="Age", ylab="", col.axis="white",xlim=c(10,90),ylim=c(-8,4), col = "white", main="Renal tranplant")
	polygon(c(data_age7$age,rev(data_age7$age)), c(data_age7$ci95lowerref,rev(data_age7$ci95upperref)),col=8, lty=0)
	lines(data_age7$age, data_age7$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age2$age,data_age2$ci95lowerref, type="l", xlab="Age", ylab="", col.axis="white",xlim=c(10,90),ylim=c(-8,4), col = "white", main="Death")
	polygon(c(data_age2$age,rev(data_age2$age)), c(data_age2$ci95lowerref,rev(data_age2$ci95upperref)),col=8, lty=0)
	lines(data_age2$age, data_age2$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age3$age,data_age3$ci95lowerref, type="l", xlab="Age", ylab="", col.axis="white",xlim=c(10,90),ylim=c(-8,4), col = "white", main="Transfer to haemodialysis")
	polygon(c(data_age3$age,rev(data_age3$age)), c(data_age3$ci95lowerref,rev(data_age3$ci95upperref)),col=8, lty=0)
	lines(data_age3$age, data_age3$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_age4$age,data_age4$ci95lowerref, type="l", xlab="Age", ylab="", col.axis="white",xlim=c(10,90),ylim=c(-8,4), col = "white", main="Renal tranplant")
	polygon(c(data_age4$age,rev(data_age4$age)), c(data_age4$ci95lowerref,rev(data_age4$ci95upperref)),col=8, lty=0)
	lines(data_age4$age, data_age4$pmoderef)
	arrows(55, 4, 55, -8, length = 0.08)
	axis(1, at = c(20, 40, 55, 80),labels = expression(20, 40, 55, 80))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)

	windows()
	layout(matrix(c(1, 1, 1, 1, 2, 1, 3, 4, 5, 6, 7, 8), 2, 6, byrow = TRUE))
	plot(0, type="n", xlab=NULL, ylab=NULL, col.axis="white", col.lab="white", tck=0)
	box(col = "white")
	plot(data_bas1$end,data_bas1$ci95lowerref, type="l", xlab="Time",ylab="Log Hazard Ratio", col.axis="white",ylim=c(-4,2), col = "white", main="Peritonitis")
	polygon(c(data_bas1$end,rev(data_bas1$end)), c(data_bas1$ci95lowerref,rev(data_bas1$ci95upperref)),col=8, lty=0)
	lines(data_bas1$end, data_bas1$pmoderef)
	arrows(8, 2, 8, -4, length = 0.08)
	axis(1, at = c(0, 8, 20, 40, 60, 80, 100, 120, 140),labels = expression(0, 8, 20, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")	
	abline(h =0,  lty=3)
	plot(data_bas2$end,data_bas2$ci95lowerref, type="l", xlab="Time",ylab="Log Hazard Ratio", col.axis="white",ylim=c(-4,3), col = "white", main="Death")
	polygon(c(data_bas2$end,rev(data_bas2$end)), c(data_bas2$ci95lowerref,rev(data_bas2$ci95upperref)), col=8, lty=0)
	lines(data_bas2$end, data_bas2$pmoderef)
	arrows(17, 3, 17, -4, length = 0.08)
	axis(1, at = c(0, 17, 40, 60, 80, 100, 120, 140),labels = expression(0, 17, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_bas3$end,data_bas3$ci95lowerref, type="l", xlab="Time",ylab="", col.axis="white", ylim=c(-4,3), col = "white", main="Transfer to haemodialysis")
	polygon(c(data_bas3$end,rev(data_bas3$end)), c(data_bas3$ci95lowerref,rev(data_bas3$ci95upperref)),col=8, lty=0)
	lines(data_bas3$end, data_bas3$pmoderef)
	arrows(18, 3, 18, -4, length = 0.08)
	axis(1, at = c(0, 18, 40, 60, 80, 100, 120, 140), labels = expression(0, 18, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_bas4$end,data_bas4$ci95lowerref, type="l", xlab="Time",ylab="", col.axis="white",ylim=c(-4,3), col = "white", main="Renal transplant")
	polygon(c(data_bas4$end,rev(data_bas4$end)), c(data_bas4$ci95lowerref,rev(data_bas4$ci95upperref)),col=8, lty=0)
	lines(data_bas4$end, data_bas4$pmoderef)
	arrows(20, 3, 20, -4, length = 0.08)
	axis(1, at = c(0, 20, 40, 60, 80, 100, 120, 140),labels = expression(0, 20, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_bas5$end,data_bas5$ci95lowerref, type="l", xlab="Time",ylab="", col.axis="white",ylim=c(-4,3), col = "white", main="Death")
	polygon(c(data_bas5$end,rev(data_bas5$end)), c(data_bas5$ci95lowerref,rev(data_bas5$ci95upperref)),col=8, lty=0)
	lines(data_bas5$end, data_bas5$pmoderef)
	arrows(13, 3, 13, -4, length = 0.08)
	axis(1, at = c(0, 13, 40, 60, 80, 100, 120, 140),labels = expression(0, 13, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_bas6$end,data_bas6$ci95lowerref, type="l", xlab="Time",ylab="", col.axis="white",ylim=c(-4,3), col = "white", main="Transfer to haemodialysis")
	polygon(c(data_bas6$end,rev(data_bas6$end)), c(data_bas6$ci95lowerref,rev(data_bas6$ci95upperref)),col=8, lty=0)
	lines(data_bas6$end, data_bas6$pmoderef)
	arrows(12, 3, 12, -4, length = 0.08)
	axis(1, at = c(0, 12, 40, 60, 80, 100, 120, 140),labels = expression(0, 12, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)
	plot(data_bas7$end,data_bas7$ci95lowerref, type="l", xlab="Time",ylab="", col.axis="white",ylim=c(-4,3), col = "white", main="Renal transplant")
	polygon(c(data_bas7$end,rev(data_bas7$end)), c(data_bas7$ci95lowerref,rev(data_bas7$ci95upperref)),col=8, lty=0)
	lines(data_bas7$end, data_bas7$pmoderef)
	arrows(12, 3, 12, -4, length = 0.08)
	axis(1, at = c(0, 12, 40, 60, 80, 100, 120, 140),labels = expression(0, 12, 40, 60, 80, 100, 120, 140))
	axis(2, col.axis="black")
	abline(h =0,  lty=3)

}


############################################
##############   AUC Graphs  ###############
############################################

AUC <- function(data2, dir){

	data=as.data.frame(cbind(data2$end, data2$trans1, data2$trans2, data2$trans3, data2$trans4, data2$trans5, data2$trans6, data2$trans7, data2$sex, data2$diab, data2$first, data2$age))
	names(data)<-c("end","trans1","trans2","trans3","trans4","trans5","trans6","trans7","sex","diab","first","age")
	smooth.f<-as.data.frame(cbind(data2$age))
	names(smooth.f)<-c("age")

	linear.predictor <- function(model, data, smooth.f = NULL) {
		beta1 <- read.table(paste(model,"__FixedEffects.res",sep=""), header=TRUE)
		beta2 <- read.table(paste(model,"__FixedEffects_2.res",sep=""), header=TRUE)
		beta3 <- read.table(paste(model,"__FixedEffects_3.res",sep=""), header=TRUE)
		beta4 <- read.table(paste(model,"__FixedEffects_4.res",sep=""), header=TRUE)
		beta5 <- read.table(paste(model,"__FixedEffects_5.res",sep=""), header=TRUE)
		beta6 <- read.table(paste(model,"__FixedEffects_6.res",sep=""), header=TRUE)
		beta7 <- read.table(paste(model,"__FixedEffects_7.res",sep=""), header=TRUE)
		m1 <- data[, as.character(beta1$varname[-1])]
		m2 <- data[, as.character(beta2$varname[-1])]
		m3 <- data[, as.character(beta3$varname[-1])]
		m4 <- data[, as.character(beta4$varname[-1])]
		m5 <- data[, as.character(beta5$varname[-1])]
		m6 <- data[, as.character(beta6$varname[-1])]
		m7 <- data[, as.character(beta7$varname[-1])]
		lp1 <- as.matrix(m1)%*%beta1$pmode[-1]
		lp1 <- lp1 + beta1$pmode[1]
		lp2 <- as.matrix(m2)%*%beta2$pmode[-1]
		lp2 <- lp2 + beta2$pmode[1]
		lp3 <- as.matrix(m3)%*%beta3$pmode[-1]
		lp3 <- lp3 + beta3$pmode[1]
		lp4 <- as.matrix(m4)%*%beta4$pmode[-1]
		lp4 <- lp4 + beta4$pmode[1]
		lp5 <- as.matrix(m5)%*%beta5$pmode[-1]
		lp5 <- lp5 + beta5$pmode[1]
		lp6 <- as.matrix(m6)%*%beta6$pmode[-1]
		lp6 <- lp6 + beta6$pmode[1]
		lp7 <- as.matrix(m7)%*%beta7$pmode[-1]
		lp7 <- lp7 + beta7$pmode[1]
		if (!is.null(smooth.f))
			for (i in 1:length(smooth.f)) {
				cov1 <- read.table(paste(model,"__f_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf1 <- approxfun(cov1[,smooth.f[i]], cov1$pmode, yleft=min(cov1$pmode), yright=max(cov1$pmode))(data[,smooth.f[i]])
				lp1 <- lp1 + sf1
				cov2 <- read.table(paste(model,"__f_2_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf2 <- approxfun(cov2[,smooth.f[i]], cov2$pmode, yleft=min(cov2$pmode), yright=max(cov2$pmode))(data[,smooth.f[i]])
				lp2 <- lp2 + sf2
				cov3 <- read.table(paste(model,"__f_3_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf3 <- approxfun(cov3[,smooth.f[i]], cov3$pmode, yleft=min(cov3$pmode), yright=max(cov3$pmode))(data[,smooth.f[i]])
				lp3 <- lp3 + sf3
				cov4 <- read.table(paste(model,"__f_4_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf4 <- approxfun(cov4[,smooth.f[i]], cov4$pmode, yleft=min(cov4$pmode), yright=max(cov4$pmode))(data[,smooth.f[i]])
				lp4 <- lp4 + sf4
				cov5 <- read.table(paste(model,"__f_5_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf5 <- approxfun(cov5[,smooth.f[i]], cov5$pmode, yleft=min(cov5$pmode), yright=max(cov5$pmode))(data[,smooth.f[i]])
				lp5 <- lp5 + sf5
				cov6 <- read.table(paste(model,"__f_6_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf6 <- approxfun(cov6[,smooth.f[i]], cov6$pmode, yleft=min(cov6$pmode), yright=max(cov6$pmode))(data[,smooth.f[i]])
				lp6 <- lp6 + sf6
				cov7 <- read.table(paste(model,"__f_7_",smooth.f[i],"_pspline.res",sep=""), header=TRUE)
				sf7 <- approxfun(cov7[,smooth.f[i]], cov7$pmode, yleft=min(cov7$pmode), yright=max(cov7$pmode))(data[,smooth.f[i]])
				lp7 <- lp7 + sf7
			}
		lp=data.frame(lp1, lp2, lp3, lp4, lp5, lp6, lp7)
	}


	setwd(dir)
	times <- seq(min(data2$end),max(data2$end),by=1)
	aux1 <- function(d){
		eta1<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC1<-NULL
		for(t in times) {
			AUC1<-c(AUC1,survivalROC.C(Stime=d$end, status= d$trans1, marker=eta1$lp1, predict.time=t,span=0.05)$AUC)
		}
	AUC1
	}
	aux2 <- function(d){
		eta2<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC2<-NULL
		for(t in times) {
			AUC2<-c(AUC2,survivalROC.C(Stime=d$end, status= d$trans2, marker=eta2$lp2, predict.time=t,span=0.05)$AUC)
		}
	AUC2
	}
	aux3 <- function(d){
		eta3<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC3<-NULL
		for(t in times) {
			AUC3<-c(AUC3,survivalROC.C(Stime=d$end, status= d$trans3, marker=eta3$lp3, predict.time=t,span=0.05)$AUC)
		}
	AUC3
	}
	aux4 <- function(d){
		eta4<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC4<-NULL
		for(t in times) {
			AUC4<-c(AUC4,survivalROC.C(Stime=d$end, status= d$trans4, marker=eta4$lp4, predict.time=t,span=0.05)$AUC)
		}
	AUC4
	}
	aux5 <- function(d){
		eta5<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC5<-NULL
		for(t in times) {
			AUC5<-c(AUC5,survivalROC.C(Stime=d$end, status= d$trans5, marker=eta5$lp5, predict.time=t,span=0.05)$AUC)
		}
	AUC5
	}
	aux6 <- function(d){
		eta6<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC6<-NULL
		for(t in times) {
			AUC6<-c(AUC6,survivalROC.C(Stime=d$end, status= d$trans6, marker=eta6$lp6, predict.time=t,span=0.05)$AUC)
		}
	AUC6
	}
	aux7 <- function(d){
		eta7<- linear.predictor("m1", data = d, smooth.f = c("age"))
		AUC7<-NULL
		for(t in times) {
			AUC7<-c(AUC7,survivalROC.C(Stime=d$end, status= d$trans7, marker=eta7$lp7, predict.time=t,span=0.05)$AUC)
		}
	AUC7
	}
	
	data1.mod <- censboot(data,aux1,R=999)
	data1.env <- envelope(data1.mod,level=0.95)$point
	data2.mod <- censboot(data,aux2,R=999)
	data2.env <- envelope(data2.mod,level=0.95)$point
	data3.mod <- censboot(data,aux3,R=999)
	data3.env <- envelope(data3.mod,level=0.95)$point
	data4.mod <- censboot(data,aux4,R=999)
	data4.env <- envelope(data4.mod,level=0.95)$point
	data5.mod <- censboot(data,aux5,R=999)
	data5.env <- envelope(data5.mod,level=0.95)$point
	data6.mod <- censboot(data,aux6,R=999)
	data6.env <- envelope(data6.mod,level=0.95)$point
	data7.mod <- censboot(data,aux7,R=999)
	data7.env <- envelope(data7.mod,level=0.95)$point

	windows()	
	layout(matrix(c(1, 1, 1, 1, 2, 1, 3, 4, 5, 6, 7, 8), 2, 6, byrow = TRUE))
	plot(0, type="n", xlab=NULL, ylab=NULL, col.axis="white", col.lab="white", tck=0)
	box(col = "white")
	plot(times,data1.env[1,], xlab="Time", ylab="Temporal AUC",type="n",xlim=c(0, 100),ylim=c(0.2,1), main="Peritonitis")
	lines(times,data1.env[1,],lty=2)
	lines(times,data1.env[2,],lty=2)
	lines(times,data1.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data5.env[1,], xlab="Time", ylab="Temporal AUC",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Death")
	lines(times,data5.env[1,],lty=2)
	lines(times,data5.env[2,],lty=2)
	lines(times,data5.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data6.env[1,], xlab="Time", ylab="",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Transfer to haemodialysis")
	lines(times,data6.env[1,],lty=2)
	lines(times,data6.env[2,],lty=2)
	lines(times,data6.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data7.env[1,], xlab="Time", ylab="",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Renal transplant")
	lines(times,data7.env[1,],lty=2)
	lines(times,data7.env[2,],lty=2)
	lines(times,data7.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data2.env[1,], xlab="Time", ylab="",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Death")
	lines(times,data2.env[1,],lty=2)
	lines(times,data2.env[2,],lty=2)
	lines(times,data2.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data3.env[1,], xlab="Time", ylab="",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Transfer to haemodialysis")
	lines(times,data3.env[1,],lty=2)
	lines(times,data3.env[2,],lty=2)
	lines(times,data3.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
	plot(times,data4.env[1,], xlab="Time", ylab="",type="n",ylim=c(0.2,1), xlim=c(0, 100),main="Renal transplant")
	lines(times,data4.env[1,],lty=2)
	lines(times,data4.env[2,],lty=2)
	lines(times,data4.mod$t0,lty=1,lwd=1)
	abline(h=0.5)
}

