%This code calculates the probability of a win for each race%

% The inputs required to run this code are defined below%
% X is a matrix of observed values for the covariates in the model for each race (other than the score)%
% Y is a vector of observed outcomes for each race%
% alpha is the constant term, theta is the parameter estimate for the score.
% beta is a vector of the parameter estimates for other unknown parameters. 
% mean and tau are the meanX and standard devation for the true score respectively.

%Copyright (c) 2011-2016 Joanne L Bradley

%Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.%


function Probj= New_prob(X, Y,W,Sigma,alpha,theta,beta,meanX,tau)

% Code supplied from van Damme, G. (2010) was used to calculate the weights and abscissa for the n point Gauss Hermite Quadrature, which can be found at 
http://www.mathworks.com/matlabcentral/fileexchange/26737-legendre-laguerre-and-hermite-gauss-quadrature%

% define the weights and abscissa for n point Gaussian hermite quadrature%
[z w]=GaussHermite(30);

% define other unknown parameter estimates%
nraces=size(Y,1);
gpoints=size(z,1);

%Initialise variables
linpred = zeros(nraces, gpoints);
logit = zeros(nraces, gpoints);
measure = zeros(nraces, gpoints);

YWaj= zeros(nraces, gpoints);
Waj= zeros(nraces, gpoints);
YWj=zeros(nraces,1);
Wj=zeros(nraces,1);
Probj=zeros(nraces,1);

%Do something
do_model




%Calculate the log likelhood and first and second differentials%

    function do_model    

    for j=1:nraces
        %j
        for a=1:gpoints
   
        %Calculate logit%    
        linpred(j, a)= exp(alpha+(theta.*((sqrt(2)*tau*z(a))+meanX))+beta'*X(j,:)');
        logit(j,a)=linpred(j,a)/(1+linpred(j,a));
         
        %Calculate measure%  
        measure(j,a)=exp(-(( (W(j,1)-((sqrt(2)*tau*z(a))+meanX))^2)/(2*Sigma(j,1))));
        
        

        
       %Calculate probability for each weight and each race%
        YWaj(j,a)= w(a)*(logit(j,a)^Y(j,1))*((1-logit(j,a))^(1-Y(j,1)))*(1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
        
        Waj(j,a)= w(a)*(1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
        end

        %loglikehood and differentials at race level%
    
        YWj(j)=(sum(YWaj(j,:)))/(sqrt(3.14));
        Wj(j)=(sum(Waj(j,:)))/(sqrt(3.14));
        Probj(j)=YWj(j)/Wj(j);
        
   
     end
    end
end


