% This file and the file newton.m contains Matlab code to evaluate the likelihood numerically using 
Gaussain Hermite quadrature and determine the log-likelihood at its maximimum in order to determine 
the unknown parameters, using e.g. Newton-Raphson method%

%This file calculates the likelihood and first and second differentials of the likelihood wrt to each unknown parameter,
which are required to apply Newton-Raphson%

% The inputs required to run this code are defined below%
% X is a matrix of observed values for the covariates in the model for each race (other than the score). Columns for covariates, rows for races%
% Y is a vector of observed outcomes for each race%
% W is a vector of observed scores from model at previous stage%
% Sigma is a vector of the measurement error variance for each race%
% alpha is the constant term, theta is the parameter estimate for the score.
Inital values are those obtained by fitting sequential regression (NB: Use estimated score at previous stage from model 3.%
% beta is a vector of the parameter estimates for other unknown parameters. This code assumes there are 6 other 
unknown parameter estimates and needs to be adapted if this is not the case. Initial values are those obtained 
by the sequential regression.%
% mean and tau are the mean and standard devation for the true score respectively. The mean and standard deviation
of the estimated scores over all j observations provide initial values for mean and tau.%

%Copyright (c) 2011-2016 Joanne L Bradley

%Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.%

function S = measure_model(X, Y, W, sigma,alpha,theta,meanX,tau,beta)

% Code supplied from van Damme, G. (2010) was used to calculate the weights and abscissa for the n point Gauss Hermite 
Quadrature, which can be found at 
http://www.mathworks.com/matlabcentral/fileexchange/26737-legendre-laguerre-and-hermite-gauss-quadrature%


% define the weights and abscissa for n point Gaussian hermite quadrature%
[z w]=GaussHermite(35);

% define other unknown parameter estimates%
nraces=size(Y,1);
gpoints=size(z,1);
betapara=size(beta,1);

%Initialise variables
linpred = zeros(nraces, gpoints);
measure = zeros(nraces, gpoints);
logit = zeros(nraces, gpoints);

loglikeaj= zeros(nraces, gpoints);
loglikej=zeros(nraces,1);
likej=zeros(nraces,1);

dalphaaj =zeros(nraces,gpoints);
dalphaj =zeros(nraces,1);
dalphalikej =zeros(nraces,1);
%dalpha = [];

dthetaaj =zeros(nraces,gpoints);
dthetaj =zeros(nraces,1);
dthetalikej =zeros(nraces,1);
%dtheta = [];


dbetalikej =zeros(nraces,betapara);
%dbeta =zeros(betapara,1);

umeanaj=zeros(nraces,gpoints);
dumeanaj=zeros(nraces,gpoints);
vmeanaj=zeros(nraces,gpoints);
dvmeanaj=zeros(nraces,gpoints);
dmeanaj=zeros(nraces,gpoints);
dmeanj=zeros(nraces,1);
dmeanlikej=zeros(nraces,1);
%dmean= [];

utauaj=zeros(nraces ,gpoints);
dutauaj=zeros(nraces ,gpoints);
vtauaj=zeros(nraces ,gpoints);
dvtauaj=zeros(nraces ,gpoints);
dtauaj =zeros(nraces ,gpoints);
dtauj =zeros(nraces,1);
dtaulikej =zeros(nraces,1);
%dtau = [];

d2alphaaj =zeros(nraces,gpoints);
d2alphaj =zeros(nraces,1);
d2alphalikej =zeros(nraces,1);
%d2alpha = [];


d2alphathetaaj=zeros(nraces,gpoints);
d2alphathetaj=zeros(nraces,1);
d2alphathetalikej=zeros(nraces,1);
%d2alphatheta= [];

d2alphabetalikej=zeros(nraces,betapara);
%d2alphabeta=zeros(betapara,1);


ualphameanaj=zeros(nraces,gpoints);
dualphameanaj=zeros(nraces,gpoints);
valphameanaj=zeros(nraces,gpoints);
dvalphameanaj=zeros(nraces,gpoints);
d2alphameanaj=zeros(nraces,gpoints);
d2alphameanj=zeros(nraces,1);
d2alphameanlikej=zeros(nraces,1);
%d2alphamean= [];

ualphatauaj=zeros(nraces,gpoints);
dualphatauaj=zeros(nraces,gpoints);
valphatauaj=zeros(nraces,gpoints);
dvalphatauaj=zeros(nraces,gpoints);
d2alphatauaj=zeros(nraces,gpoints);
d2alphatauj=zeros(nraces,1);
d2alphataulikej=zeros(nraces,1);
%d2alphatau= [];

d2thetaaj =zeros(nraces,gpoints);
d2thetaj =zeros(nraces,1);
d2thetalikej =zeros(nraces,1);


d2thetabetalikej=zeros(nraces,1);
%d2thetabeta=zeros(betapara,1);

uthetameanaj=zeros(nraces,gpoints); 
duthetameanaj=zeros(nraces,gpoints);
vthetameanaj=zeros(nraces,gpoints);
dvthetameanaj=zeros(nraces,gpoints);
d2thetameanaj=zeros(nraces,gpoints);
d2thetameanj=zeros(nraces,1);
d2thetameanlikej =zeros(nraces,1);
%d2thetamean= [];


uthetatauaj=zeros(nraces,gpoints); 
duthetatauaj=zeros(nraces,gpoints);
vthetatauaj=zeros(nraces,gpoints);
dvthetatauaj=zeros(nraces,gpoints);
d2thetatauaj=zeros(nraces,gpoints);
d2thetatauj=zeros(nraces,1);
d2thetataulikej =zeros(nraces,1);
%d2thetatau= [];

d2betalikej=zeros(nraces,betapara);
%d2beta=zeros(betapara,1);

d2betameanlikej=zeros(nraces,betapara);
%d2betamean=zeros(betapara,1);

d2betataulikej=zeros(nraces,betapara);
%d2betatau=zeros(betapara,1);


d2beta1likej=zeros(nraces,betapara);
%d2beta1=zeros(betapara,1);
 
d2beta2likej=zeros(nraces,betapara);
%d2beta2=zeros(betapara,1);
 
d2beta3likej=zeros(nraces,betapara);
%d2beta3=zeros(betapara,1);
 
d2beta4likej=zeros(nraces,betapara);
%d2beta4=zeros(betapara,1);
 
d2beta5likej=zeros(nraces,betapara);
%d2beta5=zeros(betapara,1);
 
d2beta6likej=zeros(nraces,betapara);
%d2beta6=zeros(betapara,1);
 

d2umeanaj=zeros(nraces,gpoints);
d2vmeanaj=zeros(nraces,gpoints);
d2meanaj=zeros(nraces,gpoints);
d2meanj=zeros(nraces,1);
d2meanlikej =zeros(nraces,1);
%d2mean= [];

d2umeantauaj= zeros(nraces,gpoints);
d2vmeantauaj=zeros(nraces,gpoints);
d2meantauaj=zeros(nraces,gpoints);
d2meantauj=zeros(nraces,1);
d2meantaulikej=zeros(nraces,1);
%d2meantau= [];

d2utauaj=zeros(nraces,gpoints);
d2vtauaj=zeros(nraces,gpoints);
d2tauaj=zeros(nraces,gpoints);
d2tauj=zeros(nraces,1);
d2taulikej =zeros(nraces,1);
%d2tau= [];



%Do something
do_model
do_model



%Calculate the log likelhood and first and second differentials%

    function do_model    

    for j=1:nraces
        %j
        for a=1:gpoints
   
        %Calculate logit%    
        linpred(j, a)= exp(alpha+(theta.*((sqrt(2)*tau*z(a))+meanX))+beta'*X(j,:)');
        logit(j,a)=linpred(j,a)/(1+linpred(j,a));
        
        %Calculate measure%  
        measure(j,a)=exp(-(( (W(j,1)-((sqrt(2)*tau*z(a))+meanX))^2)/(2*Sigma(j,1))));
        
        %Calculate loglikelihood for each weight and each race%
        loglikeaj(j,a)= w(a)*(logit(j,a)^Y(j,1))*((1-logit(j,a))^(1-Y(j,1)))*(1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);

        %calculate differential of likelihood wrt alpha for each weight and
        %each race%
        
        dalphaaj(j,a)= w(a)*(logit(j,a)-((logit(j,a))^2))* (1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
          
        %calculate differential of likelihood wrt theta for each weight and
        %each race%
        
        dthetaaj(j,a)= w(a)*(((sqrt(2)*tau*z(a))+meanX)*(logit(j,a)-((logit(j,a))^2)))* (1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
        
         %calculate differential of likelihood wrt mean for each weight and each race%
        
        if Y(j,:)>=1 
        umeanaj(j,a)=logit(j,a); 
        else
        umeanaj(j,a)=1-logit(j,a);
        end
        
        dumeanaj(j,a)=((-1)^(1-Y(j)))*(theta*(logit(j,a)-((logit(j,a))^2)));
        vmeanaj(j,a)=measure(j,a);
        dvmeanaj(j,a)=((W(j,1)-(sqrt(2)*tau*z(a))-meanX)/(Sigma(j,1)))*measure(j,a);
        dmeanaj(j,a)= w(a)*((dumeanaj(j,a)*vmeanaj(j,a))+(umeanaj(j,a)* dvmeanaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));

        %calculate differential of likelihood wrt tau for each weight and
        %each race%
        
        if Y(j,:)>=1 
        utauaj(j,a)=logit(j,a); 
        else
        utauaj(j,a)=1-logit(j,a);
        end

        dutauaj(j,a)=((-1)^(1-Y(j)))*(theta*sqrt(2)*z(a,1))*((logit(j,a)-((logit(j,a))^2)));
        vtauaj(j,a)=measure(j,a);
        dvtauaj(j,a)=((( sqrt(2)*z(a,1))*(W(j,1)-((sqrt(2)*tau*z(a,1))+meanX)))/(Sigma(j,1)))*measure(j,a);
        dtauaj(j,a)= w(a,1)*((dutauaj(j,a)*vtauaj(j,a))+(utauaj(j,a)*dvtauaj(j,a)))* (1/(sqrt(2*3.14*Sigma(j,1))));

        %calculate 2nd differential of likelihood wrt alpha for each weight and each race%
        
        d2alphaaj(j,a)= w(a,1)*2*(-((logit(j,a))^2)+((logit(j,a))^3))* (1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
        
        %calculate dalpha wrt theta for each weight and each race%
        
        d2alphathetaaj(j,a)= w(a,1)*2*((sqrt(2)*tau*z(a,1))+meanX)*(-((logit(j,a))^2)+((logit(j,a))^3))* (1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
       
        %calculate dalpha wrt mean for each weight and each race%
        
        
        ualphameanaj(j,a)=((-1)^(1-Y(j)))*(logit(j,a)-((logit(j,a))^2)); 
        dualphameanaj(j,a)=((-1)^(1-Y(j)))*(theta*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3))));
        valphameanaj(j,a)=measure(j,a);
        dvalphameanaj(j,a)=dvmeanaj(j,a);
        d2alphameanaj(j,a)= w(a)*((dualphameanaj(j,a)*valphameanaj(j,a))+(ualphameanaj(j,a)* dvalphameanaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
        %calculate dalpha wrt tau for each weight and each race%
        
        
        ualphatauaj(j,a)=ualphameanaj(j,a); 
        dualphatauaj(j,a)=(sqrt(2)*z(a))*dualphameanaj(j,a);
        valphatauaj(j,a)=measure(j,a);
        dvalphatauaj(j,a)=dvtauaj(j,a);
        d2alphatauaj(j,a)= w(a)*((dualphatauaj(j,a)*valphatauaj(j,a))+(ualphatauaj(j,a)* dvalphatauaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
        %calculate 2nd differential of likelihood wrt beta for each weight and each race%
        
        d2thetaaj(j,a)= w(a,1)*(((sqrt(2)*tau*z(a,1))+meanX)^2)*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)))*(1/(sqrt(2*3.14*Sigma(j,1))))*measure(j,a);
        
        
        %calculate dtheta wrt mean for each weight and each race%
        
        
        uthetameanaj(j,a)=((-1)^(1-Y(j)))*((sqrt(2)*tau*z(a,1))+meanX)*(logit(j,a)-((logit(j,a))^2)); 
        duthetameanaj(j,a)=((-1)^(1-Y(j)))*((logit(j,a)-((logit(j,a))^2))+(theta*((sqrt(2)*tau*z(a,1))+meanX)*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)))));
        vthetameanaj(j,a)=measure(j,a);
        dvthetameanaj(j,a)=dvmeanaj(j,a);
        d2thetameanaj(j,a)= w(a)*((duthetameanaj(j,a)*vthetameanaj(j,a))+(uthetameanaj(j,a)* dvthetameanaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
         %calculate dtheta wrt tau for each weight and each race%
        
        
        uthetatauaj(j,a)=uthetameanaj(j,a); 
        duthetatauaj(j,a)=((-1)^(1-Y(j)))*(((sqrt(2)*z(a,1))*(logit(j,a)-((logit(j,a))^2)))+((theta*sqrt(2)*z(a,1))*((sqrt(2)*tau*z(a,1))+meanX)*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)))));
        vthetatauaj(j,a)=measure(j,a);
        dvthetatauaj(j,a)=dvtauaj(j,a);
        d2thetatauaj(j,a)= w(a)*((duthetatauaj(j,a)*vthetatauaj(j,a))+(uthetatauaj(j,a)* dvthetatauaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
        
        %calculate 2nd differential of likelihood wrt mean for each weight and each race%
        
        d2umeanaj(j,a)= ((-1)^(1-Y(j)))*(theta^2)*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)));
        d2vmeanaj(j,a)=(((((W(j,1)-((sqrt(2)*tau*z(a,1))+meanX)))^2)/((Sigma(j,1))^2))-(1/Sigma(j,1)))*measure(j,a);
        d2meanaj(j,a)= w(a,1)*((d2umeanaj(j,a)*vmeanaj(j,a))+(dumeanaj(j,a)* dvmeanaj(j,a))+(dumeanaj(j,a)*dvmeanaj(j,a))+(umeanaj(j,a)*d2vmeanaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));

        %calculate 2nd differential of likelihood wrt mean for each weight and each race%
        
        d2umeantauaj(j,a)= ((-1)^(1-Y(j)))*(theta^2)*(sqrt(2)*z(a,1))*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)));
        d2vmeantauaj(j,a)=(((sqrt(2)*z(a,1))*(((W(j,1)-((sqrt(2)*tau*z(a,1))+meanX)))^2)/((Sigma(j,1))^2))-((sqrt(2)*z(a,1))/Sigma(j,1)))*measure(j,a);
        d2meantauaj(j,a)= w(a,1)*((d2umeantauaj(j,a)*vmeanaj(j,a))+(dumeanaj(j,a)* dvtauaj(j,a))+(dutauaj(j,a)*dvmeanaj(j,a))+(umeanaj(j,a)*d2vmeantauaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
        
        %calculate 2nd differential of likelihood wrt tau for each weight and each race%
        
        d2utauaj(j,a)= ((-1)^(1-Y(j)))*((theta*sqrt(2)*z(a,1))^2)*(logit(j,a)-(3*((logit(j,a)^2)))+(2*((logit(j,a))^3)));
        d2vtauaj(j,a)=(((sqrt(2)*z(a,1))^2)*(((W(j,1)-((sqrt(2)*tau*z(a,1))+meanX))^2)/((Sigma(j,1))^2))-(((sqrt(2)*z(a,1))^2)/Sigma(j,1)))*measure(j,a);
        d2tauaj(j,a)= w(a,1)*((d2utauaj(j,a)*vtauaj(j,a))+(dutauaj(j,a)* dvtauaj(j,a))+(dutauaj(j,a)*dvtauaj(j,a))+(utauaj(j,a)*d2vtauaj(j,a)))*(1/(sqrt(2*3.14*Sigma(j,1))));
        
        end

    %loglikehood and differentials at race level%
    likej(j)=sum(loglikeaj(j,:));
    loglikej(j)=log(sum(loglikeaj(j,:)));

    dalphaj(j)= sum(dalphaaj(j,:));
    dalphalikej(j)=(1/(likej(j)))*((-1)^(1-Y(j)))* dalphaj(j);
    
    dthetaj(j)= sum(dthetaaj(j,:));
    dthetalikej(j)=(1/(likej(j)))*((-1)^(1-Y(j)))* dthetaj(j);
    
    for b=1:betapara

    dbetalikej(j,b)=(1/(likej(j)))*((-1)^(1-Y(j)))*X(j,b)* dalphaj(j);
    S.dbeta(b)=sum(dbetalikej(:,b));

    end
    
    dmeanj(j)= sum(dmeanaj(j,:));
    dmeanlikej(j)=(1/(likej(j)))* dmeanj(j);
    
    dtauj(j)= sum(dtauaj(j,:));
    dtaulikej(j)=(1/(likej(j)))* dtauj(j);
    
    d2alphaj(j)= sum(d2alphaaj(j,:));
    d2alphalikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*dalphaj(j))^2))+((1/(likej(j)))*((((-1)^(1-Y(j)))*dalphaj(j))+(((-1)^(1-Y(j)))*d2alphaj(j))));
    
    d2alphathetaj(j)= sum(d2alphathetaaj(j,:));
    d2alphathetalikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dalphaj(j)))*(((-1)^(1-Y(j)))*dthetaj(j))))+((1/(likej(j)))*((((-1)^(1-Y(j)))*dthetaj(j))+(((-1)^(1-Y(j)))*d2alphathetaj(j))));
    
    for b=1:betapara

    d2alphabetalikej(j,b)=((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*dalphaj(j))*(((-1)^(1-Y(j)))*X(j,b)*dalphaj(j))))+((1/(likej(j)))*((((-1)^(1-Y(j)))*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))*X(j,b)*d2alphaj(j))));
    S.d2alphabeta(b)=sum(d2alphabetalikej(:,b));

    end
    
    d2alphameanj(j)= sum(d2alphameanaj(j,:));
    d2alphameanlikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dalphaj(j)))*dmeanj(j)))+((1/(likej(j)))*(d2alphameanj(j)));
    
    d2alphatauj(j)= sum(d2alphatauaj(j,:));
    d2alphataulikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dalphaj(j)))*dtauj(j)))+((1/(likej(j)))*(d2alphatauj(j)));
    
    

    d2thetaj(j)= sum(d2thetaaj(j,:));
    d2thetalikej(j)= (-(1/(likej(j))^2)*((((-1)^(1-Y(j)))*dthetaj(j))^2))+((1/(likej(j)))*((-1)^(1-Y(j)))*d2thetaj(j));

    for b=1:betapara

    d2thetabetalikej(j,b)=((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*dthetaj(j))*(((-1)^(1-Y(j)))*X(j,b)*dalphaj(j))))+((1/(likej(j)))*((((-1)^(1-Y(j)))*dthetaj(j)*X(j,b))+(((-1)^(1-Y(j)))*d2alphathetaj(j)*X(j,b))));
    S.d2thetabeta(b)=sum(d2thetabetalikej(:,b));

    end


    d2thetameanj(j)= sum(d2thetameanaj(j,:));
    d2thetameanlikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dthetaj(j)))*dmeanj(j)))+((1/(likej(j)))*(d2thetameanj(j)));
    
    d2thetatauj(j)= sum(d2thetatauaj(j,:));
    d2thetataulikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dthetaj(j)))*dtauj(j)))+((1/(likej(j)))*(d2thetatauj(j)));


    for b=1:betapara

    d2betalikej(j,b)= (-(1/(likej(j))^2)*((((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))^2)) +((1/(likej(j)))*((((-1)^(1-Y(j)))* (X(j,b)^2)*dalphaj(j))+(((-1)^(1-Y(j)))* (X(j,b)^2)*d2alphaj(j))));
    S.d2beta(b)=sum(d2betalikej(:,b));

    end
    
    for b=2:betapara

    d2beta1likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,1)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,1)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,1)*X(j,b)*d2alphaj(j))));
    S.d2beta1(b)=sum(d2beta1likej(:,b));

    end

    for b=3:betapara
    d2beta2likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,2)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,2)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,2)*X(j,b)*d2alphaj(j))));
    S.d2beta2(b)=sum(d2beta2likej(:,b));

    end
     
    for b=4:betapara
    d2beta3likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,3)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,3)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,3)*X(j,b)*d2alphaj(j))));
    S.d2beta3(b)=sum(d2beta3likej(:,b));
    
    end
    
    
    for b=5:betapara
    d2beta4likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,4)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,4)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,4)*X(j,b)*d2alphaj(j))));
    S.d2beta4(b)=sum(d2beta4likej(:,b));
    
    end
 
    for b=6:betapara
    d2beta5likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,5)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,5)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,5)*X(j,b)*d2alphaj(j))));
    S.d2beta5(b)=sum(d2beta5likej(:,b));
    
    end
 
    for b=7:betapara
    
    d2beta6likej(j,b)= (-(1/(likej(j))^2)*(((-1)^(1-Y(j)))* X(j,6)*dalphaj(j))*(((-1)^(1-Y(j)))* X(j,b)*dalphaj(j))) +((1/(likej(j)))*((((-1)^(1-Y(j)))* X(j,6)*X(j,b)*dalphaj(j))+(((-1)^(1-Y(j)))* X(j,6)*X(j,b)*d2alphaj(j))));
    S.d2beta6(b)=sum(d2beta6likej(:,b));
    
    end

    for b=1:betapara

    d2betameanlikej(j,b)= ((-(1/(likej(j))^2))*(((-1)^(1-Y(j)))*((dalphaj(j)*X(j,b))))*dmeanj(j))+((1/(likej(j)))*X(j,b)*(d2alphameanj(j)));
    S.d2betamean(b)=sum(d2betameanlikej(:,b));

    end
    
    for b=1:betapara

    d2betataulikej(j,b)= ((-(1/(likej(j))^2))*(((-1)^(1-Y(j)))*((dalphaj(j)*X(j,b))))*dtauj(j))+((1/(likej(j)))*X(j,b)*(d2alphatauj(j)));
    S.d2betatau(b)=sum(d2betataulikej(:,b));

    end
    
    
    
   
    



    d2thetameanj(j)= sum(d2thetameanaj(j,:));
    d2thetameanlikej(j)= ((-(1/(likej(j))^2))*((((-1)^(1-Y(j)))*(dthetaj(j)))*dmeanj(j)))+((1/(likej(j)))*(d2thetameanj(j)));



    d2meanj(j)= sum(d2meanaj(j,:));
    d2meanlikej(j)=((-(1/((likej(j))^2))) *((dmeanj(j))^2)) +((1/(likej(j)))* d2meanj(j));

    d2meantauj(j)= sum(d2meantauaj(j,:));
    d2meantaulikej(j)=((-(1/((likej(j))^2))) *((dmeanj(j))*(dtauj(j)))) +((1/(likej(j)))* d2meantauj(j));
    
    d2tauj(j)= sum(d2tauaj(j,:));
    d2taulikej(j)= ((-(1/((likej(j))^2))) *((dtauj(j))^2)) +((1/(likej(j)))* d2tauj(j));
    end
    
    %loglikehood and differentials at overall level%
    S.loglike=sum(loglikej);
 
    S.dalpha=sum(dalphalikej);
    S.dtheta=sum(dthetalikej);
    S.dmean=sum(dmeanlikej);
    S.dtau=sum(dtaulikej);
    S.d2alpha=sum(d2alphalikej);
    S.d2alphatheta=sum(d2alphathetalikej);
    S.d2alphamean=sum(d2alphameanlikej);
    S.d2alphatau=sum(d2alphataulikej);
    S.d2theta=sum(d2thetalikej);
    S.d2thetamean=sum(d2thetameanlikej);
    S.d2thetatau=sum(d2thetataulikej);
    S.d2mean=sum(d2meanlikej);
    S.d2meantau=sum(d2meantaulikej);
    S.d2tau=sum(d2taulikej);
    


   

        end



end


