% This file and the file measure_model.m contains Matlab code to evaluate the likelihood numerically using 
Gaussain Hermite quadrature and determine the log-likelihood at its maximum in order to determine the unknown parameters, using e.g. Newton-Raphson method%

%This file applies the Newton-Raphson method taking the first and second differentials required to run the procedure from 
the measure_model.m file. Newton-Raphson method is iterative process and this code runs until the loglikelihood changes
by less than 0.001%
% The code outputs of the log-likelihood, parameter estimates and the Hessian matrix.%

%Code inputs X Y etc which are defined in measure_model.m file%

%Copyright (c) 2011-2016 Joanne L Bradley

%Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.%


function [para diff2] = newton(X, Y, W, Sigma,alpha,theta,meanX,tau,beta)
    
tol = 1e-3;
loglike_change = inf;
loglike = []; 

%initial values
para=[alpha theta beta' meanX tau]';
n = 0;
while abs(loglike_change)>tol
    n=n+1;
    S = measure_model(X, Y, W, Sigma, para(1),para(2),para(10),para(11),para(3:9));
    
    
    if ~isempty(loglike)
        loglike_change = S.loglike-loglike;
    end
    
    loglike = S.loglike;        
    
    diff2=[S.d2alpha S.d2alphatheta S.d2alphabeta S.d2alphamean S.d2alphatau;
        S.d2alphatheta S.d2theta S.d2thetabeta S.d2thetamean S.d2thetatau;
        S.d2alphabeta(1) S.d2thetabeta(1) S.d2beta(1) S.d2beta1(2) S.d2beta1(3) S.d2beta1(4) S.d2beta1(5) S.d2beta1(6) S.d2beta1(7) S.d2betamean(1) S.d2betatau(1);
        S.d2alphabeta(2) S.d2thetabeta(2) S.d2beta1(2) S.d2beta(2) S.d2beta2(3) S.d2beta2(4) S.d2beta2(5) S.d2beta2(6) S.d2beta2(7) S.d2betamean(2) S.d2betatau(2);
        S.d2alphabeta(3) S.d2thetabeta(3) S.d2beta1(3) S.d2beta2(3) S.d2beta(3) S.d2beta3(4) S.d2beta3(5) S.d2beta3(6) S.d2beta3(7) S.d2betamean(3) S.d2betatau(3);
        S.d2alphabeta(4) S.d2thetabeta(4) S.d2beta1(4) S.d2beta2(4) S.d2beta3(4) S.d2beta(4) S.d2beta4(5) S.d2beta4(6) S.d2beta4(7) S.d2betamean(4) S.d2betatau(4);
        S.d2alphabeta(5) S.d2thetabeta(5) S.d2beta1(5) S.d2beta2(5) S.d2beta3(5) S.d2beta4(5) S.d2beta(5) S.d2beta5(6) S.d2beta5(7) S.d2betamean(5) S.d2betatau(5);
        S.d2alphabeta(6) S.d2thetabeta(6) S.d2beta1(6) S.d2beta2(6) S.d2beta3(6) S.d2beta4(6) S.d2beta5(6) S.d2beta(6) S.d2beta6(7) S.d2betamean(6) S.d2betatau(6);
        S.d2alphabeta(7) S.d2thetabeta(7) S.d2beta1(7) S.d2beta2(7) S.d2beta3(7) S.d2beta4(7) S.d2beta5(7) S.d2beta6(6) S.d2beta(7) S.d2betamean(7) S.d2betatau(7);
        S.d2alphamean S.d2thetamean S.d2betamean S.d2mean S.d2meantau;
        S.d2alphatau S.d2thetatau S.d2betatau S.d2meantau S.d2tau];

    diff=[S.dalpha S.dtheta S.dbeta S.dmean S.dtau];
    
    para=para-0.1*(diff2^-1)*diff';
    
    fprintf(1, ['Step ' num2str(n) '. Log likelihood = ' num2str(S.loglike) '. Change in log likelihood = ' num2str(loglike_change)  '.\n']);
    
end

end