## load BTLLasso library
library(BTLLasso)
 

## get data, X is centered for more convenient interpretation
data(GLES)
Y <- GLES$Y
X <- scale(GLES$X, scale = FALSE)
m <- Y$m


## define a suitable grid for lambda
lambda <- exp(seq(log(141), log(1), length = 100)) - 1


## weighting penalties is not necessary in case of only subject-specific variables
ctrl <- ctrl.BTLLasso(weight.penalties = TRUE)


## compute model and do cross-validation of the tuning parameter
## parallel on 10 cores
set.seed(5)
gles <- cv.BTLLasso(Y = Y, X = X, lambda = lambda, control = ctrl)


## execute bootstrap procedure with 500 bootstrap samples
## parallel on 25 cores
set.seed(5)
lambda2 <- tail(lambda, 40)
boot.gles <- boot.BTLLasso(gles, lambda = lambda2, cores = 25)


## define subtitles for plots
subs <- c("(in years)", "female (1); male (0)", "East Germany (1); West Germany (0)", 
          "(very) good (1); else (0)", "Abitur/A levels (1); else (0)", 
          "currently unemployed (1); else (0)", "at least once a month (1); else (0)", 
          "yes (1); no (0)")


## Figure 2, cross-validation
par(lwd = 2)
plot(log(gles$lambda + 1), gles$criterion, xlim = rev(range(log(gles$lambda + 1))), 
     ylab = "RPS", xlab = expression(log(lambda + 1)), type = "l", lwd = 2)
abline(v = log(gles$lambda + 1)[which.min(gles$criterion)], lwd = 2, col = 2, lty = 2)


## Figure 3, thresholds and intercepts
# thresholds
par(mar = c(5.1, 4, 3, 3.5), cex = 1.05, lwd = 2)
yrange <- range(gles$coefs[, 1:2])
plot(log(gles$lambda + 1), gles$coefs[, 1], ylim = yrange, xlim = rev(range(log(gles$lambda + 1))), 
     type = "l", xlab = expression(log(lambda + 1)), main = "Thresholds", ylab = "estimates", 
     lwd = 2)
lines(log(gles$lambda + 1), gles$coefs[, 2], lwd = 2)
axis(4, at = gles$coefs[length(gles$lambda), 1:2], 
     labels = c(expression(theta[1]), expression(theta[2])), las = 2)
abline(v = log(gles$lambda + 1)[which.min(gles$criterion)], lwd = 2, col = 2, lty = 2)
# intercepts
par(mar = c(5.1, 4, 3, 6.5), cex = 1.05, lwd = 2)
singlepaths(gles, plot.X = FALSE)


## Figure 4, coefficient paths
par(mar = c(5.1, 4, 3, 6.5), cex = 1.05, lwd = 2)
singlepaths(gles, plot.intercepts = FALSE, subs.X = subs)


## Figure 5, variable paths
par(mar = c(5.1, 4.5, 4, 8), cex = 1.05, lwd = 2)
paths(gles)


## Figure 6, bootstrap confidence intervals
par(mar = c(4.1, 5, 3, 4.5), cex = 1.05, lwd = 2)
ci.BTLLasso(boot.gles, plot.intercepts = FALSE, subs.X = subs, rescale = TRUE)


## Table 1, estimated coefficients
coef.opt <- print(gles, rescale = TRUE)
