% Influence Plots for F2

I_teta_teta=[ I_f2_f2 , I_f2_beta , I_f2_f1 , I_f2_fi ;
              I_beta_f2 , I_beta_beta , I_beta_f1 , I_beta_fi;
              I_f1_f2 , I_f1_beta , I_f1_f1 , I_f1_fi ;
              I_fi_f2 , I_fi_beta , I_fi_f1 , I_fi_fi];

if I_teta_teta==I_teta_teta'
      
   disp('I_teta_teta is symmetric')
else 
   disp('I_teta_teta is not symmetric')
end

I_teta_teta=(I_teta_teta'+I_teta_teta)/2; 
[df1 df2]=size(fi_nor); 
par_total=p+r1+r2+df1; 

I_beta=I_teta_teta(r2+1:par_total,r2+1:par_total);

B_beta=[zeros(r2,r2),zeros(r2,p+r1+df1);zeros(p+r1+df1,r2),inv(I_beta)];

%Cases-weight perturbation
B_1=DELTA1'*(inv(I_teta_teta)-B_beta)*DELTA1;
B_1=(B_1'+B_1)/2;
VpropiosB_1=eig(B_1);			
[eB1,fB1]=eig(B_1);	

posi=find(abs(VpropiosB_1)==max(abs(VpropiosB_1))); 
lmax_B1pond=eB1(:,posi);			
Ci_B1pond=2*abs(diag(B_1));


BBi_B1pond = 0.5*Ci_B1pond/sqrt(trace(DELTA1'*inv(I_teta_teta)*DELTA1)^2);


%Explanatory variable perturbation
B_4=DELTA4'*(inv(I_teta_teta)-B_beta)*DELTA4;
B_4=(B_4'+B_4)/2;
VpropiosB_4=eig(B_4);			
[eB4,fB4]=eig(B_4);	

posi=find(abs(VpropiosB_4)==max(abs(VpropiosB_4))); 
lmax_B4adi=eB4(:,posi);			
Ci_B4adi=2*abs(diag(B_4));

BBi_B4adi = 0.5*Ci_B4adi/sqrt(trace(DELTA4'*inv(I_teta_teta)*DELTA4)^2);


GraficoIndice=input('Graphs: 1.- Ci, 2.- lmax, 3.- Bi, =');
if GraficoIndice==1
    disp('	')
    disp('Plots of Ci')
    
    Normal_Graphs_Ci
   
elseif GraficoIndice==2
    disp('	')
    disp('Plots of lmax')

    Normal_Graphs_lmax
    
elseif GraficoIndice==3
    disp('	')
    disp('Plots of Bi')

    Normal_Graphs_Bi
    
end



