
library(Rcpp)
library(inline)
library(RcppArmadillo)
library(png)

sourceCpp("./extra/simplex_mixture.cpp")
sourceCpp("./extra/zim_simplex_mixture.cpp")
source("./extra/simplex_mixture_cpp.R")
source("./extra/zim_simplex_mixture_cpp.R")
source("./extra/extra_functions.R")

########### 
# this kind of image has 3 layers.
# http://www.johndcook.com/blog/2009/08/24/algorithms-convert-color-grayscale/
imagen <- readPNG("./images/Burzynski_PreliminaryFindings_2.png")
# luminosity method:
imagen <- (0.21*imagen[ , , 1] + 0.72*imagen[ , , 2] + 0.07*imagen[ , , 3])

xsample <- round(seq(1, dim(imagen)[1], length = 100))
ysample <- round(seq(1, dim(imagen)[2], length = 100))

# preparing the data vector
y <- as.numeric(imagen[xsample, ysample])

y<-y-.08
y[y <= 0] <- 0

hist(y, 40)
imagenB(array(y, dim = c(length(xsample), length(ysample))), col = gray.colors(10))

##################################################
# estimation
modelo2_grupos<-simplexEM_zim(y, 2, 0.1, method = "Nelder-Mead", hessian = T)

##################################################
# prediction on the image
imagenB(array(modelo2_grupos$class, dim = c(length(xsample), length(ysample))), col = gray.colors(10))

