
# lines(sort(y), modelo$pj[1] * VGAM::dsimplex(sort(y), modelo$mu[1], modelo$sigma[1]) + 
#        modelo$pj[2] * VGAM::dsimplex(sort(y), modelo$mu[2], modelo$sigma[2]) + modelo$pj[3] * 
#        VGAM::dsimplex(sort(y), modelo$mu[3], modelo$sigma[3]))

# http://blog.snap.uaf.edu/2012/06/08/matrix-rotation-for-image-and-contour-plots-in-r/
imagenB <- function(m, ...) image(t(m)[, nrow(m):1], ...)

y_to_hist<-function(modelo, y)
{
  N<-length(y)
  K<-length(modelo$pj)
  pj<-modelo$pj
  y<-sort(y)
  mu<-modelo$mu
  sigma<-modelo$sigma
  
  pre<-numeric(N)
  
  for(s in 1:K)
  {
    pre<-pre+pj[s]*VGAM::dsimplex(y, mu[s], sigma[s])
  }
    
  return(pre)  
}

y_to_hist2<-function(mus, sigmas, pj, p_inf=0, y)
{
  N<-length(y)
  K<-length(mus)
  y<-sort(y)
  
  pre<-numeric(N)
  
  for(i in 1:N)
  {
    for(s in 1:K)
    {
      if(y[i]!=0)
      {
        pre[i]<-pre[i]+pj[s]*VGAM::dsimplex(y[i], mus[s], sigmas[s])
      } else {
        pre[i]<-pre[i]+p_inf
      }
    }
  }
  
  return(pre)
}

y_to_hist_b<-function(mus, sigmas, pj, p_inf=0, y)
{
  N<-length(y)
  K<-length(mus)
  y<-sort(y)

  pre<-numeric(N)
  
  for(i in 1:N)
  {
    for(s in 1:K)
    {
      if(y[i]!=0)
      {
        pre[i]<-pre[i]+pj[s]*dbeta2(y[i], mus[s], sigmas[s])
      } else {
        pre[i]<-pre[i]+p_inf
      }
    }
  }
  
  return(pre)  
}

y_to_hist_b2<-function(modelo, p_inf=0, y)
{
  
  if(class(modelo)=='betamix')
  {
    mus <- plogis(coef(modelo)[,1])
    sigmas <- exp(coef(modelo)[,2])
    pj<-modelo$flexmix@prior
  } else {
    mus<-modelo$mu
    sigmas<-modelo$sigma
    pj<-modelo$pj
  }
  
  N<-length(y)
  K<-length(mus)
  y<-sort(y)

  pre<-numeric(N)
  
  for(i in 1:N)
  {
    for(s in 1:K)
    {
      if(y[i]!=0)
      {
        pre[i]<-pre[i]+pj[s]*dbeta2(y[i], mus[s], sigmas[s])
      } else {
        pre[i]<-pre[i]+p_inf
      }
    }
  }
  
  return(pre)  
}

y_to_hist_n<-function(mus, sigmas, pj, y)
{
  N<-length(y)
  K<-length(mus)
  # pj<-cosa$size/length(y)
  y<-sort(y)
  # mu<-modelo$mu
  # sigma<-modelo$sigma
  
  pre<-numeric(N)
  
  for(s in 1:K)
  {
    pre<-pre+pj[s]*dnorm(y, mus[s], sigmas[s])
  }
  
  return(pre)  
}

# Vuong test
vuong<-function(ver1, ver2)
{
  ver1<-as.numeric(ver1)
  ver2<-as.numeric(ver2)
  if(length(ver1)==length(ver2))
  {
    n<-length(ver1)
    m<-as.numeric(ver1-ver2)
    mbar<-mean(m)
    num<-sqrt(n)*mbar
    den<-sqrt(sum((m-mbar)^2)/n)
    res<-num/den
  }
  return(res)
}

# beta distribution reparametrized (mean and dispersion)
rbeta2 <- function(n, mu, phi) {
  alpha <- mu * phi
  beta <- phi * (1 - mu)
  return(rbeta(n, alpha, beta))
}

dbeta2 <- function(x, mu, phi, ...) {
  alpha <- mu * phi
  beta <- phi * (1 - mu)
  return(dbeta(x, alpha, beta, ...))
}

betamix_loglik_ind<-function(x, pj, mu, phi,...)
{
  n<-length(x)
  p<-length(mu)
  res<-numeric(n)
  for(i in 1:n)
  {
    for(j in 1:p)
    {
      res[i]<-res[i]+pj[j]*dbeta2(x[i], mu[j], phi[j], ...) 
    }
  }
  return(res)
}

normalmix_loglik_ind<-function(x, pj, mu, sigma,...)
{
  n<-length(x)
  p<-length(mu)
  res<-numeric(n)
  for(i in 1:n)
  {
    for(j in 1:p)
    {
      res[i]<-res[i]+pj[j]*dnorm(x[i], mu[j], sigma[j], ...) 
    }
  }
  return(res)
}

d_function<-function(y, mu)
{
  return((y-mu)^2)/(y*(1-y)*(mu^2)*(1-mu)^2)
}

sigma2_estim<-function(y, mu)
{
  return(sum(d_function(y, mu))/(length(y)-2))
}

mezcla<-function(Ene, mus, sigmas)
{
  if(length(Ene)!=length(mus)) stop('falta gente')
  y<-c()
  K<-length(Ene)
  for(k in 1:K)  y<-c(y, VGAM::rsimplex(Ene[k], mus[k], sigmas[k]))
  return(y)
}

emp_hellinger<-function(y, modelo, tipo='no_zim')
{

  mus<-modelo$mu
  sigmas<-modelo$sigma
  pj<-modelo$pj
  if(tipo=='zim') 
  {
    y<-y[y!=0]
    pj<-pj[-1]
  }
  # y<-y[y!=0]
  a<-data.frame(a=density(sort(y), from=min(y), to=max(y))$x, 
    b=density(sort(y), from=min(y), to=max(y))$y)
  b<-data.frame(c=density(sort(y), from=min(y), to=max(y))$x, 
    d=y_to_hist2(mus=mus, sigmas=sigmas, pj=pj,
        y=density(sort(y), from=min(y), to=max(y))$x))
  # kk<-sqldf("select * from a,b where a.a=b.c")
  # y_to_hist2<-function(mus, sigmas, pj, p_inf=0, y)

  hellinger<-sqrt(.5*caTools::trapz(a$a,(sqrt(a$b)-sqrt(b$d))^2))
  return(hellinger)
}


emp_hellinger_b<-function(y, modelo)
{
  if(class(modelo)=='betamix')
  {
    mus <- plogis(coef(modelo)[,1])
    sigmas <- exp(coef(modelo)[,2])
    pj<-modelo$flexmix@prior
  } else {
    mus<-modelo$mu
    sigmas<-modelo$sigma
    pj<-modelo$pj[-1]
    y<-y[y!=0]    
  }


  a<-data.frame(a=density(sort(y), from=min(y), to=max(y))$x, 
    b=density(sort(y), from=min(y), to=max(y))$y)
  b<-data.frame(c=density(sort(y), from=min(y), to=max(y))$x, 
    d=y_to_hist_b(mus=mus, sigmas=sigmas, pj=pj, y=density(sort(y), from=min(y), to=max(y))$x))
  # kk<-sqldf("select * from a,b where a.a=b.c")

  hellinger<-sqrt(.5*caTools::trapz(a$a,(sqrt(a$b)-sqrt(b$d))^2))
  return(hellinger)
}

emp_hellinger_n<-function(y, modelo)
{

  y<-y[y!=0]
  a<-data.frame(a=density(sort(y), from=min(y), to=max(y))$x, 
    b=density(sort(y), from=min(y), to=max(y))$y)
  b<-data.frame(c=density(sort(y), from=min(y), to=max(y))$x, 
    d=y_to_hist_n(modelo$mu, modelo$sigma, modelo$lambda,
      density(sort(y), from=min(y), to=max(y))$x))
  # kk<-sqldf("select * from a,b where a.a=b.c")

  hellinger<-sqrt(.5*caTools::trapz(a$a,(sqrt(a$b)-sqrt(b$d))^2))
  return(hellinger)
}
