# modelling sources:
library(Rcpp)
library(inline)
library(RcppArmadillo)
sourceCpp("./extra/zim_simplex_mixture.cpp")

simplexEM_zim <- function(y, K, tol, init=NULL, pj=NULL, pij=NULL, restarts=10, ...) {
  
  cont <- 0
  diferencia <- 1

  N <- length(y)

  aux<-kmeans(y[y!=0], K)

  # aquí
  medias<-tapply(y[y!=0], aux$cluster, mean)
  if(is.null(init))
  {
    para <- logit(as.numeric(medias))
    for(i in 1:K)
    {
      para<-c(para, log(sigma2_estim(y[aux$cluster==i], medias[i])) )
    }
  } else {
    para<-init
  }
  
  para0<-para
  
  # ifelse(is.null(init), para <- c(logit((as.numeric(aux$centers))), log(rep((.1), K))), para<-init)
  if(is.null(pj)) pj <- c(mean(y==0), as.numeric(table(aux$cluster)/length(y)))

  pj0<-pj

  if(is.null(pij))
  {
    pij<-peij_zim(y, c(mean(y==0), as.numeric(table(aux$cluster)/length(y))), 
                  c((as.numeric(aux$centers)), (rep(.1, K))) )
    
    pij[is.nan(apply(pij,1,sum)),2:(K+1)]<-VGAM::rdiric(1,rep(1,K))
  }
  

  para_old <- para # 
  # value <- 1
  loglik <- 1
  
  while (diferencia > tol) {
    # N <- N + 1
    para_old <- para
    # value_old <- value
    loglik_old <- loglik

    # el siguiente bloque será para reiniciar cuando haya malas estimaciones    
    restartings<-0
    saltar <- 0
    while(sum(pj==0)!=0 & restartings<=restarts)
    {
      pj<-runif(K)

      temp <- optim(para, fn_zim, y = y, pj = pj, pij = pij, control = list(maxit = 1000), ...)
      saltar<-1
      restartings<-restartings+1
    }

    if(saltar==0) 
    {
      temp <- optim(para, fn_zim, y = y, pj = pj, pij = pij, control = list(maxit = 1000), ...)
    }
    # termina el bloque

    para <- temp$par
    
    loglik <- fn_zim(y, pj, c(para[1:K], para[-c(1:K)]), pij) # log scale

    diferencia <- abs(loglik - loglik_old)
    

    pij <- peij_zim(y, pj, c(inv.logit(para[1:K]), exp(para[-c(1:K)])) )
    pj <- apply(pij, 2, mean)
    
    cont <- cont + 1
  }
  
  se <- NULL
  if(!is.null(temp$hessian)) se <- sqrt(diag(solve(temp$hes)))
  loglik <- fn_zim(y, pj, c(para[1:K], para[-c(1:K)]), pij) # log scale
  loglik_ind <- fn_zim_ind(y, pj, c(para[1:K], para[-c(1:K)]), pij) # log scale
  classs <- apply(pij, 1, which.max)
  
  return(list(mu = inv.logit(para[1:K]), se_mu = se[1:K], sigma = exp(para[-c(1:K)]), se_sigma = se[-c(1:K)], 
        cont=cont, pj = pj, pij = pij, loglik = loglik, loglik_ind= loglik_ind, class = classs, para0=para0,
        convergence=temp$convergence, restartings=restartings))
}
