criterion = 0
while(criterion < 5) {
  if (rank == 'low') {
    A = matrix(rnorm(p*r), p, r)
    C = matrix(rnorm(K*r), K, r)
    B = tcrossprod(A, C)
  } else {
    B = matrix(rnorm(p * K), p, K)
  }
  
  X = matrix(rnorm(n*p, sd = sqrt(10 / p)), n, p)
  eta = X %*% B
  P = exp(eta)/rowSums(exp(eta))
  Y = t(apply(P, 1, rmultinom, n = 1, size = 1))
  criterion = min(colSums(Y))
}

Xtest = matrix(rnorm(m*p, sd = sqrt(10 / p)), m, p)
etatest = Xtest %*% B
Ptest = exp(etatest)/rowSums(exp(etatest))
Ytest = t(apply(Ptest, 1, rmultinom, n = 1, size = 1))

pred.null = matrix(colMeans(Y), nrow = m, ncol = K, byrow = TRUE)

foldid = sample(rep(1:10, length = n))

fit.ridge = glmnet::cv.glmnet(X, apply(Y, 1, which.max),
  family = 'multinomial', alpha = 0, foldid = foldid,
  lambda = exp(seq(5, -10, length = 100)))
pred.ridge = predict(fit.ridge, Xtest, s = 'lambda.min',
  type = 'response')[, , 1]

fit.npmr = npmr::cv.npmr(X, Y, foldid = foldid)
pred.npmr = predict(fit.npmr, Xtest)

loss = function(pred) {-2 * mean(log(rowSums(Ytest * pred)))}

