## some help functions
source('Methods/help_funs.R')

## workspace containing the results
load("compare_methods.RData")

## load bookmakers data for betting and comparison of probabilities
load("Data/odds_payouts_sorted.RData")
load("Data/odds.RData")

n.rep <- 100

## load data wc.data (different version for Group Lasso, called wc.data14)
load(file="Data/wc.data.02.14.rda")

## Extract results for prediction of goals
all.quad <- apply(pred.goals, 2, loss.quad, y = rep(wc.data$Goals, each = n.rep))
all.diff <- apply(pred.goals, 2, goal.diff.quad, y = rep(wc.data$Goals,each = n.rep), n.rep = n.rep)


## Extract results for prediction of win/draw/loss probabilities
## likelihoods
all.mult <- sapply(pred.probs, loss.mult, y = wc.data$Goals)

## err.class2 automatically excludes the missing matches in the bookmakers odds
all.err <- unlist(lapply(pred.probs, err.class2, y = wc.data$Goals))

##  ranked probability scores
all.rps <- sapply(pred.probs,rps,y=wc.data$Goals)

## Get corresponding results for bookmakers and mark non-missing matches in no.na
## likelihood
mult.b <- data.0214odds$true.odds
no.na <- !is.na(mult.b)

## ranked probability score
rps.b <- data.0214odds$rps

## bind together results from methods and bookmakers
mult <- cbind(all.mult,mult.b)[no.na,]
rps <- cbind(all.rps, rps.b)[no.na,]

colnames(mult)[ncol(mult)] <- "Bookmakers"
colnames(rps)[ncol(rps)] <- "Bookmakers"

## extract average values
means <- apply(mult,2,mean)
mean.rps <- apply(rps,2,mean)

# Results from Table 4
t(round(rbind(means,c(all.err,corr.class),mean.rps)[,-9],3))


# Results from Table 5
round(cbind(
  colMeans(all.diff),
  colMeans(all.quad)
),3)

## Extract results for comparison of betting returns
all.bets <- matrix(unlist(lapply(pred.probs, bet.crit, goals = wc.data$Goals)), nrow = 4)
rownames(all.bets) <- c("Payed","Payout","Return","NumBets")
colnames(all.bets) <- colnames(all.mult)

# Results from Table 6
t(round(all.bets[3,,drop=FALSE]*100,2))

