RF_Result_ordfor <- function(data, wm, n.rep, permute = FALSE, n.perm = 50){  

  wm.index <- data$WM
  
  ## create suitable data set
  data.predict <- data[wm.index==wm,]
  data <- data[wm.index!=wm,]
  
  data.RF <- data[seq(1,nrow(data)-1,by=2),]
  match.index <- rep(1:nrow(data.RF),each=2)
  
  data.RF.predict <- data.predict[seq(1,nrow(data.predict)-1,by=2),]
  match.index.predict <- rep(1:nrow(data.RF.predict),each=2)
  
  data.RF$Goals <- NULL
  data.RF$Y <- rep(1,nrow(data.RF))
  g1 <- g2 <-  c()
  for(i in 1:nrow(data.RF)){
    goals.i <- c(data[match.index==i,"Goals"])

    diff.i <- diff(goals.i)
    if(diff.i < 0){
      data.RF$Y[i] <- 1
      g1 <- cbind(g1, goals.i)
  }
    if(diff.i==0){
      data.RF$Y[i] <- 2
      g2 <- cbind(g2, goals.i)
    }
    if(diff.i > 0){
      data.RF$Y[i] <- 3
      g1 <- cbind(g1, goals.i[c(2,1)])
    }

  }
  data.RF$Y <- as.ordered(data.RF$Y)

  data.RF.predict$Goals <- NULL
  data.RF.predict$Y <- rep(1,nrow(data.RF.predict))

  for(i in 1:nrow(data.RF.predict)){
    goals.i <- c(data.predict[match.index.predict==i,"Goals"])
    
    diff.i <- diff(goals.i)
    if(diff.i < 0){
      data.RF.predict$Y[i] <- 1
    }
    if(diff.i==0){
      data.RF.predict$Y[i] <- 2
    }
    if(diff.i > 0){
      data.RF.predict$Y[i] <- 3
    }
    
  }
  
  data.RF$Team <- data.RF$Opponent <- data.RF$WM <- 
    data.RF.predict$Team <- data.RF.predict$Opponent <- data.RF.predict$WM <- NULL  

  ##  create permutations of data set and train random forests
  if(permute){
    p.prob.mat <- matrix(0,ncol=3,nrow=nrow(data.RF.predict))
    perm.predict <- c(rep(FALSE,nrow(data.RF.predict)),rep(TRUE,nrow(data.RF.predict)))
    data.RF.predict <- rbind(data.RF.predict,data.RF.predict)
    data.RF.predict <- permute.rows(data.RF.predict,perm.vec = perm.predict)$data
    
    for(oo in 1:n.perm){
      data.RF <- permute.rows(data.RF)$data
      rf <- ordfor("Y", data = data.RF, nbest = 10)
      
      
      p.result <- predict(rf, newdata = data.RF.predict)
      p.prob <- p.result$classfreqtree
      p.prob1 <- p.prob[1:sum(perm.predict),]
      p.prob2 <- p.prob[(sum(perm.predict)+1):nrow(data.RF.predict),]
      p.prob2 <- t(apply(p.prob2,1,rev))
      p.prob.mat <- p.prob.mat + p.prob1 + p.prob2
    }
    p.prob <- p.prob.mat/n.perm/2
    p.result <- apply(p.prob,1,which.max)
  }


  
  ## predict goals
  form.rf <- as.formula(paste("Goals ~ ",paste(names(data)[5:(ncol(data))],collapse=" + ")))

  rf.goals <- cforest(form.rf, data = data, controls = cforest_unbiased(
    mtry=5,ntree=5000))
  p.rf.goals <- predict(rf.goals, newdata = data.predict)
  index.rf.goals <- rep(1:nrow(data.RF.predict),each=2)

p.rf <- c()
for(i in 1:length(p.result)){
  
  lambda.i <- p.rf.goals[index.rf.goals==i]
res.i <- c()
  
  for(j in 1:n.rep){
    result.i <- sample(1:3,1,prob = p.prob[i,])
    
    if(result.i==1){
        diff.i <- 5
        while(diff.i>=0){
          goals.i <- c(rpois(1,lambda.i[1]), rpois(1,lambda.i[2]))
          diff.i <- diff(goals.i)
        }
        res.i <- rbind(res.i,goals.i)
    }
    if(result.i==2){
      diff.i <- 5
      while(diff.i!=0){
        goals.i <- c(rpois(1,lambda.i[1]), rpois(1,lambda.i[2]))
        diff.i <- diff(goals.i)
      }
      res.i <- rbind(res.i,goals.i)
    }
    if(result.i==3){
      diff.i <- -5
      while(diff.i<=0){
        goals.i <- c(rpois(1,lambda.i[1]), rpois(1,lambda.i[2]))
        diff.i <- diff(goals.i)
      }
      res.i <- rbind(res.i,goals.i)
    }
    
    }
  p.rf <- c(p.rf, c(res.i))
}

list(p.rf = p.rf, probs = t(p.prob))
}

