gamboost_nb <- function(data, form){
  data$int <- rep(1,nrow(data))
  
m.nb <- gamboost(form, data = data, family = NBinomial(nuirange = c(0, 1e8)),
                 control = boost_control(mstop = 500))


B <- 25
cl <- makeCluster(B)
myApply <- function(X, FUN, ...) {
  myFun <- function(...) {
    library("mboost")
    FUN(...)
  }
  parLapply(cl = cl, X, myFun, ...)
}

cvr <- cvrisk(m.nb, folds = cv(model.weights(m.nb), B = B),
              papply = myApply)

mstop(m.nb) <- mstop(cvr)
m.nb
}
