## predict n.rep goals
pred_goals <- function(lambdas, n.rep){
  p.goals <- c()
  for(i in 1:length(lambdas)){
    p.goals <- c(p.goals, rpois(n.rep,lambdas[i]))
  }
  p.goals
}


## predict probabilities from predicted goals
pred_probs <- function(lambdas){
  index <- rep(1:(length(lambdas)/2),each=2)
  
  real.probs <- c()
  
  for(i in 1:max(index)){
    
    preds <- lambdas[index==i]
    prob.quad <- dpois(0:20,lambda=preds[1])%*%t(dpois(0:20,preds[2]))
    
    away.prob <- sum(prob.quad[upper.tri(prob.quad)])
    home.prob <- sum(prob.quad[lower.tri(prob.quad)])
    draw.prob <- sum(diag(prob.quad))
    
    real.probs <- cbind(real.probs, c(home.prob, draw.prob, away.prob))
  }
  real.probs
}

## quadratic loss
loss.quad <- function(x,y){(x-y)^2}

## quadratic loss of goal differences
goal.diff.quad <- function(x,y,n.rep){
  ngames <- length(x)/2/n.rep
start <- 1
diffs <- c()
for(i in 1:ngames){
  index <- start:(start+2*n.rep-1)
  diffs <- c(diffs,(-apply(matrix(x[index],ncol=2),1,diff) + apply(matrix(y[index],ncol=2),1,diff))^2)
  start <- start+2*n.rep
}
  diffs
}


## classification error
err.class <- function(x,y){

  index <- rep(1:(length(y)/2),each=2)
  
  corr.preds <- 0
  for(i in 1:max(index)){
    
    goals <- y[index==i]
    
    result <- 1
    if(goals[1]==goals[2]){
      result <- 2
    }
    if(goals[1]<goals[2]){
      result <- 3
    }
    if(which.max(x[,i])==result){
      corr.preds <- corr.preds+1
    }
  }
  corr.preds/max(index)
}
 
## classification error whithout missing matches of bookmakers
err.class2 <- function(x,y){

  no.na <- complete.cases(data.0214odds)

  x <- x[,no.na]
  y <- y[rep(no.na,each= 2)]
  index <- rep(1:(length(y)/2),each=2)
  
  corr.preds <- 0
  for(i in 1:max(index)){
    
    goals <- y[index==i]
    
    result <- 1
    if(goals[1]==goals[2]){
      result <- 2
    }
    if(goals[1]<goals[2]){
      result <- 3
    }
    if(which.max(x[,i])==result){
      corr.preds <- corr.preds+1
    }
  }
  corr.preds/max(index)
}

## multinomial loss (likelihood)
loss.mult <- function(x,y){
  index <- rep(1:(length(y)/2),each=2)
  real.probs <- c()
  
  for(i in 1:max(index)){

    goals <- y[index==i]

    result <- 1
    if(goals[1]==goals[2]){
      result <- 2
    }
    if(goals[1]<goals[2]){
      result <- 3
    }
    real.probs <- c(real.probs, x[result,i])
  }
  real.probs
}


## betting strategy criterion
bet.crit <- function(probs, goals){


  no.na <- complete.cases(odds.sorted)

  odds.probs <- odds.sorted[no.na,]

    payouts <- payouts.sorted[no.na,] 

  
  probs <- t(probs[,no.na])
  goals <- goals[rep(no.na,each= 2)]
  index <- rep(1:(length(goals)/2),each=2)
  
  
  
  payed.out <- 0
  payed <- 0
  num.bets <- 0
  for(i in 1:max(index)){
    goals.i <- goals[index==i]
    
    result.i <- 1
    if(goals.i[1]==goals.i[2]){
      result.i <- 2
    }
    if(goals.i[1]<goals.i[2]){
      result.i <- 3
    }
    expected <- probs[i,]*(payouts[i,]) - 1
    
    which.bet <- which.max(expected)

    if(all(expected<0)){
      stake <- 0
    }else{
      num.bets <- num.bets+1
      stake <- 1
    }
    if(which.bet==result.i){
        payed.out <- payed.out + payouts[i,result.i]*stake
        payed <- payed+stake
      }else{
        payed <- payed+stake
      }
    
    
    
  }
  return(list(payed = payed, payed.out = payed.out, return = (payed.out-payed)/payed,
         played = num.bets))
}


rps <- function(x,y){
  
  index <- rep(1:(length(y)/2),each=2)
  rps.vec <- c()

  for(i in 1:max(index)){
    
    goals <- y[index==i]
    
    result <- 1
    if(goals[1]==goals[2]){
      result <- 2
    }
    if(goals[1]<goals[2]){
      result <- 3
    }
    result.vec <- rep(0,3)
    result.vec[result] <- 1
     rps.i <- 0.5*sum((cumsum(x[,i])[-3] - cumsum(result.vec)[-3])^2)
    rps.vec<- c(rps.vec, rps.i)
  }
  rps.vec
  
}

## permute function for ordinal random forests
permute.rows <- function(data, balanced = FALSE, perm.vec = NULL){
  
  if(is.null(perm.vec)){
    perm.vec <- sample(c(TRUE, FALSE),nrow(data), replace = TRUE)
    
    if(balanced){
      perm.vec <- sample(rep(c(TRUE, FALSE),nrow(data)/2))
    }
  }
  
  numerics <- sapply(data,is.numeric)
  
  data2 <- data[perm.vec,]
  data2[,numerics] <- -data[perm.vec,numerics]
  data2$host <- data$host.oppo[perm.vec]
  data2$continent <- data$continent.oppo[perm.vec]
  data2$confed <- data$confed.oppo[perm.vec]
  data2$Nation.Coach <- data$Nation.Coach.oppo[perm.vec]
  data2$host.oppo <- data$host[perm.vec]
  data2$continent.oppo <- data$continent[perm.vec]
  data2$confed.oppo <- data$confed[perm.vec]
  data2$Nation.Coach.oppo <- data$Nation.Coach[perm.vec]
  data2$Knockout <- data$Knockout[perm.vec]
  
  data2$Y <- data$Y[perm.vec]
  data2$Y[data$Y[perm.vec]==1] <- 3
  data2$Y[data$Y[perm.vec]==3] <- 1
  
  data[perm.vec,] <- data2
  
  return(list(data = data, permuted = perm.vec))
}
