cd("C:\\Users\\Linda\\Desktop\\NPBM_script_SM_revised\\NPBM_Julia_code") # change working directory
addprocs(3)                           # add three processors
nprocs()                              # no. of processors
workers()                             # no. of workers
myid()                                # identity of processor
@everywhere include("NPBM.jl")        # include source code

################
# Static model #
################

# Example using simulated data
y = readtable("simulated_eg.txt", header=false, separator=' ');
y = convert(Array, y);

# Parallel computing
@everywhere y = y            # n by n adjacency matrix of type: Array{Int64,2}
@everywhere N = 20000        # Total no. of MCMC iterations
@everywhere burnin = 10000
@everywhere thin = 5
@everywhere gamma0 = 5.0
@everywhere v0 = 1.0
@everywhere initcomp = 5
@everywhere ncores = 3

@time output = @parallel (union) for i=1:ncores
    procid = myid()   # get id of processor
    println(procid)
    Static(y, N, burnin, thin, gamma0, v0, initcomp, i)
end;
save("static.jld", "output", output)

# output is an array of length 6 times no. of chains.
# e.g. if there are three chains, output is an array of length 18.
# mcmc samples of first chain are stored in array elements one to six
# mcmc samples of second chain are stored in array elements seven to twelve and so on.
# For each mcmc chain, the output consist of samples for
# nu, beta, phi, alpha, z and c in this order.
# For example, to obtain the MCMC samples for nu for chain 1:
output[1][1]                        # name of variable
nu_samples_chain1 = output[1][2]    # mcmc samples of nu from chain 1

###################
# Dynamic Model I #
###################

# Parallel computing
@everywhere Y = Y                # type: Array{Array{Int64,2},1}
@everywhere N = 20000
@everywhere burnin = 10000
@everywhere thin = 5
@everywhere gamma0 = 5.0
@everywhere v0 = 1.0
@everywhere initcomp = 5
@everywhere ncores = 3

@time output = @parallel (union) for i=1:ncores
    procid = myid()   # get id of processor
    println(procid)
    DynI(Y, N, burnin, thin, gamma0, v0, initcomp, i)
end;
length(output)
save("DynI.jld", "output", output);

####################
# Dynamic Model II #
####################

# Parallel computing
@everywhere Y = Y                          # type: Array{Array{Int64,2},1}
@everywhere N = 20000
@everywhere burnin = 10000
@everywhere thin = 5
@everywhere gamma0 = 10.0
@everywhere v0 = 2.0
@everywhere initcomp = 5
@everywhere ncores = 3

@time output = @parallel (union) for i=1:ncores
    procid = myid()   # get id of processor
    println(procid)
    DynII(Y, N, burnin, thin, gamma0, v0, initcomp, i)
end;
length(output)
save("DynII.jld", "output", output)
