# R function used in  Verzilli & Carpenter, Assessing uncertainty about parameter estimates with incomplete repeated ordinal data.
# Provides intervals of ignorance (II) and intervals of uncertainty (IU) for differences between active groups and placebo.
# Author:    Claudio Verzilli
#            Medical Statistics Unit 
#            London School of Hygiene & Tropical Medicine
#            Keppel Street
#            London, WC1E 7HT, UK
# Note:      The ASCII files painscores.txt and availest.txt should be placed in your working directory
# Arguments:
# ngroups    1 to 5 indicating the active group treatment contrasts for which II and IU are calculated
# hourstr    3 to 8 hours since randomisation
# hourend    3 to 8 hours since randomisation (must be >= hourstr)
# scenario   choose from "extreme", "A", "B", "C".
# maxiter    maximum number of iteration for the modified Fisher scoring algorithm
# tol        convergence criterion for the modified Fisher scoring algorithm (1e-tol)
#
# example    IIIUgee(5,3,8,"extreme",20,5) gives results in  first plot of Figure 3
cat("Note: The ASCII files painscores.txt and availest.txt should be placed in your working directory\n")
IIIUgee<-function(ngroups,hourstr,hourend,scenario,maxit,tol){
  data<-read.table("painscores.txt")#get data set
  betainit<-read.table("availest.txt")# get initial estimates
  hourstr<-hourstr+5
  hourend<-hourend+5
  betaminout<-array(0,dim=c(13,c(hourend-hourstr+1),ngroups))
  betamaxout<-array(0,dim=c(13,c(hourend-hourstr+1),ngroups))
  sandsematmin<-array(0,dim=c(13,c(hourend-hourstr+1),ngroups))  
  sandsematmax<-array(0,dim=c(13,c(hourend-hourstr+1),ngroups))
  H2min<-array(0,dim=c(13,13,313))
  H1min<-array(0,dim=c(13,13,313))
  H2max<-array(0,dim=c(13,13,313))
  H1max<-array(0,dim=c(13,13,313))
  ylabexp<-as.list(c(expression(alpha[1]),expression(alpha[2]),expression(alpha[3]),expression(alpha[4]),expression(beta[1]),expression(beta[2]),expression(beta[3]),expression(beta[4]),expression(beta[5]),expression(beta[6]),expression(beta[7]),expression(beta[8]),expression(beta[9])))#labels for plots of sequences of parameter estimates 
########## "expands" dataset to fit model (2)
  lastval<-data[,2]
  N<-nrow(data)
  du1<-rep(0,N)
  du2<-rep(0,N)
  for (i in 2:N){
    if(is.na(data$score[i])&data$id[i]==data$id[i-1])
      {lastval[i]<-lastval[i-1]}
    if((is.na(data$score[i])&is.na(data$score[i+1])&!is.na(data$score[i-1]))|(is.na(data$score[i])&!is.na(data$score[i-1])&!is.na(data$score[i+1])))
      {du1[i]<-1
       du2[i]<-data$score[i-1]+1}
  }
  lastval<-as.vector(lastval)
  Z<-matrix(NA,N,4)
  scores<-unique(data$score[!is.na(data$score)])
  nscores<-length(scores)
  contrZ<-matrix(c(1,1,1,1,0,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0),nscores,nscores-1,byrow=T)
  Zt<-cbind(as.vector(data$score),Z)
  Z<-matrix(apply(Zt,1,FUN=function(x){x[2:5]<-contrZ[x[1]+1,]}),N,4,byrow=T)
########## creates design matrix corresponding to expanded dataset 
  XL<-matrix(model.matrix(~as.factor(rep(c(1,2,3,4),N))+as.factor(rep(data$group,rep(4,N)))+rep(data$time,rep(4,N))+I(rep(data$time,rep(4,N))^2)+rep(data$cntage,rep(4,N))+rep(data$cntweight,rep(4,N))),4*N,13)
  y2<-cbind(as.vector(t(Z)),rep(as.vector(lastval),rep(4,N)),rep(du1,rep(4,N)),rep(du2,rep(4,N)))
  Rm<-diag(4)
  RM<-diag(4)
########## for each treatment contrast with placebo ... 
  for(group in 1:ngroups){
    s4<-group+4
    premmtemp1<-array(0,dim=c(13,13,313))
    premmtemp2<-matrix(0,13,313)
    premMtemp1<-array(0,dim=c(13,13,313))
    premMtemp2<-matrix(0,13,313)
########## ...and up to the time point specified in the call by the user (8 to 13 corresponding to 3-8 hours from start of study)
    for(k in 1:c(hourend-hourstr+1)){
########## initialize vectors, arrays, matrices whose size depend on time points included 
      p1<-seq(1,4*(hourstr+k-1),4)
      p2<-seq(2,4*(hourstr+k-1),4)
      p3<-seq(3,4*(hourstr+k-1),4)
      p4<-seq(4,4*(hourstr+k-1),4)
      U<-matrix(1,4,(hourstr+k-1))
      Rmar<-array(0,dim=c(4*(k+hourstr-1),4*(k+hourstr-1),313))
      RMar<-array(0,dim=c(4*(k+hourstr-1),4*(k+hourstr-1),313))
      Xklm<-XL[rep(data$visit,rep(4,N))<=(k+hourstr-1),]
      Xar<-apply(array(as.vector(t(Xklm)),dim=c(13,4*(hourstr+k-1),313)),c(1,3),t)
      lar<-matrix(y2[rep(data$visit,rep(4,N))<=(k+hourstr-1),2],c(4*(hourstr+k-1)),313)
      destemp<-apply(array(as.vector(t(cbind(Xklm,rep(seq(1,313,1),rep(4*(hourstr+k-1),313)),as.vector(lar)))),dim=c(15,4*(hourstr+k-1),313)),c(1,3),t)
      y<-as.vector(y2[rep(data$visit,rep(4,N))<=(k+hourstr-1),1])
      ytemp<-y
      ytemp[is.na(ytemp)]<-0.5
      yar<-matrix(y,c(4*(hourstr+k-1)),313)
      yar[is.na(yar)]<-999
      du1ar<-matrix(y2[rep(data$visit,rep(4,N))<=(k+hourstr-1),3],c(4*(hourstr+k-1)),313)
      du2ar<-matrix(y2[rep(data$visit,rep(4,N))<=(k+hourstr-1),4],c(4*(hourstr+k-1)),313)
      
      betamin<-matrix(0,13,maxit)
      betamax<-matrix(0,13,maxit)
      yselmin<-matrix(0,4*(k+hourstr-1),313)
      yselmax<-matrix(0,4*(k+hourstr-1),313)
########## modified Fisher scoring algorithm of section 3.1
      betamin[,1]<-betainit[,hourend-7]# step 1 
      betamax[,1]<-betainit[,hourend-7]#
      i<-2
      if(.Platform$OS.type=="unix"){x11()}
      else if (.Platform$OS.type=="windows"){windows()}
      else if (.Platform$OS.type=="mac"){macintosh()}
      eps<-10^(-tol)+10^(-(tol+1))
      while(eps>10^(-tol)){#iterate util convergence criterion is satisfied
        #for the minimum
        muhatm<-1/(1+exp(-Xklm%*%betamin[,i-1]))
        dmudpim<-matrix(as.vector(1/(muhatm*(1-muhatm))),c(4*(k+hourstr-1)),313)
        pidmudpim<-matrix(1/(1-muhatm),c(4*(k+hourstr-1)),313)
        for(j in 1:3){#R block in expression (3)
          for (h in (j+1):4){
            Rm[j,h]<-sqrt(exp(I(j!=1)*betamin[j,i-1]-betamin[h,i-1]))
            Rm[h,j]<-Rm[j,h]
          }
        }
        Rmkr<-kronecker(diag(hourstr+k-1),Rm)
        Vm1m<-1/dmudpim
        premmtemp1<-array(apply(destemp,3,FUN=function(x){t(x[,1:13]*Vm1m[,x[1,14]])%*%solve(sqrt(diag(Vm1m[,x[1,14]]))%*%Rmkr%*%sqrt(diag(Vm1m[,x[1,14]])))%*%(Vm1m[,x[1,14]]*x[,1:13])}),dim=c(13,13,313))
        premm1<-solve(apply(premmtemp1,c(1,2),sum))
        #for the maximum
        muhatM<-1/(1+exp(-Xklm%*%betamax[,i-1]))
        dmudpiM<-matrix(as.vector(1/(muhatM*(1-muhatM))),c(4*(k+hourstr-1)),313)
        pidmudpiM<-matrix(1/(1-muhatM),c(4*(k+hourstr-1)),313)
        for(j in 1:3){#block R in (3)
          for (h in (j+1):4){
            RM[j,h]<-sqrt(exp(I(j!=1)*betamax[j,i-1]-betamax[h,i-1]))
            RM[h,j]<-RM[j,h]
          }
        }
        RMkr<-kronecker(diag(hourstr+k-1),RM)
        Vm1M<-1/dmudpiM
        premMtemp1<-array(apply(destemp,3,FUN=function(x){t(x[,1:13]*Vm1M[,x[1,14]])%*%solve(sqrt(diag(Vm1M[,x[1,14]]))%*%RMkr%*%sqrt(diag(Vm1M[,x[1,14]])))%*%(Vm1M[,x[1,14]]*x[,1:13])}),dim=c(13,13,313))
        premM1<-solve(apply(premMtemp1,c(1,2),sum))
########## step 2  
        for(l in 1:313){
          muhatml<-1/(1+exp(-Xar[,,l]%*%betamin[,i-1]))
          muhatMl<-1/(1+exp(-Xar[,,l]%*%betamax[,i-1]))
          tm<-premm1%*%t(Vm1m[,l]*Xar[,,l])%*%solve(sqrt(diag(Vm1m[,l]))%*%Rmkr%*%sqrt(diag(Vm1m[,l])))
          tM<-premM1%*%t(Vm1M[,l]*Xar[,,l])%*%solve(sqrt(diag(Vm1M[,l]))%*%RMkr%*%sqrt(diag(Vm1M[,l])))
          if(scenario=="extreme"){
            if(sum(yar[,l]==999)>0){
              yselmin[,l]<-yar[,l]
              yselmax[,l]<-yar[,l]
              yselmin[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tm[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==min(x[1:5]))})),]))
              
              yselmax[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tM[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==max(x[1:5]))})),]))
            }
            else {yselmin[,l]<-yar[,l];yselmax[,l]<-yar[,l]}
          }
          else  if(scenario=="A"){
            if(sum(yar[,l]==999)>0){
              yselmin[,l]<-yar[,l]
              yselmax[,l]<-yar[,l]
              yselmin[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tm[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==min(x[c(x[7]*1*I(x[8]>1&x[8]<5)*c(rep(c((x[8]-1):(x[8]+1)),length.out=5)))+x[7]*1*I(x[8]==1)*rep(c(1,1,2),length.out=5)+x[7]*1*I(x[8]==5)*rep(c(4,4,5),length.out=5)+(1-x[7])*c(1:5)]))})),]))
              
              yselmax[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tM[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==max(x[c(x[7]*1*I(x[8]>1&x[8]<5)*c(rep(c((x[8]-1):(x[8]+1)),length.out=5)))+x[7]*1*I(x[8]==1)*rep(c(1,1,2),length.out=5)+x[7]*1*I(x[8]==5)*rep(c(4,4,5),length.out=5)+(1-x[7])*c(1:5)]))})),]))
            }
            else {yselmin[,l]<-yar[,l];yselmax[,l]<-yar[,l]}
          }
          
          else if(scenario=="B"){
             if(sum(yar[,l]==999)>0){
              yselmin[,l]<-yar[,l]
              yselmax[,l]<-yar[,l]
              yselmin[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tm[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==min(x[1:(x[6]+1)]))})),]))
              
              yselmax[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tM[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==max(x[1:(x[6]+1)]))})),]))
            }
            else {yselmin[,l]<-yar[,l];yselmax[,l]<-yar[,l]}
           }
          else if(scenario=="C"){
            if(sum(yar[,l]==999)>0){
              yselmin[,l]<-yar[,l]
              yselmax[,l]<-yar[,l]
              yselmin[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tm[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==min(x[(x[6]+1):5]))})),]))
              
              yselmax[yar[,l]==999,l]<-as.vector(t(contrZ[c(apply(cbind(matrix(tM[s4,yar[,l]==999],ncol=4,byrow=T)%*%t(contrZ),lar[p1,l][yar[p1,l]==999],du1ar[p1,l][yar[p1,l]==999],du2ar[p1,l][yar[p1,l]==999]),1,FUN=function(x){which(x[1:5]==max(x[(x[6]+1):5]))})),]))
            }
            else {yselmin[,l]<-yar[,l];yselmax[,l]<-yar[,l]}
          }
          premmtemp2[,l]<-t(Vm1m[,l]*Xar[,,l])%*%solve(sqrt(diag(Vm1m[,l]))%*%Rmkr%*%sqrt(diag(Vm1m[,l])))%*%(yselmin[,l]-muhatml)
          premMtemp2[,l]<-t(Vm1M[,l]*Xar[,,l])%*%solve(sqrt(diag(Vm1M[,l]))%*%RMkr%*%sqrt(diag(Vm1M[,l])))%*%(yselmax[,l]-muhatMl)
        }
########## step 3         
        betamin[,i]<-c(betamin[,i-1]+c(premm1%*%apply(premmtemp2,1,sum)) )
        betamax[,i]<-c(betamax[,i-1]+c(premM1%*%apply(premMtemp2,1,sum)))
########## plot sequences of parameter estimates interactively        
        par(mfrow=c(2,7),omi=c(0.3,0,0.5,0),mar=c(2,2,0,0))
        for(v in 1:13){
          par(mfg=c(1*I(v<=7)+2*I(v>7),v*I(v<=7)+(v-7)*I(v>7)))
          plot(c(i-1,i),c(betamin[v,i-1],betamin[v,i]),xlim=c(0,maxit),ylim=c(-8,10),type="l",xlab="",ylab="")
          par(mfg=c(1*I(v<=7)+2*I(v>7),v*I(v<=7)+(v-7)*I(v>7)),new=T)
          plot(c(i-1,i),c(betamax[v,i-1],betamax[v,i]),xlim=c(0,maxit),ylim=c(-8,10),type="l",xlab="",ylab="")
          text(15,8,ylabexp[[v]])
          title(main=paste("No of hours since randomisation:",(hourstr-6+k)),outer=T)
          title(xlab="Iteration",outer=T,line=0.2)
        }#for v
        eps<-max(abs(c(betamin[,i]-betamin[,i-1],betamax[,i]-betamax[,i-1])))
        i<-i+1
        if(i==maxit+1){break;warning("Maximum number of iterations reached without convergence")}
      }#while
      dev.off()
########## keep last values upon convergence      
      betaminout[,k,group]<-c(betamin[,i-1])
      betamaxout[,k,group]<-c(betamax[,i-1])
########## upon convergence, calculate robust (sandwich) SE
      
      for(l in 1:313){
        temp2<-c(exp(Xar[,,l]%*%betamin[,i-1])/(1+exp(Xar[,,l]%*%betamin[,i-1]))^2)
        temp3<-c(exp(Xar[,,l]%*%betamax[,i-1])/(1+exp(Xar[,,l]%*%betamax[,i-1]))^2)
        temp4<-yselmin[,l]-exp(Xar[,,l]%*%betamin[,i-1])/(1+exp(Xar[,,l]%*%betamin[,i-1]))
        temp5<-yselmax[,l]-exp(Xar[,,l]%*%betamax[,i-1])/(1+exp(Xar[,,l]%*%betamax[,i-1]))
        
        H1min[,,l]<-t(temp2*Xar[,,l])%*%solve(sqrt(diag(Vm1m[,l]))%*%Rmkr%*%sqrt(diag(Vm1m[,l])))%*%(temp2*Xar[,,l])
        H1max[,,l]<-t(temp3*Xar[,,l])%*%solve(sqrt(diag(Vm1M[,l]))%*%RMkr%*%sqrt(diag(Vm1M[,l])))%*%(temp3*Xar[,,l])
        
        H2min[,,l]<-t(temp2*Xar[,,l])%*%solve(sqrt(diag(Vm1m[,l]))%*%Rmkr)%*%((sqrt(diag(1/Vm1m[,l]))%*%(temp4%*%t(temp4))%*%sqrt(diag(1/Vm1m[,l])))*1*I(kronecker(diag(hourstr+k-1),matrix(1,4,4))==0)+Rmkr)%*%solve(Rmkr%*%sqrt(diag(Vm1m[,l])))%*%(temp2*Xar[,,l])
        H2max[,,l]<-t(temp3*Xar[,,l])%*%solve(sqrt(diag(Vm1M[,l]))%*%RMkr)%*%((sqrt(diag(1/Vm1M[,l]))%*%(temp5%*%t(temp5))%*%sqrt(diag(1/Vm1M[,l])))*1*I(kronecker(diag(hourstr+k-1),matrix(1,4,4))==0)+RMkr)%*%solve(RMkr%*%sqrt(diag(Vm1M[,l])))%*%(temp3*Xar[,,l])
      }
      sandsematmin[,k,group]<-sqrt(diag(solve(apply(H1min,c(1,2),sum))%*%apply(H2min,c(1,2),sum)%*%solve(apply(H1min,c(1,2),sum))))
      sandsematmax[,k,group]<-sqrt(diag(solve(apply(H1max,c(1,2),sum))%*%apply(H2max,c(1,2),sum)%*%solve(apply(H1max,c(1,2),sum))))
    }#k
  }#group
  betamin<-matrix(unlist(lapply(seq(1,ngroups,1),function(x){betaminout[drop=F,5:(5+ngroups-1),,][x,,x]})),ngroups,hourend-hourstr+1,byrow=T)
  betamax<-matrix(unlist(lapply(seq(1,ngroups,1),function(x){betamaxout[drop=F,5:(5+ngroups-1),,][x,,x]})),ngroups,hourend-hourstr+1,byrow=T)
  SEmin<-matrix(unlist(lapply(seq(1,ngroups,1),function(x){sandsematmin[drop=F,5:(5+ngroups-1),,][x,,x]})),ngroups,hourend-hourstr+1,byrow=T)
  SEmax<-matrix(unlist(lapply(seq(1,ngroups,1),function(x){sandsematmax[drop=F,5:(5+ngroups-1),,][x,,x]})),ngroups,hourend-hourstr+1,byrow=T)
  rownames(betamin)<-paste("Test dose",1:ngroups)
  colnames(betamin)<-paste("Hours",3:(3+hourend-hourstr))
  rownames(SEmin)<-paste("Test dose",1:ngroups)
  colnames(SEmin)<-paste("Hours",3:(3+hourend-hourstr))
  rownames(betamax)<-paste("Test dose",1:ngroups)
  colnames(betamax)<-paste("Hours",3:(3+hourend-hourstr))
  rownames(SEmax)<-paste("Test dose",1:ngroups)
  colnames(SEmax)<-paste("Hours",3:(3+hourend-hourstr))
  list(scenario=scenario,IImin=betamin,IImax=betamax,IUmin=betamin-1.96*SEmin,IUmax=betamax+1.96*SEmax)#on exit
}


