/*NAIVE CASE*/
/*gsa data was re-formated as follows:*/
/*
  PATID pca0 intercept responsej timej timej_2 responsek timek timek_2
      1      3      1          0       1     1         999     2      4
      1      3      1          0       1     1         999     3      9
      1      3      1          0       1     1         999     4      16
      2      5      1          1       1     1         999     2      4
      2      5      1          1       1     1         999     3      9
      2      5      1          1       1     1         999     4      16
...
*/

/*The code for the available cases:*/
proc nlmixed data=model_gsa_ac_naive QPOINTS=20;
parms beta0=0 beta1=0 beta2=0 beta3=0 rho_1=0 rho_2=0 rho_3=0;
eta_j = beta0 + beta1*timej + beta2*timej_2+ beta3*pca0 ;
eta_k = beta0 + beta1*timek + beta2*timek_2+ beta3*pca0 ;
nu_j = exp(eta_j)/(1+exp(eta_j));
nu_k = exp(eta_k)/(1+exp(eta_k));
if (timej=1 and timek=2) or (timej=2 and timek=3) or (timej=3 and timek=4)
then mu11 = nu_j*nu_k + rho_1*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=3) or (timej=2 and timek=4)
then mu11 = nu_j*nu_k + rho_2*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=4)
then mu11 = nu_j*nu_k + rho_3*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k));
mu10 = nu_j - mu11;
mu01 = nu_k - mu11;
mu00 = 1 - (mu11+mu10+mu01);
if responsej = 1 and responsek = 1 then loglik=log(mu11); else
if responsej = 1 and responsek = 0 then loglik=log(mu10); else
if responsej = 1 and responsek = 999 then loglik=log(mu11 + mu10); else
if responsej = 0 and responsek = 1 then loglik=log(mu01); else
if responsej = 0 and responsek = 0 then loglik=log(mu00); else
if responsej = 0 and responsek = 999 then loglik=log(mu00+mu01);
model intercept ~ general(loglik);
run;

/*SINGLY ROBUST CASE*/
/*For the dropout model, gsa data was re-formated as follows (model_weights.sas7bdat):*/
/*
 PATID pca0 ID_AC time GSAbin dropout prev
     1   3     1    1    0       0      .
     1   3     1    2    .       1      0
     1   3     1    3    .       1      .
     1   3     1    4    .       1      .
     2   5     2    1    1       0      .
     2   5     2    2    .       1      1
     2   5     2    3    .       1      .
     2   5     2    4    .       1      .
 ...
*/
/*The code for the dropout model:*/
proc nlmixed data=model_weights QPOINTS=20;
parms gamma0=0 gamma1=0 gamma2=0;
eta = gamma0 + gamma1*prev + gamma2*pca0 ;
nu = exp(eta)/(1+exp(eta));
if dropout = 1 then loglik=log(nu); else
if dropout = 0 then loglik=log(1-nu);
model dropout ~ general(loglik);
run;
/*Based on probabilities estimated with the dropout model, 
the inverse probabilities weights were calculated. 
The data for the analysis of the available cases are as follows (model_gsa_wi_ac.sas7bdat):*/
/*
 PATID pca0 intercept responsej   wij     timej  timej_2 responsek    wik    timek  timek_2
     1   3      1         0     1.00000     1      1         999    1.50253    2      4
     1   3      1         0     1.00000     1      1         999       .       3      9
     1   3      1         0     1.00000     1      1         999       .       4      16
     2   5      1         1     1.00000     1      1         999    1.25292    2      4
     2   5      1         1     1.00000     1      1         999       .       3      9
 ...
*/
/*The code for the available cases is as follows:*/
proc nlmixed data=model_gsa_wi_ac QPOINTS=20;
parms beta0=0 beta1=0 beta2=0 beta3=0 rho_1=0 rho_2=0 rho_3=0;
eta_j = beta0 + beta1*timej + beta2*timej_2+ beta3*pca0 ;
eta_k = beta0 + beta1*timek + beta2*timek_2+ beta3*pca0 ;
nu_j = exp(eta_j)/(1+exp(eta_j));
nu_k = exp(eta_k)/(1+exp(eta_k));
if (timej=1 and timek=2) or (timej=2 and timek=3) or (timej=3 and timek=4)
then mu11 = nu_j*nu_k + rho_1*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=3) or (timej=2 and timek=4)
then mu11 = nu_j*nu_k + rho_2*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=4)
then mu11 = nu_j*nu_k + rho_3*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k));
mu10 = nu_j - mu11;
mu01 = nu_k - mu11;
mu00 = 1 - (mu11+mu10+mu01);
if responsek = 1 and responsej = 1 then loglik=wik*log(mu11/(mu11 + mu10)); else
if responsek = 0 and responsej = 1 then loglik=wik*log(mu10/(mu11 + mu10)); else
if responsek = 1 and responsej = 0 then loglik=wik*log(mu01/(mu01 + mu00)); else
if responsek = 0 and responsej = 0 then loglik=wik*log(mu00/(mu01 + mu00)); else
if responsej = 1 and responsek = 999 then loglik= wij*log(mu11 + mu10); else
if responsej = 0 and responsek = 999 then loglik= wij*log(mu00 + mu01);
model intercept ~ general(loglik);
run;

/*DOUBLY ROBUST CASE*/
/*'Help' Bahadur model to model expectations*/
proc nlmixed data=model_gsa_wi_AC QPOINTS=20;
parms kappa0=0 kappa1=0 kappa2=0 kappa3=0 omega1=0 omega2=0 omega3=0 tau_1=0 tau_2=0 tau_3=0;
if gsabin2 ne . then do;
if (timej=1 and timek=2) or (timej=1 and timek=3) or (timej=1 and timek=4) then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 ;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 ;
end; else
if timej=2 and timek=3 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega1*gsabin1;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega2*gsabin1;
end; else
if timej=2 and timek=4 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega1*gsabin1;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega3*gsabin1;
end; else
if timej=3 and timek=4 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega2*gsabin1 + omega1*gsabin2;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega3*gsabin1 + omega2*gsabin2;
end;
end;
if gsabin2 = . then do;
if (timej=1 and timek=2) or (timej=1 and timek=3) or (timej=1 and timek=4) then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 ;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 ;
end; else
if timej=2 and timek=3 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega1*gsabin1;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega2*gsabin1;
end; else
if timej=2 and timek=4 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega1*gsabin1;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega3*gsabin1;
end; else
if timej=3 and timek=4 then do;
eta_j = kappa0 + kappa1*timej + kappa2*timej_2+ kappa3*pca0 + omega2*gsabin1;
eta_k = kappa0 + kappa1*timek + kappa2*timek_2+ kappa3*pca0 + omega3*gsabin1;
end;
end;
q_j = exp(eta_j)/(1+exp(eta_j));
q_k = exp(eta_k)/(1+exp(eta_k));
if (timej=1 and timek=2) or (timej=2 and timek=3) or (timej=3 and timek=4)
then mu11 = q_j*q_k + tau_1*sqrt(q_j*(1-q_j)*q_k*(1-q_k)); else
if (timej=1 and timek=3) or (timej=2 and timek=4)
then mu11 = q_j*q_k + tau_2*sqrt(q_j*(1-q_j)*q_k*(1-q_k)); else
11
if (timej=1 and timek=4)
then mu11 = q_j*q_k + tau_3*sqrt(q_j*(1-q_j)*q_k*(1-q_k));
mu10 = q_j - mu11;
mu01 = q_k - mu11;
mu00 = 1 - (mu11+mu10+mu01);
if responsej = 1 and responsek = 1 then loglik=log(mu11); else
if responsej = 1 and responsek = 0 then loglik=log(mu10); else
if responsej = 0 and responsek = 1 then loglik=log(mu01); else
if responsej = 0 and responsek = 0 then loglik=log(mu00);
if responsej = 1 and responsek = 999 then loglik= log(mu11 + mu10); else
if responsej = 0 and responsek = 999 then loglik= log(mu00 + mu01);
model intercept ~ general(loglik);
run;

/*The data for the analysis looks as follows (model_gsa_wi_qs_ac.sas7bdat):*/
/*
 PATID pca0 intercept responsej timej timej_2 responsek timek timek_2    wij      wik     q11     q10     q01    q11
     1  3       1         0       1     1        999     2       4     1.00000 1.50253 0.65036 0.16425 0.09806 0.08733
     1  3       1         0       1     1        999     3       9     1.00000 1.50253 0.65232 0.16229 0.09357 0.09182
     1  3       1         0       1     1        999     4       16    1.00000 1.50253 0.70389 0.11072 0.10458 0.08081
     2  5       1         1       1     1        999     2       4     1.00000 1.25292 0.55410 0.19757 0.11795 0.13039
     2  5       1         1       1     1        999     3       9     1.00000 1.25292 0.55665 0.19501 0.11244 0.13590
     2  5       1         1       1     1        999     4       16    1.00000 1.25292 0.61516 0.13650 0.12893 0.11940
 ...
*/

/*The code for available cases is as follows:*/
proc nlmixed data=model_gsa_wi_qs_ac QPOINTS=20;
parms beta0=0 beta1=0 beta2=0 beta3=0 rho_1=0 rho_2=0 rho_3=0;
eta_j = beta0 + beta1*timej + beta2*timej_2+ beta3*pca0 ;
eta_k = beta0 + beta1*timek + beta2*timek_2+ beta3*pca0 ;
12
nu_j = exp(eta_j)/(1+exp(eta_j));
nu_k = exp(eta_k)/(1+exp(eta_k));
if (timej=1 and timek=2) or (timej=2 and timek=3) or (timej=3 and timek=4)
then mu11 = nu_j*nu_k + rho_1*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=3) or (timej=2 and timek=4)
then mu11 = nu_j*nu_k + rho_2*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=4)
then mu11 = nu_j*nu_k + rho_3*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k));
mu10 = nu_j - mu11;
mu01 = nu_k - mu11;
mu00 = 1 - (mu11+mu10+mu01);
Exp_cond1=q11/(q11+q10)*log(mu11/(mu11+mu10))+q10/(q11+q10)*log(mu10/(mu11+mu10));
/*Responsej=1*/
Exp_cond0=q01/(q01+q00)*log(mu01/(mu01+mu00))+q00/(q01+q00)*log(mu00/(mu01+mu00));
/*Responsej=0*/
if responsek = 1 and responsej = 1 then loglik=wik*log(mu11/(mu11 + mu10)) + (1-wik)*Exp_cond1; else
if responsek = 0 and responsej = 1 then loglik=wik*log(mu10/(mu11 + mu10)) + (1-wik)*Exp_cond1; else
if responsek = 1 and responsej = 0 then loglik=wik*log(mu01/(mu01 + mu00)) + (1-wik)*Exp_cond0; else
if responsek = 0 and responsej = 0 then loglik=wik*log(mu00/(mu01 + mu00)) + (1-wik)*Exp_cond0; else
if responsej = 1 and responsek = 999 then loglik= wij*log(mu11 + mu10) + (1-wik)*Exp_cond1
+ (1-wij)*log(q11+q10); else
if responsej = 0 and responsek = 999 then loglik= wij*log(mu00 + mu01)+ (1-wik)*Exp_cond0
+ (1-wij)*log(q01+q00);
model intercept ~ general(loglik);
run;

/*After selecting the data for the complete pairs, the model can be fitted using the following program:*/
proc nlmixed data=model_gsa_wi_qs_cp QPOINTS=20;
parms beta0=0 beta1=0 beta2=0 beta3=0 rho_1=0 rho_2=0 rho_3=0;
eta_j = beta0 + beta1*timej + beta2*timej_2+ beta3*pca0 ;
eta_k = beta0 + beta1*timek + beta2*timek_2+ beta3*pca0 ;
nu_j = exp(eta_j)/(1+exp(eta_j));
nu_k = exp(eta_k)/(1+exp(eta_k));
if (timej=1 and timek=2) or (timej=2 and timek=3) or (timej=3 and timek=4)
then mu11 = nu_j*nu_k + rho_1*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=3) or (timej=2 and timek=4)
then mu11 = nu_j*nu_k + rho_2*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k)); else
if (timej=1 and timek=4)
then mu11 = nu_j*nu_k + rho_3*sqrt(nu_j*(1-nu_j)*nu_k*(1-nu_k));
mu10 = nu_j - mu11;
mu01 = nu_k - mu11;
mu00 = 1 - (mu11+mu10+mu01);
Exp_joint=q11*log(mu11)+q10*log(mu10)+q01*log(mu01)+q00*log(mu00);
if responsej = 1 and responsek = 1 then loglik=wik*log(mu11)+(1-wik)*Exp_joint; else
if responsej = 1 and responsek = 0 then loglik=wik*log(mu10)+(1-wik)*Exp_joint; else
if responsej = 0 and responsek = 1 then loglik=wik*log(mu01)+(1-wik)*Exp_joint; else
if responsej = 0 and responsek = 0 then loglik=wik*log(mu00)+(1-wik)*Exp_joint;
model intercept ~ general(loglik);
run;
