### Example 1
library(ggplot2)
library(gridExtra)

# Simulation of the data
# set.seed(0911)
# alpha1<-0.7;alpha2<-0.7
# lam1_v<-rep(5,12) 
# lam2_v<-rep(1,12) 
# n<-500
# y<-c(rep(seq(1:12), 41), seq(1:8))
# x <- vector()
# x[1] <- rpois(1,lam1_v[1]/(1-alpha1))
# for(j in 2:n) 
# {
#   alpha <- ifelse(j <= 400, alpha1, alpha2)
#   lam1 <- lam1_v[y[j]]
#   lam2 <- lam2_v[y[j]]
#   lambda <- ifelse(j <= 400, lam1, lam2)
#   x[j] <- rbinom(1,x[j-1],alpha)+rpois(1,lambda)
# }
# 
# x2 <- vector()
# x2[1] <- rpois(1,lam1/(1-alpha1))
# for(j in 2:n) 
# {
#   x2[j] <- rbinom(1,x2[j-1],alpha1)+rpois(1,lam1)
# }

data.ex1 <- read.table("LaTeX/StatMod/ex3_1.txt", sep="", header=T)
x        <- data.ex1$series_a
x2       <- data.ex1$series_b
n        <- length(x)
y        <- c(rep(seq(1:12), 41), seq(1:8))

bacfdf1 <- data.frame(Time=seq(1:500), Count=x)
bacfdf2 <- data.frame(Time=seq(1:500), Count=x2)
g1 <- ggplot(data = bacfdf1, mapping = aes(x = Time, y = Count)) + geom_line() + xlab("Time\n (a)") + geom_vline(xintercept=400, linetype="dotted", size=1.5)
g2 <- ggplot(data = bacfdf2, mapping = aes(x = Time, y = Count)) + geom_line() + xlab("Time\n (b)")

### figure 1
grid.arrange(g1, g2, ncol=2)

IND <- c(rep(0, 400), rep(1, 100))
loglik <- function(b)
{
  loglik<-0
  for (i in 2:n)
  {
    c <- 0
    m <- min(x[i-1], x[i])
    for (k in 0:m)
      {
        c <- c + (b[2]^k*(1-b[2])^(x[i-1]-k)*(b[1]+b[3]*IND[i])^(x[i]-k))/
          (factorial(k)*factorial(x[i]-k)*factorial(x[i-1]-k))
      }
      loglik <- loglik - log(c) + b[1]+b[3]*IND[i]
  }
  loglik
}

MLE.inar1 <- nlm(loglik,p=c(1, 0.5, 1), hessian=TRUE,iterlim=1000)
sigma <- solve(MLE.inar1$hessian)
lim.inf95 <- MLE.inar1$estimate - 1.96*sqrt(diag(sigma))
lim.sup95 <- MLE.inar1$estimate + 1.96*sqrt(diag(sigma))

loglik2 <- function(b)
{
  loglik<-0
  for (i in 2:n)
  {
    c <- 0
    m <- min(x2[i-1], x2[i])
    for (k in 0:m)
      {
        c <- c + (b[2]^k*(1-b[2])^(x2[i-1]-k)*(b[1]+b[3]*IND[i])^(x2[i]-k))/
          (factorial(k)*factorial(x2[i]-k)*factorial(x2[i-1]-k))
      }
      loglik <- loglik - log(c) + b[1]+b[3]*IND[i]
  }
  loglik
}

MLE.inar2 <- nlm(loglik2,p=c(1, 0.7, 1), hessian=TRUE,iterlim=1000)
sigma <- solve(MLE.inar2$hessian)
lim.inf95 <- MLE.inar2$estimate - 1.96*sqrt(diag(sigma))
lim.sup95 <- MLE.inar2$estimate + 1.96*sqrt(diag(sigma))

### Hudecová S., Husková M. and Meintanis S. (2015)
z <- x # Select first (with intervention) or second (without intervention) series
loglik3 <- function(b)
{
  loglik<-0
  for (i in 2:200) ### We use the first 200 observations to estimate the parameters (training data)
  {
    c <- 0
    m <- min(z[i-1], z[i])
    for (k in 0:m)
    {
      c <- c + (b[2]^k*(1-b[2])^(z[i-1]-k)*(b[1])^(z[i]-k))/
        (factorial(k)*factorial(z[i]-k)*factorial(z[i-1]-k))
    }
    loglik <- loglik - log(c) + b[1]
  }
  loglik
}

MLE.inar3 <- nlm(loglik3,p=c(5, 0.7), hessian=TRUE,iterlim=1000)
sigma3 <- solve(MLE.inar3$hessian)
MLE.inar3$estimate
MLE.inar3$estimate - 1.96*sqrt(diag(sigma3))
MLE.inar3$estimate + 1.96*sqrt(diag(sigma3))

S_mt <- function(t)
{
  m <- 200
  Q <- function(m, t, u)
  {
    sum <- 0
    for (i in (m+2):length(z))
    {
      sum <- sum + u^z[i]-((1+MLE.inar3$estimate[2]*(u-1))^z[i-1])*(exp(-MLE.inar3$estimate[1] + MLE.inar3$estimate[1]*u))
    }
    resQ <- (1/sqrt(200))*sum
    return(resQ)
  }
  integrand <- function(u)
  {
    return((Q(m, t, u)-(t/200)*Q(0, 200, u))^2)
  }
  res <- integrate(integrand, 0, 1)$value
  return(res)
}

resultat <- vector()
for (i in 1:300)
{
  resultat[i] <- S_mt(i+200)
}

gamma <- 0
q_gamma <- function(s)
{
  return((1+s)*((s/(s+1))^gamma))
}  

def <- vector()
for (i in 1:300)
{
  def[i] <- resultat[i]/q_gamma((i+200)/200)
}

### Estimation of the intervention time (200 observations were used as training data)
which(def>qnorm(0.975))[1]+200 