## Example 3.2
library(zoo)
library(ggplot2)
library(gridExtra)

df <- read.table("LaTeX/StatMod/ex3_2.txt", header=T)

x2 <- as.numeric(df$VanKilled)
y  <- df$time
IND <- df$law

coefcomb <- function(n,m)
{
  resultat <- factorial(n)/(factorial(m)*factorial(n-m))
  resultat
}

loglik <- function(b)
{
  loglik <- 0
  period <- 12
  for (i in 13:length(x2))
  {
    if (substr(y[i],1,3)=="Jan")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[1]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[1]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Feb")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[2]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[2]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Mar")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[3]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[3]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Apr")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[4]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[4]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="May")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[5]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[5]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Jun")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[6]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[6]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Jul")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[7]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[7]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Aug")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[8]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[8]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Sep")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[9]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[9]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Oct")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[10]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[10]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Nov")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[11]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[11]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Dec")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
              (exp(-b[12]*df$PetrolPrice[i]-b[period+3]*IND[i]-b[period+4]*i/12)*
                  (b[12]*df$PetrolPrice[i]+b[period+3]*IND[i]+b[period+4]*i/12)^(x2[i]-k-n))/
                  factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    loglik <- loglik - log(c)
  }#for
  return(loglik)
}#loglik

MLE.ex1.inar2 <- nlm(loglik, p=c(1,1,1,1,1,1,1,1,1,1,1,1,0.1,0.1,1,1), hessian=TRUE)
sigma <- solve(MLE.ex1.inar2$hessian)
low95 <- MLE.ex1.inar2$estimate-qnorm(0.975)*sqrt(diag(sigma))
upp95 <- MLE.ex1.inar2$estimate+qnorm(0.975)*sqrt(diag(sigma))

### AIC
32+2*MLE.ex1.inar2$minimum ### proposed model:   923.2088

est_inar2_ex1   <- vector()
v_est_inar2_ex1 <- vector()
est_inar2_ex1[1:12] <- x2[1:12]
v_est_inar2_ex1[1:12] <- 0
for (i in 13:length(x2))
{
  if(substr(y[i], 1, 3)=="Jan") t <- 1
  if(substr(y[i], 1, 3)=="Feb") t <- 2
  if(substr(y[i], 1, 3)=="Mar") t <- 3
  if(substr(y[i], 1, 3)=="Apr") t <- 4
  if(substr(y[i], 1, 3)=="May") t <- 5
  if(substr(y[i], 1, 3)=="Jun") t <- 6
  if(substr(y[i], 1, 3)=="Jul") t <- 7
  if(substr(y[i], 1, 3)=="Aug") t <- 8
  if(substr(y[i], 1, 3)=="Sep") t <- 9
  if(substr(y[i], 1, 3)=="Oct") t <- 10
  if(substr(y[i], 1, 3)=="Nov") t <- 11
  if(substr(y[i], 1, 3)=="Dec") t <- 12
  est_inar2_ex1[i] <- MLE.ex1.inar2$estimate[13]*x2[i-1] + MLE.ex1.inar2$estimate[14]*x2[i-12] + 
    MLE.ex1.inar2$estimate[t]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[15]*IND[i]+MLE.ex1.inar2$estimate[16]*i/12
  v_est_inar2_ex1[i] <- diag(sigma)[13]*x2[i-1]^2+diag(sigma)[14]*x2[i-12]^2+diag(sigma)[t]*df$PetrolPrice[i]^2+diag(sigma)[15]*IND[i]^2+
    diag(sigma)[16]*(i/12)^2+
    2*x2[i-1]*df$PetrolPrice[i]*sigma[13,t]+2*x2[i-12]*df$PetrolPrice[i]*sigma[14,t]+2*x2[i-1]*IND[i]*sigma[13,15]+2*x2[i-12]*IND[i]*sigma[14,15]+
    2*x2[i-1]*i/12*sigma[13,16]+2*x2[i-12]*i/12*sigma[14,16]+2*IND[i]*df$PetrolPrice[i]*sigma[15,16]
}
est_inar2_ex1_low <- est_inar2_ex1-1.96*sqrt(v_est_inar2_ex1)
for (i in 1:length(est_inar2_ex1_low))
{
  if (est_inar2_ex1_low[i] < 0) est_inar2_ex1_low[i] <- 0
}
est_inar2_ex1_upp <- est_inar2_ex1+1.96*sqrt(v_est_inar2_ex1)
df2 <- data.frame(Time=y, Observed=x2, Estimated=est_inar2_ex1, ci_inf=est_inar2_ex1_low, ci_sup=est_inar2_ex1_upp)
df2$Time <- paste0("1/", df2$Time)
df2$Time <- gsub(" ", "/", df2$Time)
df2$Time <- as.yearmon(df2$Time, format="%d/%b/%Y")

### Observations within the interval (proposed model)
in.int <- df2[df2$Observed >= df2$ci_inf & df2$Estimated <= df2$ci_sup, ]
round(dim(in.int)/dim(df2)*100, 2)[1] ### 85.94%

### figure 2
ggplot(df2, aes(Time)) + geom_line(aes(y = Observed, linetype = "Observed")) + 
  geom_line(aes(y = Estimated, linetype="Estimated")) + scale_x_yearqtr(breaks = seq(from = min(df2$Time), to = max(df2$Time), by = 0.25),
                                                                        format = "%YQ%q") + xlab("") + ylab("Number of causalties") + scale_y_continuous(limits=c(0, 32)) +
  theme(axis.text.x = element_text(angle = 45, hjust = 1)) +
  geom_vline(xintercept = 1983.083, colour="black", size=1.1) +
  geom_ribbon(aes(ymin = ci_inf, ymax = ci_sup), alpha=0.4, fill = "grey70") + scale_linetype_manual(values=c(2, 1), name="")

### mid pseudo-residuals
probs <- function(x, nn)
{
  period <- 12
  if (substr(y[nn],1,3)=="Jan")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[1]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[1]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Feb")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[2]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[2]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Mar")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[3]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[3]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Apr")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[4]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[4]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="May")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[5]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[5]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Jun")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[6]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[6]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Jul")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[7]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[7]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Aug")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[8]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[8]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Sep")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[9]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[9]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Oct")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[10]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[10]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Nov")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[11]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[11]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
    if (substr(y[nn],1,3)=="Dec")
    {
      c <- 0
      m <- min(x2[nn-1], x)
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[nn-12], x-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[nn-12],n)*(MLE.ex1.inar2$estimate[period+2]^n)*(1-MLE.ex1.inar2$estimate[period+2])^(x2[nn-12]-n))*
              (exp(-MLE.ex1.inar2$estimate[12]*df$PetrolPrice[i]-MLE.ex1.inar2$estimate[period+3]*IND[nn]-MLE.ex1.inar2$estimate[period+4]*nn/12)*
                  (MLE.ex1.inar2$estimate[12]*df$PetrolPrice[i]+MLE.ex1.inar2$estimate[period+3]*IND[nn]+MLE.ex1.inar2$estimate[period+4]*nn/12)^(x-k-n))/
                  factorial(x-k-n))
        }#for
        c <- c + (MLE.ex1.inar2$estimate[period+1]^k*(1-MLE.ex1.inar2$estimate[period+1])^(x2[nn-1]-k)*coefcomb(x2[nn-1],k))*d
      }#for
    }#if
  return(c)
}#probs

un.neg <- function(x, m)
{
  if (x==0) return(0)
  res <- 0
  for (i in 0:(x-1))
  {
    res <- res + probs(i, m)
  }
  return(res)
}

un.pos <- function(x, m)
{
  res <- 0
  for (i in 0:x)
  {
    res <- res + probs(i, m)
  }
  return(res)
}

### mid pseudo-residuals
mpr_neg <- vector()
mpr_neg[1:12] <- 0
for (i in 13:length(x2))
{
  mpr_neg[i] <- un.neg(x2[i], i)
}

mpr_pos <- vector()
mpr_pos[1:12] <- 0
for (i in 13:length(x2))
{
  mpr_pos[i] <- un.pos(x2[i], i)
}

mpr <- qnorm((mpr_neg+mpr_pos)/2)
mpr[1:12] <- 0

hist(mpr)
shapiro.test(mpr)

### figure 3
bacf   <- acf(mpr, lag.max=20, plot = FALSE)
bacfdf <- with(bacf[2:20], data.frame(lag, acf))
conf.level <- 0.95
ciline <- qnorm((1 - conf.level)/2)/sqrt(length(x2))
q1 <- ggplot(data = bacfdf, mapping = aes(x = lag, y = acf)) +
  geom_hline(aes(yintercept = 0)) + geom_hline(aes(yintercept = ciline), linetype=2) + geom_hline(aes(yintercept = -ciline), linetype=2)+
  geom_segment(mapping = aes(xend = lag, yend = 0)) + ylab("") + xlab("Lag") + ggtitle("ACF") + theme(plot.title = element_text(hjust = 0.5))
bacf   <- pacf(mpr, lag.max=20, plot = FALSE)
bacfdf <- with(bacf, data.frame(lag, acf))
conf.level <- 0.95
ciline <- qnorm((1 - conf.level)/2)/sqrt(length(x2))
q2 <- ggplot(data = bacfdf, mapping = aes(x = lag, y = acf)) +
  geom_hline(aes(yintercept = 0)) + geom_hline(aes(yintercept = ciline), linetype=2) + geom_hline(aes(yintercept = -ciline), linetype=2)+
  geom_segment(mapping = aes(xend = lag, yend = 0)) + ylab("") + xlab("Lag") + ggtitle("PACF") + theme(plot.title = element_text(hjust = 0.5))
grid.arrange(q1, q2, ncol=2)
