## Example 3.2 using the standard seasonal INAR model (Morina et al., 2011)
library(zoo)
library(ggplot2)
library(gridExtra)

df <- read.table("LaTeX/StatMod/ex3_2.txt", header=T)

x2 <- as.numeric(df$VanKilled)
y  <- df$time
IND <- df$law

coefcomb <- function(n,m)
{
  resultat <- factorial(n)/(factorial(m)*factorial(n-m))
  resultat
}

loglik <- function(b)
{
  loglik <- 0
  period <- 12
  for (i in 13:length(x2))
  {
    if (substr(y[i],1,3)=="Jan")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[1])*
                       (b[1])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Feb")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[2])*
                       (b[2])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Mar")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[3])*
                       (b[3])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Apr")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[4])*
                       (b[4])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="May")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[5])*
                       (b[5])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Jun")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[6])*
                       (b[6])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Jul")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[7])*
                       (b[7])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Aug")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[8])*
                       (b[8])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Sep")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[9])*
                       (b[9])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Oct")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[10])*
                       (b[10])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Nov")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[11])*
                       (b[11])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    if (substr(y[i],1,3)=="Dec")
    {
      c <- 0
      m <- min(x2[i-1], x2[i])
      for (k in 0:m)
      {
        d <- 0
        l <- min(x2[i-12], x2[i]-k)
        for (n in 0:l)
        {
          d <- d+((coefcomb(x2[i-12],n)*(b[period+2]^n)*(1-b[period+2])^(x2[i-12]-n))*
                    (exp(-b[12])*
                       (b[12])^(x2[i]-k-n))/
                    factorial(x2[i]-k-n))
        }#for
        c <- c + (b[period+1]^k*(1-b[period+1])^(x2[i-1]-k)*coefcomb(x2[i-1],k))*d
      }#for
    }#if
    loglik <- loglik - log(c)
  }#for
  return(loglik)
}#loglik

MLE.ex1.est <- nlm(loglik,p=c(1,1,1,1,1,1,1,1,1,1,1,1,0.1,0.1), hessian=TRUE,iterlim=1000)
sigma <- solve(MLE.ex1.est$hessian)

### AIC
14+2*MLE.ex1.est$minimum   ### seasonal INAR(2) AIC: 931.1917

est_inar2_ex1   <- vector()
v_est_inar2_ex1 <- vector()
est_inar2_ex1[1:12] <- x2[1:12]
v_est_inar2_ex1[1:12] <- 0
for (i in 13:length(x2))
{
  if(substr(y[i], 1, 3)=="Jan") t <- 1
  if(substr(y[i], 1, 3)=="Feb") t <- 2
  if(substr(y[i], 1, 3)=="Mar") t <- 3
  if(substr(y[i], 1, 3)=="Apr") t <- 4
  if(substr(y[i], 1, 3)=="May") t <- 5
  if(substr(y[i], 1, 3)=="Jun") t <- 6
  if(substr(y[i], 1, 3)=="Jul") t <- 7
  if(substr(y[i], 1, 3)=="Aug") t <- 8
  if(substr(y[i], 1, 3)=="Sep") t <- 9
  if(substr(y[i], 1, 3)=="Oct") t <- 10
  if(substr(y[i], 1, 3)=="Nov") t <- 11
  if(substr(y[i], 1, 3)=="Dec") t <- 12
  est_inar2_ex1[i] <- MLE.ex1.est$estimate[13]*x2[i-1] + MLE.ex1.est$estimate[14]*x2[i-12] + 
    MLE.ex1.est$estimate[t]
  v_est_inar2_ex1[i] <- diag(sigma)[13]*x2[i-1]^2+diag(sigma)[14]*x2[i-12]^2+diag(sigma)[t]+
    2*x2[i-1]*x2[i-12]*sigma[13, 14]+2*x2[i-1]*sigma[13, t]+
    2*x2[i-12]*sigma[14, t]
}
est_inar2_ex1_low <- est_inar2_ex1-1.96*sqrt(v_est_inar2_ex1)
for (i in 1:length(est_inar2_ex1_low))
{
  if (est_inar2_ex1_low[i] < 0) est_inar2_ex1_low[i] <- 0
}
est_inar2_ex1_upp <- est_inar2_ex1+1.96*sqrt(v_est_inar2_ex1)
df2 <- data.frame(Time=y, Observed=x2, Estimated=est_inar2_ex1, ci_inf=est_inar2_ex1_low, ci_sup=est_inar2_ex1_upp)
df2$Time <- paste0("1/", df2$Time)
df2$Time <- gsub(" ", "/", df2$Time)
df2$Time <- as.yearmon(df2$Time, format="%d/%b/%Y")

### Observations within the interval
in.int2 <- df2[df2$Observed >= df2$ci_inf & df2$Estimated <= df2$ci_sup, ]
round(dim(in.int2)/dim(df2)*100, 2)[1] ### 69.27%
