## Example 3.2 using tscount (Liboschik, 2016)
library(tscount)

df <- Seatbelts[, "VanKilled"]

regressors <- cbind(PetrolPrice=Seatbelts[, "PetrolPrice"], linearTrend=seq(along=df)/12)
seatbeltsfit_alldata <- tsglm(ts=df, link="log", model=list(past_obs=c(1,12)),
                              distr="pois", xreg=regressors)

interv_test(seatbeltsfit_alldata, tau=170, delta=1, est_interv=TRUE)

summary(seatbeltsfit_alldata)$AIC