###Consumption Counts, Chatfield & Goodhardt (1970)
###We consider the number of customers that bought in exactly z out of 12 weeks at least one unit of "Brand M". 25 customers did not buy "Brand M" in any of the weeks. See Table 3 in Chatfield & Goodhardt (1970).
###Reference: Chatfield, C., Goodhardt, G.J. (1970) The beta-binomial model for consumer purchasing behaviour. Journal of the Royal Statistical Society. Series C (Applied Statistics) 19(3), 240-250.

N <- 12 #number of weeks

data <- c(25,7,6,4,3,2,1,1,0,1,0,0,0) #From Table 3 in Chatfield & Goodhardt (1970)
X <- rep(0:N,data)
n <- length(X)

#Descriptive Statistics
(H <- tabulate(X+1)) #absolute frequencies
(mu <- mean(X))
#1.5
(sigma2 <- var(X))
#4.459184
(p0 <- sum(X==0)/n) #zero frequency
#0.5
(U <- max(X)) #maximum of observations


##Estimation
#Table for Results
Results <- matrix(0,0,12)
colnames(Results) <- c("pi","phi","omega",paste0("np_",0:6),"np_>=7","BIC")
#Information about data
Results <- rbind(Results,c(NA,NA,NA,H[1:7],sum(H[8:10]),NA))
rownames(Results) <- "data"

###Binomial distribution
llh_Bin <- function(param){
  llh <- sum(H*log(dbinom(0:U,N,param)))
  
  return(-llh)
}

estim_Bin <- optim(mean(X)/N,llh_Bin,method="L-BFGS-B",lower=c(0.0001),upper=c(0.9999),hessian=TRUE)

pi_Bin <- estim_Bin$par[1]
ofiest_Bin <- estim_Bin$hessian #inverse covariance
neglmax_Bin <- estim_Bin$value
estcov_Bin <- solve(ofiest_Bin)

stadflr_Bin <- rep(0,1)
stadflr_Bin[1] <- sqrt(estcov_Bin[[1,1]])

BIC_Bin <- 2*neglmax_Bin+log(n)*1

Results <- rbind(Results, c(pi_Bin,NA,NA,n*dbinom(0:6,N,pi_Bin),n*sum(dbinom(7:N,N,pi_Bin)),BIC_Bin))
Results <- rbind(Results, c(stadflr_Bin,rep(NA,ncol(Results)-1)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("Bin","s.e.")

###Beta-Binomial distribution
#Beta-binomial distribution:
dbbinom <- function(x, N, alpha, bet){
  choose(N,x) * beta(x+alpha, N-x+bet) / beta(alpha, bet)
}


llh_BBin <- function(param,data){
  pi <- param[1]
  phi <- param[2]
  
  P <- dbbinom(0:U,N,(1-phi)/phi*pi,(1-phi)/phi*(1-pi))
  llh <- sum(H*log(P))
  return(-llh)
}

pi_start_BBin <- mean(X)/N
phi_start_BBin <- min(max(0.001, (var(X)/(N*pi_start_BBin*(1-pi_start_BBin))-1)/(N-1) ), 0.999)

esti_BBin <- optim(c(pi_start_BBin,phi_start_BBin),llh_BBin,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(0.9999,0.9999),data=X,hessian=TRUE)
pi_BBin <- esti_BBin$par[1]
phi_BBin <- esti_BBin$par[2]
ofiest_BBin <- esti_BBin$hessian #inverse covariance
neglmax_BBin <- esti_BBin$value
estcov_BBin <- solve(ofiest_BBin)

stadflr_BBin <- rep(0,2)
stadflr_BBin[1] <- sqrt(estcov_BBin[[1,1]])
stadflr_BBin[2] <- sqrt(estcov_BBin[[2,2]])

BIC_BBin <- 2*neglmax_BBin+log(n)*2

Results <- rbind(Results, c(c(pi_BBin,phi_BBin),NA,n*dbbinom(0:6,N,(1-phi_BBin)/phi_BBin*pi_BBin,(1-phi_BBin)/phi_BBin*(1-pi_BBin)),n*sum(dbbinom(7:N,N,(1-phi_BBin)/phi_BBin*pi_BBin,(1-phi_BBin)/phi_BBin*(1-pi_BBin))),BIC_BBin))
Results <- rbind(Results, c(stadflr_BBin,rep(NA,ncol(Results)-2)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("BB","s.e.")

###Zero-Inflated Beta-Binomial distribution

llh_ZIBB <- function(param,data){
  pi <- param[1]
  phi <- param[2]
  omega <- param[3]
  
  llh <- 0
  
  for(t in 1:n){
    llh <- llh + log(omega*(data[t]==0)+(1-omega)*dbbinom(data[t],N,(1-phi)/phi*pi,(1-phi)/phi*(1-pi)))
  }
  
  return(-llh)
}


pi_start_ZIBB <- mean(X)/N*1.1
omega_start_ZIBB <- 1-mean(X)/(N*pi_start_ZIBB)
phi_start_ZIBB <- min( max( ((var(X) - omega_start_ZIBB*(1-omega_start_ZIBB)*N*N*pi_start_ZIBB^2)/( (1-omega_start_ZIBB)*N*pi_start_ZIBB*(1-pi_start_ZIBB)) -1)/(N-1), 0.001), 0.9999)

estim_ZIBB <- optim(c(pi_start_ZIBB,phi_start_ZIBB,omega_start_ZIBB),llh_ZIBB,method="L-BFGS-B",lower=c(0.0001,0.001,0.0001),upper=c(0.9999,0.9999,p0-0.0001),data=X,hessian=TRUE)
pi_ZIBB <- estim_ZIBB$par[1]
phi_ZIBB <- estim_ZIBB$par[2]
omega_ZIBB <- estim_ZIBB$par[3]

ofiest_ZIBB <- estim_ZIBB$hessian #inverse covariance
neglmax_ZIBB <- estim_ZIBB$value
estcov_ZIBB <- solve(ofiest_ZIBB)

stadflr_ZIBB <- rep(0,3)
stadflr_ZIBB[1] <- sqrt(estcov_ZIBB[[1,1]])
stadflr_ZIBB[2] <- sqrt(estcov_ZIBB[[2,2]])
stadflr_ZIBB[3] <- sqrt(estcov_ZIBB[[3,3]])

BIC_ZIBB <- 2*neglmax_ZIBB+log(n)*3

Results <- rbind(Results, c(c(pi_ZIBB,phi_ZIBB,omega_ZIBB),n*c(omega_ZIBB*c(1,rep(0,6))+(1-omega_ZIBB)*dbbinom(0:6,N,(1-phi_ZIBB)/phi_ZIBB*pi_ZIBB,(1-phi_ZIBB)/phi_ZIBB*(1-pi_ZIBB))),n*sum((1-omega_ZIBB)*dbbinom(7:N,N,(1-phi_ZIBB)/phi_ZIBB*pi_ZIBB,(1-phi_ZIBB)/phi_ZIBB*(1-pi_ZIBB))),BIC_ZIBB))
Results <- rbind(Results, c(stadflr_ZIBB,rep(NA,ncol(Results)-3)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("ZIBB","s.e.")

###"Excessive demand" inflated Beta-Binomial (ELIBB) distribution, reduced to a = 1, b = -1
llh_ELIBB <- function(param){
  pi <- param[1]
  phi <- param[2]
  a <- 1
  b <- -1
  
  P <- c(1-a-b*pi+a*dbbinom(0,N,(1-phi)/phi*pi,(1-phi)/phi*(1-pi)),(a+b/N*1:U)*dbbinom(1:U,N,(1-phi)/phi*pi,(1-phi)/phi*(1-pi)))
  
  llh <- sum(H*log(P))
  return(-llh)
  
}

pi_start_ELIBB <- mean(X)/N
phi_start_ELIBB <- 0.05

estim_ELIBB <- optim(c(pi_start_ELIBB,phi_start_ELIBB),llh_ELIBB,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(0.9999,0.9999),hessian=TRUE)

pi_ELIBB <- estim_ELIBB$par[1]
phi_ELIBB <- estim_ELIBB$par[2]

ofiest_ELIBB <- estim_ELIBB$hessian #inverse covariance
neglmax_ELIBB <- estim_ELIBB$value
estcov_ELIBB <- solve(ofiest_ELIBB)

stadflr_ELIBB <- rep(0,2)
stadflr_ELIBB[1] <- sqrt(estcov_ELIBB[[1,1]])
stadflr_ELIBB[2] <- sqrt(estcov_ELIBB[[2,2]])

BIC_ELIBB <- 2*neglmax_ELIBB+log(n)*2

Results <- rbind(Results, c(pi_ELIBB,phi_ELIBB,NA,n*c(pi_ELIBB+dbbinom(0,N,(1-phi_ELIBB)/phi_ELIBB*pi_ELIBB,(1-phi_ELIBB)/phi_ELIBB*(1-pi_ELIBB)),(1-1/N*1:6)*dbbinom(1:6,N,(1-phi_ELIBB)/phi_ELIBB*pi_ELIBB,(1-phi_ELIBB)/phi_ELIBB*(1-pi_ELIBB))),n*sum((1-1/N*7:N)*dbbinom(7:N,N,(1-phi_ELIBB)/phi_ELIBB*pi_ELIBB,(1-phi_ELIBB)/phi_ELIBB*(1-pi_ELIBB))) , BIC_ELIBB ) ) 
Results <- rbind(Results, c(stadflr_ELIBB,rep(NA,ncol(Results)-2)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("ELIBB","s.e.")

View(cbind(round(Results[,1:3],3),round(Results[,4:12],1)))
