###MPC Votes, Mller et al. (2018)
###Votes for a change of the interest rate in consecutive meetings of the Monetary Policy Council (MPC) of the National Bank of Poland (NBP) between 2002 and 2013. The MPC has 10 members. For more information see Mller et al. (2018) and Sirchenko (2013).
###References: Mller, T.A., Wei, C.H., Kim, H.-Y., Sirchenko, A. (2018) Modeling zero inflation in count data time series with bounded support. Methodology and Computing in Applied Probability 20(2), 589-609.
###            Sirchenko, A. (2013) A model for ordinal responses with an application to policy interest rate. NBP Working paper No 148


N <- 10 #number of MPC members

X <- c(8,  0,  3,  7,  9,  8,  4,  9,  6,  5,  5,  0,  8,  6,  7,  5,  5,  5,  0,  4,  0, 0,  0,  0,  0,  0,  0,  0,  0,  10, 6,  10, 0,  0,  0,  0,  0,  0,  9,  10, 0,  10, 6,  6,  0,  0,  0,  0,  7,  6,  0,  0,  0,  0,  0,  0,  0,  4,  4,  4,  0,  3,  5, 6,  4,  6,  1,  9,  0,  4,  10, 4,  9,  7,  10, 4,  4,  10, 3,  5,  5,  0,  8,  10, 10, 7,  5,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  5,  5, 4,  4,  10, 3,  9,  8,  9,  1,  0,  0,  0,  0,  0,  0,  0,  3,  8,  0,  2,  2,  4, 7,  10, 9,  7,  8,  0,  5,  5,  5,  0,  0,  0,  0)
n <- length(X)

#Descriptive Statistics
(U <- max(X))
(mu <- mean(X)) #mean
(sigma2 <- var(X)) #variance
(rho1 <- acf(X)$acf[2]) #autocorrelation function at lag 1
(p0 <- sum(X==0)/n) #zero frequency

###Estimation
#Table for Results
Results <- matrix(0,0,11)
colnames(Results) <- c("pi","rho","omega_alpha; a_alpha","b_alpha","omega_beta; a_beta","b_beta","BIC","p_0","mu","sigma^2","rho(1)")
#Information about data
Results <- rbind(Results,c(rep(NA,7),c(p0,mu,sigma2,rho1)))
rownames(Results) <- "data"

###ZIB-AR
pklZIB_pirBAR <- function(param){
  k <- param[1]
  l <- param[2]
  N <- param[3]
  r <- param[4]    #r
  pi <- param[5]  #pi
  omega_a <- param[6]
  omega_b <- param[7]
  
  beta <- pi*(1-r)
  alpha <- r+beta
  if(r>max(-pi/(1-pi),-(1-pi)/pi) && k>=0 && k<=N && l>=0 && l<=N){
    summ <- 0
    for(m in max(0,k+l-N):min(k,l)){
      summ <- summ + ((m==0)*omega_a +(1-omega_a)*choose(l,m)*alpha^m*(1-alpha)^(l-m))*((k==m)*omega_b+(1-omega_b)*choose(N-l,k-m)*beta^(k-m)*(1-beta)^(N-l+m-k))
    }
    return(summ)
  }else{
    print(c("k","l","N","r","pi","alpha","beta"))
    print(c(k,l,N,r,pi,alpha,beta))
    stop("Wrong Parametervalues!")
  }
}

Stat_ZIB_pirBAR <- function(param){
  s <- param[1]
  N <- param[2]
  r <- param[3]   #r
  pi <- param[4]  #pi
  omega_a <- param[5]
  omega_b <- param[6]
  
  PZIB <- matrix(0,(N+1),(N+1))
  for(k in 0:N){
    for(l in 0:N){
      PZIB[(k+1),(l+1)] <- pklZIB_pirBAR(c(l,k,N,r,pi,omega_a,omega_b)) #transposed matrix
    }
  }
  
  EV <- Re(eigen(t(PZIB),symmetric=FALSE)$vectors[,1])
  stat <- EV/sum(EV) 
  
  return(stat[(s+1)])
}

llh_ZIB_pirBAR <- function(param,data){
  r <- param[1]
  pi <- param[2]
  omega_a <- param[3]
  omega_b <- param[4]
  
  if(r>max(-pi/(1-pi),-(1-pi)/pi)){
    #sumt <- 0 #conditional llh
    sumt <- log(Stat_ZIB_pirBAR(c(data[1],N,r,pi,omega_a,omega_b)))
    
    for(t in 2:n){
      k <- data[t]
      l <- data[(t-1)]
      pkl <- pklZIB_pirBAR(c(k,l,N,r,pi,omega_a,omega_b))
      
      sumt <- sumt + log(pkl)
    }
    return(-sumt)
  }else{
    return(999999999)
  }
}



mlestim_ZIB_pirBAR <- optim(c(acf(X,plot=FALSE)$acf[2],mean(X)/N,0.1,0.1),llh_ZIB_pirBAR,method="L-BFGS-B",lower=c(-0.9999,0.0001,0.0001,0.0001),upper=c(0.9999,0.9999,0.9999,0.9999),data=X,hessian=TRUE)
pi_pirBAR <- mlestim_ZIB_pirBAR$par[2]
rho_pirBAR <- mlestim_ZIB_pirBAR$par[1]
omega_alpha_ZIB_AR_pirBAR <- mlestim_ZIB_pirBAR$par[3]
omega_beta_ZIB_AR_pirBAR <- mlestim_ZIB_pirBAR$par[4]

ofiest_ZIB_pirBAR <- mlestim_ZIB_pirBAR$hessian #inverse covariance
neglmax_ZIB_AR_pirBAR <- mlestim_ZIB_pirBAR$value
estcov_ZIB_pirBAR <- solve(ofiest_ZIB_pirBAR)

#Estimated standard errors:
s1_ZIB_pirBAR <- sqrt(estcov_ZIB_pirBAR[[1,1]])
s2_ZIB_pirBAR <- sqrt(estcov_ZIB_pirBAR[[2,2]])
s3_ZIB_pirBAR <- sqrt(estcov_ZIB_pirBAR[[3,3]])
s4_ZIB_pirBAR <- sqrt(estcov_ZIB_pirBAR[[4,4]])
stadflr_ZIB_AR_pirBAR <- c(s2_ZIB_pirBAR,s1_ZIB_pirBAR,s3_ZIB_pirBAR,s4_ZIB_pirBAR)

#BIC
BIC_ZIB_AR_pirBAR <- 2*neglmax_ZIB_AR_pirBAR+4*log(n)

#stationary marginal distribution
F <- rep(0,U+1)
for(i in 0:U){
  F[i+1] <- Stat_ZIB_pirBAR(c(i,N,rho_pirBAR,pi_pirBAR,omega_alpha_ZIB_AR_pirBAR,omega_beta_ZIB_AR_pirBAR))
}

Results <- rbind(Results, c(c(pi_pirBAR,rho_pirBAR,omega_alpha_ZIB_AR_pirBAR,NA,omega_beta_ZIB_AR_pirBAR,NA),BIC_ZIB_AR_pirBAR,F[1],sum(F*(0:N)),sum(F*(0:N-sum(F*(0:N)))^2),(1-omega_alpha_ZIB_AR_pirBAR)*(pi_pirBAR*(1-rho_pirBAR)+rho_pirBAR)-(1-omega_beta_ZIB_AR_pirBAR)*pi_pirBAR*(1-rho_pirBAR)))
Results <- rbind(Results, c(stadflr_ZIB_AR_pirBAR[1:3],NA,stadflr_ZIB_AR_pirBAR[4],rep(NA,ncol(Results)-5)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("ZIB-AR","s.e.")

###ZIB_SD-AR(1)
pkl_DDb_ZIB <- function(param){
  k <- param[1]
  l <- param[2]
  N <- param[3]
  r <- param[4]    #rho
  pi <- param[5]  #pi
  a_alpha <- param[6]
  b_alpha <- param[7]	
  a_beta <- param[8]
  b_beta <- param[9]        
  
  
  beta <- pi*(1-r)
  alpha <- r+beta
  omega <- function(theta){
    return((theta[2]+theta[1]*theta[3]/N))
  }
  
  if(pi<1 && pi>0 && r>max(-pi/(1-pi),-(1-pi)/pi) && k>=0 && k<=N && l>=0 && l<=N){
    summ <- 0
    for(m in max(0,k+l-N):min(k,l)){
      summ <- summ + ((m==0)*(1-omega(theta=c(l,a_alpha,b_alpha))) +(omega(theta=c(l,a_alpha,b_alpha)))*choose(l,m)*alpha^m*(1-alpha)^(l-m))*((k==m)*(1-omega(theta=c(N-l,a_beta,b_beta)))+(omega(theta=c(N-l,a_beta,b_beta)))*choose(N-l,k-m)*beta^(k-m)*(1-beta)^(N-l+m-k))
    }
    return(summ)
  }else{
    print(c("k","l","N","r","pi","alpha","beta"))
    print(c(k,l,n,r,pi,alpha,beta))
    stop("Wrong Parametervalues!")
  }
}


Stat_DDb_ZIB <- function(param){
  s <- param[1]
  N <- param[2]
  r <- param[3]   #rho
  pi <- param[4]  #pi
  a_alpha <- param[5]
  b_alpha <- param[6]
  a_beta <- param[7]
  b_beta <- param[8]
  
  PZIB <- matrix(0,(N+1),(N+1))
  for(k in 0:N){
    for(l in 0:N){
      PZIB[(k+1),(l+1)] <- pkl_DDb_ZIB(c(k,l,N,r,pi,a_alpha,b_alpha,a_beta,b_beta)) 
    }
  }
  
  EV <- Re(eigen(PZIB,symmetric=FALSE)$vectors[,1])
  stat <- EV/sum(EV) 
  
  return(stat[(s+1)])
}

llh_SDr_ZIB <- function(param,data){
  r <- param[1]
  pi <- param[2]
  a_alpha <- param[3]
  b_alpha <- 0
  a_beta <- 1
  b_beta <- param[4]
  
  if(r>max(-pi/(1-pi),-(1-pi)/pi) & pi*(1-r) < 1 & pi*(1-r)>0 & pi*(1-r)+r<1 & pi*(1-r)+r>0){
    sumt <- log(Stat_DDb_ZIB(c(data[1],N,r,pi,a_alpha,b_alpha,a_beta,b_beta)))
    
    for(t in 2:n){
      k <- data[t]
      l <- data[(t-1)]
      pkl <- pkl_DDb_ZIB(c(k,l,N,r,pi,a_alpha,b_alpha,a_beta,b_beta))
      
      sumt <- sumt + log(pkl)
    }
    #print(c(param,sumt))
    return(-sumt)
  }else{
    return(999999999)
  }
}



#Estimation full SDr-ZIB
mlestim_SDr_ZIB <- optim(c(0.1,0.7,0.7,-0.7),llh_SDr_ZIB,method="L-BFGS-B",lower=c(0.001,0.001,0.001,-0.999),upper=c(0.999,0.999,0.999,0.999),data=X,hessian=TRUE)
pi_SDr_ZIB_AR <- mlestim_SDr_ZIB$par[2]
rho_SDr_ZIB_AR <- mlestim_SDr_ZIB$par[1]
a_alpha_SDr_ZIB_AR <- mlestim_SDr_ZIB$par[3]
b_alpha_SDr_ZIB_AR <- 0
a_beta_SDr_ZIB_AR <- 1
b_beta_SDr_ZIB_AR <- mlestim_SDr_ZIB$par[4]

ofiest_SDr_ZIB <- mlestim_SDr_ZIB$hessian #inverse covariance
neglmax_SDr_ZIB_AR <- mlestim_SDr_ZIB$value
estcov_SDr_ZIB <- solve(ofiest_SDr_ZIB)

#Estimated standard errors:
s1_SDr_ZIB <- sqrt(estcov_SDr_ZIB[[1,1]])
s2_SDr_ZIB <- sqrt(estcov_SDr_ZIB[[2,2]])
s3_SDr_ZIB <- sqrt(estcov_SDr_ZIB[[3,3]])
s4_SDr_ZIB <- NA
s5_SDr_ZIB <- NA
s6_SDr_ZIB <- sqrt(estcov_SDr_ZIB[[4,4]])
stadflr_SDr_ZIB_AR <- c(s2_SDr_ZIB,s1_SDr_ZIB,s3_SDr_ZIB,s4_SDr_ZIB,s5_SDr_ZIB,s6_SDr_ZIB)

#BIC
BIC_SDr_ZIB_AR <- 2*neglmax_SDr_ZIB_AR+4*log(n)

#stationary marginal distribution
F <- rep(0,U+1)
for(i in 0:U){
  F[i+1] <- Stat_DDb_ZIB(c(i,N,rho_SDr_ZIB_AR,pi_SDr_ZIB_AR,a_alpha_SDr_ZIB_AR,b_alpha_SDr_ZIB_AR,a_beta_SDr_ZIB_AR,b_beta_SDr_ZIB_AR))
}

P <- matrix(0,N+1,N+1)
for(k in 0:N){
  for(l in 0:N){
    P[k+1,l+1] <- pkl_DDb_ZIB(c(k,l,N,rho_SDr_ZIB_AR,pi_SDr_ZIB_AR,a_alpha_SDr_ZIB_AR,b_alpha_SDr_ZIB_AR,a_beta_SDr_ZIB_AR,b_beta_SDr_ZIB_AR))
  }
}

#ACF
#max Lag
k <- 2
Pk <- diag(1,(N+1))
p_lag <- array(NA,c((k+1),(N+1),(N+1)))
for (l in 0:k){
  p_lag[(l+1),,] <- (Pk) %*% diag(F)
  Pk <- Pk %*% P
}


#range
h_var <- 0:k
summecov <- rep(0,length(h_var))
for (h in h_var){
  for (i in 0:N){
    for (j in 0:N){
      summecov[(h+1)] <- summecov[(h+1)] + i*j*p_lag[(h+1),(i+1),(j+1)]
    }
  }
}
corr <- (summecov-sum(F*0:N)^2)/sum(F*(0:N-sum(F*(0:N)))^2)


rho1_SDr_AR <- corr[2]

Results <- rbind(Results, c(pi_SDr_ZIB_AR,rho_SDr_ZIB_AR,a_alpha_SDr_ZIB_AR,NA,NA,b_beta_SDr_ZIB_AR,BIC_SDr_ZIB_AR,F[1],sum(F*(0:N)),sum(F*(0:N-sum(F*(0:N)))^2),rho1_SDr_AR))
Results <- rbind(Results, c(stadflr_SDr_ZIB_AR,rep(NA,ncol(Results)-6)))

rownames(Results)[(nrow(Results)-1):(nrow(Results))] <- c("ZIB_SD-AR","s.e.")


View(cbind(round(Results[,1:6],3),round(Results[,7],1),round(Results[,8:11],2)))
