###Thunderstorm Events (THE), Falls (1971)
###"Frequencies of the observed number of days that experienced x thunderstorm events at Cape Kennedy, Fla., for the 11-year period of record January 1957 through December 1967." x = 0, 1,... , 6. See Table 1 in Falls et al. (1971).
###Reference: Falls, L.W., Williford, W.O., Carter, M.C. (1971) Probability distributions for thunderstorm activity at Cape Kennedy, Florida. Journal of Applied Meteorology 10(1), 97-104.

Data <- matrix(0,7,12)
colnames(Data) <- month.abb
Data[1:3,1] <- c(335,4,2)
Data[1:4,2] <- c(295,9,4,2)
Data[1:5,3] <- c(308,20,9,3,1)
Data[1:4,4] <- c(299,18,10,3)
Data[1:7,5] <- c(266,43,25,3,3,0,1)
Data[1:7,6] <- c(187,77,40,17,6,2,1)
Data[1:6,7] <- c(177,80,47,26,9,2)
Data[1:6,8] <- c(185,89,30,24,10,3)
Data[1:5,9] <- c(228,54,33,12,3)
Data[1:4,10] <- c(311,17,9,4)
Data[1:3,11] <- c(321,6,3)
Data[1:4,12] <- c(334,3,2,2)

U <- 6

Results <- matrix(0,12,11)
rownames(Results) <- month.abb
colnames(Results) <- c("n","mu","sigma^2","p_0","Poi","Geom","ZIP","ZIGeom","UIP","UIGeom","NB")
Results[,1] <- colSums(Data) #n
Results[,2] <- apply(Data, 2, function(x) sum(x*(0:U))/sum(x)) #mean
Results[,3] <- apply(Data, 2, function(x) sum((rep(0:U,x)-sum(x*(0:U))/sum(x))^2)/(sum(x)-1)) #variance
Results[,4] <- Data[1,]/Results[,1] #p_0
for(m in 1:12){
  X <- rep(0:U,Data[,m]) #Data of month m
  n <- Results[m,1] #number of observations for month m
  p0 <- Results[m,4] #zero frequency for month m
  
  H <- tabulate(X+1) #absolute frequencies
  
  M <- max(X)
  
  ###Poisson
  lambda_est_Poi <- mean(X) #ML estimator is the mean of the data
  
  neglmax_Poi <- -n*lambda_est_Poi - sum(log(factorial(X))) + log(lambda_est_Poi)*sum(X) #value of maximized likelihood
  BIC_Poi <- -2*neglmax_Poi + log(n)*1 #BIC
  
  ###Geom
  llh_geom <- function(param){
    p <- param[1]
    
    P <- p*(1-p)^(0:M)
    
    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #ML estimation
  estim_geom <- optim(1/(1+exp(mean(X))),llh_geom,method="L-BFGS-B",lower=c(0.0001),upper=c(0.9999),hessian=TRUE)
  
  neglmax_geom <- estim_geom$value
  
  BIC_geom <- 2*neglmax_geom+log(n)*1
  
  ###ZIP
  llh_ZIP <- function(param){
    mu <- param[1]
    om <- param[2]
    
    P <- c(om+(1-om)*exp(-mu),(1-om)*dpois(1:M,mu))
    
    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #starting values for optimization 
  omega_start_ZIP <- max(min(((var(X)-mean(X))/(mean(X)^2))/(1+(var(X)-mean(X))/(mean(X)^2)),0.99),0.01)
  lambda_start_ZIP <- mean(X)/(1-omega_start_ZIP)
  
  #ML estimation
  estim_ZIP <- optim(c(lambda_start_ZIP,omega_start_ZIP),llh_ZIP,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(2*max(X),p0),hessian=TRUE)
  lambda_ZIP <- estim_ZIP$par[1]
  omega_ZIP <- estim_ZIP$par[2]
  neglmax_ZIP <- estim_ZIP$value #negative maximized log-likelihood
  BIC_ZIP <- 2*neglmax_ZIP+log(n)*2
  
  
  ###ZIGeom
  llh_ZIGeom <- function(param){
    p <- param[1]
    om <- param[2]
    
    P <- c(om+(1-om)*p,(1-om)*p*(1-p)^(1:M))
    
    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #starting values for optimization 
  p_start_ZIGeom <- (1-p0)/mean(X)
  omega_start_ZIGeom <- (p0-p_start_ZIGeom)/(1-p_start_ZIGeom)
  
  #ML estimation
  estim_ZIGeom <- optim(c(p_start_ZIGeom,omega_start_ZIGeom),llh_ZIGeom,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(0.9999,p0),hessian=TRUE)
  
  neglmax_ZIGeom <- estim_ZIGeom$value
  
  BIC_ZIGeom <- 2*neglmax_ZIGeom+log(n)*2
  
  ###UIP
  #likelihood function
  llh_UIP <- function(param){
    mu <- param[1]
    tau <- param[2]
    
    P <- c(exp(mu*(exp(-tau)-1)),exp(-mu)*((1-exp(-tau*(1:M)))*mu^(1:M))/factorial(1:M))
    
    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #starting values for optimization 
  lambda_start_UIP <- (lambda_ZIP+lambda_est_Poi)/2
  tau_start_UIP <- max((log((1-omega_ZIP)+omega_ZIP*exp(lambda_start_UIP)))/lambda_start_UIP, 0.01)
  
  #ML estimation
  estim_UIP <- optim(c(lambda_start_UIP,tau_start_UIP),llh_UIP,method="L-BFGS-B",lower=c(0.001,0.0001),upper=c(99.99,99.99),hessian=TRUE)
  
  neglmax_UIP <- estim_UIP$value #negative maximized log-likelihood
  
  BIC_UIP <- 2*neglmax_UIP+log(n)*2
  
  ###UIGeom
  llh_UIGeom <- function(param){
    p <- param[1]
    tau <- param[2]
    
    P <- c(p/(1-(1-p)*exp(-tau)),(1-exp(-tau*1:M))*p*(1-p)^(1:M))
    
    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #starting values for optimization 
  p_start_UIGeom <- min(p_start_ZIGeom,p0-0.0001)
  tau_start_UIGeom <- -log((p0-p_start_UIGeom)/(p0-p0*p_start_UIGeom))
  
  #ML estimation
  estim_UIGeom <- optim(c(p_start_UIGeom,tau_start_UIGeom),llh_UIGeom,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(0.9999,100),hessian=TRUE)
  
  neglmax_UIGeom <- estim_UIGeom$value

  BIC_UIGeom <- 2*neglmax_UIGeom+log(n)*2
  
  ###NB
  llh_NB <- function(param,data){
    mu <- param[1]
    r <- param[2]
    
    P <- dnbinom(0:M,size=r,mu=mu)

    llh <- sum(H*log(P))
    
    return(-llh)
  }
  
  #starting values for optimization 
  mu_start_NB <- mean(X)
  r_start_NB <- mean(X)^2/(var(X)-mean(X))
  
  #ML estimation
  estim_NB <- optim(c(mu_start_NB,r_start_NB),llh_NB,method="L-BFGS-B",lower=c(0.0001,0.0001),upper=c(M,1000),data=X,hessian=TRUE)
  neglmax_NB <- estim_NB$value
 
  BIC_NB <- 2*neglmax_NB+log(n)*2
  
  
  Results[m,5:11] <- rank(c(BIC_Poi,BIC_geom,BIC_ZIP,BIC_ZIGeom,BIC_UIP,BIC_UIGeom,BIC_NB))
}
View(round(Results,3))
