#########################################################################################
## Application to Sport Data 
#########################################################################################
rm(list=ls())
set.seed(4321)
library(rstan)
library(loo)

data(ais,package="sn")
data <- ais[which(ais$sport=="Row"),]

#VIEW
attach(data)
#invlogit <- function(x) exp(x)/(1+exp(x))

n <- nrow(data)
y <- Bfat/100
x1 <- LBM

###VIBReg model for the mean

stan.data <- list(
  N = n,
  y = y, 
  x1=x1
)

fit.VIBReg <- stan(
  file = "VIBReg.stan",  
  data = stan.data,    # named list of data
  chains = 1,             # number of Markov chains
  warmup = 1000,
  iter = 5000,            # total number of iterations per chain
  cores = 1,              # number of cores (using 2 just for the vignette)
  thin=1,
  refresh = 1000          # show progress every 'refresh' iterations
)

save(fit.VIBReg, file="./VIBReg.RData")
#load(file="./VIBReg.RData")

print(fit.VIBReg, digits = 1, pars=c("beta0", "beta1","phi", "p", "k"))

#Regression curve

#scatter plot and regression lines 
opar=par()
par(cex=1)
par(mar=c(4.5,4.5,1,1))
plot(x1,y, ylab="Body Fat Percentage", xlab="Lean Body Mass", cex=2, cex.axis=1, cex.lab=1.5)
mu.VIB <- colMeans(extract(fit.VIBReg)$mu)
lines(x1[order(x1)], mu.VIB[order(x1)],lwd=2)
