data {
  
int<lower=1> N; // number of observations
  
vector[N]    y; // outcomes
  
vector[N]    x1; // covariate
}

parameters {
  
real beta0;
real beta1;
real<lower=0,upper=1> k;
real<lower=0,upper=1> p;
real<lower=0> phi;
}

transformed parameters {
vector<lower=0,upper=1>[N]  mu;
vector<lower=0>[N] b1;
vector<lower=0>[N] b2;
vector<lower=0>[N] a1; 
vector<lower=0>[N] a2;
mu = inv_logit(beta0+beta1*x1);
//prob p
b2 = (1-mu)*phi*k;
a2 = mu*phi*k;
// prob (1-p)
b1 = (1-mu)*phi;
a1 = mu*phi;
}
model {
  
//priors
phi ~ gamma(0.001,0.001);
beta0 ~ normal(0,10);
beta1 ~ normal(0,10);
k ~ uniform(0,1);
p ~ uniform(0,1);
// likelihood of log(y)
 
for(i in 1:N)
target += log_mix(p, beta_lpdf(y[i] | a2[i],b2[i]),
                         beta_lpdf(y[i] | a1[i], b1[i]));     
}