########################################################################
#Required packages
library(Rcpp)
library(RcppArmadillo)
library(MASS)
library(rgen)
library(MCMCpack)
Rcpp::sourceCpp('mcmc.cpp') # source in the c++ functions
########################################################################
#Simulated data Setup
n=100 #sample size
m=10 #cluster size, excluding initial states
#Parameters
px=3; #dimension of transition regression parameters; including intercept.
pz=2; #dimension of missing model parameters for MNAR is pz+2, for MAR model is pz.
beta01=c(1,-0.5,0.5)
beta10=c(-1,0.5,-0.5)
truealpha=c(1,0.5,-0.5,-0.5)
Sigma=cbind(c(0.6,-0.3),c(-0.3,0.4))
########################################################################
#Simulate covariates
xcov=array(0,dim=c(2*m*n,px))
k=1
for(i in 1:n){
    for(t in 1:m){
        for(j in 1:2){
            xcov[k,1]=1
            xcov[k,2]=rnorm(1,0,1)
            xcov[k,3]=rbinom(1,1,0.5)
            k=k+1
        }
    }
}
#Simulate random effects
us=matrix(0,ncol=2,nrow=n)
us=mvrnorm(n,c(0,0),Sigma)
#Simulate responses
probs1=NULL
probs2=NULL
y=matrix(0,ncol=(m+1),nrow=n)
k1=1;k2=1
for(i in 1:n){
    ibegin=2*m*(i-1)+1
    iend=2*i*m
    xcovi=xcov[ibegin:iend,]
    y[i,1]=rbinom(1,1,0.5)
    for(j in 2:(m+1)){
        ibegin2=2*(j-2)+1
        iend2=2*(j-1)
        xcovij=xcovi[ibegin2:iend2,]
        if(y[i,j-1]==0){probs1[k1]=1-1/(1+exp(xcovij[1,]%*%beta01+us[i,1]))
            y[i,j]=rbinom(1,1,probs1[k1]);k1=k1+1 }
        else{probs2[k2]=1/(1+exp(xcovij[2,]%*%beta10+us[i,2]))
            y[i,j]=rbinom(1,1,probs2[k2]);k2=k2+1}
    }
}

#Simulate missing indicators
deltas=matrix(0,ncol=(m+1),nrow=n)
zcov=array(0,dim=c(m*n,pz))
k=1
for(i in 1:n){
    for(t in 1:m){
        zcov[k,1]=1
        zcov[k,2]=rnorm(1,0,0.5)
        k=k+1
    }
}
k=1;prob=NULL
for(i in 1:n){
    deltas[i,1]=1
    for(j in 2:(m+1)){
        prob[k]=exp(truealpha[1:pz]%*%zcov[k,]+truealpha[pz+1]*y[i,j]+truealpha[pz+2]*y[i,j-1])/
          (1+exp(truealpha[1:pz]%*%zcov[k,]+truealpha[pz+1]*y[i,j]+truealpha[pz+2]*y[i,j-1]))
        deltas[i,j]=rbinom(1,1,prob[k])
        k=k+1
    }
}

####################################################################################
#Fit the transition model assuming MNAR missing model
nrun=50000;nskip=5;nsave=10000;nburn=6000;nuse=4000
a=2;zetasq=c(10^5,10^5)
calpha = 5^2;cbeta=5^2

#mcmc starting values
beta01_start=rep(0,px)
beta10_start=rep(0,px)
phi_start=matrix(0,nrow=n,ncol=m)
for(i in 1:n){phi_start[i,]=rgamma(m,shape=7.3/2,rate=7.3/2)}
Sigma_start=cbind(c(1,0),c(0,1))
Lambda_start=cbind(c(0.2,0),c(0,0.2))
alpha_start=c(2,0,0,0)

#######################################################################
zcov_MNAR = cbind(zcov,rep(0,n*m),rep(0,n*m))
fit=mcmcsave(nrun, nskip, nburn,  y, deltas, xcov,zcov_MNAR,a,
zetasq,calpha, cbeta,beta01_start, beta10_start, phi_start, Sigma_start,Lambda_start,alpha_start)
fit$LPML #LPML
lppd = sum(log(apply(fit$Marginal_prob,1,mean)))
WAICvar = lppd-sum(apply(log(fit$Marginal_prob),1,var)) #Calculate WAIC
beta01save=fit$beta01 # all beta01 mcmc iterates thinned by every other 'nskip'
beta10save=fit$beta10 # all beta10 mcmc iterates thinned by every other 'nskip'
Sigmasave = fit$Sigma # all Sigma mcmc iterates thinned by every other 'nskip'
alphasave = fit$alpha # all alpha mcmc iterates thinned by every other 'nskip'
####################################################################################
#Fit the transition model assuming MAR missing model
nrun=50000;nskip=5;nsave=10000;nburn=6000;nuse=4000
a=2;zetasq=c(10^5,10^5)
calpha = 5^2;cbeta=5^2

#mcmc starting values
beta01_start=rep(0,px)
beta10_start=rep(0,px)
phi_start=matrix(0,nrow=n,ncol=m)
for(i in 1:n){phi_start[i,]=rgamma(m,shape=7.3/2,rate=7.3/2)}
Sigma_start=cbind(c(1,0),c(0,1))
Lambda_start=cbind(c(0.2,0),c(0,0.2))
alpha_start = c(1,0)
fit = mcmcsave_MAR(nrun, nskip, nburn,y, deltas, xcov,zcov,a,zetasq,calpha, cbeta,
beta01_start, beta10_start, phi_start, Sigma_start,Lambda_start,
alpha_start)
fit$LPML #LPML
lppd = sum(log(apply(fit$Marginal_prob,1,mean)))
WAICvar = lppd-sum(apply(log(fit$Marginal_prob),1,var)) #Calculate WAIC
beta01save=fit$beta01 # all beta01 mcmc iterates thinned by every other 'nskip'
beta10save=fit$beta10 # all beta10 mcmc iterates thinned by every other 'nskip'
Sigmasave = fit$Sigma # all Sigma mcmc iterates thinned by every other 'nskip'
alphasave = fit$alpha # all alpha mcmc iterates thinned by every other 'nskip'

