#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
#include <rgen.h>
// [[Rcpp::depends(rgen)]]

using namespace Rcpp;
using namespace arma;
using namespace std;

// [[Rcpp::export]]
double theta01(arma::rowvec xcovit,arma::vec beta01,arma::vec ui){
    double prob =0.0;
    arma::mat tempmat(1,1); tempmat.zeros();
    tempmat=xcovit*beta01;
    prob=1.0-1.0/(1.0+exp(tempmat(0,0)+ui(0)));
    
    return prob;
}

// [[Rcpp::export]]
double theta10(arma::rowvec xcovit,arma::vec beta10,arma::vec ui){
    double prob = 0.0;
    arma::mat tempmat(1,1); tempmat.zeros();
    tempmat=xcovit*beta10;
    prob=1.0-1.0/(1.0+exp(tempmat(0,0)+ui(1)));
    
    return prob;
}


// [[Rcpp::export]]
Rcpp::IntegerVector missingyi(int m,int px,int pz, Rcpp::IntegerVector yi,Rcpp::IntegerVector deltai, arma::mat xcovi,arma::vec beta01,arma::vec beta10, arma::vec ui,arma::mat zcovi,arma::vec alpha){
    Rcpp::IntegerVector newys(m+1);
    Rcpp::IntegerVector newy0(m+1);
    Rcpp::IntegerVector newy1(m+1);
    double probs1 =0.0;double probs2 =0.0;
    arma::rowvec xcovit0(px); xcovit0.zeros();
    arma::rowvec xcovit1(px); xcovit1.zeros();
    arma::rowvec zcovit(pz);zcovit.zeros();
    arma::mat tempmat(1,1); tempmat.zeros();
    
    double tempv1 = 0.0;
    double tempv2 = 0.0;
    for(int i=1;i<=(m+1);i++){newys[i-1]=yi[i-1];}
    int tempk = 0;
    arma::vec probsv1(m);probsv1.ones();
    arma::vec probsv2(m);probsv2.ones();
    /*Imputing starting from the second observation*/
    for(int s=1;s<=m;s++){
        for(int i=1;i<=(m+1);i++){newy0[i-1]=newys[i-1];}
        for(int i=1;i<=(m+1);i++){newy1[i-1]=newys[i-1];}
        newy0[s]=0;newy1[s]=1;
        probsv1.ones();probsv2.ones();
        
        if(double(deltai[s])<0.5){
            for(int i=1; i<=m;i++){
                tempk=2*(i-1);
                zcovit = zcovi.row(i-1);
                zcovit(pz-2) = (double)newy0[i];
                zcovit(pz-1) = (double)newy0[i-1];
                tempmat = zcovit*alpha;
                tempv1 = exp(tempmat(0,0));tempv1=tempv1/(1.0+tempv1);
                xcovit0= xcovi.row(tempk);
                xcovit1= xcovi.row(tempk+1);
                probsv1(i-1)=((theta01(xcovit0,beta01,ui))*(double)(newy0[i])+(1.0-theta01(xcovit0,beta01,ui))*
                              (double)(1.0-newy0[i]))*(double)(1.0-newy0[i-1]) +
                ((theta10(xcovit1,beta10,ui))*(double)(1.0-newy0[i])+ (1-theta10(xcovit1,beta10,ui))*
                 (double)(newy0[i]))*(double)(newy0[i-1]);
                
                probsv1(i-1) = probsv1(i-1)*(tempv1*(double)(deltai[i])+(1.0-tempv1)*(1.0-(double)deltai[i]));
                
                zcovit(pz-2) = (double)newy1[i];
                zcovit(pz-1) = (double)newy1[i-1];
                tempmat = zcovit*alpha;
                tempv2 = exp(tempmat(0,0));tempv2=tempv2/(1.0+tempv2);
                probsv2(i-1)=((theta01(xcovit0,beta01,ui))*(double)(newy1[i])+(1.0-theta01(xcovit0,beta01,ui))*
                              (double)(1.0-newy1[i]))*(double)(1.0-newy1[i-1]) +
                ((theta10(xcovit1,beta10,ui))*(double)(1.0-newy1[i])+ (1-theta10(xcovit1,beta10,ui))*
                 (double)(newy1[i]))*(double)(newy1[i-1]);
                probsv2(i-1) = probsv2(i-1) *(tempv2*(double)(deltai[i])+(1.0-tempv2)*(1.0-(double)deltai[i]));
            }
            probs1 = arma::prod(probsv1);probs2 = arma::prod(probsv2);
            newys[s]=Rf_rbinom(1,probs2/(probs1+probs2));
            
        }
        else{newys[s] = newys[s];}
    }
    
    return(newys);
}


// [[Rcpp::export]]
Rcpp::IntegerVector missingyi_MAR(int m,int px,int pz, Rcpp::IntegerVector yi,Rcpp::IntegerVector deltai, arma::mat xcovi,arma::vec beta01,arma::vec beta10, arma::vec ui,arma::mat zcovi,arma::vec alpha){
    Rcpp::IntegerVector newys(m+1);
    Rcpp::IntegerVector newy0(m+1);
    Rcpp::IntegerVector newy1(m+1);
    double probs1 =0.0;double probs2 =0.0;
    arma::rowvec xcovit0(px); xcovit0.zeros();
    arma::rowvec xcovit1(px); xcovit1.zeros();
    arma::rowvec zcovit(pz);zcovit.zeros();
    arma::mat tempmat(1,1);tempmat.zeros();
    double tempv1 = 0.0;
    double tempv2 = 0.0;
    for(int i=1;i<=(m+1);i++){newys[i-1]=yi[i-1];}
    int tempk = 0;
    arma::vec probsv1(m);probsv1.ones();
    arma::vec probsv2(m);probsv2.ones();
    /*Imputing starting from the second observation*/
    /*cout<< "m"<< newys<<" "  <<".\n"; */
    for(int s=1;s<=m;s++){
        for(int i=1;i<=(m+1);i++){newy0[i-1]=newys[i-1];}
        for(int i=1;i<=(m+1);i++){newy1[i-1]=newys[i-1];}
        newy0[s]=0;newy1[s]=1;
        probsv1.ones();probsv2.ones();
        
        if(double(deltai[s])<0.5){
            for(int i=1; i<=m;i++){
                tempk=2*(i-1);
                zcovit = zcovi.row(i-1);
                xcovit0= xcovi.row(tempk);
                xcovit1= xcovi.row(tempk+1);
                tempmat = zcovit*alpha;
                tempv1 = exp(tempmat(0,0));tempv1=tempv1/(1.0+tempv1);
                probsv1(i-1)=((theta01(xcovit0,beta01,ui))*(double)(newy0[i])+(1.0-theta01(xcovit0,beta01,ui))*
                              (double)(1.0-newy0[i]))*(double)(1.0-newy0[i-1]) +
                ((theta10(xcovit1,beta10,ui))*(double)(1.0-newy0[i])+ (1-theta10(xcovit1,beta10,ui))*
                 (double)(newy0[i]))*(double)(newy0[i-1]);
                
                probsv1(i-1) = probsv1(i-1)*(tempv1*(double)(deltai[i])+(1.0-tempv1)*(1.0-(double)deltai[i]));
                tempv2 = exp(tempmat(0,0));tempv2=tempv2/(1.0+tempv2);
                probsv2(i-1)=((theta01(xcovit0,beta01,ui))*(double)(newy1[i])+(1.0-theta01(xcovit0,beta01,ui))*
                              (double)(1.0-newy1[i]))*(double)(1.0-newy1[i-1]) +
                ((theta10(xcovit1,beta10,ui))*(double)(1.0-newy1[i])+ (1-theta10(xcovit1,beta10,ui))*
                 (double)(newy1[i]))*(double)(newy1[i-1]);
                probsv2(i-1) = probsv2(i-1) *(tempv2*(double)(deltai[i])+(1.0-tempv2)*(1.0-(double)deltai[i]));
            }
            probs1 = arma::prod(probsv1);probs2 = arma::prod(probsv2);
            newys[s]=Rf_rbinom(1,probs2/(probs1+probs2));
            
        }
        else{newys[s] = newys[s];}
    }
    
    return(newys);
}


// [[Rcpp::export]]
double prioralpha(int pz,arma::vec alpha,double calpha){
    double var  =  calpha;
    double palpha  =  0.0;
    for(int j = 1;j<=pz; j++){
        palpha = palpha-pow(alpha(j-1),(double)2)/((double)(2)*var);
    }
    return(palpha);
}
// [[Rcpp::export]]
double likelihoodalpha(int n, int m, int pz, arma::mat zcov,arma::vec alpha,
                       Rcpp::IntegerMatrix ny, Rcpp::IntegerMatrix delta){
    double loglikeli = 0.0;
    arma::rowvec tempz(pz); tempz.zeros();
    arma::mat tempm(1,1);
    double piti = 0.0;
    for(int i=1;i<=n;i++){
        for(int j=1;j<=m;j++){
            tempz = zcov.row((i-1)*m+j-1);
            tempz(pz-2) = (double)ny(i-1,j);
            tempz(pz-1) = (double)ny(i-1,j-1);
            tempm=tempz*alpha;
            piti = exp(tempm(0,0))/(1.0+exp(tempm(0,0)));
            loglikeli = loglikeli+(double)(delta(i-1,j))*log(piti)+(double)(1-delta(i-1,j))*log(1.0-piti);
        }
    }
    return(loglikeli);
}

// [[Rcpp::export]]
double likelihoodalpha_MAR(int n, int m, int pz, arma::mat zcov,arma::vec alpha,
                           Rcpp::IntegerMatrix ny, Rcpp::IntegerMatrix delta){
    double loglikeli = 0.0;
    arma::rowvec tempz(pz); tempz.zeros();
    arma::mat tempm(1,1);
    double piti = 0.0;
    for(int i=1;i<=n;i++){
        for(int j=1;j<=m;j++){
            tempz = zcov.row((i-1)*m+j-1);
            tempm=tempz*alpha;
            piti = exp(tempm(0,0))/(1.0+exp(tempm(0,0)));
            loglikeli = loglikeli+(double)(delta(i-1,j))*log(piti)+(double)(1-delta(i-1,j))*log(1.0-piti);
        }
    }
    return(loglikeli);
}



// [[Rcpp::export]]
double truncatednormal(double a, double b, double meanx, double stdx){
    double sampley = 0.0, u =0.0, nu =0.0;
    double pa=Rf_pnorm5(a,meanx,stdx,1,0);
    double pb=Rf_pnorm5(b,meanx,stdx,1,0);
    u=Rf_runif(0.0,1.0);
    nu = std::min(std::max(pa+(pb-pa)*u,0.000000001),0.999999999);
    sampley = Rf_qnorm5(nu,meanx,stdx,1,0);
    
    return(sampley);
}



// [[Rcpp::export]]
double sampleomegati(arma::rowvec xcovti0,arma::rowvec xcovti1, arma::vec beta01,
                     arma::vec beta10, arma::vec ui, double phiti, int ytmo, int yt){
    double omegati =0.0, meany = 0.0, stdy =0.0;
    double c=7.3;
    double sigma2=pow(3.1415926,2.0)*(c-2.0)/3.0/c;
    double upperlimit = 0.0, lowerlimit = 0.0;
    arma::mat tempmat0(1,1); tempmat0.zeros();
    arma::mat tempmat1(1,1); tempmat1.zeros();
    tempmat0=xcovti0*beta01;
    tempmat1=xcovti1*beta10;
    if(ytmo<1){
        meany=tempmat0(0,0)+ui(0);
        stdy=pow(sigma2/phiti,0.5);
        if(yt>0){
            upperlimit=100.0;
            omegati=std::max(truncatednormal(0.0,upperlimit,meany,stdy),1.0e-10);
        }
        else{
            
            lowerlimit=-100.0;
            omegati=std::min(truncatednormal(lowerlimit, 0.0,meany,stdy),-1.0e-10);
        }
    }
    else{
        meany=tempmat1(0,0)+ui(1);
        stdy=pow(sigma2/phiti,0.5);
        if(yt>0){
            lowerlimit=-100.0;
            omegati=std::min(truncatednormal(lowerlimit, 0.0,meany,stdy),-1.0e-10);
        }
        else{
            upperlimit=100.0;
            omegati=std::max(truncatednormal(0.0, upperlimit,meany,stdy),1.0e-10);
        }
    }
    return(omegati);
}
// [[Rcpp::export]]
arma::vec rmnorm(arma::vec mu, arma::mat sigma) {
    int ncols = sigma.n_cols;
    arma::mat Y = arma::randn(1, ncols);
    arma::rowvec sample (ncols);
    sample = arma::repmat(mu, 1, 1).t() + Y * arma::chol(sigma);
    return (sample.t());
}
// [[Rcpp::export]]
arma::vec sampleui(int m, int p, Rcpp::IntegerVector yi, arma::mat xcovi,arma::vec beta01,
                   arma::vec beta10,arma::vec phii,arma::vec omegai,arma::mat Sigma){
    double zeta0i = 0.0, zeta1i = 0.0, kappa0i = 0.0, kappa1i = 0.0;
    arma::vec nmeani(2),tempmeani(2);nmeani.zeros(); tempmeani.zeros();
    arma::mat Omegai(2,2),diagkappa(2,2),invOmegai(2,2); Omegai.zeros(); diagkappa.zeros(); invOmegai.zeros();
    double c=7.3;
    double sigma2=pow(3.1415927,2.0)*(c-2.0)/3.0/c;
    arma::mat tempmat0(1,1); tempmat0.zeros();
    arma::mat tempmat1(1,1); tempmat1.zeros();
    Rcpp::IntegerVector newyi(m+1);
    arma::vec nui(2); nui.zeros();
    
    for(int i=1;i<=(m+1);i++){newyi[i-1]=yi[i-1];}
    
    zeta0i=0.0;zeta1i=0.0;kappa0i=0.0;kappa1i=0.0;
    for(int i=1; i<=m; i++){
        tempmat0=xcovi.row(2*(i-1))*beta01;
        tempmat1=xcovi.row(2*(i-1)+1)*beta10;
        zeta0i=zeta0i+phii(i-1)/sigma2*(1.0-newyi[i-1])*(omegai(i-1)-tempmat0(0,0));
        zeta1i=zeta1i+phii(i-1)/sigma2*(double)(newyi[i-1])*(omegai(i-1)-tempmat1(0,0));
        kappa0i=kappa0i+phii(i-1)/sigma2*(1.0-newyi[i-1]);
        kappa1i=kappa1i+phii(i-1)/sigma2*(double)(newyi[i-1]);
        
    }
    
    tempmeani(0)=zeta0i;tempmeani(1)=zeta1i;
    diagkappa(0,0)=kappa0i;diagkappa(1,1)=kappa1i;
    invOmegai=diagkappa+arma::inv_sympd(Sigma);
    Omegai=arma::inv_sympd(invOmegai);
    nmeani=Omegai*tempmeani;
    
    nui=rmnorm(nmeani, Omegai);
    
    return(nui);
}
// [[Rcpp::export]]
arma::vec samplephii(int m, int p, Rcpp::IntegerVector yi, arma::mat xcovi,arma::vec beta01,
                     arma::vec beta10,arma::vec omegai,arma::vec ui){
    arma::vec phii(m); phii.zeros();
    double shapeg =0.0, ati =0.0,rateg = 0.0;
    double c=7.3;
    shapeg=c/2.0+0.5;
    double sigma2=pow(3.1415926,2.0)*(c-2.0)/3.0/c;
    arma::mat tempmat0(1,1); tempmat0.zeros();
    arma::mat tempmat1(1,1); tempmat1.zeros();
    
    for(int i=1; i<=m;i++){
        if(yi[i-1]==0){
            
            tempmat0=xcovi.row(2*(i-1))*beta01;
            ati=pow((omegai(i-1)-tempmat0(0,0)-ui(0)),2.0);
            rateg=ati/2.0/sigma2+c/2.0;
            phii(i-1)=Rf_rgamma(shapeg,1.0)/rateg;
        }
        else{
            
            tempmat1=xcovi.row(2*(i-1)+1)*beta10;
            ati=pow((omegai(i-1)-tempmat1(0,0)-ui(1)),2.0);
            rateg=ati/2.0/sigma2+c/2.0;
            phii(i-1)=Rf_rgamma(shapeg,1.0)/rateg;
        }
    }
    
    return (phii);
}


// [[Rcpp::export]]
arma::mat riwishart(unsigned int df, const arma::mat S) {
    return rgen::riwishart(df, S);
}

// [[Rcpp::export]]
arma::mat samplesigma(int n, int a, int d, arma::mat us, arma::mat Lambda){
    int df=n+a+d-1;
    arma::mat tempmat(d,d); tempmat.zeros();
    arma::mat samplesig(d,d); samplesig.zeros();
    arma::mat uscol(d,1); uscol.zeros();
    arma::mat usrow(1,d); usrow.zeros();
    tempmat=2.0*(double)(a)*Lambda;
    for(int i=1;i<=n;i++){
        uscol.col(0)=trans(us.row(i-1));
        usrow.row(0)=us.row(i-1);
        tempmat=tempmat+uscol*usrow;
    }
    
    samplesig = riwishart(df,  tempmat);
    return(samplesig);
}


// [[Rcpp::export]]
arma::mat sampleLambda(int a, int d, arma::vec zetasq, arma::mat Sigma){
    arma::mat sampledLambda(d,d); sampledLambda.zeros();
    arma::mat invSigma(d,d); invSigma.zeros();
    invSigma = arma::inv_sympd(Sigma);
    double shapeg = (double)(a+d)/(double)(2);
    double rateg =0.0;
    for(int i=1; i<=d;i++){
        rateg = 1.0/zetasq(i-1)+(double)(a)*invSigma(i-1,i-1);
        sampledLambda(i-1,i-1)=Rf_rgamma(shapeg,1.0)/rateg;
    }
    return(sampledLambda);
}



// [[Rcpp::export]]
arma::mat samplebeta(int p,int n,int m, Rcpp::IntegerMatrix y, arma::mat phi,
                     arma::mat xcov, double cbeta, arma::mat omega,arma::mat us){
    arma::vec beta0t(p); beta0t.zeros();
    arma::vec beta1t(p); beta1t.zeros();
    arma::mat Psi0inv0(p,p); Psi0inv0.zeros();
    arma::mat priorB(p,p); priorB.zeros();
    arma::vec B0(p); B0.zeros();
    arma::mat Psi0inv1(p,p); Psi0inv1.zeros();
    arma::vec B1(p); B1.zeros();
    arma::mat betat(p,2);
    arma::vec Bzeros(p); Bzeros.zeros();
    double c=7.3;
    double sigma2=pow(3.1415927,2.0)*(c-2.0)/3.0/c;
    
    arma::rowvec xcov0it(p); xcov0it.zeros();
    arma::rowvec xcov1it(p); xcov1it.zeros();
    arma::mat xcovi (2*m,p); xcovi.zeros();
    
    for(int i=1; i<=p;i++){priorB(i-1,i-1)=1.0/cbeta;}
    Psi0inv0 = priorB;
    Psi0inv1 = priorB;
    
    for(int i=1; i<=n;i++){
        for(int t=1; t<=m;t++){
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            if(y(i-1,t-1)<1){
                xcov0it = xcovi.row(2*(t-1));
                Psi0inv0=Psi0inv0+phi(i-1,t-1)/sigma2*trans(xcov0it)*xcov0it;
                B0 =B0+phi(i-1,t-1)/sigma2*(omega(i-1,t-1)-us(i-1,0))*trans(xcov0it);
                
            }else{
                xcov1it = xcovi.row(2*(t-1)+1);
                Psi0inv1=Psi0inv1+phi(i-1,t-1)/sigma2*trans(xcov1it)*xcov1it;
                B1 =B1+phi(i-1,t-1)/sigma2*(omega(i-1,t-1)-us(i-1,1))*trans(xcov1it);
            }
            
        }}
    
    Psi0inv0=Psi0inv0+priorB;
    beta0t = rmnorm(arma::inv_sympd(Psi0inv0)*B0,  arma::inv_sympd(Psi0inv0));
    
    
    Psi0inv1=Psi0inv1+priorB;
    beta1t = rmnorm(arma::inv_sympd(Psi0inv1)*B1, arma::inv_sympd(Psi0inv1));
    
    
    
    betat.col(0)=beta0t;
    betat.col(1)=beta1t;
    return(betat);
}




// [[Rcpp::export]]
double tdensi(double z, double mu) {
    double c=7.3;
    double sigma2=pow(3.1415927,2.0)*(c-2.0)/3.0/c;
    double density= exp(lgamma(c/2.0+0.5)-lgamma(c/2.0))/sqrt(c*3.1415926)/sqrt(sigma2);
    density=density*pow(1.0+pow(z-mu,2.0)/c/sigma2,(-c/2.0-0.5));
    return(density);
    
}

// [[Rcpp::export]]
double logitdensi(double z, double mu) {
    double density=exp(z-mu)/pow(1.0+exp(z-mu),2.0);
    return(density);
    
}

// [[Rcpp::export]]
double logweight(int p,int n,int m, Rcpp::IntegerMatrix y,
                 arma::mat xcov, arma::vec beta01,
                 arma::vec beta10, arma::mat omega,arma::mat us) {
    double weightv;
    arma::mat xcovi (2*m,p);xcovi.zeros();
    arma::mat tempmat0(1,1); tempmat0.zeros();
    arma::mat tempmat1(1,1); tempmat1.zeros();
    
    weightv = 0.0;
    for(int i=1; i<=n;i++){
        xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
        for(int t=1; t<=m;t++){
            if(y(i-1,t-1)==0){
                tempmat0=xcovi.row(2*(t-1))*beta01;
                weightv=weightv+log(logitdensi(omega(i-1,t-1), tempmat0(0,0)+us(i-1,0)))
                -log(tdensi(omega(i-1,t-1), tempmat0(0,0)+us(i-1,0)));
            }
            else{
                tempmat1=xcovi.row(2*(t-1)+1)*beta10;
                weightv=weightv+log(logitdensi(omega(i-1,t-1), tempmat1(0,0)+us(i-1,1)))
                -log(tdensi(omega(i-1,t-1), tempmat1(0,0)+us(i-1,1)));
            }
            
            
        }
        
    }
    
    
    return(weightv);
}



// [[Rcpp::export]]
Rcpp::IntegerMatrix designm10(int missingm){
    int M = pow(2,missingm);
    Rcpp::IntegerMatrix D (M,missingm);
    int k =1;
    for(int i1=1;i1<=2;i1++){for(int i2=1; i2<=2; i2++){ for(int i3=1;i3<=2;i3++){
        for(int i4=1;i4<=2;i4++){ for(int i5=1;i5<=2;i5++){ for(int i6=1;i6<=2;i6++){ for(int i7=1;i7<=2;i7++){ for(int i8=1;i8<=2;i8++){
            for(int i9=1;i9<=2;i9++){ for(int i10=1;i10<=2;i10++){
                D(k-1,0) = i1-1;D(k-1,1) = i2-1;D(k-1,2) = i3-1;D(k-1,3) = i4-1;D(k-1,4) = i5-1; D(k-1,5) = i6-1; D(k-1,6) = i7-1; D(k-1,7) = i8-1;
                D(k-1,8) = i9-1;D(k-1,9) = i10-1;
                k=k+1;}}}}}}}}}}
    return(D);
}

// [[Rcpp::export]]
double likelihoodi(int m,int px,int pz, Rcpp::IntegerVector yi,Rcpp::IntegerVector deltai, arma::mat xcovi,arma::vec beta01,
                   arma::vec beta10, arma::vec ui,arma::mat zcovi,arma::vec alpha,int missingm,Rcpp::IntegerMatrix dem10){
    
    Rcpp::IntegerVector newy0(m+1);
    arma::rowvec xcovit0(px); xcovit0.zeros();
    arma::rowvec xcovit1(px); xcovit1.zeros();
    arma::rowvec zcovit(pz); zcovit.zeros();
    double tempv1 = 0.0;
    arma::mat tempmat(1,1);tempmat.zeros();
    int missingv = pow(2,missingm);
    arma::vec likeli(missingv); likeli.zeros();
    double p01,p10,p00,p11,pti;
    int ind;
    double sumloglikeli;
    int tempk = 0;
    arma::vec probsv1(m);probsv1.ones();
    
    
    if(missingm ==0){
        for(int i=1;i<=(m+1);i++){newy0[i-1]=yi[i-1];}
        probsv1.ones();
        for(int i=1; i<=m;i++){
            tempk=2*(i-1);
            zcovit = zcovi.row(i-1);
            zcovit(pz-2) = (double) (newy0[i]);
            zcovit(pz-1) = (double) (newy0[i-1]);
            xcovit0= xcovi.row(tempk);
            xcovit1= xcovi.row(tempk+1);
            tempmat = zcovit*alpha;
            tempv1 = exp(tempmat(0,0));pti=tempv1/(1.0+tempv1);
            p01 = theta01(xcovit0,beta01,ui);p00 = 1.0-p01;
            p10 = theta10(xcovit1,beta10,ui);p11 = 1.0-p10;
            probsv1(i-1)=(p01*(double)(newy0[i])+p00*(1.0-newy0[i]))*(1.0-newy0[i-1]) +
            (p10*(1.0-newy0[i])+ p11*(double)(newy0[i]))*(double)(newy0[i-1]);
            probsv1(i-1) = probsv1(i-1)*(pti*(double)(deltai[i])+(1.0-pti)*(1.0-(double)deltai[i]));
            
        }
        sumloglikeli=arma::prod(probsv1);
    }
    else{
        for(int k=1;k<=missingv;k=k+1){
            for(int i=1;i<=(m+1);i++){newy0[i-1]=yi[i-1];}
            ind = 1;
            for(int i=2;i<=(m+1);i++){
                if(deltai[i-1]<1){
                    newy0[i-1] = dem10(k-1,10-missingm+ind-1);ind=ind+1;
                }}
            
            tempk = 0;
            probsv1.ones();
            
            for(int i=1; i<=m;i++){
                tempk=2*(i-1);
                zcovit = zcovi.row(i-1);
                zcovit(pz-2) = (double) (newy0[i]);
                zcovit(pz-1) = (double) (newy0[i-1]);
                xcovit0= xcovi.row(tempk);
                xcovit1= xcovi.row(tempk+1);
                tempmat = zcovit*alpha;
                tempv1 = exp(tempmat(0,0));pti=tempv1/(1.0+tempv1);
                p01 = theta01(xcovit0,beta01,ui);p00 = 1.0-p01;
                p10 = theta10(xcovit1,beta10,ui);p11 = 1.0-p10;
                probsv1(i-1)=(p01*(double)(newy0[i])+p00*(1.0-newy0[i]))*(1.0-newy0[i-1]) +
                (p10*(1.0-newy0[i])+ p11*(double)(newy0[i]))*(double)(newy0[i-1]);
                
                probsv1(i-1) = probsv1(i-1)*(pti*(double)(deltai[i])+(1.0-pti)*(1.0-(double)deltai[i]));
                
            }
            likeli(k-1) = arma::prod(probsv1);
        }
        sumloglikeli = arma::sum(likeli);
    }
    return(sumloglikeli);
}



// [[Rcpp::export]]
double likelihoodi_MAR(int m,int px,int pz, Rcpp::IntegerVector yi,Rcpp::IntegerVector deltai, arma::mat xcovi,arma::vec beta01,
                       arma::vec beta10, arma::vec ui,arma::mat zcovi,arma::vec alpha,int missingm,Rcpp::IntegerMatrix dem10){
    
    Rcpp::IntegerVector newy0(m+1);
    arma::rowvec xcovit0(px); xcovit0.zeros();
    arma::rowvec xcovit1(px); xcovit1.zeros();
    arma::rowvec zcovit(pz); zcovit.zeros();
    double tempv1 = 0.0;
    arma::mat tempmat(1,1);tempmat.zeros();
    int missingv = pow(2,missingm);
    arma::vec likeli(missingv); likeli.zeros();
    double p01,p10,p00,p11,pti;
    int ind;
    double sumloglikeli;
    int tempk = 0;
    arma::vec probsv1(m);probsv1.ones();
    
    
    if(missingm ==0){
        for(int i=1;i<=(m+1);i++){newy0[i-1]=yi[i-1];}
        probsv1.ones();
        for(int i=1; i<=m;i++){
            tempk=2*(i-1);
            zcovit = zcovi.row(i-1);
            xcovit0= xcovi.row(tempk);
            xcovit1= xcovi.row(tempk+1);
            tempmat = zcovit*alpha;
            tempv1 = exp(tempmat(0,0));pti=tempv1/(1.0+tempv1);
            p01 = theta01(xcovit0,beta01,ui);p00 = 1.0-p01;
            p10 = theta10(xcovit1,beta10,ui);p11 = 1.0-p10;
            probsv1(i-1)=(p01*(double)(newy0[i])+p00*(1.0-newy0[i]))*(1.0-newy0[i-1]) +
            (p10*(1.0-newy0[i])+ p11*(double)(newy0[i]))*(double)(newy0[i-1]);
            probsv1(i-1) = probsv1(i-1)*(pti*(double)(deltai[i])+(1.0-pti)*(1.0-(double)deltai[i]));
            
        }
        sumloglikeli=arma::prod(probsv1);
    }
    else{
        for(int k=1;k<=missingv;k=k+1){
            for(int i=1;i<=(m+1);i++){newy0[i-1]=yi[i-1];}
            ind = 1;
            for(int i=2;i<=(m+1);i++){
                if(deltai[i-1]<1){
                    newy0[i-1] = dem10(k-1,10-missingm+ind-1);ind=ind+1;
                }}
            
            tempk = 0;
            probsv1.ones();
            
            for(int i=1; i<=m;i++){
                tempk=2*(i-1);
                zcovit = zcovi.row(i-1);
                xcovit0= xcovi.row(tempk);
                xcovit1= xcovi.row(tempk+1);
                tempmat = zcovit*alpha;
                tempv1 = exp(tempmat(0,0));pti=tempv1/(1.0+tempv1);
                p01 = theta01(xcovit0,beta01,ui);p00 = 1.0-p01;
                p10 = theta10(xcovit1,beta10,ui);p11 = 1.0-p10;
                probsv1(i-1)=(p01*(double)(newy0[i])+p00*(1.0-newy0[i]))*(1.0-newy0[i-1]) +
                (p10*(1.0-newy0[i])+ p11*(double)(newy0[i]))*(double)(newy0[i-1]);
                
                probsv1(i-1) = probsv1(i-1)*(pti*(double)(deltai[i])+(1.0-pti)*(1.0-(double)deltai[i]));
                
            }
            likeli(k-1) = arma::prod(probsv1);
        }
        sumloglikeli = arma::sum(likeli);
    }
    return(sumloglikeli);
}


// [[Rcpp::export]]
arma::vec likelihoodv(int n, int m,int px,int pz, Rcpp::IntegerMatrix y,Rcpp::IntegerMatrix delta, arma::mat xcov,arma::vec beta01,
                      arma::vec beta10, arma::mat us,arma::mat zcov,arma::vec alpha,Rcpp::IntegerVector missingmv,Rcpp::IntegerMatrix dem10){
    
    Rcpp::IntegerVector yi(m+1);
    Rcpp::IntegerVector deltai(m+1);
    arma::mat xcovi(m*2,px);
    arma::mat zcovi(m,pz);
    arma::vec ui(2);ui.zeros();
    arma::vec loglikeli(n);loglikeli.zeros();
    
    for(int i=1;i<=n;i++){
        for(int j=1;j<=(m+1);j++){yi[j-1] = y(i-1,j-1);deltai[j-1] = delta(i-1,j-1);}
        xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
        ui=us.col(i-1);
        zcovi=zcov.rows(m*(i-1),m*i-1);
        loglikeli(i-1) = likelihoodi(m,px,pz, yi,deltai, xcovi, beta01,beta10, ui,zcovi,alpha,missingmv[i-1],dem10);
        
    }
    return(loglikeli);
}
// [[Rcpp::export]]
List mcmcsave(int nrun, int nskip, int nburn, Rcpp::IntegerMatrix y, Rcpp::IntegerMatrix delta, arma::mat xcov,
              arma::mat zcov,int a, arma::vec zetasq,double calpha, double cbeta,arma::vec beta01_start,arma::vec beta10_start,
              arma::mat phi_start, arma::mat Sigma_start,arma::mat Lambda_start,arma::vec alpha_start){
    int nsave = nrun/nskip;
    int nuse = nsave-nburn;
    int p = xcov.n_cols;
    int n = y.nrow();
    int m = y.ncol()-1;
    int pz = zcov.n_cols;
    arma::mat Sigmasave(nsave,3);
    arma::mat beta01save(nsave,p);
    arma::mat beta10save(nsave,p);
    arma::mat gsave(nsave,2);
    arma::cube ussave(n,2,nsave);
    arma::mat  alphasave(nsave,pz);
    int indsave  =  0;
    int nstart  =  50 ;
    Rcpp::IntegerMatrix ny(n,m+1);
    arma::mat omegam(n,m);
    arma::mat us(n,2);
    arma::mat phis(n,m);
    arma::mat Sigmas(2,2);
    arma::mat Lambdas(2,2);
    arma::vec beta01s(p);
    arma::vec beta10s(p);
    arma::vec gs(2);
    arma::vec logweightv(nsave); logweightv.zeros();
    arma::vec alpha(pz);
    arma::vec nalpha(pz);
    arma::mat alphacov(pz,pz);
    arma::mat indcov(pz,pz,arma::fill::eye);
    double err  =  0.001;
    double err2  =  0.0000001;
    double sdd  =  pow(2.4,2.0);
    double palpha0,palpha1,loglikeli0,loglikeli1,u,threshold;
    
    Rcpp::IntegerVector nyi(m+1);
    Rcpp::IntegerVector updateyi(m+1);
    Rcpp::IntegerVector deltai(m+1);
    arma::mat xcovi(m*2,p);
    arma::mat zcovi(m,pz);
    arma::rowvec xcov0it(p);
    arma::rowvec xcov1it(p);
    arma::vec beta01t(p);
    arma::vec beta10t(p);
    arma::vec ui(2);ui.zeros();
    arma::vec phii(m);
    arma::vec omegai(m);
    arma::mat betamatrix(p,2);
    arma::vec gt(2);
    
    
    Rcpp::IntegerMatrix m10(pow(2,10),10);m10 = designm10(10);
    
    int missingm = 0;
    int indsavem = 0;
    arma::mat likelihoodm(n,nuse);likelihoodm.zeros();
    arma::vec LPMLvec(n); LPMLvec.zeros();
    double LPML;
    for(int k=1;k<=nrun;k++){
        if(k==1){
            ny=y;
            beta01s=beta01_start;
            beta10s=beta10_start;
            phis=phi_start;
            Sigmas=Sigma_start;
            Lambdas=Lambda_start;
            us.zeros();
            alpha = alpha_start;
            
        }
        
        if (indsave > nstart){
            alphacov  =  sdd/(double)(pz) * (arma::cov(alphasave.submat(0,0,(indsave-1),(pz-1)))+indcov*err2);
        }
        else{
            alphacov  =  ((double)50)*indcov*err;
        }
        
        for(int i=1;i<=n;i++){
            /*sample missing y and omegas*/
            
            for(int j=1;j<=(m+1);j++){nyi[j-1] = ny(i-1,j-1);deltai[j-1] = delta(i-1,j-1);}
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            ui=trans(us.row(i-1));
            zcovi=zcov.rows(m*(i-1),m*i-1);
            updateyi= missingyi(m,p,pz, nyi,deltai,xcovi,beta01s,beta10s,ui,zcovi,alpha);
            
            for(int j=1;j<=(m+1);j++){ny(i-1,j-1)=updateyi[j-1];}
            
            for(int j=1; j<=m; j++){
                xcov0it = xcovi.row(2*(j-1));
                xcov1it = xcovi.row(2*(j-1)+1);
                omegam(i-1,j-1)=sampleomegati(xcov0it,xcov1it,beta01s,beta10s, ui, phis(i-1,j-1),
                                              ny(i-1,j-1), ny(i-1,j));}
            
        }
        /*sample ui, phis, taus*/
        
        
        for(int i=1;i<=n;i++){
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            phii=trans(phis.row(i-1));
            omegai=trans(omegam.row(i-1));
            for(int j=1;j<=(m+1);j++){nyi[j-1]=ny(i-1,j-1);}
            ui=sampleui(m, p,nyi,xcovi,beta01s,beta10s,phii,omegai,Sigmas);
            us.row(i-1)=trans(ui);
            
            
        }
        
        
        for(int i=1;i<=n;i++){
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            phii=trans(phis.row(i-1));
            omegai=trans(omegam.row(i-1));
            ui=trans(us.row(i-1));
            phii=samplephii(m, p, ny(i-1,_), xcovi,beta01s,beta10s,omegai,ui);
            phis.row(i-1)=trans(phii);
        }
        
        /*sampling alpha*/
        palpha0 = prioralpha(pz,alpha,calpha);
        loglikeli0 = likelihoodalpha(n, m, pz, zcov,alpha,  ny, delta);
        nalpha = rmnorm(alpha,alphacov);
        palpha1 = prioralpha(pz,nalpha,calpha);
        loglikeli1 = likelihoodalpha(n, m, pz, zcov,nalpha,  ny, delta);
        u  =  Rf_runif(0,1);
        threshold  =   loglikeli1 + palpha1 -  loglikeli0 - palpha0;
        
        if (log(u)<= threshold){alpha  =   nalpha;}
        
        
        
        
        Lambdas=sampleLambda(a, 2, zetasq, Sigmas);
        
        Sigmas=samplesigma(n, a, 2, us, Lambdas);
        
        
        betamatrix=samplebeta(p,n,m, ny, phis,xcov,cbeta, omegam,us);
        beta01s=betamatrix.col(0);
        beta10s=betamatrix.col(1);
        
        
        if((k % nskip)==0 && k>1){
            indsave = indsave +1;
            Sigmasave(indsave-1,0)=Sigmas(0,0);
            Sigmasave(indsave-1,1)=Sigmas(0,1);
            Sigmasave(indsave-1,2)=Sigmas(1,1);
            beta01save.row(indsave-1)=trans(beta01s);
            beta10save.row(indsave-1)=trans(beta10s);
            alphasave.row(indsave-1) = trans(alpha);
            ussave.slice(indsave-1)=us;
            logweightv(indsave-1) = logweight(p,n, m, ny,xcov, beta01s, beta10s,omegam, us);
            if(indsave>nburn){
                indsavem = indsavem+1;
                for(int i=1;i<=n;i++){
                    missingm = 0;
                    
                    for(int j=1;j<=(m+1);j++){nyi[j-1] = ny(i-1,j-1);deltai[j-1] = delta(i-1,j-1);
                        if((deltai[j-1]<1) && (j>1)){missingm = missingm+1;}}
                    xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
                    ui=trans(us.row(i-1));
                    zcovi=zcov.rows(m*(i-1),m*i-1);
                    likelihoodm(i-1,indsavem-1) = likelihoodi(m,p,pz, nyi,deltai, xcovi,beta01s,
                                                              beta10s, ui,zcovi, alpha,missingm,m10);
                    
                    LPMLvec(i-1) = LPMLvec(i-1)+1.0/likelihoodm(i-1,indsavem-1)/double(nuse);
                    
                }
            }
        }
        LPML = -arma::sum(log(LPMLvec));
    }
    
    List save;
    save["beta01"] = beta01save;
    save["beta10"] = beta10save;
    save["u"] =  ussave;
    save["Sigma"] = Sigmasave;
    save["logweight"]=logweightv;
    save["alpha"]=alphasave;
    save["LPML"] = LPML;
    save["Marginal_prob"] = likelihoodm;
    return (save);
    
}

// [[Rcpp::export]]
List mcmcsave_MAR(int nrun, int nskip, int nburn, Rcpp::IntegerMatrix y,
                  Rcpp::IntegerMatrix delta, arma::mat xcov,arma::mat zcov,int a, arma::vec zetasq,double calpha, double cbeta,arma::vec beta01_start,
                  arma::vec beta10_start, arma::mat phi_start, arma::mat Sigma_start,arma::mat Lambda_start,
                  arma::vec alpha_start){
    int nsave = nrun/nskip;
    int nuse = nsave-nburn;
    int p = xcov.n_cols;
    int n = y.nrow();
    int m = y.ncol()-1;
    int pz = zcov.n_cols;
    
    arma::mat Sigmasave(nsave,3);
    arma::mat beta01save(nsave,p);
    arma::mat beta10save(nsave,p);
    arma::mat gsave(nsave,2);
    arma::cube ussave(n,2,nsave);
    arma::mat  alphasave(nsave,pz);
    int indsave  =  0;
    int nstart  =  50 ;
    Rcpp::IntegerMatrix ny(n,m+1);
    arma::mat omegam(n,m);
    arma::mat us(n,2);
    arma::mat phis(n,m);
    arma::mat Sigmas(2,2);
    arma::mat Lambdas(2,2);
    arma::vec beta01s(p);
    arma::vec beta10s(p);
    arma::vec gs(2);
    arma::vec logweightv(nsave); logweightv.zeros();
    arma::vec alpha(pz);
    arma::vec nalpha(pz);
    arma::mat alphacov(pz,pz);
    arma::mat indcov(pz,pz,arma::fill::eye);
    double err  =  0.001;
    double err2  =  0.0000001;
    double sdd  =  pow(2.4,2.0);
    double palpha0,palpha1,loglikeli0,loglikeli1,u,threshold;
    
    Rcpp::IntegerVector nyi(m+1);
    Rcpp::IntegerVector updateyi(m+1);
    Rcpp::IntegerVector deltai(m+1);
    arma::mat xcovi(m*2,p);
    arma::mat zcovi(m,pz);
    arma::rowvec xcov0it(p);
    arma::rowvec xcov1it(p);
    arma::vec beta01t(p);
    arma::vec beta10t(p);
    arma::vec ui(2);ui.zeros();
    arma::vec phii(m);
    arma::vec omegai(m);
    arma::mat betamatrix(p,2);
    arma::vec gt(2);
    
    
    Rcpp::IntegerMatrix m10(pow(2,10),10);m10 = designm10(10);
    
    int missingm = 0;
    int indsavem = 0;
    arma::mat likelihoodm(n,nuse);likelihoodm.zeros();
    arma::vec LPMLvec(n); LPMLvec.zeros();
    double LPML;
    for(int k=1;k<=nrun;k++){
        if(k==1){
            ny=y;
            beta01s=beta01_start;
            beta10s=beta10_start;
            phis=phi_start;
            Sigmas=Sigma_start;
            Lambdas=Lambda_start;
            us.zeros();
            alpha = alpha_start;
            
        }
        
        if (indsave > nstart){
            alphacov  =  sdd/(double)(pz) * (arma::cov(alphasave.submat(0,0,(indsave-1),(pz-1)))+indcov*err2);
        }
        else{
            alphacov  =  ((double)50)*indcov*err;
        }
        
        for(int i=1;i<=n;i++){
            /*sample missing y and omegas*/
            
            for(int j=1;j<=(m+1);j++){nyi[j-1] = ny(i-1,j-1);deltai[j-1] = delta(i-1,j-1);}
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            ui=trans(us.row(i-1));
            zcovi=zcov.rows(m*(i-1),m*i-1);
            updateyi= missingyi_MAR(m,p,pz, nyi,deltai,xcovi,beta01s,beta10s,ui,zcovi,alpha);
            
            for(int j=1;j<=(m+1);j++){ny(i-1,j-1)=updateyi[j-1];}
            for(int j=1; j<=m; j++){
                xcov0it = xcovi.row(2*(j-1));
                xcov1it = xcovi.row(2*(j-1)+1);
                omegam(i-1,j-1)=sampleomegati(xcov0it,xcov1it,beta01s,beta10s, ui, phis(i-1,j-1),
                                              ny(i-1,j-1), ny(i-1,j));}
            
        }
        /*sample ui, phis, taus*/
        for(int i=1;i<=n;i++){
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            phii=trans(phis.row(i-1));
            omegai=trans(omegam.row(i-1));
            ui=trans(us.row(i-1));
            phii=samplephii(m, p, ny(i-1,_), xcovi,beta01s,beta10s,omegai,ui);
            phis.row(i-1)=trans(phii);
        }
        
        for(int i=1;i<=n;i++){
            xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
            phii=trans(phis.row(i-1));
            omegai=trans(omegam.row(i-1));
            ui=sampleui(m, p,ny(i-1,_),xcovi,beta01s,beta10s,phii,omegai,Sigmas);
            us.row(i-1)=trans(ui);}
        
        
        /*sampling alpha*/
        palpha0 = prioralpha(pz,alpha,calpha);
        loglikeli0 = likelihoodalpha_MAR(n, m, pz, zcov,alpha,  ny, delta);
        nalpha = rmnorm(alpha,alphacov);
        palpha1 = prioralpha(pz,nalpha,calpha);
        loglikeli1 = likelihoodalpha_MAR(n, m, pz, zcov,nalpha,  ny, delta);
        u  =  Rf_runif(0,1);
        threshold  =   loglikeli1 + palpha1 -  loglikeli0 - palpha0;
        
        if (log(u)<= threshold){alpha  =   nalpha;}
        
        
        
        Sigmas=samplesigma(n, a, 2, us, Lambdas);
        /*sample Lambda*/
        Lambdas=sampleLambda(a, 2, zetasq, Sigmas);
        
        
        betamatrix=samplebeta(p,n,m, ny, phis,xcov,cbeta, omegam,us);
        beta01s=betamatrix.col(0);
        beta10s=betamatrix.col(1);
        
        
        
        
        /*The end of the gibbs sampling*/     
        if((k % nskip)==0 && k>1){
            indsave = indsave +1;
            Sigmasave(indsave-1,0)=Sigmas(0,0);
            Sigmasave(indsave-1,1)=Sigmas(0,1);
            Sigmasave(indsave-1,2)=Sigmas(1,1);
            beta01save.row(indsave-1)=trans(beta01s);
            beta10save.row(indsave-1)=trans(beta10s);
            alphasave.row(indsave-1) = trans(alpha);
            ussave.slice(indsave-1)=us;
            logweightv(indsave-1) = logweight(p,n, m, ny,xcov, beta01s, beta10s,omegam, us); 
            if(indsave>nburn){
                indsavem = indsavem+1;
                
                /*cout<< indsave << " "<< indsavem  <<".\n" ; */
                for(int i=1;i<=n;i++){
                    missingm = 0; 
                    
                    for(int j=1;j<=(m+1);j++){nyi[j-1] = ny(i-1,j-1);deltai[j-1] = delta(i-1,j-1);
                        if((deltai[j-1]<1) && (j>1)){missingm = missingm+1;}}
                    
                    
                    
                    xcovi=xcov.rows(2*m*(i-1),2*m*i-1);
                    ui=trans(us.row(i-1));
                    zcovi=zcov.rows(m*(i-1),m*i-1);
                    likelihoodm(i-1,indsavem-1) = likelihoodi_MAR(m,p,pz, nyi,deltai, xcovi,beta01s,
                                                                  beta10s, ui,zcovi, alpha,missingm,m10);
                    
                    LPMLvec(i-1) = LPMLvec(i-1)+1.0/likelihoodm(i-1,indsavem-1)/double(nuse);
                    
                    
                }
            }
        }
        LPML = -arma::sum(log(LPMLvec));
    }
    
    List save;
    save["beta01"] = beta01save;
    save["beta10"] = beta10save;
    save["u"] =  ussave;
    save["Sigma"] = Sigmasave;
    save["logweight"]=logweightv;
    save["alpha"]=alphasave;
    save["LPML"] = LPML;
    save["Marginal_prob"] = likelihoodm;
    return (save);
    
}
