

**Model no.33 selected to fit the dataset: 2-SLMC_6(2);
**This code was executed in SAS v9.3;

/*
data=dades is the file Data_models_section3.3.txt previously readed in SAS software.
*/

/*
Details execution:

NOTE: Convergence criterion (GCONV=1E-8) satisfied.
NOTE: PROCEDURE NLMIXED used (Total process time):
      real time           26.75 seconds
      cpu time            26.59 seconds

*/

proc nlmixed data=dades qpoints=8;
  parms b0=2 b00=0.15 b1=-1.20 b11=0.20 b2=-.50 b3=-.30 b33=-.10 sigma=1 alfa=0;
  xb1 = b0 + xt1*b1 + xt2*b2 + cares36*b3 ;
  xb2 = b00 + xt1*b11 +  cares36*b33 ;
  p1 = exp(xb1)/(1+exp(xb1));
  p2=  exp(xb2)/(1+exp(xb2));
  q= probnorm(rb1+alfa);
  liklhd1 = (p1**col1)*((1-p1)**(1-col1));
  liklhd2 = (p2**col1)*((1-p2)**(1-col1));
  liklhd= q*liklhd1 + (1-q)*liklhd2;	
  ll = log(liklhd);
  model col1 ~ general(ll);
  random rb1 ~ normal(0,sigma**2) subject=indi;
  estimate 'q' probnorm(alfa);
run;

