function [Coef2, products_basis2_HK]=coef_basis2(V, M, grid, lambda)

% Calculate the coefficients, with respect to the second basis, of a set of m triangulated surfaces in R^3, from the barycenters and normal area vectors of their triangles.
% 
%  INPUTS:
% *V contains the normal area vectors, M contains the barycenters. Their dimensions are num_triangx3xm. V(:,:,ii) and M(:,:,ii) are the (num_triangx3)-matrices for surface ii.
% *grid is a (Nx3)-matrix, where N is the number of points in the grid. grid(ii,:) is one of the points.
% *lambda is a positive number, the parameter of the Gaussian kernel.
%
%  OUTPUTS:
% *Coef2 are the coefficients with respect to the second basis of the set of m surfaces. Each one of the m rows corresponds with the estimation of the first coefficients of a surface.
% *products_basis2_HK is a (3Nx3N)-matrix where the element (ii,jj) corresponds with the inner-product in Hk of the elements ii and jj of the second basis of functions.



%TO OBTAIN Coef2, A FIRST STEP CONSISTS OF CALCULATING THE DATA MATRIX X:
N=size(grid,1); 
m=size(V,3); 

% Calculate the (mx3N)-matrix "X", where each row corresponds with the evaluation of a surface in all the points of the grid.
X=zeros(m,3*N);
for i=1:m
	aux=zeros(size(V,1),1,N); 
	for j=1:N
		aux(:,1,j)=sum(bsxfun(@minus,M(:,:,i),grid(j,:)).^2,2); 
	end
	Eval_current=sum(bsxfun(@times,V(:,:,i),exp(-aux/lambda^2)),1); 	
	X(i,:)=Eval_current(:).'; 
end

%Use Matlab's pca function to calculate Coef2.
[~,Coef2] = pca(X); 






%TO OBTAIN products_basis2_HK, IT IS NECESSARY CALCULATE EIGENVECTORS AND EIGENVALUES OF MATRIX K AND GAMMA AND USE THE EQUATION THAT RELATES INNER-PRODUCT IN Hk WITH INNER PRODUCT IN L^2: 
% Calculate the (NxN)-matrix, where the element (ii,jj) corresponds with the evaluation of the scalar gaussian kernel in grid points, i.e. k(grid(ii,:), grid(jj,:)).
k=zeros(N);
for j=1:N
	k(:,j)=sum(bsxfun(@minus,grid,grid(j,:)).^2,2);
end
k=exp(-k/lambda^2); 

%Calculate eigenvectors ang eigenvalues of the (NxN)-matrix "k" and order them considering the descending order of the eigenvalues. Matrix "k", "Eigenveck", "Eigenvalk" corresponds with the scalar case that it is extended to the vectorial case: "K", "EigenvecK", "EigenvalK". Matrix "K" is defined by N blocks 33 (the block i, j of the matrix is K(grid(ii,:), grid(jj,:))=k(grid(ii,:), grid(jj,:))I_{33} , with i,j=1,...,N).
[Eigenveck,Eigenvalk]=eig(k,'vector'); 
[Eigenvalk,EigenvalkOrder] = sort(Eigenvalk,'descend');Eigenveck=Eigenveck(:,EigenvalkOrder);clear EigenvalkOrder;
EigenvecK=repelem(Eigenveck,3,3).*repmat(eye(3),size(Eigenveck,1),size(Eigenveck,2)); 
EigenvalK=repelem(Eigenvalk,3); 
K=repelem(k,3,3).*repmat(eye(3),size(k,1),size(k,2)); 

%Calculate eigenvectors ang eigenvalues of the (3Nx3N)-matrix "GAMMA" and order them considering the descending order of the eigenvalues. 
GAMMA=cov(X);
[EigenvecGamma,EigenvalGamma]=eig(GAMMA,'vector'); 
[EigenvalGamma,EigenvalGammaOrder] = sort(EigenvalGamma,'descend');EigenvecGamma=EigenvecGamma(:,EigenvalGammaOrder);clear EigenvalGammaOrder; 

%Calculate the inner-product in Hk of elements of the second basis of functions using its relation with the inner-product in L^2 and eigenvectors and eigenvalues of matrix K.
product_K_Gamma=dot(repmat(permute(EigenvecK,[2 3 1]),[1,size(EigenvecGamma,2),1]),repmat(permute(EigenvecGamma,[3 2 1]),[size(EigenvecK,2),1,1]),3); %product_K_Gamma(i,j) is the euclidean inner-product between column "i" of EigenvecK and column "j" of EigenvecGamma.
products_basis2_HK=product_K_Gamma.'*diag(1./EigenvalK)*product_K_Gamma; %Apply relation
products_basis2_HK=(products_basis2_HK+products_basis2_HK.')/2; %Ensure the symmetry of the matrix (it could be non symmetrical as a consequence of the finite precision of the computer).


