function [Coef3, products_basis3_HK]=coef_basis3(V, M, grid, lambda)

% Calculate the coefficients, with respect to the third basis, of a set of m triangulated surfaces in R^3, from the barycenters and normal area vectors of their triangles.
% 
%  INPUTS:
% *V contains the normal area vectors, M contains the barycenters. Their dimensions are num_triangx3xm. V(:,:,ii) and M(:,:,ii) are the (num_triangx3)-matrices for surface ii.
% *grid is a (Nx3)-matrix, where N is the number of points in the grid. grid(ii,:) is one of the points.
% *lambda is a positive number, the parameter of the Gaussian kernel.
%
%  OUTPUTS:
% *Coef3 are the coefficients with respect to the third basis of the set of m surfaces. Each one of the m rows corresponds with the estimation of the first coefficients of a surface.
% *products_basis3_HK is a (3Nx3N)-matrix where the element (ii,jj) corresponds with the inner-product in Hk of the elements ii and jj of the third basis of functions.


%TO OBTAIN Coef3, A FIRST STEP CONSISTS OF CALCULATING THE MATRIX G. IT IS DEFINED FROM MATRIX K AND MATRIX GAMMA.
%To calulate matrix GAMMA, it is necessary obtain the data matrix X.
N=size(grid,1); 
m=size(V,3); 
% Calculate the (mx3N)-matrix "X", where each row corresponds with the evaluation of a surface in all the points of the grid.
X=zeros(m,3*N);
for i=1:m
	aux=zeros(size(V,1),1,N); 
	for j=1:N
		aux(:,1,j)=sum(bsxfun(@minus,M(:,:,i),grid(j,:)).^2,2); 
	end
	Eval_current=sum(bsxfun(@times,V(:,:,i),exp(-aux/lambda^2)),1); 	
	X(i,:)=Eval_current(:).'; 
end 
% Obtain GAMMA
GAMMA=cov(X);

% To obtain the (3Nx3N)-matrix "K", calculate the (NxN)-matrix "k", where the element (ii,jj) corresponds with the evaluation of the scalar gaussian kernel in grid points, i.e. k(grid(ii,:), grid(jj,:)).
k=zeros(N);
for j=1:N
	k(:,j)=sum(bsxfun(@minus,grid,grid(j,:)).^2,2);
end
k=exp(-k/lambda^2); 
% Matrix "k"corresponds with the scalar case that it is extended to the vectorial case: "K". Matrix "K" is defined by N blocks 33 (the block i, j of the matrix is K(grid(ii,:), grid(jj,:))=k(grid(ii,:), grid(jj,:))I_{33} , with i,j=1,...,N).
K=repelem(k,3,3).*repmat(eye(3),size(k,1),size(k,2)); 

% Obtain (3Nx3N)-matrix G defined in the paper from K and GAMMA.
sqrt_K=sqrtm(K);
G=sqrt_K*GAMMA*sqrt_K;
G=(G+G.')/2; %Ensure the symmetry of the matrix (it could be non symmetrical as a consequence of the finite precision of the computer).


%Once obtained matrix G, calculate eigenvectors and eigenvalues of matrix G to calculate Coef3 solving a matrix system (Theorem of the paper). 
[EigenvecG,EigenvalG] = eig(G,'vector');
[EigenvalG,EigenvalGOrder] = sort(EigenvalG,'descend');EigenvecG=EigenvecG(:,EigenvalGOrder);clear EigenvalGOrder;
Mixed_Basis=sqrt_K*EigenvecG; %Mixed_basis is a (3Nx3N)-matrix containing the vectors that estimates the third basis functions.
Coef3=X/(Mixed_Basis.'); 





%TO OBTAIN products_basis3_HK, IT IS NECESSARY CALCULATE EIGENVECTORS AND EIGENVALUES OF MATRIX K AND USE THE EQUATION THAT RELATES INNER-PRODUCT IN Hk WITH INNER PRODUCT IN L^2: 

%Calculate eigenvectors ang eigenvalues of the (NxN)-matrix "k" and order them considering the descending order of the eigenvalues. Matrix "k", "Eigenveck", "Eigenvalk" corresponds with the scalar case that it is extended to the vectorial case: "K", "EigenvecK", "EigenvalK". 
[Eigenveck,Eigenvalk]=eig(k,'vector'); %Calculamos los valores y vectores propios
[Eigenvalk,EigenvalkOrder] = sort(Eigenvalk,'descend');Eigenveck=Eigenveck(:,EigenvalkOrder);clear EigenvalkOrder; 
EigenvecK=repelem(Eigenveck,3,3).*repmat(eye(3),size(Eigenveck,1),size(Eigenveck,2)); 
EigenvalK=repelem(Eigenvalk,3); 


%Calculate the inner-product in Hk of elements of the third basis of functions using its relation with the inner-product in L^2 and eigenvectors and eigenvalues of matrix K.
product_K_Mixed=dot(repmat(permute(EigenvecK,[2 3 1]),[1,size(Mixed_Basis,2),1]),repmat(permute(Mixed_Basis,[3 2 1]),[size(EigenvecK,2),1,1]),3); %product_K_Mixed(i,j) is the euclidean inner-product between column "i" of EigenvecK and column "j" of Mixed_Basis.
products_basis3_HK=product_K_Mixed.'*diag(1./EigenvalK)*product_K_Mixed; %Apply relation
products_basis3_HK=(products_basis3_HK+products_basis3_HK.')/2; %Ensure the symmetry of the matrix (it could be non symmetrical as a consequence of the finite precision of the computer).

