cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c       Simulation study. Bayesian Analysis of Markov Switching
c       NB INGARCH models based on arranged autoregression						 							 
c                                                        28,05, 2018                
c       Using M-H algorithm                                 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
        program main
	  use msimsl
	  use dfport   ! for PC Fortran Version 6.5
c	  use portlib  ! for PC Fortran Version 5 
	  implicit none

	  integer nn,mm,mn,ii,k,j,t,i,ngb,mgb,igb,ino,isi,iseed
        parameter(nn=5,mm=5)
        real*8 y(8800),at(8800),z(8800),abd,bbd,pr(10,8800)
 
        real*8 ph1(nn),ph2(mm),sig(8800),s_t(8800),s_tt(8800)
        real*8 p_00,p_11,u,ss_t(8800),wt(8800),zt(8800)
	  real*8 tt(800,30000),est(30,5),mu,md,std,p25,p975,true(25)
 	  real*8 a_1(5),a_2(5),lik,temp_a(5),xx(500,8800)

	  real*8 sum1,sum2,ssig3(800,30000),ssig4(800,30000)
	  real*8 ssig(800,30000), ssig2(800,30000),predy(800,30000)
	  real*8 sig1(1000),sig2(1000),sig3(1000) !! for conditional mean
  	  real*8 sig_md(1000), sig_m(1000),sig_low(1000),sig_up(1000)
     + 	     ,sig2_m(1000),sig3_m(1000)
  	  real*8 pred_md(1000), pred_m(1000),pred_low(1000),pred_up(1000)
	  real*8 emean(30,1000),emedian(30,1000),esd(30,1000)
        real*8 eest(8800,30,5),fest(30,5)
	  real*8 wtf(8800),yf(8800),rsig1(5,5),rsig2(5,5)
        character(10) pname(25)
	  real*8 b_1(30000,5),b_2(30000,5)
	  real*8 res(8800),resid(8800),ps_t(8800),temp
        real*8 cov(25)
        integer d, th_no,jjcount(2)
        integer cnt(2),p(2),npar(2),nob,nmax,nosim,pcount(2)
        integer fnob,numv5,numv1
	  integer iacpt1,iacpt2,acceptmu1
	  integer jcount(2),n0,n1,pw(2),nregime(2)
	  integer*4  No1, No2
	  parameter(No1= 8800, No2=5)
	  real*8 mean1(5),mean2(5),var1(5,5),var2(5,5)
    	  real*8 design_mat(No1,No2), resp(No1), 
     *		 WXTX(No2,No2),XWM(No2,No1),R(No2),
     *         MAT(No2,No2),error
	  real*8 ss1,ss2,shead,con,mu1,u_1,u_2
	  integer cind,w(8800)
        integer y_hat(1000)
        real*8 bsum(8800),por(8800),pred_y(1000)
        real*8 r1, ss(8800)
	  real*8 sum3,sum4,wmean,wvar,w1(8800),w2(8800)
	  real*8 zmean,zvar
        real   rhh 


        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /exogenous/ pw,wt,zt
        common /index/ nob
	  common /quartile/ abd,bbd
	  common /accept1/ iacpt1
	  common /accept2/ iacpt2
        common /count/ jcount,jjcount,n0,n1
	  common /con/ con                 !alpha0~U(0,con*svar)
	  common /pred/ pred_y


******** Defined by Mike

	  integer naccept
	  real*8  svar, smean, ay(-100:8800), step0, step1, step0a, 
     *		  step1a, stepr1, stepch, stepmu1
	  character(9)   now, today

	  common /meanvar/ svar
	  common /ay/ ay
	  common /stepsize/ step0,step1,step0a,step1a,stepmu1
	  common /mcmc/ igb, mgb
	  common /accept3/ acceptmu1
	  common /blk10/ naccept
	  common /blk11/ stepch 
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2


************* For DIC 	       

        real*8 DIC_1, DIC_2, lik1, lik2

******************* report files *************************

c      open (1,file='simu.txt')
       open (2,file='si2.txt')
c      open (3,file='si3.txt')
c      open (4,file='gibbs.txt')
       open (5,file='DIC.txt')
       open (15,file='si4.txt')  
       open (17,file='est_final.txt')
	 open (18,file='ms100note.txt')
	 open (19,file='sig_MS.txt')
       open (90,file='prob_bt.txt')
       open (168,file='bt.txt')
       open (169,file='pred.txt')

********************************************************
************** Determine the current date & time

	  call date_and_time(today)
	  now= clock()
	  write(2,*)'Date and time  ',today,'   ',now

************* Real data: dengue ************************

       open (111,file='DS2.txt')

********************************************************

       sum1=0.0d0
	 sum2=0.0d0
	 sum3=0.0d0
	 sum4=0.0d0

	 do t=1, 612
	   read(111,*,end=2005) y(t), wt(t), zt(t)
	   nob = t

******** To transfrom zt(t)
       
	 sum1=sum1 + wt(t)
	 sum2=sum2 + wt(t)**2    
	 sum3=sum3 + zt(t)
	 sum4=sum4 + zt(t)**2    

	 enddo
2005	 continue
       close(11)

********************************************************
       wmean =  sum1/real(nob)
	 wvar  = (sum2-(sum1**2)/real(nob))/real(nob-1)
       zmean =  sum3/real(nob)
	 zvar  = (sum4-(sum3**2)/real(nob))/real(nob-1)

	  write (*,*) 'wmean, wvar',wmean,wvar
	  write (*,*) 'zmean, zvar',zmean,zvar
        
********************************************************

c	 do t=1,nob
c      write (*,*) w(t), y(t)
c	 enddo
c	 close(111)

c	 pause


*************** To transformation for railfall and temp. 

       do t=1, nob

       wt(t) = abs(wt(t)-wmean)/sqrt(wvar)
       zt(t) = abs(zt(t)-zmean)/sqrt(zvar)

       enddo 

c       write (*,*) (t, wt(t), zt(t), t=1,nob)
c       pause

************** no. of simulations, sample size, no. of iterations
	 
	  data nosim/1/	    ! no. of simulations
        
c	  nob = 700         ! no. of samples
	  ngb = 30000		! no. of iterations
	  mgb = 8000		! no. of burn-in iterations

****************  Setting the value of the seed

         iseed=70368760954879  !! 
c        iseed=57347737657177  !!  
c        iseed=57845906769303  !!  
c	   iseed=61329737591919  
c	   iseed=51729737757199    


	  call rnopt(2)
	  call rnset(iseed)
	  write(*,*)'The seed is  ',iseed

************** some information to file

c	 write(2,*)'The Metropolis step uses the normal kernels ' 
c      write(2,*)'rather than truncated normal in sampling r'
	 write(2,*)'I do not use the first 100 iterates to obtain the'
       write(2,*)'Normal kernal for GARCH parameters'

       write(2,*)'No. of simulations  ',nosim
	 write(2,*)'No. of iterations & burn-in ',ngb, mgb
	 write(2,*)'No. of observations  ',nob
	 write(2,*)'The seed is   ',iseed
       write(2,*)'p_00 prior and p_11 prior '
c	 write(2,*)'restriction in garch2: un_var1 > un_var2'
c      write(2,*)'restriction in garch2: a_1(1) > a_2(1)'
c      write(2,*)


***********  (nosim) data sets are generated

       cov = 0.0d0

       do 1000 isi=1, nosim    
       
***************************************************     

       tt=0.0d0
	 est=0.0d0   
	 jcount=0	
       iacpt1=0
       iacpt2=0
       acceptmu1=0	
       naccept=0
       bsum=0.0d0
	 por=0.0d0
       DIC_1=0.0d0
	 DIC_2=0.0d0

**************************************************     
	 write(2,34)
34	 format(65('-'))
	 write(2,*)'Iteration  ',isi
	 write(2,*)

	  call date_and_time(today)
	    now= clock()
	  write(2,*)'Date and time  ',today,' ',now

********** reset initial values

        data cnt(1),cnt(2),p(1), p(2) /1,1,1,1/
        data pw(1),pw(2) /1,1/
        data a_1 /0.1d0, 0.1d0, 0.1d0, 0.1d0, 0.1d0/
	  data a_2 /0.1d0, 0.1d0, 0.1d0, 0.1d0, 0.1d0/
	  data iacpt1,iacpt2,naccept,acceptmu1 /0,0,0,0/
        data p_00 /.50/
        data p_11 /.50/
        data con /0.8d0/
        data mu1 /2.0d0/
        data r1  /2.0d0/ 
     
************************************************** 
        do k=1,2
	                               
	   npar(k)=3  !npar=no. of total parameters

	  enddo
    
************ simulate s_t as one set initial value 

      s_t(3) = 0.0d0  

      do i=4,nob
	  call rnopt(6)
	  call drnun(1,u)
	if ( s_t(i-1) .eq. 0.0d0 ) then
	   if ( u <= p_00 ) then
	     s_t(i) = 0.0d0
	   else
	     s_t(i) = 1.0d0    
	   end if
      else if ( s_t(i-1) .eq. 1.0d0 ) then
         if ( u <= p_11 ) then
	     s_t(i) = 1.0d0
	   else
	     s_t(i) = 0.0d0    
	   end if
      end if
      end do
       

*********** count the number of s_t(t-1)

       jjcount(1)=0
       do t=npar(1)+1,nob
	  if ( s_t(t-1) .eq. 0.0d0 ) then
	    jjcount(1)=jjcount(1)+1  !count the number of s_t(t-1)=0
	  endif
	 enddo	  
	    jjcount(2)=nob-npar(1)-jjcount(1) !count the number of s_t(t-1)=1  
	    
c	 write (5,*) 'simulate_ no of each regime',jjcount
c      write (2,*) 'simulate_ no of each regime',jjcount
c      write (*,*) 'simulate_ no of regime_1',jjcount(1)
c      write (*,*) 'simulate_ no of regime_2',jjcount(2)
c	 pause

*********** count the number of s_t(t)=0 and s_t(t-1)=0
 
       n0=0
      do t=npar(1)+1,nob
	  if ( s_t(t) .eq. 0.0d0 .and. s_t(t-1) .eq. 0.0d0 ) then
	    n0=n0+1	  
	  endif
	enddo
c      write (*,*) 'n0',n0
       

*********** count the number of s_t(t)=1 and s_t(t-1)=1

       n1=0
      do t=npar(1)+1,nob
	  if ( s_t(t) .eq. 1.0d0 .and. s_t(t-1) .eq. 1.0d0 ) then
	    n1=n1+1  
	  endif
	enddo
c      write (*,*) 'n1',n1
c      pause 
************** reset stepsize 
	 
	  step0= .02d0    ! step sizes for regime 1 garch parameters
	  step1= .02d0
	  step0a= .02d0  ! step sizes for regime 2 garch parameters
	  step1a= .02d0
	  stepch=  1.4d0 ! step for r
	  stepmu1= 1.6d0  ! step size for mu1
	  

       write(2,*)
	 write(2,*)'The stepsizes in the Metropolis step:  '
	 write(2,*)'Step0, step1, step0a, step1a ',step0,step1,step0a
     *		   ,step1a,' for r1, mu1 ',stepch, stepmu1
	 write(2,*)


************* simulate the data

c       call simu (pname,true)
c	  pause
c       write (*,*) 'y(1)=', y(1)
c	  write (2,*) 'y(1)=', y(1)
c       pause

***********************************************************  
******** calculate the sample mean and variance

	  do t= -100, 0
	    ay(t)= 0.0d0		! Define ay(t)
        enddo

		ss1=0.0d0
	    ss2=0.0d0

	  do t=1, nob
	    ay(t)= y(t)			! Define ay(t)
	    ss1= ss1 + y(t)
	    ss2= ss2 + y(t)**2.0d0
	  enddo
	  smean= ss1/real(nob)
	  svar= (ss2-(ss1**2)/real(nob))/real(nob-1)
       
        
***********************************************************
******** initial guess 
      
	  write (*,*) 'smean, svar',smean,svar
	  write (*,*) 'sample mean and variance  ',smean,svar
	  write (2,*) 'sample mean and variance  ',smean,svar

c	  svar=smean

	  step0= step0
	  step0= step0*svar*0.01 
        step0a= step0a
	  step0a= step0a*svar*0.01
        stepch= stepch

        
	  write(*,*)'Revising the stepsizes for alpha0 as ',
     *	step0,step0a ,' r1',stepch,' mu1',stepmu1
	  write(2,*)'Revising the stepsizes for alpha0 as ',
     *	step0,step0a ,' r1',stepch,' mu1',stepmu1

****************************************************************

	 ino=0		! count the number of iterations after burn-in

****************************************************************

	 do igb=1, ngb	 !Start the MCMC

	 call proba  (a_1,a_2,r1,mu1,p_00,p_11)  ! generate p_00 and p_11
	 call pst    (a_1,a_2,r1,mu1,p_00,p_11)  ! generate b_t
	 call garch1 (a_1,a_2,r1,mu1,p_00,p_11) 
	 call garch2 (a_1,a_2,r1,mu1,p_00,p_11)

	 u_1=r1*a_1(1)/(1.0d0-r1*a_1(2)-a_1(3))
	 u_2=r1*a_2(1)/(1.0d0-r1*a_2(2)-a_2(3))

	 if (u_1 .gt. u_2) then

		temp_a = a_1
		   a_1 = a_2
		   a_2 = temp_a	

	 endif

       call drawr1 (a_1,a_2,r1,mu1,p_00,p_11) 
 	 call drawmu1 (a_1,a_2,r1,mu1,p_00,p_11)
	 
****************************************************************

       if(igb .gt. 8000) then	
       do i= 1,1
c	 if ( isi .eq. i ) then
       
c	 write (3,113) a_1(1),a_1(2),a_1(3),a_1(4),a_1(5),a_2(1),a_2(2)
c     +	   ,a_2(3),a_2(4),a_2(5),p_00,p_11,r1,mu1
c       endif
	enddo
      endif

113   format (1x,15(f10.4,1x))

      if ( mod(igb,1000) .eq. 0 )  then	!print/1000

	write(*,34)  
	print *,isi,' run ', igb, ' iteration'
		
	write(*,91)'garch1  ',a_1
	write(*,91)'accept. rate ',100.0d0*iacpt1/igb
      write(*,*)
	write(*,91)'garch2  ',a_2
	write(*,91)'accept. rate ',100.0d0*iacpt2/igb
	write(*,*)
      write(*,91)'r1 ', r1
	write(*,91)'accept. rate ',100.0d0*naccept/igb
      write(*,91)'mu1 ', mu1
	write(*,91)'accept. rate ',100.0d0*acceptmu1/igb
      write(*,*)
	write(*,91)'umean_1 ', r1*a_1(1)/(1.0d0-r1*a_1(2)-a_1(3))
	write(*,91)'umeam_2 ', r1*a_2(1)/(1.0d0-r1*a_2(2)-a_2(3))
      write(*,*)

91    format (1x,a14,1x,10(f8.4,1x)) 

	endif
       
************* Revise the step size of garch1, garch2 and mu1 after 1000 iteration

        if (igb.eq.2000 ) then 

        write(*,*)'Revise the step size of garch1, garch2 here'
        write(2,*)
        write(2,*)'Revise the step size of garch1, garch2 here'

        write(*,*)'Revise the step size of r1 and mu1 here'
        write(2,*)
        write(2,*)'Revise the step size of r1 and mu1 here'
	
       sum2= 1.0d0*iacpt1/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       step1= dexp(dlog(step1) + sum1/1.0d0)
       step0= step1

        write(*,*)'The new step size of garch1 is  ',step1
        write(2,*)'The new step size of garch1 is  ',step1

       sum2= 1.0d0*iacpt2/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)
       
       step1a= dexp(dlog(step1a) + sum1/1.0d0)
       step0a= step1a

        write(*,*)'The new step size of garch2 is  ',step1a
        write(2,*)'The new step size of garch2 is  ',step1a

       sum2= 1.0d0*naccept/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       stepch = dexp(dlog(stepch) + sum1/1.0d0)

       sum2= 1.0d0*acceptmu1/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       stepmu1 = dexp(dlog(stepmu1) + sum1/1.0d0)

        write(*,*)'The new step size of r1 is',stepch
        write(2,*)'The new step size of r1 is',stepch
        write(*,*)'The new step size of mu1 is',stepmu1
        write(2,*)'The new step size of mu1 is',stepmu1

        endif

*************** Calculate the sample covariance after the burn-in iterations
********** This is used to carry out the MH step using independent normal kernel.
		
	if ( (igb.gt.1000).and.(igb .le. mgb) ) then !mgb=8000
	
	  do i=1,5
		b_1(igb-1000,i)=a_1(i)
		b_2(igb-1000,i)=a_2(i)
	  enddo

	  if (igb .eq. mgb) then
	 
	    call s_cov(1, b_1, mgb-1000)
	    call s_cov(2, b_2, mgb-1000)

 		write(2,*)'burn-in acceptance rate  '
	    write(2,*) igb,' garch1: accept. rate ',100.0d0*iacpt1/igb
	    write(2,*) igb,' garch2: accept. rate ',100.0d0*iacpt2/igb
          write(2,*) igb,' r1: accept. rate ',100.0d0*naccept/igb
          write(2,*) igb,' mu1: accept. rate ',100.0d0*acceptmu1/igb

	  endif
      endif

*************************************************************************
**************** Analyze the results after the burn-in iterations

	if ( (igb .gt. mgb) .and. (mod(igb,5) .eq. 0)) then
       
**************DIC

	  call loglik (a_1,a_2,lik1,r1,mu1,p_00,p_11)
	       
		   DIC_1=DIC_1+lik1

************** Iterations after burn-in        

	  ino=ino+1  ! count the number of iterations after burn-in

***************** To draw y_hat
      
	 rhh=int(r1)
     
       do t=4, nob 
       
	 call rnnbn(1, rhh, real(sig(t)/(1+sig(t))), y_hat(t))
       
	      pred_y(t) = y_hat(t)
       
	 enddo

******************
	do i=1,5
         tt(i,ino)=a_1(i)
	enddo
	
	do i=1,5
	   tt(i+5,ino)=a_2(i)
	enddo
	    
		 tt(11,ino) = p_00
           tt(12,ino) = p_11
           tt(13,ino) = r1
           tt(14,ino) = mu1
           tt(15,ino) = r1*a_1(1)/(1.0d0-r1*a_1(2)-a_1(3))
           tt(16,ino) = r1*a_2(1)/(1.0d0-r1*a_2(2)-a_2(3))
            

****************** To calculate prob b_t *************************
     
	  do t=4, nob 
            bsum(t)=bsum(t)+int(s_t(t))
	  enddo
	  write (168,1118) (int(s_t(t)),t=1, nob)   
1118    format (1x,630(i3))


***************** For lambda & prediction ****************

	 call sigma(a_1,a_2,r1,mu1,p_00,p_11)
	 
	  do t=4, nob
	     predy(t,ino) = pred_y(t)  ! for predition
	     ssig(t,ino) = r1*sig(t)   ! for mean
	  enddo

**********************************************************         
        if ( isi .eq. 1 ) then   
c            if ( mod(igb,5) .eq. 0 )  then	  	   
c			write (4,103) (tt(i,ino),i=1,11)   
c103    format (1x,15(f10.4,1x),i4,f10.4)
c	      endif 
         endif
        endif
	enddo

*********  enddo igb --- end the MCMC 
        
      write(2,*)
	write(2,*)'garch1  ','accept. rate ',100.0d0*iacpt1/igb
	write(2,*)'garch2  ','accept. rate ',100.0d0*iacpt2/igb
      write(2,*)'r1  ','accept. rate ',100.0d0*naccept/igb
	write(2,*)'mu1  ','accept. rate ',100.0d0*acceptmu1/igb
	write(2,*)

*************** Average prob of b_t ***************

	 do t=4, nob 
	 	   
		   por(t) = (bsum(t))/real(ino) 

	 ! To calculate prob of two-state

	  if (por(t) .ge. 0.5d0) then

           s_t(t) = 1.0d0
	  else
           s_t(t) = 0.0d0

	   endif

	 write(90,108) t, int(y(t)), int(s_t(t)), por(t) 

108   format ((i4, 1x, i4, 1x, i4, 1x,f10.5,1x))
       
	 enddo

*************** To estimate parameters ***********************
 
         do ii=1,16
	  
	   call med(ii,ino,tt,mu,md,std,p25,p975)
	
		est(ii,1)=mu
		est(ii,2)=md
		est(ii,3)=std
		est(ii,4)=p25
		est(ii,5)=p975

		enddo
  
	  do ii=1,16
	  if (true(ii).ge. est(ii,4).and. 
     +  true(ii).le. est(ii,5)) cov(ii)=cov(ii)+1.0
	  enddo

*************** To estimate residual ***********************
 
        sig1(3)= mu1
        sig2(3)= mu1

      	do t=4, nob

	    call med(t,ino,ssig,mu,md,std,p25,p975)

		sig_m(t)   = mu
	    sig_md(t)  = md
		sig_low(t) = p25
		sig_up(t)  = p975

       sig1(t)=a_1(1)+a_1(2)*y(t-1)+a_1(3)*sig1(t-1)+a_1(4)*wt(t-1)
     +         +a_1(5)*zt(t-1)
	 sig2(t)=a_2(1)+a_2(2)*y(t-1)+a_2(3)*sig2(t-1)+a_2(4)*wt(t-1)
     +         +a_2(5)*zt(t-1)

	 if (por(t) .gt. 0.5) then
 
       	sig3(t) = sig2(t)
	 else
      	sig3(t) = sig1(t)
	 endif	   
 
	   res(t) = (y(t)-r1*sig3(t))/(r1*sig3(t)*(1+sig3(t)))**0.5	

	   enddo

c		write(*,*) sig_m(2), sig_low(2), sig_up(2)	
c         pause


***************** For prediction

		do t=4, nob

	    call med(t,ino,predy,mu,md,std,p25,p975)

		pred_m(t)	= mu
	    pred_md(t)	= md             
		pred_low(t)	= p25
		pred_up(t)	= p975
        
	  enddo

*********************To put in estimates **************************
       
	 a_1(1)=est(1,1)
	 a_1(2)=est(2,1)
	 a_1(3)=est(3,1)
       a_1(4)=est(4,1)
       a_1(5)=est(5,1)
	 a_2(1)=est(6,1)
	 a_2(2)=est(7,1)
	 a_2(3)=est(8,1)
       a_2(4)=est(9,1)
       a_2(5)=est(10,1)
	 p_00=est(11,1)
	 p_11=est(12,1)
	 r1=est(13,1)
	 mu1=est(14,1)


***************** For DIC

	  call pst (a_1,a_2,r1,mu1,p_00,p_11)   

        call loglik (a_1,a_2,lik2,r1,mu1,p_00,p_11)

	   DIC_2=2.0d0*(-2.0d0*DIC_1)/(ino)-(-2.0d0*lik2)

        write (2,*) 'DIC = ', DIC_2
        write (*,*) 'DIC = ', DIC_2
        write (2,*) 'POR: loglik = ', lik2
        write (*,*) 'POR: loglik = ', lik2

        write (5,*)  DIC_2, lik2

*********** write out real*8 parameters to compare

	 pname(1)='alpha1_0'
	 pname(2)='alpha1_1'
	 pname(3)='beta1_1'
       pname(4)='gamma1_1'
       pname(5)='gamma1_2'
	 pname(6)='alpha2_0'
	 pname(7)='alpha2_1'
	 pname(8)='beta2_1'
	 pname(9)='gamma2_1'
	 pname(10)='gamma2_2'
	 pname(11)='p_00'
	 pname(12)='p_11' 
       pname(13)='r1'
       pname(14)='mu1'
       pname(15)='un_var_1' 
       pname(16)='un_var_2' 

*********************** resule est************************************

	  do ii=1,14
	  write (2,101) pname(ii),true(ii),(est(ii,k),k=1,5) ,cov(ii)
	  write (*,101) pname(ii),true(ii),(est(ii,k),k=1,5) ,cov(ii)

101   format(1x,a10,1x,15(f10.4,1x))
	 
	 enddo

*********** To save resd

	 do t=1, nob
c	 write(*,*)   sig_low(t), sig_m(t), sig_up(t)
	 write (19,104) y(t),sig_low(t),sig_m(t),sig_up(t),res(t)
104	 format (1x, 5(f10.4, 1x))
	 enddo

************** To save predit est
	 
	 do t=4, nob
	 write (169,105) y(t), pred_low(t), pred_m(t), pred_up(t)
105	 format (1x, 4(f10.4, 1x))
	 enddo


************ To given posterior means to parameters 

	 a_1(1)=est(1,1)
	 a_1(2)=est(2,1)
	 a_1(3)=est(3,1)
       a_1(4)=est(4,1)
       a_1(5)=est(5,1)
	 a_2(1)=est(6,1)
	 a_2(2)=est(7,1)
	 a_2(3)=est(8,1)
       a_2(4)=est(9,1)
       a_2(5)=est(10,1)
	 p_00=est(11,1)
	 p_11=est(12,1)
	 r1=est(13,1)
	 mu1=est(14,1)
      
********************************************************************

       write(15,102) ((est(j,i),i=1,5),j=1,13)
c      write(*,102) ((est(j,i),i=1,5),j=1,11) 
102   format(65(f8.4,1x),i1)


**************save the est************

	do j=1,5
	 do i=1,16
	     eest(isi,i,j)=est(i,j)
	 enddo
	enddo

	do i=1,16
	   emean(i,isi)=eest(isi,i,1)
	   emedian(i,isi)=eest(isi,i,2)
	   esd(i,isi)=eest(isi,i,3)
	enddo

***************************************************

1000   continue  ! enddo 1000 isi=1, nosim

*************************************************** 

	 do i=1,isi-1
	 write(18,113) (eest(i,j,2), j=1,14)
	enddo
	

****************** Compute the mean of est.*********

	do i=1,16
	 do j=1,5
	  do isi=1,nosim

	fest(i,j)=fest(i,j)+eest(isi,i,j)

	  enddo
	 enddo
	enddo
	
	do i=1,16
	 do j=1,5

	fest(i,j)=fest(i,j)/nosim
	 enddo
	enddo

	 write(*,*)'-----------------------------------------'
	 write(2,*)'-----------------------------------------'       

	write(17,118)  ' ','True value','Mean ','Median','Std Dev'
     +,'25%','97.5%','Coverage'
 
 118	format (1x,16(a10,1x))

          write(*,*) '  '
          write(*,*) 'Summary Stat'
	    write(2,101) 'Summary Stat'

	write(2,120)'parameters','true','mean','md','std','p25','p975'
     +	,'Coverage'
   	write(*,120)'parameters','true','mean','md','std','p25','p975'
     +	,'Coverage'  
    
	  do ii=1,14
c	  if (ii .eq. 11 )  write (*,*)  '---------------------'  
	  cov(ii)=(cov(ii)/real(nosim))
        write(2,119) pname(ii),true(ii),(fest(ii,k),k=1,5),cov(ii)
	  write(17,119) pname(ii),true(ii),(fest(ii,k),k=1,5),cov(ii)
	  write(*,119) pname(ii),true(ii),(fest(ii,k),k=1,5),cov(ii)
 	  enddo
 
 119	format(1x,a10,1x,15(f10.4,1x))         
 120 	format(1x,a10,1x,a10,1x,15(a10,1x))  

       
*************************************************** 
		
	  call date_and_time(today)
	  now= clock()
	  write(2,*)'Date and time  ',today,'   ',now

      stop
	end

*********** generate p_00 & p_11*************************************************
 
        subroutine proba (a_1,a_2,r1,mu1,p_00,p_11) 
	  use msimsl
	  implicit none

	  integer  irg, i,j,i1,j1, nob, t, ii, m, n,irank,r
	  real*8  a_1(5),a_2(5),svar,ay(-100:8800)
        parameter (n=5,m=5)
        real*8 y(8800),at(8800),lik1,lik2,sigma(8800),a_t(8800),wt(8800)
        real*8 ph1(n),ph2(m),sig(8800),s_t(8800),mu1,r1,zt(8800)
        integer cnt(2),p(2),npar(2), pw(2)
        integer jcount(2),igb,mgb,jjcount(2),n0,n1,k1,k0
        real*8 p_00, p_11,u_00,u_01,e_1,e_2,rr,u_11,u_10,w_1,w_2
       
        common /obs/ y,sig,s_t
	  common /exogenous/ pw,wt,zt
        common /order/ cnt,p, npar
        common /index/ nob
	  common /count/ jcount,jjcount,n0,n1
	  common /mcmc/ igb, mgb
	  common /meanvar/ svar
	  common /ay/ ay  
	  

      u_00=80.0d0
	u_01=20.0d0
	k0=jjcount(1)  ! k0 is the number of s_t(t-1)=0
	
	e_1=u_00 + n0  ! n0 is the number of s_t(t)=0 and s_t(t-1)=0
	e_2=u_01 - n0 + k0

c      write(*,*) 'the posterior parameter of p_00',e_1, e_2
c      write(*,*) n0
	
        call rnopt(6)
	  call drnbet(1,e_1,e_2,p_00)
c       write(*,*) 'p_00= ',p_00	
c       write(13,*) 'p_00= ',p_00

      u_11=80.0d0
	u_10=20.0d0
	k1=jjcount(2)  ! k1 is the number of s_t(t-1)=1
	
	w_1=u_11 + n1  ! n1 is the number of s_t(t)=1 and s_t(t-1)=1
	w_2=u_10 - n1 + k1
c      write(*,*) 'the posterior parameter of p_11',w_1, w_2
      
        call rnopt(6)
	  call drnbet(1,w_1,w_2,p_11)
c       write(*,*) 'p_11= ',p_11	
c       write(14,*) 'p_11= ',p_11	

	return
      end


*************** generate st ***********************************************

        subroutine pst (a_1,a_2,r1,mu1,p_00,p_11)
	  use msimsl
	  implicit none
	  integer  irg, i,j,i1,j1, nob, t, ii, m, n,irank,r
	  real*8  a_1(5), a_2(5), svar,ay(-100:8800),zt(8800)
        parameter (n=5,m=5)
        real*8 y(8800),at(8800), likeli_0,likeli_1,sigma(8800),a_t(8800)
        real*8 ph1(n),ph2(m),sig(8800),s_t(8800),s_tt(8800),st(8800)
        integer cnt(2),p(2),npar(2),d,th_no,k,kk,pw(2),w(8800)
        integer jcount(2),igb,mgb,jjcount(2),n0,n1,iino,st_count(2)
        real*8 u, p_00, p_11,pp,pr,likeli,ymean,mu1,uu
        real*8 li_0,li_1,pr_0,pr_1,prob_0,prob_1, wt(8800),r1,r11


        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
	  common /count/ jcount,jjcount,n0,n1
	  common /mcmc/ igb, mgb
	  common /meanvar/ svar
	  common /ay/ ay  
        common /exogenous/ pw,wt,zt


        likeli_0 = 0.0d0
        likeli_1 = 0.0d0


*********	ay(t)= y(t), t=1,...,nob   and  ay(t)=0 for t<1	**********************
******** calculate sig(t)    

       sigma(3) = mu1
	 r11      = r1

	do 550 t=4,nob
	
	 if ( s_t(t) .eq. 0.0d0 ) then

           sigma(t) = a_1(1)+a_1(2)*real(y(t-1))+a_1(3)*sigma(t-1)
 
     +              +  a_1(4)*real(wt(t-1)) + a_1(5)*zt(t-1)
	else
	     sigma(t) = a_2(1)+a_2(2)*real(y(t-1))+a_2(3)*sigma(t-1)
 
     +              +  a_2(4)*real(wt(t-1)) + a_2(5)*zt(t-1)
	end if

550	 continue

c      write (*,*) (t, s_t(t), sigma(t),t=1, nob) 
c	 pause


******** do t=nob & s_t(t) = 0.0d0 *****************************
 
c1033  t= nob

	 t= nob
       s_t(t) = 0.0d0   !fix s_t(t)=0.0d0

!!!!!!!!!!! calculate pr_0 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	
       
	  if ( s_t(t-1) .eq. 0.0d0 ) then   ! s_t(t-1)=0.0d0
              pr_0 = p_00
	  else								! s_t(t-1)=1.0d0
              pr_0 = (1-p_11)
        endif

********* calculate li_0     

	  sigma(t) = a_1(1)+a_1(2)*real(y(t-1))+a_1(3)*sigma(t-1)
    
     +  + a_1(4)*wt(t-1)+a_1(5)*zt(t-1)  
	  
c       likeli_0 =  real(y(t))*dlog(sigma(t)) - sigma(t)  

       likeli_0 = dlngam(y(t)+r11)-dlngam(r11)-dlngam(y(t)+1)
     +	      + r11*(dlog(1.0d0/(1+sigma(t))))
     +          + real(y(t))*dlog(sigma(t)/(1+sigma(t)))
       
	 li_0=dexp(likeli_0)

       prob_0=li_0*pr_0  ! when s_t(t)=0 we calculate Lik*(prior of st)

c       print*, 'r1',r1
c	  pause

c       write(*,*) t,'pr_0',pr_0
c       pause

************ ****** do t=nob & s_t(t) = 1.0d0 *****************************
	 
          t= nob
		s_t(t) = 1.0d0		! fix s_t(t)=1.0d0
             

!!!!!!!!!!! calculate pr_1 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	
     
            if ( s_t(t-1) .eq. 0.0d0 ) then       ! s_t(t-1)=0.0d0
              pr_1 = (1-p_00)       
	      else									! s_t(t-1)=1.0d0
              pr_1 = p_11 
            endif
     
c        write(*,*) t,'pr_1',pr_1
       
********* calculate li_1 

	  sigma(t) = a_2(1) + a_2(2)*real(y(t-1)) + a_2(3)*sigma(t-1)
     
     +		   + a_2(4)*wt(t-1) + a_2(5)*zt(t-1)

        likeli_1 = dlngam(y(t)+r11)-dlngam(r11)-dlngam(y(t)+1)
     +	       + r11*(dlog(1.0d0/(1+sigma(t))))
     +           + real(y(t))*dlog(sigma(t)/(1+sigma(t)))

	  li_1=dexp(likeli_1)

	  prob_1=li_1*pr_1  ! when s_t(t)=1 we calculate Lik*(prior of st)

c      write(*,*)  t,'li_0',li_0

********* calculate the conditional posterior probability of s_t(t) = 0.0d0 *************

        pp = prob_0 
        call rnopt(6)
        call drnun(1,u)
        pr=u*( prob_0 +prob_1 )
	  if ( pr <= pp ) then
	        s_tt(nob)=0.0d0
        else 
              s_tt(nob)=1.0d0
	  endif

******** update s_t(nob)

	  s_t(nob)=s_tt(nob)


******** do 1500 t=2,...,nob-1 & s_t(t) = 0.0d0 *****************************

	  do 1500 k=p(1)+3,nob-1
                t=nob+3-k     

          s_t(t) = 0.0d0   !fix s_t(t)=0.0d0

*********** calculate pr_0, that is (prior of st) ************************************
      
	  if ( s_t(t-1) .eq. 0.0d0 ) then   ! s_t(t-1)=0.0d0

*****************

        if ( s_t(t+1) .eq. 0.0d0 ) then   ! s_t(t+1)=0.0d0                   
	        pr_0 = p_00*p_00 		           
	  else								! s_t(t+1)=1.0d0
              pr_0 = (1-p_00)*p_00 
        endif

*****************
	  
	  elseif ( s_t(t-1) .eq. 1.0d0 ) then    ! s_t(t-1)=1.0d0

*****************

        if ( s_t(t+1) .eq. 0.0d0 ) then   ! s_t(t+1)=0.0d0
             pr_0 = p_00 *(1-p_11)  	
	  else								! s_t(t+1)=1.0d0
             pr_0 = (1-p_00)*(1-p_11) 
        endif  
       
	 endif

c       write(*,*) t,'pr_0',pr_0
c       pause

*********** endif calculate pr_0, that is (prior of st) *********************
*****************************************************************************

*********** calculate sigma, and likeli **********************************
         
	  sigma(t) = a_1(1)+a_1(2)*real(y(t-1)) + a_1(3)*sigma(t-1) + 
     
     +	  a_1(4)*wt(t-1) + a_1(5)*zt(t-1)

        likeli_0 = dlngam(y(t)+r11)-dlngam(r11)-dlngam(y(t)+1)
     +	       + r11*(dlog(1.0/(1.0+sigma(t))))
     +           + real(y(t))*dlog(sigma(t)/(1.0+sigma(t)))


*************** update a_t(t+1) & ht(t+1) by new s_t(t) 

       if ( s_t(t+1) .eq. 0.0d0 ) then
	  
	   sigma(t+1) = a_1(1) + a_1(2)*real(y(t)) + a_1(3)*sigma(t)

     +			  + a_1(4)*wt(t) + a_1(5)*zt(t)
     
       elseif ( s_t(t+1) .eq. 1.0d0 ) then
        
 	   sigma(t+1) = a_2(1) + a_2(2)*real(y(t)) + a_2(3)*sigma(t)
 
     +              + a_2(4)*wt(t) + a_2(5)*zt(t)        

	 endif

******************************************************************  
 
c       likeli_0=likeli_0+real(y(t+1))*dlog(sigma(t+1))- sigma(t+1)

       likeli_0 = likeli_0 + dlngam(y(t+1)+r11)-dlngam(y(t+1)+1)
     +	      - dlngam(r11) + r1*(dlog(1.0d0/(1+sigma(t+1))))
     +          + real(y(t+1))*dlog(sigma(t+1)/(1+sigma(t+1)))

          ! the likelihood function of t and t+1 

       li_0=dexp(likeli_0)  ! =dexp(0.912d0*likeli_0)
	 prob_0=li_0*pr_0   ! when s_t(t)=0 we calculate Lik*(prior of st)

c      write(*,*)  'likeli_0 ',likeli_0 ,'li_0',li_0  
c      pause
***********************************************************************   
******** t=2,...,nob-1 & s_t(t) = 1.0d0 *****************************
        
	 s_t(t) = 1.0d0      ! fix s_t(t)=1.0d0
	
************ calculate pr_1, that is (prior of st) ********************	
       
       if ( s_t(t-1) .eq. 0.0d0 ) then      ! s_t(t-1)=0.0d0

**********************
          if ( s_t(t+1) .eq. 0.0d0 ) then   ! s_t(t+1)=0.0d0
                pr_1 = (1-p_11)*(1-p_00) 
	      else							  ! s_t(t+1)=1.0d0
                pr_1 = p_11 *(1-p_00)  
          endif

************************	  
	 elseif ( s_t(t-1) .eq. 1.0d0 ) then    ! s_t(t-1)=1.0d0

************************

          if ( s_t(t+1) .eq. 0.0d0 ) then
                pr_1 = (1-p_11) *p_11  
	     else    ! s_t(t+1)=1.0d0  
	          pr_1 = p_11 *p_11  
          endif
        
       endif

c      write(*,*) t,'pr_1',pr_1
c	 pause
*********** endif calculate pr_1, that is (prior of st) ********************
******************************************************************************

*********** calculate sigma, and likeli

	   sigma(t)= a_2(1) + a_2(2)*real(y(t-1)) + a_2(3)*sigma(t-1) +
     
     +             a_2(4)*wt(t-1) + a_2(5)*zt(t-1)
     
        likeli_1 = dlngam(y(t)+r11)-dlngam(r11)-dlngam(y(t)+1)
     +	       + r11*(dlog(1.0d0/(1+sigma(t))))
     +           + real(y(t))*dlog(sigma(t)/(1+sigma(t)))


*************** update ht(t+1) by new s_t(t)  

        if ( s_t(t+1) .eq. 0.0d0 ) then

	 sigma(t+1) = a_1(1) + a_1(2)*real(y(t)) + a_1(3)*sigma(t)
     +            + a_1(4)*wt(t) + a_1(5)*zt(t)
   
        elseif ( s_t(t+1) .eq. 1.0d0 ) then
      
	 sigma(t+1) = a_2(1) + a_2(2)*real(y(t)) + a_2(3)*sigma(t) 
     +            + a_2(4)*wt(t) + a_2(5)*zt(t)
	 
	 endif
       
******************************************************************
    
        likeli_1 = likeli_1 + dlngam(y(t+1)+r11)-dlngam(y(t+1)+1)
     +	       - dlngam(r11) + r1*(dlog(1.0d0/(1+sigma(t+1))))
     +           + real(y(t+1))*dlog(sigma(t+1)/(1+sigma(t+1)))

         ! the likelihood function of t and t+1 

       li_1=dexp(likeli_1) 
       prob_1=li_1*pr_1  ! when s_t(t)=1 we calculate Lik*(prior of st)

c       write(*,*)  t,'likeli_1',likeli_1,'li_1',li_1

********* calculate the conditional posterior probability of s_t(t) = 0.0d0 *************
       
          pp = prob_0 
          call rnopt(6)
          call drnun(1,u)
	   pr=u*( prob_0 + prob_1 )
	      if ( pr <= pp ) then
	        s_tt(t)=0.0d0
            else 
              s_tt(t)=1.0d0
	      endif

********** update s_t(t) &  sig(t) 

	  s_t(t)=s_tt(t)

       if ( s_t(t) .eq. 0.0d0 ) then
	  
	    sigma(t)= a_1(1) + a_1(2)*real(y(t-1)) + a_1(3)*sigma(t-1)
  
     +              + a_1(4)*wt(t-1) + a_1(5)*zt(t-1)
	 else

	    sigma(t)= a_2(1) + a_2(2)*real(y(t-1)) + a_2(3)*sigma(t-1)
     
     +             + a_2(4)*wt(t-1) + a_2(5)*zt(t-1)
	 endif
       
1500   continue

!############################################################################################
*********** count the number of s_t(t)

       st_count(1)=0
 
        do t=npar(1)+1,nob
	  if ( s_t(t) .eq. 0.0d0 ) then
	    st_count(1)=st_count(1)+1  !count the number of s_t(t-1)=0
	  endif
	 enddo	  
	    st_count(2)=nob-npar(1)-st_count(1) !count the number of s_t(t-1)=1  
       
c          write (100,*) igb,'in pst_ no of each regime',st_count

c        if ( st_count(1) .le. 0.1*nob 
c     +   .or. st_count(2) .le. 0.1*nob ) goto 1033  !set st restriction

*********** count the number of s_t(t-1)

       jjcount(1)=0
       do t=npar(1)+1,nob
	  if ( s_t(t-1) .eq. 0.0d0 ) then
	    jjcount(1)=jjcount(1)+1   !count the number of s_t(t-1)=0
	  endif
	 enddo	  
	    jjcount(2)=nob-npar(1)-jjcount(1) !count the number of s_t(t-1)=1  
	  
*********** count the number of s_t(t)=0 and s_t(t-1)=0

       n0=0
      do t=npar(1)+1,nob
	  if ( s_t(t) .eq. 0.0d0 .and. s_t(t-1) .eq. 0.0d0 ) then
	    n0=n0+1	  
	  endif
	enddo
c      write (*,*) 'n0',n0

*********** count the number of s_t(t)=1 and s_t(t-1)=1

       n1=0
      do t=npar(1)+1,nob
	  if ( s_t(t) .eq. 1.0d0 .and. s_t(t-1) .eq. 1.0d0) then
	    n1=n1+1  
	  endif
	enddo
c      write (*,*) 'n1',n1
c	 pause
c      end subroutine

1033	return
	end
      
***********************************************************************
       subroutine med (ii,ino,tt,mu,md,std,p25,p975)
	  use msimsl
	  implicit none
	  
	  integer i,j,ino,k,ii
	  real*8  ss
	  real*8  sum,temp,tt(800,30000),mu,md,std,p25,p975,p1,p2
	  integer nmiss, nqprop
        real*8  q(100), xlo(100), xhi(100), qprop(100), par(30000)


! to calcilate the medians

	 do j=1,ino
          par(j)= tt(ii,j)
	 enddo
c       write(*,*) par(1:6)
        nqprop =3
	  
	  qprop(1) = 0.025d0
	  qprop(2) = 0.5d0      
	  qprop(3) = 0.975d0 
	  
	  call deqtil(ino,par,nqprop,qprop,q,xlo,xhi,nmiss)

		p25		= q(1)
		md		= q(2)
		p975	= q(3)
	
! to calculate the averages

	  sum=0.0d00
	  do k=1,ino
        sum=sum+tt(ii,k)
	  enddo
	  mu=sum/real(ino)

! to calculate the standard deviation

	  temp=0.0d0
	  do k=1,ino
        temp=temp+(tt(ii,k)**2)
	  enddo
	  ss=temp-real(ino)*(mu**2)
	  ss=ss/(real(ino))
	  if (ss <= 0.0d0 ) then
c	  write (1,*) 'std: NA ',ss
        std=0.0d0
	  else
	  std=sqrt(ss)
	  endif
c	 write (*,*) tt(ii)
c      pause

	  end subroutine med
       
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	 subroutine simu (pname,true)
	  use msimsl
	  implicit none
	 
	  real*8 mean1(5), var1(5),mean2(5),var2(5),true(25)
	  integer nn, m, ist, nmax, nob, i, ii, k

        parameter (nn=5,m=5)
        real*8 y(8800),at(8800),aa(10000),ht(10000),sig(8800)
     +         ,ae(10000),un_mean(2),un_var(2)
     +         ,wt(8800),zt(8800),aezt(8800),hzt(8800)
        integer t, icount(2),pw(2),a, x(8800)
        integer cnt(2),p(2),npar(2),w(8800),z(8800)
        character(10) pname(25)
        real*8 u,p_00,p_11,p_0,p_1,s_t(8800),ss_t(8800),s(8800)
	  real lambda,lamda,rh1,pt
	  real*8 mu1, mu_1
	  real*8 bb_1(8800)
        real*8 r1, r_1

        data rh1 /5.0d0/

        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
        common /exogenous/ pw,wt,zt


	  var1(1)= 0.3d0
	  var1(2)= 0.02d0
	  var1(3)= 0.5d0
        var1(4)= 0.03d0
        var1(5)= 0.05d0
	  var2(1)= 0.9d0
	  var2(2)= 0.03d0
	  var2(3)= 0.4d0
        var2(4)= 0.04d0
        var2(5)= 0.06d0

c	  un_var(1)=var1(1)/(1.0d0-var1(2)-var1(3)) 
c       un_var(2)=var2(1)/(1.0d0-var2(2)-var2(3)) 

        ss_t(1)= 0.0d0
 
        p_0		= 0.93d0
        p_1		= 0.89d0
        x(1)		= 1
    	  r_1       = 5.0d0
	  mu_1      = 4.0d0

	  un_var(1)=r_1*var1(1)/(1.0d0-r_1*var1(2)-var1(3)) 
        un_var(2)=r_1*var2(1)/(1.0d0-r_1*var2(2)-var2(3)) 

       write(*,*) 'un_var(1), un_var(2)', un_var(1),un_var(2)
c	 pause

************ write out real parameters to compare	     
	do ii=1,5

	 true(ii)=var1(ii)
	 true(ii+5)=var2(ii)
	
	end do
 
       true(11)=p_0
       true(12)=p_1
       true(13)=r_1
       true(14)=mu_1
       true(15)=un_var(1)
       true(16)=un_var(2)

	  write(2,*)'True values: ',' p_00  ',p_0,' p_11 ',p_1 
     +			, 'mu_1 ', mu_1 , 'r_1', r_1
	  write(2,*)'Var1 ',var1(1),var1(2),var1(3),var1(4),var1(5)
	  write(2,*)'Var2 ',var2(1),var2(2),var2(3),var2(4),var2(5)
        write(2,*)'un_var ',un_var(1),un_var(2)
        write(2,*)

	pname(1)='alpha1_0'
	pname(2)='alpha1_1'
	pname(3)='beta1_1'
	pname(4)='gamma1_1'
	pname(5)='gamma1_2'	
	pname(6)='alpha2_0'
	pname(7)='alpha2_1'
	pname(8)='beta2_1'
	pname(9)='gamma2_1'
	pname(10)='gamma2_1'
	pname(11)='p_00'
	pname(12)='p_11' 
      pname(13)='r1' 
      pname(14)='mu1' 
	pname(15)='un_var1' 
      pname(16)='un_var2' 


***************************************************
*********** simulate s_t as one set true value
        ist=1
	  icount(1)=0
	  icount(2)=0
        nmax=nob+100	! the first 100 observations will be discarded,nmax =800
 
       
       do i=2, nmax

	  call rnopt(6)

	  call drnun(1,u)

	if ( ss_t(i-1) .eq. 0.0d0 ) then
	   if ( u <= p_0 ) then

	     ss_t(i) = 0.0d0
	   else
	     ss_t(i) = 1.0d0    
	   end if
      else if ( ss_t(i-1) .eq. 1.0d0 ) then
         if ( u <= p_1 ) then

	     ss_t(i) = 1.0d0
	   else
	     ss_t(i) = 0.0d0    
	   end if
      end if

      enddo

************** To set dummy (season) varibles ***********

c      do i=1, nmax
	
c	 if (mod(i,12) .eq. 6.0d0 
c     +   .or. mod(i,12) .eq. 7.0d0 
c     +	.or. mod(i,12) .eq. 8.0d0
c     +	.or. mod(i,12) .eq. 9.0d0) then 

c			wt(i)=1.0d0
c	 else
c			wt(i)=0.0d0
c	 endif
	 
c       enddo
 	
c   	 write (*,*) (wt(i), i=1,nmax)
c	 pause

**************** To random an exogenous variable from normal distribution

       call drnnor(nmax, bb_1(1:nmax))

	 w=int(bb_1+20)
	 z=int(bb_1+5)

c   	 write (*,*) (i, w(i), z(i), i=1, nmax)
c	 pause

********************************************************

       call rnopt(6)

         do i=2, nmax

          if ( ss_t(i) .eq. 0.0d0 ) then

		  ht(i)= var1(1) + var1(2)*x(i-1) + var1(3)*ht(i-1)
     +		   + var1(4)*w(i-1) + var1(5)*z(i-1)

	      pt = 1/(1+ht(i))

	   call rnnbn(1,rh1,pt,x(i))

       else

		ht(i)= var2(1) + var2(2)*x(i-1) + var2(3)*ht(i-1)
     +         + var2(4)*w(i-1) + var2(5)*z(i-1) 
         
            pt = 1/(1+ht(i))
     
	   call rnnbn(1,rh1,pt,x(i))
	
          endif

        enddo

c	 write(*,*) (i,lambda,ht(i),x(i),i=1,nmax)
c	 pause

	  write(*,*)'h(1) is   ', ht(100) 
	  write(2,*)'h(1) is   ', ht(100)

        do i=101, nmax
          y(i-100)=x(i)
          wt(i-100)=w(i)
          zt(i-100)=z(i)
		s(i-100)=ss_t(i)    ! skip the first 100 observations
        enddo

      do t=1, nob
c       write (99,109) y(t)
c109   format (1(f10.1,1x))

c       write (1,*) t, y(t), s(t)
       write (1,105) t, y(t), wt(t), zt(t), s(t)
105   format (I4, 3(f10.1,1x))

	enddo

*********** count the number of s(t)

	  do t=1,nob
	  if ( s(t) .eq. 0.0d0 ) then
	    icount(1)=icount(1)+1 !count the number of s(t)=0
	  else
	    icount(2)=icount(2)+1 !count the number of s(t)=1
	  endif
	  enddo
	    write (*,*) 'no of each regime',icount
	    write (2,*) 'no of each regime',icount
c         pause
        return
        end

*****************************************************************************

**  Compute h(t)

	  subroutine sigma(a_1,a_2,r1,mu1,p_00,p_11)
	  use msimsl
	  implicit none
	  
	  real*8  svar, ay(-100:8800), sum, mu1
	  integer m, n, nob, i,lag
	  real*8  r1

        parameter (n=5,m=5)
        real*8 y(8800),at(8800),sig(8800),s_t(8800),s_tt(8800),wt(8800)
	  real*8 ph1(n),ph2(m),a_1(5),a_2(5),p_00,p_11,zt(8800)
        integer t
        integer cnt(2),p(2),npar(2),pw(2),w(8800)

        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
        common /exogenous/ pw,wt,zt
	  common /meanvar/ svar
	  common /ay/ ay
      
	  if (cnt(1)*cnt(2).eq.0) then
	    write(*,*)'warning: zero intercepts  '
	    stop
        endif

********* Set-up

	    sig(3)= mu1

***	ay(t)= y(t), t=1,...,nob   and  ay(t)=0 for t<1	

c       call pst (a_1,a_2,r1,mu1,p_00,p_11) ! generate s_t  

	do t=4, nob

	 if( s_t(t) .eq. 0.0d0 ) then

	   sig(t) = a_1(1) + a_1(2)*real(y(t-1))+ a_1(3)*sig(t-1)
     +          + a_1(4)*wt(t-1) + a_1(5)*zt(t-1)
	else

	   sig(t) = a_2(1) + a_2(2)*real(y(t-1)) + a_2(3)*sig(t-1)
     +		  + a_2(4)*wt(t-1) + a_2(5)*zt(t-1)

c		if (sig(t) .lt.  0.0d0  ) then
c		 write (*,*) t, ' th  h_t is less than 0 '
c	  endif

 	end if
 
	end do

c      write(*,*) (t, pt(t), sig(t), t=1, nob)
c	 pause

  	return
 	end
	 
*****************************************************************************************
	 subroutine loglik (a_1,a_2,lik,r1,mu1,p_00,p_11)
	  use msimsl
	  implicit none

	  integer k,t,p(2),lagd,nob,n,m,cnt(2),npar(2),pw(2)
	  parameter (n=3,m=3)   
	  real*8 lik, ymean,zt(8800)
        real*8 y(8800),at(8800),sig(8800),a_1(5),a_2(5),s_t(8800)
        real*8 ph1(n),ph2(m),s_tt(8800),p_00,p_11,mu1,wt(8800)
        real*8 r1


        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
        common /exogenous/ pw,wt,zt


********** assume that cnt(1)=cnt(2)=1 in calculating the loglikelihood, i.e.
********** we have intercepts in the model

********** Do the checking
	

	if (cnt(1)*cnt(2).eq.0) then

	  write(*,*)'problems detected in the likelihood evaluation'
      endif

	lik = 0.0d0
      

	call sigma(a_1,a_2,r1,mu1,p_00,p_11)
      
c	 print*, 'r1',r1
c	 pause

	do 100 t=4, nob
	 
c       lik = lik  + real(y(t))*(dlog(sig(t))) - sig(t)

c        lik = lik + y(t)*dlog(sig(t))-(r1+y(t))*(dlog(1.0d0+sig(t)))
c     +      + dlngam(y(t)+r1)-dlngam(r1)-dlngam(y(t)+1)

       lik = lik + dlngam(y(t)+r1)-dlngam(y(t)+1)-dlngam(r1)
     +	  + r1*(dlog(1.0d0/(1+sig(t))))
     +      + real(y(t))*dlog(sig(t)/(1+sig(t)))

100	continue

c      write(*,*) 'lik',lik
c	 pause

	return
	end
      

**********************************************************************************************
	 subroutine garch1 (a_1,a_2,r1,mu1,p_00,p_11)
	  use msimsl
	  implicit none
	  integer  n, m, i, nob, igb, mgb
	  
	  real*8   step0, step1, step0a, step1a,
     *	  mean1(5), mean2(5), var1(5,5), var2(5,5),
     *	  lognor1, lognor2, svar
        parameter (n=5,m=5)
        real*8 y(8800),at(8800),sig(8800),s_t(8800),s_tt(8800)
	  real*8 ph1(n),ph2(m),a_1(5),a_2(5), p_00, p_11, mu1
	  real*8 ta_1(5),b_1(5),tb_1(5),bb_1(5),lik1,lik2,prob1(1),prob2
	  real*8 rsig1(5,5),rsig2(5,5),con,constant1,wt(8800),zt(8800) 
        integer pw(2)
        integer cnt(2),p(2),npar(2)
	  integer iacpt1
        real*8  r1

        common /obs/ y,sig,s_t
        common /exogenous/ pw,wt,zt 
	  common /order/ cnt,p,npar
        common /index/ nob
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	  common /accept1/ iacpt1
      
	  common /stepsize/ step0, step1, step0a, step1a
	  common /mcmc/ igb, mgb
        common /meanvar/ svar
	  common /con/ con              !alpha0~U(0,con*svar)


c        constant1=con*svar
c        write(100,*) 'the range of alpha1_0 ',constant1

	lik1 = 0.0d0
	lik2 = 0.0d0
       
        call loglik (a_1,a_2,lik1,r1,mu1,p_00,p_11) !f(alpha^[i-1])
		
100	  call rnopt(6)


******** We perform independent MH using normal kernel after the burn-in iterations
********** The mean & covariance are determined from the MCMC iterates in the burn-in iterations
	
	  if (igb.gt.mgb) then         ! var 1-8000
      	    
		call drnmvn (1,5,rsig1,5,bb_1,1)
	
		do i=1,5

c			 b_1(i)= mean1(i) + bb_1(i)
 			 b_1(i)= mean1(i) + bb_1(i)*0.4d0
 
	    enddo
	 
	    call mnden(5,mean1,var1,a_1,lognor1) !g(alpha^[i-1])
	    call mnden(5,mean1,var1,b_1,lognor2) !g(alpha^*)
	   
	    prob2 = lognor1 - lognor2

	  else

	    call drnnor(5,bb_1)


	    b_1(1)= a_1(1) + bb_1(1)*step0 
	    b_1(2)= a_1(2) + bb_1(2)*step1
	    b_1(3)= a_1(3) + bb_1(3)*step1
          b_1(4)= a_1(4) + bb_1(4)*step1
          b_1(5)= a_1(5) + bb_1(5)*step1
	
		prob2= 0.0d0
			
	  endif
       
                    
	  if ( b_1(1) .le. 0.0d0 
     +  .or. b_1(1) .ge. con*svar   
     +  .or. b_1(2) .le. 0.0d0 
     +  .or. b_1(3) .le. 0.0d0 
c     +  .or. b_1(2)+b_1(3) .ge. 1.0d0
     +  .or. r1*b_1(2)+b_1(3) .ge. 1.0d0
     +  .or. (r1*b_1(2)**2.0 + (r1*b_1(2)+b_1(3))**2.0) .ge. 1.0d0 
     +  .or. b_1(4) .lt. 0.0d0 
     +  .or. b_1(5) .lt. 0.0d0 ) goto 100 

c      print*, 'r1', r1
c	 pause

        call  loglik (b_1,a_2,lik2,r1,mu1,p_00,p_11) !f(alpha^*)
	
		
	  prob2= prob2 + lik2 - lik1
	  
	  call drnun(1,prob1)

	  if ( prob2 > dlog(prob1(1)) ) then
	
	    iacpt1= iacpt1 + 1

	    do i=1,5
	      a_1(i)= b_1(i)
	    enddo
	
	  endif

*******  update h(t)

		call  sigma(a_1,a_2,r1,mu1,p_00,p_11)

1000	return
      
	end

***************************************************************************************
	 subroutine garch2 (a_1,a_2,r1,mu1,p_00,p_11)
	  use msimsl
	  implicit none
	 
	  integer  n, m, i, nob, igb, mgb
	  real*8   step0, step1, step0a, step1a,
     *	  mean1(5), mean2(5), var1(5,5), var2(5,5),
     *	  lognor1, lognor2, svar
        parameter (n=5,m=5)
        real*8 y(8800),at(8800),sig(8800),s_t(8800),s_tt(8800),wt(8800)
	  real*8 ph1(n),ph2(m),a_1(5),a_2(5), p_00, p_11, mu1
	  real*8 ta_2(5),b_2(5),tb_2(5),bb_2(5),lik1,lik2,prob1(1),prob2
	  real*8 rsig1(5,5),rsig2(5,5),con,constant2,zt(8800)
        integer pw(2)
        integer cnt(2),p(2),npar(2)
	  integer iacpt2
	  real*8  r1

        common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	  common /accept2/ iacpt2
        common /exogenous/ pw,wt,zt
	  
	  common /stepsize/ step0, step1, step0a, step1a
	  common /mcmc/ igb, mgb
        common /meanvar/ svar	
        common /con/ con              !alpha0~U(0,con*svar)


c        constant2=con*svar
c        write(100,*) 'the range of alpha2_0 ',constant2


	lik1= 0.0d0
	lik2= 0.0d0

	  call  loglik (a_1,a_2,lik1,r1,mu1,p_00,p_11) !f(alpha^[i-1])
	  
 101    call rnopt(6)
       

******** We perform independent MH using normal kernel after the burn-in iterations
********** The mean & covariance are determined from the MCMC iterates in the burn-in iterations

	  if (igb.gt.mgb) then

	    call drnmvn (1,5,rsig2,5,bb_2,1)

		do i=1,5

c	       b_2(i)= mean2(i) + bb_2(i)
	       b_2(i)= mean2(i) + bb_2(i)*0.4d0 

	    enddo

	    call mnden(5,mean2,var2,a_2,lognor1) !g(alpha^[i-1])
	    call mnden(5,mean2,var2,b_2,lognor2) !g(alpha^*)
	   
	    prob2= lognor1 - lognor2

	  else

	    call drnnor(5,bb_2)

	    b_2(1)= a_2(1) + bb_2(1)*step0a
	    b_2(2)= a_2(2) + bb_2(2)*step1a
	    b_2(3)= a_2(3) + bb_2(3)*step1a
	    b_2(4)= a_2(4) + bb_2(4)*step1a
	    b_2(5)= a_2(5) + bb_2(5)*step1a

	    prob2= 0.0d0

	  endif
	  
		 
	  if ( b_2(1) .le. 0.0d0 
     +  .or. b_2(1) .ge. con*svar   
     +  .or. b_2(2) .le. 0.0d0      
     +  .or. b_2(3) .le. 0.0d0 
c     +  .or. b_2(2) + b_2(3) .ge. 1.0d0
     +  .or. r1*b_2(2) + b_2(3) .ge. 1.0d0
     +  .or. (r1*b_2(2)**2.0 + (r1*b_2(2) + b_2(3))**2.0) .ge. 1.0d0 
     +  .or. b_2(4) .lt. 0.0d0  
     +  .or. b_2(5) .lt. 0.0d0 ) goto 101 


c       write(169,*) 'mean volatility..1..',a_1(1) /( 1 -a_1(2) -a_1(3) )
c       write(169,*) 'mean volatility..2..',b_2(1) /( 1 -b_2(2) -b_2(3) )

c       if ( a_1(1) / ( 1 -a_1(2) -a_1(3) ) 
c     +  .le. b_2(1) / ( 1 -b_2(2) -b_2(3) ) ) goto 101
        
c       if ( a_1(1) .le. b_2(1) ) goto 101

	  call  loglik (a_1,b_2,lik2,r1,mu1,p_00,p_11) !f(alpha^*)

	  prob2= prob2 + lik2 - lik1

	  call drnun(1,prob1)

	  if ( prob2 > dlog(prob1(1)) ) then

	    iacpt2=iacpt2+1

	    do i=1,5
	      a_2(i)=b_2(i)
		enddo

	  endif


******* update h(t)

	  call  sigma(a_1,a_2,r1,mu1,p_00,p_11)

1000	return
	end

**************************************************************************
************ draw lambda_1 
  
       subroutine drawmu1 (a_1,a_2,r1,mu1,p_00,p_11)

        implicit none
        integer n, m, acceptmu1, cnt(2), p(2), npar(2), 
     *              nob,igb,mgb,t
        real*8 a_1(5), a_2(5), lik1, lik2
	  real*8 stepmu1
        parameter (n=5, m=5)
        real*8 ph1(n), ph2(m), p_00, p_11
        real*8 prob(1), prob2, aa
        real*8 ga_a, ga_b, mu1, mu1_2, wt(8800), zt(8800)
	  real*8 y(8800),at(8800), sig(8800),s_t(8800)
        integer pw(2)
	  real*8  r1

	  common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
	  common /stepsize/ stepmu1
	  common /mcmc/ igb, mgb
	  common /accept3/ acceptmu1
        common /exogenous/ pw,wt,zt

         data ga_a, ga_b/5.0d0, 1.0d0/


	lik1 = 0.0d0
	lik2 = 0.0d0

         call loglik (a_1,a_2,lik1,r1,mu1,p_00,p_11)

c	print*,"mu1",mu1
c	pause
			
			lik1= lik1 + (ga_a - 1.0d0)*dlog(mu1)-(ga_b*mu1)
  
 200     call rnopt (6)
         call drnnor (1,aa)    
		    
			mu1_2 = mu1 + aa* stepmu1

		if ( mu1_2 .le. 0.0d0 ) goto 200

!	print*,"mu1_2",mu1_2
!	pause
       
         call loglik (a_1,a_2,lik2,r1,mu1_2,p_00,p_11)
	
			lik2= lik2 + (ga_a -1.0d0)*dlog(mu1_2)-(ga_b*mu1_2)
                 
			prob2= lik2 - lik1
!	print*,"prob2",prob2
!	pause
     
          call rnopt (6)
		call drnun (1,prob)

			prob(1)=dlog(prob(1))
!	print*,"prob(1)",prob(1)
!	pause

          if ( prob2 .gt. prob(1) ) then
       
	      mu1= mu1_2

            acceptmu1 = acceptmu1 + 1
          
		endif  
	
	
c		  write(*,*) 'drawmu1', mu1
        return
        end

**************************************************************************
*********** draw r_1 
  
       subroutine drawr1 (a_1,a_2,r1,mu1,p_00,p_11)

        implicit none
        integer n, m, naccept, cnt(2), p(2), npar(2), 
     *              nob,igb,mgb,t
        real*8 a_1(5), a_2(5), lik1, lik2, mu1
	  real*8 stepch
        parameter (n=5, m=5)
        real*8 ph1(n), ph2(m), p_00, p_11
        real*8 prob(1), prob2, aa, wt(8800), zt(8800)
        real*8 ga_a1, ga_b1
	  real*8 y(8800),at(8800), sig(8800),s_t(8800)
        integer pw(2)
        real*8  r1, r1_2

	  common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
        common /index/ nob
	  common /mcmc/ igb, mgb
        common /exogenous/ pw,wt,zt
	  common /blk10/ naccept
	  common /blk11/ stepch 

	  

         data ga_a1, ga_b1/10.0d0, 1.0d0/

	lik1 = 0.0d0
	lik2 = 0.0d0

         call loglik (a_1,a_2,lik1,r1,mu1,p_00,p_11)

c	 print*,"r1",r1
c	 pause
		
	  lik1= lik1 + (ga_a1 - 1.0d0)*(dlog(r1))-(ga_b1*r1)
  
 201     call rnopt (6)
         call drnnor (1,aa)    
		    
			r1_2 = r1 + aa* stepch

		if ( r1_2 .lt. 1.0d0 ) goto 201

c	write(*,*) r1_2
c	pause
       
         call loglik (a_1,a_2,lik2,r1_2,mu1,p_00,p_11)
	
			lik2 = lik2 + (ga_a1 -1.0d0)*(dlog(r1_2))-(ga_b1*r1_2)
                 
			prob2 = lik2 - lik1

c	write(*,*) prob2
c	pause
     
          call rnopt (6)
		call drnun (1,prob)

			prob(1)=dlog(prob(1))

!	print*,"prob(1)",prob(1)
!	pause

          if ( prob2 .gt. prob(1) ) then
       
	      r1 = r1_2

            naccept = naccept + 1
          
		endif  

c		  write(*,*) 'drawr1', r1

        return
        end


*********************************************************************************
	! We choose a multivariate normal distribution for a_1 (a_2)
	! the multivariate proposal density with covariance var1 (var2)
      ! subroutine  delta(th_v)
	! integer :: t,n_1,n_2 
*********************************************************************************		

	 subroutine s_cov(no, b_1, mgb)

	  implicit none
	  integer  no, i, j, irank, lag, k, mgb
	  real*8   mean1(5),mean2(5),var2(5,5),var(5,5),TOL

	  integer t
	  integer cnt(2),p(2),npar(2),pw(2)
	  integer nob

	  real*8  b_1(30000,5),sum1(5),sum2(5),ss(5),ave(5)
        real*8  var1(5,5),rsig1(5,5),rsig2(5,5),wt(8800),zt(8800)
	  real*8  y(8800),at(8800),sig(8800),s_t(8800),amach  


  	  common /obs/ y,sig,s_t
        common /order/ cnt,p,npar
	  common /index/ nob
        common /exogenous/ pw,wt,zt
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	

	  var=0.0d0
	  sum1=0.0d0
	  sum2=0.0d0


       do t =1, mgb
	   do k=1,5
	    sum1(k)=sum1(k)+b_1(t,k)
	    sum2(k)=sum2(k)+b_1(t,k)**2
	   enddo
	 enddo

	 do k=1,5
	   ave(k)=sum1(k)/real(mgb)
	   ss(k)=sum2(k)-((sum1(k)**2) /real(mgb))
	 enddo

	 do i=1,5
	  do j=1,5
	    do t=1, mgb
		   var(i,j)=var(i,j)+(b_1(t,i)-ave(i))*(b_1(t,j)-ave(j))
	    enddo
	  enddo
	 enddo
	
	 do i=1,5
	   do j=1,5
c	  	  var(i,j)=var(i,j)/((ss(i)*ss(j))**0.5) ! this is for corr. matrix
	      var(i,j)=var(i,j)/real(mgb)  ! this is for covariance matrix
	  enddo
	 enddo

	 if (no .eq. 1) then
		
	    do i=1,5
	      mean1(i)= ave(i)
          enddo
	    do i=1,5
	      do j=1,5
	        var1(i,j)=var(i,j)
            enddo
	    enddo
		TOL = 100.0*AMACH(4)
	
		call  dchfac (5,var1,5,1.0d-5,irank,rsig1,5)

	    write(2,*)
		write(2,*)'Normal independent kernels determined from burn-in'
		write(2,*)
	    write(2,39) mean1(1),mean1(2),mean1(3),mean1(4),mean1(5)
	    write(2,40) var1(1,1),var1(1,2),var1(1,3),var1(1,4),var1(1,5)
	    write(2,40) var1(2,1),var1(2,2),var1(2,3),var1(2,4),var1(2,5)
	    write(2,40) var1(3,1),var1(3,2),var1(3,3),var1(3,4),var1(3,5)
          write(2,40) var1(4,1),var1(4,2),var1(4,3),var1(4,4),var1(4,5)
	    write(2,40) var1(5,1),var1(5,2),var1(5,3),var1(5,4),var1(5,5)

39	    format('mean1  ',5f10.6)
40	    format('var1  ',5f10.6)

	 else

	    do i=1,5
	      mean2(i)= ave(i)
          enddo
	    do i=1,5
	      do j=1,5
	        var2(i,j)=var(i,j)
            enddo
	   
	    enddo
	    TOL = 100.0*AMACH(4)

	 	call  dchfac (5,var2,5,1.0d-5,irank,rsig2,5)   

	    write(2,139) mean2(1),mean2(2),mean2(3),mean2(4),mean2(5)
	    write(2,140) var2(1,1),var2(1,2),var2(1,3),var2(1,4),var2(1,5)
	    write(2,140) var2(2,1),var2(2,2),var2(2,3),var2(2,4),var2(2,5)
	    write(2,140) var2(3,1),var2(3,2),var2(3,3),var2(3,4),var2(3,5)
          write(2,140) var2(4,1),var2(4,2),var2(4,3),var2(4,4),var2(4,5)
          write(2,140) var2(5,1),var2(5,2),var2(5,3),var2(5,4),var2(5,5)

139	    format('mean2  ',5f10.6)
140	    format('var2  ',5f10.6)

	 endif

	 return
	 end

!	  *****************************************************************
*       N1 = NO. OF OBSERVATIONS      
*       N2 = NO. OF PARAMETERS INCLUDING THE INTERCEPTS
*       X(No1,No2) - DESIGN MATRIX
*       Y(No1) - VECTOR OF OBSERVATIONS FOR THE DEP. VAR.
*       R(No2) - VECTOR OF LS ESTIMATES
*       WXTX(No2,No2) - X'X
*       ERROR - ESTIMATE OF THE ERROR VARIANCE

	 subroutine OLSE (No1,No2,N1,N2,X,Y,R,WXTX,xwm,mat,error)
	 integer*4 I, J, K, N1, N2
c      integer*4 L, No
	real*8 X(No1,No2),Y(No1),WXTX(No2,No2),XWM(No2,No1),R(No2),
     *         MAT(No2,No2),error

*
*       FIND X'X
*

	do 90 K=1, N2
	  do 90 I=1, N2
	     WXTX(K,I)= 0.0
	     do 90 J=1, N1
		WXTX(K,I)= WXTX(K,I) + X(J,K)*X(J,I)
90      continue
c       PRINT *,WXTX(1,1),WXTX(1,2),WXTX(2,1),WXTX(2,2)
*
*       FIND INVERSE OF X'X
*

	call DLINRG(N2,WXTX,N2,MAT,N2)

*
*       FIND OLSE
*

	do 120 I=1 ,N2
	  do 120 J=1, N1
	     XWM(I,J)= 0.0d0
	     do 120 K=1, N2
		XWM(I,J)= XWM(I,J) + MAT(I,K)*X(J,K)
120     continue

	do 130 I=1, N2
	  R(I)= 0.0d0
	  do 130 K=1, N1
		R(I)= R(I) + XWM(I,K)*Y(K)
130     continue

	temp1= 0.0d0
	do 140 i=1, n1
	  temp2= 0.0d0
	  do 150 j=1, n2
	    temp2= temp2 + x(i,j)*r(j)
150       continue
	  temp1= temp1 + (y(i)-temp2)**2
140     continue
	error= temp1/(n1-n2)

	return
	end



******* This is used to compute the log of multivariate normal density
******* -.5*(x-mu)'Sigma^{-1}(x-mu)

	subroutine mnden(dim, mean, var, x, logden)

	implicit none
	integer  i, dim
	real*8   mean(5), var(5,5), logden, x(5), diff(5), dblinf, 
     *		varinv(5,5)

	external dblinf

	do i=1, dim
	  diff(i)= x(i) - mean(i)
	enddo

	call dlinrg(dim, var, dim, varinv, dim)

	logden= dblinf(dim, dim, varinv, dim, diff, diff)

	logden= -.5d0*logden
 
	return
	end
**********************************************************************************************


