cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c       Simulation study. Bayesian Analysis of Threshold NB INGRCH models							 
c       based on arranged autoregression													    	
c  **   Assume threshold lag (d) is unkonwn!!													 
c       the Gibbs sampler are run for n iterations,												 
c       but only use the last m iterations for making inferences							 
c       Modified date                                    8.11.2018              
c       Using M-H algorithm                                                                         
c       d is unknown !!!                           
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
        program main
	  use msimsl
	  use dfport   ! for PC Fortran Version 6.5
c	  use portlib  ! for PC Fortran Version 5 
	  implicit none

	  integer nn, mm, lag, nosim, i, j, k, igb, ngb, jj, isi,
     *		  iacpt3, ii, ind, lagd, ino, nob, mgb, iseed, item,f,iino
	  real*8  temp,lagdd(8800),lagdt(3)
	  real*8 y(8800), xx(500,8800),w(8800)
        
	  real*8 sig(8800)
	  real*8 ssig(800,30000),ssig2(800,30000),sig_md(1000),
     + sig_m(1000),sig_low(1000),sig_up(1000),sig2_m(1000),res(8800)
        real*8 at(8800),z(8800),wt(8800),ztt(8800),resid(8800)
	  real abd,bbd
        real th_v,dth_v, temp_a(5)
	  real*8 dlik,de,deta,da_1(5),dbarlik,DIC(6),da_2(5)
	  real*8 tt(800,30000),est(30,5),mu,md,std,p25,p975
	  real*8 emean(30,1000),emedian(30,1000),esd(30,1000)
        real*8 eest(8800,30,5),fest(30,5)
 	  real*8 a_1(5),a_2(5)
	  real*8 aa_1(30000,5),aa_2(30000,5)
        integer d,idx(8800),th_no,icount(800),dcount(5),dicount(20)
        integer cnt(2),p(2),t,npar(2),ir
	  integer iacpt1,iacpt2
	  integer jcount(2),kcount(2)
	  integer*4  No1, No2
	  parameter(No1= 8800, No2=5)
    	  real*8 design_mat(No1,No2), resp(No1), 
     *		WXTX(No2,No2),XWM(No2,No1),R(No2),
     *          MAT(No2,No2),error
	 real*8 ss1,ss2,shead
	 real*8 var1(5),var2(5),realv(20),cov(20)
       character(10) name(20)
	 integer d_max,d_mass
	 real*8  estmd(100,100),delta
	 real  mode, count, currentcount
	 real*8 sum1,sum2,sum3,sum4,w1(8800),w2(8800)
	 real*8 wmean,wvar,zmean,zvar


        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx
	  common /quartile/ abd,bbd
	  common /accept1/ iacpt1
	  common /accept2/ iacpt2
        common /count/ jcount
	  common /par/ var1,var2,th_v
	  common /var/ realv
	  common /exogenous/ wt,ztt


******** Defined by Mike

	  integer naccept
	  real*8  svar, smean, ay(-100:8800), step0, step1, step0a, 
     *		  step1a, h1, steph1, stepch, step_d
	  real*8  zt(-100:8800)	
	  character(9) now, today

	  common /meanvar/ svar
	  common /ay/ ay
	  common /stepsize/ step0, step1, step0a, step1a
	  common /mcmc/ igb, mgb
	  common /accept3/ iacpt3
	  common /h1/ steph1
	  common /blk10/ naccept
	  common /blk11/ stepch
        common /blk12/ step_d
	  common /threshold/ zt		! zt is the threshold variable

        real*8  stepmu1
	  integer acceptmu1, iac_del
        common /mu1_inf/ acceptmu1
        common /mu1_inf2/ stepmu1
        common /ac_del/ iac_del



************* For DIC 
	       
        real*8 DIC_1, DIC_2, lik1, lik2

****************Defined xt Q1 and Q3
       real*8 qprob(3), xtq1q3(3), xlo, xhi
	 integer nmiss	

******************************define by Edward
	 real*8 ww(30000,2)
	 INTEGER IEXP(15), IPF(13), IPW(13), NOUT, NPF
	 INTEGER randomseed,seedm(8800)
**********************************************

        data cnt(1),cnt(2),p(1),p(2),d,lag /1,1,1,1,1,3/
	  data iacpt1,iacpt2 /0,0/

c	de=0.0d0
c	da_1=0.0d0
c	da_2=0.0d0		        
c	dth_v=0.0
	  

        do k=1,2
          npar(k)=5	! # of mean parameters in regime k
        enddo
		! number of weight variables

ccccccccccccccccccc
        ir=p(1)
ccccccccccccccccccc

c       open (1,file='simu.txt')
        open (2,file='si2.txt')
c       open (3,file='si3.txt')
	  open (4,file='gibbs.txt')
	  open (5,file='sig_TNB.txt')
	  open (10,file='maxval.txt')
	  open (11,file='si4.txt')
	  open (17,file='est_final.txt')
	  open (23,file='tacp100note.txt')
c	  open (25,file='th_v_est.txt')
c	  open (36,file='mode_th_v.txt')
c       open (38,file='data_sim.txt')
	  open (40,file='DIC.txt')

************** Determine the current date & time

	  call date_and_time(today)
	  now= clock()

	  write(2,*)'Date and time  ',today,'   ',now
c      pause

************** Real data

	 open (111,file='DS2.txt')

******************
       sum1 = 0.0d0
	 sum2 = 0.0d0
       sum3 = 0.0d0
	 sum4 = 0.0d0

	 do t=1,612
	 read(111,*,end=2007)  y(t), wt(t), ztt(t)
	 nob= t

******************

	 sum1=sum1 + wt(t)
	 sum2=sum2 + wt(t)**2    
	 sum3=sum3 + ztt(t)
	 sum4=sum4 + ztt(t)**2    

	 enddo
2007	 continue
	 close(111)  
	
c	 write (*,*) (y(t), wt(t), ztt(t), t=1,20)
c	 pause 
********************************************************
 
       wmean =  sum1/real(nob)
	 wvar  = (sum2-(sum1**2)/real(nob))/real(nob-1)
       zmean =  sum3/real(nob)
	 zvar  = (sum4-(sum3**2)/real(nob))/real(nob-1)

	  write (*,*) 'wmean, wvar',wmean,wvar
	  write (*,*) 'zmean, zvar',zmean,zvar


*************** To transformation for railfall and temp. 

       do t=1, nob

	 wt(t)  = abs(wt(t)-wmean)/sqrt(wvar)
	 ztt(t) = abs(ztt(t)-zmean)/sqrt(zvar)

       enddo 

c       write (*,*) (t, wt(t), y(t), t=1,nob)
c       pause


************** sample size, no. of iterations, stepsize 

	 nosim=1

c	 nob=700		! no. of samples         
       ngb=30000		! no. of iterations 
	 mgb=8000		! no. of burn-in iterations

****************  Setting the value of the seed

c       iseed= 70368760954879  !!
        iseed= 57845906768499   
c       iseed= 57377299759199  !! 
c       iseed= 57729739751771   
c       iseed= 51798713776703  !
	  
	  call rnopt(6)
	  call rnset(iseed)
	  write(*,*)'The seed is  ',iseed
	  write(2,*)'The seed is  ',iseed

************** some information to file 1

	 write(2,*)'Note a modification in subroutine med'

c	 write(2,*)'The maximum sample size is 2000'
	 write(2,*)'The maximum delay is   ',lag

	 write(2,*)'No. of iterations & burn-in   ',ngb,mgb
	 write(2,*)'No. of observations  ',nob

***********  (nosim) data sets are generated
 
       cov = 0.0d0

       do 1000 isi=1, nosim

**************************************************
	  data a_1 /0.1d0, 0.1d0, 0.1d0, 0.1d0, 0.1d0/  
	  data a_2 /0.1d0, 0.1d0, 0.1d0, 0.1d0, 0.1d0/
        data delta/2.0d0/

c        h1=(y(1)+y(2))/2
         h1=y(2)
        
	  lagd=1
	  iacpt1=0
	  iacpt2=0
	  naccept=0
        acceptmu1=0
        iac_del=0

	  icount=0
	  dcount=0

	  DIC_1=0.0d0
	  DIC_2=0.0d0
 
*************************************************************************  all var parameter
	  step0=0.02d0	! step sizes for regime 1 garch parameters
	  step1=0.02d0
	  step0a=0.02d0	! step sizes for regime 2 garch parameters
	  step1a=0.02d0

	  stepch= 1.4d0	! step size for r	
	  step_d= 1.2d0
	  steph1= 1.0
        stepmu1=1.0d0

********************************************************************************
************** some information to file 2

	write(*,*)'parameter star a1',a_1(1:5),'all parameter a2',a_2(1:5)
	if (isi .eq. 1) then
	 write(2,*)'The stepsizes in the Metropolis step:  '
	 write(2,*)'Step0, step1, step0a, step1a ',step0,step1,step0a
     *			 ,step1a,' for eta  ',stepch, 'for delta  ',step_d
	 write(2,*)
	endif

******************************************
	write(2,34)
34	format(65('-'))
	write(2,*)'Iteration  ',isi
	write(2,*)

	  call date_and_time(today)
	  now= clock()
	  write(2,*)'Date and time  ',today,'   ',now
	
******* simulate the data
c       pause

c288	   call simu	
******** calculate the xt Q1 and Q3
      data qprob /0.20d0 , 0.5d0, 0.80d0 /
c************* fortran ثO*********************

	CALL DEQTIL(nob, y(1:nob), 3, qprob, xtq1q3, xlo, xhi, nmiss)
	write (*,*) 'qunatile of yt',xtq1q3
c     CALL DEQTIL(nob, xt(1:nob), 2, qprob, xtq1q3, xlo, xhi, nmiss)
               !ƦCino,ttƦC,QnD3Ӧʤ,ʤƤOqprop
	         !NXʤƭȦsbxemp,NXʤƤUɦsbxlo
	         !NXʤƤWɦsbxhi,Nmiss valueӼƦsbnmiss

	write (*,*) 'qunatile of xt',xtq1q3

        abd=xtq1q3(1)
        bbd=xtq1q3(3)
	  th_v=xtq1q3(2)
        
c       if ( realv(7) .lt. abd .or. realv(7) .gt. bbd) goto 288
******* initialize the threshold variable   !leon close

	  do t=1, nob
	    zt(t)= y(t)
	  enddo

	  do t= -100, 0
	    zt(t)= 0.0d0		! Define zt(t)
        enddo

****************************************
        
c	write (*,*) '# of simulation',isi
c	write (2,*) '# of simulation',isi
c ----- d is a threshold lag
c ----- Thr: location of a threshold
c        initial value for d = 1
	 
******** calculate the sample mean and variance

	  do t= -100, 0
	    ay(t)= 0.0d0		! Define ay(t)
        enddo

		ss1=0.0d0
	    ss2=0.0d0
	  do t=1, nob
	    ay(t)= y(t)			! Define ay(t)
	    ss1= ss1 + real(y(t))
	    ss2= ss2 + real(y(t))**2.0d0
	  enddo

	  smean= ss1/real(nob)
*******************************************************************************************************************************
	  svar= (ss2-(ss1**2)/real(nob))/real(nob-1)
*******************************************************************************************
	  write (*,*)'smean,svar', smean,svar

c       svar=smean

******** initial guess 
	  write (*,*) 'sample mean and variance  ',smean,svar
	  write (2,*) 'sample mean and variance  ',smean,svar

        step0= step0
	  step0= step0*svar*0.01
	  step0a= step0a*svar*0.01
	  steph1= steph1

	  write(*,*)'Revising the stepsizes for alpha0 assss ',
     *	step0,step0a,'   h1',steph1
	  write(2,*)'Revising the stepsizes for alpha0 assss ',
     *	step0,step0a,'   h1',steph1

********* choose 25th and 75th percentile for uniform prior
	      				  
	 th_no=0

	  write(*,*) 'min', minval(y),'max',maxval(y)
c	  pause
        write (10, 388)   minval(y),maxval(y)
 388    format (1x, 2(f8.1,1x))
	  write (*,*) 'Q1= ',abd, ' Q3= ',bbd
    	  write (*,*) 'initial guess th_v  ', th_v 
	  write (*,*) 'max lag',lag
	  write (*,*) 'Initial guess delay', lagd 
	  write (2,*)
	  write (2,*) 'min=',minval(y), '  max=',maxval(y)
	  write (2,*) 'Q1= ',abd, ' Q3= ',bbd
    	  write (2,*) 'initial guess th_v  ', th_v 
	  write (2,*) 'max lag',lag

	

***************************************************************
	ino= 0
	iino=0		! count the number of iterations after burn-in

**************************************************************
   
	do 888 igb=1,ngb	! Start the MCMC


	 call chpoint  (a_1,a_2,th_v,lagd,h1,delta)
	 call garch1   (a_1,a_2,th_v,lagd,h1,delta)
	 call garch2   (a_1,a_2,th_v,lagd,h1,delta)
	 call delay    (a_1,a_2,th_v,lagd,h1,delta)
       call drawmu1  (a_1,a_2,th_v,lagd,h1,delta)
       call prob     (a_1,a_2,th_v,lagd,h1,delta)


106	format(9(f10.4,1x),i3)

       if (igb .gt. mgb) then   
	do i=1,1
c	 if( isi .eq. i) then 

c	write (3,113) a_1(1),a_1(2),a_1(3),a_1(4),a_1(5),a_2(1),a_2(2)
c     ,	         ,a_2(3),a_2(4),a_2(5),th_v,lagd,delta
c	 endif
	enddo
	endif
113   format (1x,15(f10.4,1x))

      if ( mod(igb,1000) .eq. 0 )  then   !print/1000

	write(*,34)  
	print *,isi,' run ', igb, ' iteration'

	write(*,91)'garch1  ',a_1
	write(*,91)'accept. rate ',100.0d0*iacpt1/igb
	write(*,*)
	write(*,91)'garch2  ',a_2
	write(*,91)'accept. rate ',100.0d0*iacpt2/igb
	write(*,*)
      write(*,91)'th_v   ',th_v
	write(*,91) 'accept. rate ',100.0d0*naccept/igb
      write(*,91)'delta ', delta
	write(*,91)'accept. rate  ',100.0d0*iac_del/igb
      write(*,91)'mu1 ',h1
	write(*,91)'accept. rate  ',100.0d0*acceptmu1/igb
	write(*,*) 'delay', lagd
	write(*,*) 
	write(*,91)'umean_1', delta*a_1(1)/(1.0d0 - delta*a_1(2) - a_1(3))
	write(*,91)'umean_2', delta*a_2(1)/(1.0d0 - delta*a_2(2) - a_2(3))
	write(*,*)

 91	format (1x,a14,1x,10(f8.4,1x))


	endif
		

************* Revise the step size size of garch1 and garch2 after 1000 iteration

        if (igb.eq.2000) then

        write(6,*)'Revise the step size of garch1 and garch2 here'
        write(2,*)'Revise the step size of garch1 and garch2 here'


	 sum2= 1.0d0*iacpt1/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       step1= dexp(log(step1) + sum1/1.0d0)
	 step0= step1

        write(6,*)'The new step size of garch1 is  ',step1
        write(2,*)'The new step size of garch1 is  ',step1

       sum2= 1.0d0*iacpt2/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       step1a= dexp(log(step1a) + sum1/1.0d0)
	 step0a= step1a
	
       write(6,*)'The new step size of garch2 is  ',step1a
       write(2,*)'The new step size of garch2 is  ',step1a

       sum2= 1.0d0*naccept/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       stepch= dexp(dlog(stepch) + sum1/1.0d0)
        write(6,*)'The new step size of r is  ',stepch
        write(2,*)'The new step size of r is  ',stepch

       sum2= 1.0d0*acceptmu1/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       stepmu1= dexp(dlog(stepmu1) + sum1/1.0d0)
        write(6,*)'The new step size of mu1 is  ',stepmu1
        write(2,*)'The new step size of mu1 is  ',stepmu1

       sum2= 1.0d0*iac_del/igb
       sum1= dlog(sum2/(1.0d0-sum2)) - dlog(.4d0/.6d0)

       step_d= dexp(dlog(step_d) + sum1/1.0d0)
        write(6,*)'The new step size of delta is  ',step_d
        write(2,*)'The new step size of delta is  ',step_d

        endif

	
*************** Calculate the sample covariance after the burn-in iterations
********** This is used to carry out the MH step using independent normal kernel.

	if ( (igb.gt.1000).and.(igb .le. mgb) ) then
	
	  do i=1,5

		aa_1(igb-1000,i)=a_1(i)
		aa_2(igb-1000,i)=a_2(i)

	  enddo

	  if (igb .eq. mgb) then	    
	    call s_cov(1, aa_1, mgb-1000)
	    call s_cov(2, aa_2, mgb-1000)
		write(2,*)'burn-in acceptance rate  '
	    write(2,*)igb,' garch1: accept. rate ',100.0d0*iacpt1/igb
	    write(2,*)igb,' garch2: accept. rate ',100.0d0*iacpt2/igb
c	    pause
	  endif
      endif
        
	        
**************** Analyze the results after the burn-in iterations

      if ( (igb > mgb) .and. mod(igb,5) .eq. 0) then

       do i=1,lag
        if ( lagd .eq. i) then
          dcount(i)=dcount(i)+1
        endif
        enddo

**************** To calculate DIC
 
       call loglik (a_1,a_2,th_v,lagd,h1,lik1,delta )    

	 DIC_1=DIC_1+lik1

	 ino=ino+1   ! count the number of iterations after burn-in

               
	do i=1,npar(1)
	   tt(i,ino)=a_1(i)
	enddo
	
	do i=1,npar(2)
	   tt(npar(1)+i,ino)=a_2(i)
	enddo

		 tt(npar(1)+npar(2)+1,ino)=th_v
		 tt(npar(1)+npar(2)+2,ino)=lagd
	     tt(npar(1)+npar(2)+3,ino)=delta
  	     tt(npar(1)+npar(2)+4,ino)= h1

c		tt(15,ino)= delta*a_1(1)/(1.0d0 - delta*a_1(2) - a_1(3))
c      	tt(16,ino)= delta*a_2(1)/(1.0d0 - delta*a_2(2) - a_2(3))

	call sigma(a_1,a_2,th_v,lagd,h1,delta)

        do t=lag,nob
		ssig(t,ino)=delta*sig(t)
		ssig2(t,ino)=delta*sig(t)*(1+sig(t))
	  enddo

	
	if ( isi .eq. 1 ) then
	write (4,103) (tt(i,ino),i=1,14)
103   format (1x,12(f10.4,1x))
	endif

      endif
 	
888   continue

	
*************************  end of igb
        
      write(2,*)
      write(2,*)'th_v   ','  accept. rate ',100.0d0*naccept/igb
	write(2,*)'garch1  ',' accept. rate ',100.0d0*iacpt1/igb
	write(2,*)'garch2  ',' accept. rate ',100.0d0*iacpt2/igb
	write(2,*)
	write(2,*)'mu1   ',' accept. rate ',100.0d0*acceptmu1/igb
	write(2,*)'delta   ',' accept. rate ',100.0d0*iac_del/igb

c	pause

	  do ii=1,14
	    call med(ii,ino,tt,mu,md,std,p25,p975,mode)
c	pause

		est(ii,1)=mu
		est(ii,2)=md
		est(ii,3)=std
		est(ii,4)=p25
		est(ii,5)=p975


          if (realv(ii) .ge. est(ii,4) .and.
     +   realv(ii) .le. est(ii,5) ) cov(ii)=cov(ii)+1.0
          enddo

         do t=lag+1,nob

	    call med2(t,ino,ssig,mu,md,std,p25,p975)
		sig_m(t)=mu
	    sig_md(t)=md
		sig_low(t)=p25
		sig_up(t)=p975	   

c	   res(t)=(y(t)-sig_m(t))/(sig_m(t)*(1+sig(t)))**0.5

	   call med2(t,ino,ssig2,mu,md,std,p25,p975)
	   sig2_m(t)=mu
	   res(t)=(y(t)-sig_m(t))/(sig2_m(t))**0.5

	  end do 

c       	write(*,*) sig_m(2), sig_low(2), sig_up(2)	
c         pause
******************To put in estimates ***********

	do 112 i=1,npar(1)
	 a_1(i)=est(i,1)	
       a_2(i)=est(npar(1)+i,1)

112	continue

	th_v=est(npar(1)+npar(2)+1,1)
	lagd=est(npar(1)+npar(2)+2,1)
	delta=est(npar(1)+npar(2)+3,1)
	H1=est(npar(1)+npar(2)+4,1)
	
c	 call sigma(a_1,a_2,th_v,lagd,h1 )    

c	    do t=1,nob
c	     call med2(t,ino,ssig,mu,md,std,p25,p975)
c		sig_m(t)=mu
c		sig_low(t)=p25
c		sig_up(t)=p975
c	    end do 
c	 pause

***************** For DIC

       call loglik (a_1,a_2,th_v,lagd,h1,lik2,delta )    
	   DIC_2=2.0d0*(-2.0d0*DIC_1)/(ino)-(-2.0d0*lik2)
       write (2,*) 'DIC = ', DIC_2
       write (*,*) 'DIC = ', DIC_2
       write (2,*) 'loglik = ', lik2
       write (*,*) 'loglik = ', lik2
	 write (40,*) DIC_2 , lik2

************ write out real*8 parameters to compare

	name(1)='alpha1_0'
	name(2)='alpha1_1'
	name(3)='beta1_1'
	name(4)='gamma1_1'
	name(5)='gamma1_2'
	name(6)='alpha2_0'
	name(7)='alpha2_1'
	name(8)='beta2_1'
	name(9)='gamma2_1'
	name(10)='gamma2_2'
	name(11)='th_v'
	name(12)='delay'
      name(13)='delta'
	name(14)='mu1'

c	name(15)='umean_1'
c	name(16)='umean_2'  
c	name(12)='w_bar_2' 
c	name(13)='lagd'
***************************************************
        write (*,*) isi, 'run'
	  do ii=1,14

	    write (2,1112) name(ii),realv(ii),(est(ii,k),k=1,5),cov(ii)
	    write (*,1112) name(ii),realv(ii),(est(ii,k),k=1,5),cov(ii)

 1112	format (1x,a10,1x,15(f10.4,1x))

	  enddo

c        write(25,*)(est(7,1))

******************To given posterior means to parameters***********
	do 1111 i=1,npar(1)
	 a_1(i)=est(i,1)	
	 a_2(i)=est(npar(1)+i,1)
1111	continue

	th_v=est(npar(1)+npar(2)+1,1)
	lagd=est(npar(1)+npar(2)+2,1)
      delta=est(npar(1)+npar(2)+3,1) 

	d_max=dcount(1)
	d_mass=1
	do k=2,lag
	if ( dcount(k) .gt. d_max ) then
	d_max=dcount(k)
	d_mass=k
	endif
	enddo
	lagd=d_mass	


	do t=1,nob
	write(5,103) y(t),sig_low(t),sig_m(t),sig_up(t),res(t)
	enddo

104   format (i4,1x,4(f10.4,1x))


c	do t=nob-5,nob
c	write(*,104)   y(t), sig_low(t), sig_m(t), sig_up(t)
c	enddo
c
c	if ( isi .eq. 1 ) then
c	do i=lag+1,nob
c	write (5,103) y(i),sig(i),ay(i)/sig(i)
c	enddo
c	endif
*******************************************************************
        write (2,*)
	  write (2,*)'counts for each delay  '
	  write (*,*)'counts for each delay  '
        write (2,102) (dcount(k),k=1,lag)
	  write (*,102) (dcount(k),k=1,lag)
	  write (*,*)
102     format(1x,5(i6,1x))


	write(11,111) ((est(j,i),i=1,5),j=1,14)
111   format (70(f10.4,1x))
ccc	pause

**************save the est************0407

	do j=1,5
	 do i=1,14
	eest(isi,i,j)=est(i,j)

	enddo
c	eest(isi,npar(1)+npar(2)+3,j)=est(9,j)
c	eest(isi,npar(1)+npar(2)+4,j)=est(10,j)
c	eest(isi,npar(1)+npar(2)+5,j)=est(11,j)

	enddo

	do i=1,14
	emean(i,isi)=eest(isi,i,1)
	emedian(i,isi)=eest(isi,i,2)
	esd(i,isi)=eest(isi,i,3)
	enddo

	lagdd=0.0d0
	lagdd(isi)=lagd

C	do i=1,lag
C	if (lagdd(isi) .eq. i) then
C	dicount(i)=dicount(i)+1
C	endif
C	enddo

******************************************
1000    continue

**************************LCӲժdata****************************
	
	 do i=1,isi-1
	 write(23,106) (eest(i,j,2), j=1,14)
	 enddo
	
c	eest(i,1,2),eest(i,2,2),eest(i,3,2),eest(i,4,2),
!    *eest(i,5,2),eest(i,6,2),eest(i,7,2),eest(i,8,2),eest(i,9,2)
	
**********************************************************************

c	mse=sqrt(mse)/real*8(nofor)
c	write (2,*) 'MSE=   ',mse

******************compute the mean of est.********0407

	do i=1,14
	 do j=1,5
	  do isi=1,nosim

	fest(i,j)=fest(i,j)+eest(isi,i,j)

	  enddo
	 enddo
	enddo
	
	do i=1,14
	 do j=1,5

	fest(i,j)=fest(i,j)/real(nosim)
	
	 enddo
	enddo

	 write(*,*)'-----------------------------------------'
	 write(2,*)'-----------------------------------------'       


	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c	write(*,118)  '  ','True value','Estm','S.D.m','25%','97.5%'
c     +,'Est_median','Mean.md','Median.md','SD.md'

	write(17,118)  ' ','True value','Mean ','Median','Std Dev'
     +,'25%','97.5%', 'coverage'
 
 118	format (1x,16(a10,1x))

          write(*,*) '  '
          write(*,*) 'Summary Stat'
	    write(2,119) 'Summary Stat'

	write(2,120)'parameters','true','mean','md','std','p25','p975'
     +	,'Coverage'
   	write(*,120)'parameters','true','mean','md','std','p25','p975'
     +	,'Coverage' 

	  do ii=1,14
        cov(ii)=cov(ii)/real(nosim)
          write (2,*)
	    write (2,*)
          write (2,119) name(ii),realv(ii),(fest(ii,k),k=1,5),cov(ii)
	    write (17,119) name(ii),realv(ii),(fest(ii,k),k=1,5),cov(ii)
	    write (*,119)  name(ii),realv(ii),(fest(ii,k),k=1,5),cov(ii)
 	  enddo
 119	format (1x,a10,1x,15(f10.4,1x))
 120 	format(1x,a10,1x,a10,1x,15(a10,1x))  		


*********************************************************************	

	  call date_and_time(today)
	  now= clock()
	  write(2,*)'Date and time  ',today,'   ',now

      stop
      end

*********************************************************************
       subroutine chpoint (a_1,a_2,th_v,lagd,h1,delta)
	  implicit none
	  integer n, m, lag,lagd, naccept, nob ,th_v1
	  integer d
	  real*8  a_1(5), a_2(5), h1, lik1, lik2, stepch
	  real*8 y(8800),sig(8800),wt(8800),ztt(8800)
        parameter (n=5,m=5)
        real*8 at(8800),delta
	  real abd,bbd

        real*8 z(2,n+m),aa(1)
        real*8 sum1,sum2,ss(2),prob(1),prob2
        real th_1,th_2 ,th_v
        real*8 sm(2)
	  
        integer  cnt(2),p(2),t,npar(2),idx(8800),th_no
	  
	  common /obs/ y,at,d,lag,sig
        common /index/ nob,idx
        common /quartile/ abd,bbd
	  common /blk10/ naccept
	  common /blk11/ stepch
 	  common /exogenous/ wt,ztt

	  real*8	df

	  integer  count
	  real*8  zt(-100:8800)
	  common /threshold/ zt		! zt is the threshold variable


c	write(*,*)stepch

	  th_1=th_v

2	call rnopt (6)
      call drnnor (1,aa)
c	call drnstt (1,15,aa)
c	  write(*,*)th_v
c	pause
c       write(*,*)aa(1)
	 aa(1)=aa(1)*stepch
	 th_2=th_1+aa(1)
	
c	  write(*,*) aa(1)
c	pause
	
c	write(*,*) th_1, th_2 ,aa(1)

	if (int(th_2) .lt. int(abd) .or. int(th_2) .gt. int(bbd) ) goto 2


        call loglik (a_1,a_2,th_1,lagd,h1,lik1,delta )  !leon th_1 to th_2
	
        call loglik (a_1,a_2,th_2,lagd,h1,lik2,delta )
	
c         write(*,*) th_v
c	pause
	       
        prob2= lik2 - lik1
	
	
	  call rnopt (6)
        call drnun (1,prob)
	  prob(1)=dlog(prob(1))

	 if ( prob2 .gt. prob(1) ) then

	   th_v= int(th_2)
	 
	   naccept= naccept + 1
	
	 endif

  
200	  return
        end subroutine chpoint

!!******************************************************************
		subroutine med (ii,ino,tt,mu,md,std,p25,p975,mode)
		 integer  i,j,ino,k,ii
		real*8  ss
		real*8  sum,temp,tt(800,30000),mu,md,std,p25,p975,p1,p2
 	    real    mode,count,currentcount
	    integer  ffmode(20000),ttemp

	  integer  nmiss, nqprop,iino
	  real*8   q(100), xlo(100), xhi(100), qprop(100), par(30000)
	
c       pause
	
	  do j=1, ino
	    par(j)= tt(ii,j)
	  enddo
c	write(*,*)par(1:6)
	  nqprop= 3

	  qprop(1)= 0.025d0
	  qprop(2)= 0.5d0
	  qprop(3)= 0.975d0

	  call deqtil(ino,par,nqprop,qprop,q,xlo,xhi,nmiss)
	
	  p25  = q(1)
	  md   = q(2)
	  p975 = q(3)
c	pause


! to calculate the averages

	  sum=0.0d00
	  do k=1,ino
      sum=sum+tt(ii,k)
	  enddo
	  mu=sum/real(ino)
c	pause

! to calculate the standard deviation

	  temp=0.0d0
	  do k=1,ino
      temp=temp+(tt(ii,k)**2)
	  enddo
	  ss=temp-real(ino)*(mu**2)
	  ss=ss/(real(ino))
	  if (ss <= 0.0d0 ) then
c	  write (1,*) 'std: NA ',ss
	  std=0.0d0
	  else
	  std=sqrt(ss)
	  endif
c	write(*,*)tt(ii)
c	pause


*********!caculate  mode**************************
c	write(*,*) ino
c	pause
      if (ii==11 .or. ii==12) then
	do j=1,ino
	ffmode(j)=INT(tt(ii,j))
	enddo
	endif
c	write(*,*) ino
c	pause
	
      do i=1,ino-1  !!make order for draw mode
	do j=1,ino-1
	if (ffmode(j) > ffmode(j+1)) then
	ttemp=ffmode(j)
	ffmode(j)=ffmode(j+1)
	ffmode(j+1)=ttemp
	endif
	enddo
	enddo
c	pause
c      write(*,*)ffmode
c	pause
      iino=ino
      mode=ffmode(1)
	count=1
	currentcount=1
c		write(*,*) mode
c	pause
	
	do i= 2,iino
	if (ffmode(i)==ffmode(i-1)) then 
	currentcount=currentcount+1
	else
	if (currentcount > count) then
	count=currentcount
	mode=ffmode(i-1)
	endif
	currentcount=1
	endif
	enddo
	if (currentcount > count) then
	mode=ffmode(iino)
	endif   !end draw the mode of y

	if (ii==11 .or. ii==12) then 
	mu=real(mode)
	md=real(mode)
c     write(36,*) mode
c	write(*,*) 'mode', mode
       endif


c	  return
	  end subroutine med

!!******************************************************************
		subroutine med2 (ii,ino,tt,mu,md,std,p25,p975)
		 integer  i,j,ino,k,ii
		real*8  ss
		real*8 sum,temp,tt(800,30000),mu,md,std,p25,p975,p1,p2
	    real ttemp

	  integer  nmiss, nqprop,iino
	  real*8   q(100), xlo(100), xhi(100), qprop(100), par(30000)
	
c       pause
	
	  do j=1, ino
	    par(j)= tt(ii,j)
	  enddo
c	write(*,*)par(1:6)
	  nqprop= 3

	  qprop(1)= 0.025d0
	  qprop(2)= 0.5d0
	  qprop(3)= 0.975d0

	  call deqtil(ino,par,nqprop,qprop,q,xlo,xhi,nmiss)
	
	  p25= q(1)
	  md= q(2)
	  p975= q(3)
c	pause


! to calculate the averages

	  sum=0.0d00
	  do k=1,ino
      sum=sum+tt(ii,k)
	  enddo
	  mu=sum/real(ino)
c	pause

! to calculate the standard deviation

	  temp=0.0d0
	  do k=1,ino
      temp=temp+(tt(ii,k)**2)
	  enddo
	  ss=temp-real(ino)*(mu**2)
	  ss=ss/(real(ino-1))
	  if (ss <= 0.0d0 ) then
c	  write (1,*) 'std: NA ',ss
	  std=0.0d0
	  else
	  std=sqrt(ss)
	  endif
c	write(*,*)tt(ii)
c	pause

	  end subroutine med2
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	  subroutine simu 
	  implicit none
	  real*8 mean1(3), var1(3), mean2(3), var2(3), realv(20) 
	  real*8 zt(-100:8800)
	  real*8 sig(8800)
	  integer  lag,lagd, n, m, ist, nmax, i, nob,x(10000)
     *	       ,zit(10,8800)
	  real th_v
        real*8 y(8800),at(880),aa(10000),eta,ht(10000)
		real lamda
 
        real*8  bb(10000),ee(10000),dd(10000)

        integer t,d, idx(8800),icount(2)
        integer cnt(2),p(2),npar(2)
        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx

	  real*8  df,temp
	  real*8  rh(10000), rt(10000)		! for generating an exogenous variable


	  integer ccount(800)

	  common /threshold/ zt		! zt is the threshold variable
	  common /thre_var/ zit		! zit compose the threshold variable
	  common /par/ var1,var2,th_v 
	  common /var/ realv

       
        var1(1)= 0.9d0  !leon
	  var1(2)= 0.2d0
	  var1(3)= 0.4d0
	  var2(1)= 2.2d0
	  var2(2)= 0.3d0
	  var2(3)= 0.5d0

        th_v=4.0d0  
	  lagd= 1

c	  write(2,*)'True values: ',' lagd  ',lagd,' th_v  ',th_v

c	  write(2,*)'Var1 ',var1(1),var1(2),var1(3)
c	  write(2,*)'Var2 ',var2(1),var2(2),var2(3)
*************true value*********************************************

	realv(1)= var1(1)
	realv(2)= var1(2)
	realv(3)= var1(3)
	realv(4)= var2(1)
	realv(5)= var2(2)
	realv(6)= var2(3)
	realv(7)= th_v
	realv(8)= lagd
	realv(10)= var1(1)/(1.0-var1(2)-var1(3))
	realv(11)= var2(1)/(1.0-var2(2)-var2(3))
********************************************************************
        ist=3
	  icount(1)=0
	  icount(2)=0
        nmax=nob+100	! the first 50 observations will be discarded

         
********************************************************************
      call rnopt(6)
	do i=1,ist
		ht(i)= var1(1) / (1.0d0 - var1(2) - var1(3)) 	
		lamda=ht(i)
c		write(*,*) 'ht(i)', lamda
c		pause											
		call rnpoi(1,lamda,x(i))
          

	  enddo

      do i=ist+1,nmax

	if ( x(i-lagd) .le. int(th_v) ) then

	    ht(i)= var1(1) + var1(2)*x(i-1) + var1(3)*ht(i-1)
		lamda=ht(i)
													
		call rnpoi(1,lamda,x(i))

	     ccount(i)=1

      else

		ht(i)= var2(1) + var2(2)*x(i-1) + var2(3)*ht(i-1)
	    lamda=ht(i)											
		call rnpoi(1,lamda,x(i))

	   ccount(i)=2

          endif
		
	  enddo


	realv(9)=x(100)

      do i=101, nmax
          y(i-100)= x(i)    ! skip the first 1000 observations  !leon
c	    zit(1,i-1000)= x(i)
c	    zit(2,i-1000)= x(i)
c		zt(i-1000)= x(i)
	write(22,*) i-100, y(i-100), ccount(i-100)
c	write(*,*) y(i-100)
c	pause
        enddo
      
	 do t=1, nob
	write(38,105) y(t)
105   format (1(f10.1, 1x))
	enddo

	  do t=1, nob
	  if ( y(t) .le. th_v ) then
	    icount(1)=icount(1)+1
	  else
	    icount(2)=icount(2)+1
	  endif
	  enddo
	    write (*,*) 'no of each regime',icount
c	    write (22,*) 'no of each regime',icount
c	  pause

        return
        end subroutine simu
!*****************************************************************************

**  Compute h(t)

	  subroutine sigma(a_1,a_2,th_v,lagd,h1,delta)
	  implicit none
	  integer   m, n, nob, i, lag ,t,d, idx(8800),lagd
	  integer cnt(2),p(2),npar(2)
	  parameter (n=5,m=5)
	  real th_v
        real*8 y(8800),a_1(5),a_2(5) ,delta
	  real*8 sig(8800), h1,at(8800),zt(-100:8800)
        real*8 svar, ay(-100:8800), sum, wt(8800),ztt(8800)

        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx

	  common /meanvar/ svar
	  common /ay/ ay
	  common /threshold/ zt		! zt is the threshold variable
	  common /exogenous/ wt,ztt

     
      sig(lag)=int(h1)
			   

	do t=lag+1, nob
	 	
	 if ( zt(t-lagd) .le.  int(th_v)) then 

	 sig(t) = a_1(1)+a_1(2)*real(y(t-1))+a_1(3)*sig(t-1)
     +         +a_1(4)*real(wt(t-1))+a_1(5)*ztt(t-1)	         
	else
	 
	 sig(t) = a_2(1)+a_2(2)*real(y(t-1))+a_2(3)*sig(t-1)
     +         +a_2(4)*real(wt(t-1))+a_2(5)*ztt(t-1)	         


	end if

	end do

  	return
 	end subroutine sigma

******************************************************************

	 subroutine delay (a_1,a_2,th_v,lagd,h1,delta)
	  implicit none
	  real*8  h1

	  integer k,m,n,ldir,id,lag,nob
	  integer i, cnt(2),p(2),npar(2),lagd,d,idx(8800)

        parameter (k=4,n=5,m=5,ldir=1)
        real*8 y(8800),at(8800),sig(8800)
        real*8 a_1(5),a_2(5),delta
	  real*8 prob(k)

        real*8 tot,sm(4)
	  real th_v
        common /obs/ y,at,d,lag,sig

        common /order/ cnt,p,npar
        common /index/ nob,idx
        
        real*8	lik, pr(0:100),genu(1),likmax,aloglik(100)
	  real*8 sum
        lag=3
     	
	 likmax=-1.0d10
	do 17 id=1, lag
	  call loglik (a_1,a_2,th_v,id,h1,lik,delta) ! compute the loglik for
	  aloglik(id)= lik	
	  						      ! lagd= id
c	write(36,*)id,aloglik(id)

	  if (aloglik(id).gt.likmax) then
	    likmax= aloglik(id)
	  endif
17	continue

	tot= 0.0d0
	do 20 id=1, lag
	  sm(id)= dexp(aloglik(id)-likmax)
	  tot= tot + sm(id)
20	continue
***************lag for d1=3/6,d2=2/6,d1=3/6****start********
	do 27 id=1, lag
	  prob(id)= sm(id)/tot
	sum=sum+id
27	continue	  	    

	do 28 id=1,lag
	prob(id)=prob(id)*(lag-id+1)/sum
28	continue 
***************lag for d1=3/6,d2=2/6,d1=3/6****end*********
c	write (*,*) 'prob ',prob

      call drnun(1,genu)
	
      pr(0)= 0.0d0		! pr()= cumulative probability
	do 123 id=1, lag
	  pr(id)= pr(id-1) + prob(id)
123	continue

*	 draw from multinomial distribution

	do 1237 id=1, lag
	  if (genu(1).le.pr(id)) then
	    lagd= id
		d= id
		goto 1231
	  endif
1237	continue

1231	return 
	end
*****************************************************************************************

	subroutine loglik (a_1,a_2,th_v,lagd,h1,lik,delta)
	  implicit none
	  real*8   h1,tt,kk,dlngam
	  real*8  lyt,sig(8800),lik,fa,delta
	  real*8 y(8800),at(8800),a_1(5),a_2(5),zt(-100:8800)
	  real th_v 
	  integer  k,t,p(2),lagd,nob,lag,d,n,m,cnt(2),npar(2),idx(8800)
	  integer px(2),i
	  parameter  (n=5,m=5)   
	  real*8 ymean,wt(8800),ztt(8800)
                
        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx
	  common /threshold/ zt		! zt is the threshold variable
	  common /exogenous/ wt,ztt
		 

	  real*8   mean(8800)

	  integer   indt
	  common /blk32/ indt

			
	lik= 0.0

	
	call sigma(a_1,a_2,th_v,lagd,h1,delta)

          sig(lag)=int(h1)

	  do 107 t=lag+1, nob

c	    lik= lik + real(y(t))*(dlog(sig(t)))-sig(t)-dlngam(y(t)+1)

       lik = lik + dlngam(y(t)+delta)-dlngam(delta)-dlngam(y(t)+1)
     +	 + delta*(dlog(1.0/(1+sig(t))))
     +     + real(y(t))*dlog(sig(t)/(1+sig(t)))

107	  continue

	return
	
	end subroutine loglik

**********************************************************************************************

	  subroutine garch1 (a_1,a_2,th_v,lagd,h1,delta)
	  implicit none
	  integer  n, m, i, nob, lag, igb, mgb
	  real*8   step0, step1, step0a, step1a, 
     *	  mean1(5), mean2(5), var1(5,5), var2(5,5),
     *	  lognor1, lognor2, h1 
                                   
        parameter (n=5,m=5)
	   
	  real th_v
        real*8 y(8800),at(8800),sig(8800),zsig(8800),us(8800)
	  real*8 a_1(5),a_2(5)
	  real*8 ta_1(5),b_1(5),tb_1(5),bb_1(5),lik1,lik2,prob1(1),prob2
	  real*8 rsig1(5,5),rsig2(5,5),wt(8800),ztt(8800),delta
	  real*8 svar
        integer d, idx(8800),lagd
        integer cnt(2),p(2),npar(2)
	  integer iacpt1

        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	  common /accept1/ iacpt1
	  common /exogenous/ wt,ztt


	  common /stepsize/ step0, step1, step0a, step1a
	  common /mcmc/ igb, mgb
	  
	  common /meanvar/ svar	

	  real*8	df
	

        call  loglik (a_1,a_2,th_v,lagd,h1,lik1,delta)

	
100	  call rnopt(6)


******** We perform independent MH using normal kernel after the burn-in iterations
********** The mean & covariance are determined from the MCMC iterates in the burn-in iterations

	  if (igb.gt.mgb) then

		call drnmvn (1,5,rsig1,5,bb_1,1)  !var 1-8000

		do i=1,5
c	      b_1(i)= mean1(i) + bb_1(i)
	      b_1(i)= mean1(i) + bb_1(i)*0.5d0

	    enddo

	    call mnden(5,mean1,var1,a_1,lognor1)
	    call mnden(5,mean1,var1,b_1,lognor2)
	   
	    prob2= lognor1 - lognor2

	  else 
!!!!!!!!!!!!!!!!!random walk MH!!!!!!!!!!!!!!!!!!!!!!!
c	write(*,*) 'in garch1-3'
	    call drnnor(5,bb_1)
!	write(*,*)' garch-3 a1',a_1(1:3),'all parameter a2',a_2(1:3)
	    b_1(1)= a_1(1) + bb_1(1)*step0
	    b_1(2)= a_1(2) + bb_1(2)*step1
	    b_1(3)= a_1(3) + bb_1(3)*step1
	    b_1(4)= a_1(4) + bb_1(4)*step1
	    b_1(5)= a_1(5) + bb_1(5)*step1
	
		prob2= 0.0d0
c		write(*,*) 'in garch1-4'
	  endif
	

c	  if (b_1(1) .le. 0.0d0 .or. b_1(1) .gt. 2.0*svar !0.5*svar
c     +	  .or. b_1(2) .le. 0.0d0 
c     +  .or. b_1(3) .le. 0.0d0 .or. b_1(2)+b_1(3) .ge. 1.0d0 !) goto 100
c     +  .or. b_1(4) .lt. 0.0d0 .or. b_1(5) .lt. 0.0d0 ) goto 100

                    
	  if ( b_1(1) .le. 0.0d0 
     +  .or. b_1(2) .le. 0.0d0 
     +  .or. b_1(1) .ge. 0.5*svar   
     +  .or. b_1(3) .le. 0.0d0 
     +  .or. delta*b_1(2)+b_1(3) .ge. 1.0d0 
     +  .or. (delta*b_1(2)**2.0+(delta*b_1(2)+b_1(3))**2.0) .ge. 1.0d0 
     +  .or. (b_1(2)+b_1(3))**2.0 + (b_1(3)**2.0)/ delta .ge. 1.0d0 
     +  .or. b_1(4) .lt. 0.0d0 
     +  .or. b_1(5) .lt. 0.0d0 ) goto 100 


        call  loglik (b_1,a_2,th_v,lagd,h1,lik2,delta)

	  prob2= prob2 + lik2 - lik1
	  call drnun(1,prob1)
     
	  if ( prob2 > dlog(prob1(1)) ) then
	
	    iacpt1= iacpt1 + 1
	    do i=1,5
	      a_1(i)= b_1(i)
	    enddo
	
	  endif
	
*******  update h(t)
       
		call  sigma(a_1,a_2,th_v,lagd,h1,delta)

     
1000	return
	end  subroutine garch1
***************************************************************************************
	  subroutine garch2 (a_1,a_2,th_v,lagd,h1,delta)
	  implicit none
	  integer  n, m, i, nob, lag, igb, mgb
	  real*8   step0, step1, step0a, step1a, 
     *	  mean1(5), mean2(5), var1(5,5), var2(5,5),
     *	  lognor1, lognor2, h1 

        parameter (n=5,m=5)
        real th_v
        real*8  y(8800),at(8800),sig(8800),zsig(8800),us(8800)
	  real*8 a_1(5),a_2(5)
	  real*8 ta_2(5),b_2(5),tb_2(5),bb_2(5),lik1,lik2,prob1(1),prob2
	  real*8 rsig1(5,5),rsig2(5,5),wt(8800),ztt(8800)
	  real*8 svar,delta

        integer d, idx(8800),lagd
        integer cnt(2),p(2),npar(2)
	  integer iacpt2 

        common /obs/ y,at,d,lag,sig
        common /order/ cnt,p,npar
        common /index/ nob,idx
	  common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	  common /accept2/ iacpt2

	  common /stepsize/ step0, step1, step0a, step1a
	  common /mcmc/ igb, mgb
	  common /exogenous/ wt,ztt

	  common /meanvar/ svar

	  real*8	df


	  call  loglik (a_1,a_2,th_v,lagd,h1,lik1,delta )
	  
 101    call rnopt(6)
       

******** We perform independent MH using normal kernel after the burn-in iterations
********** The mean & covariance are determined from the MCMC iterates in the burn-in iterations

	  if (igb.gt.mgb) then
c		pause

	    call drnmvn (1,5,rsig2,5,bb_2,1)
c		write(*,*)'bb2222',bb_2
		do i=1,5
c	       b_2(i)= mean2(i) + bb_2(i)
	       b_2(i)= mean2(i) + bb_2(i)*0.5d0
	    enddo

	    call mnden(5,mean2,var2,a_2,lognor1)
	    call mnden(5,mean2,var2,b_2,lognor2)
	   
	    prob2= lognor1 - lognor2

	  else

	    call drnnor(5,bb_2)
c	    write(*,*)'bb2',bb_2

	    b_2(1)= a_2(1) + bb_2(1)*step0a
	    b_2(2)= a_2(2) + bb_2(2)*step1a
	    b_2(3)= a_2(3) + bb_2(3)*step1a
	    b_2(4)= a_2(4) + bb_2(4)*step1a
	    b_2(5)= a_2(5) + bb_2(5)*step1a

	    prob2= 0.0d0

	  endif

c	write(*,*)'bb2',bb_2

c	  if (b_2(1) .le. 0.0d0 .or. b_2(1) .gt. 2.0*svar   !0.8*svar
c     +			.or. b_2(2) .le. 0.0d0 
c     +  .or. b_2(3) .le. 0.0d0 .or. b_2(2)+b_2(3) .ge. 1.0d0 !) goto 101
c     +  .or. b_2(4) .lt. 0.0d0 .or. b_2(5) .lt. 0.0d0 ) goto 101


	  if ( b_2(1) .le. 0.0d0 
     +  .or. b_2(1) .ge. 0.80*svar   
     +  .or. b_2(2) .le. 0.0d0      
     +  .or. b_2(3) .le. 0.0d0 
     +  .or. delta*b_2(2)+b_2(3) .ge. 1.0d0 
     +  .or. (delta*b_2(2)**2.0+(delta*b_2(2)+b_2(3))**2.0) .ge. 1.0d0  
     +  .or. (b_2(2)+b_2(3))**2.0 + (b_2(3)**2.0)/ delta .ge. 1.0d0 
     +  .or. b_2(4) .lt. 0.0d0  
     +  .or. b_2(5) .lt. 0.0d0 ) goto 101 

	 
	  call  loglik (a_1,b_2,th_v,lagd,h1,lik2,delta )
	  prob2= prob2 + lik2 - lik1
	  call drnun(1,prob1)

	  if ( prob2 > dlog(prob1(1)) ) then

	    iacpt2=iacpt2+1
	    do i=1,5
	      a_2(i)=b_2(i)
		enddo

	  endif

******* update h(t)

	  call  sigma(a_1,a_2,th_v,lagd,h1,delta )
	
1000	return
	end  subroutine garch2

*********************************************************************************		

	subroutine s_cov(no, aa_1, mgb)
	implicit none
	integer  no, i, j, irank, lag, k, mgb
	real*8   mean1(5),mean2(5),var2(5,5),var(5,5),TOL

	integer t
	integer cnt(2),p(2),npar(2)
	integer nob ,d,idx(8800)

	real*8 :: aa_1(30000,5),sum1(5),sum2(5),ss(5),ave(5)
      real*8 ::var1(5,5),rsig1(5,5),rsig2(5,5)
	real*8 :: y(8800),at(8800),sig(8800),amach,wt(8800),ztt(8800) 

  	common /obs/ y,at,d,lag,sig
      common /order/ cnt,p,npar
	common /index/ nob,idx
	common /var_cov/ mean1,mean2,var1,var2,rsig1,rsig2
	common /exogenous/ wt,ztt


	var=0.0d0
	sum1=0.0d0
	sum2=0.0d0

      do t =1, mgb
	  do k=1,5
	    sum1(k)=sum1(k)+aa_1(t,k)
	    sum2(k)=sum2(k)+aa_1(t,k)**2
	  enddo
	enddo

	do k=1,5
	  ave(k)=sum1(k)/real(mgb)
	  ss(k)=sum2(k)-((sum1(k)**2) /real(mgb))
	enddo

	do i=1,5
	  do j=1,5
	    do t=1, mgb
		   var(i,j)=var(i,j)+(aa_1(t,i)-ave(i))*(aa_1(t,j)-ave(j))
	    enddo
	  enddo
	enddo
	
	do i=1,5
	  do j=1,5
c	  	  var(i,j)=var(i,j)/((ss(i)*ss(j))**0.5) ! this is for corr. matrix
	      var(i,j)=var(i,j)/real(mgb)  ! this is for covariance matrix
	  enddo
	enddo


	if (no .eq. 1) then
		
	    do i=1,5
	      mean1(i)= ave(i)
          enddo
	    do i=1,5
	      do j=1,5
	        var1(i,j)=var(i,j)

            enddo
	    enddo
		TOL = 100.0*AMACH(4)
		call  dchfac (5,var1,5,tol,irank,rsig1,5)
		
	
c		write(22,*)'var1',var1  
	    write(2,*)
		write(2,*)'Normal independent kernels determined from burn-in'
		write(2,*)
	    write(2,39)mean1(1),mean1(2),mean1(3),mean1(4),mean1(5)
	    write(2,40)var1(1,1),var1(1,2),var1(1,3),var1(1,4),var1(1,5)
	    write(2,40)var1(2,1),var1(2,2),var1(2,3),var1(2,4),var1(2,5)
	    write(2,40)var1(3,1),var1(3,2),var1(3,3),var1(3,4),var1(3,5)
	    write(2,40)var1(4,1),var1(4,2),var1(4,3),var1(4,4),var1(4,5)
	    write(2,40)var1(5,1),var1(5,2),var1(5,3),var1(5,4),var1(5,5)

39	    format('mean1  ',5f10.6)
40	    format('var1   ',5f10.6)
c	    call wrrrn('mean1',5,1,mean1,5,0)   
c		call wrrrn('var1',5,5,var1,5,0)   
c		call wrrrn('rsig1',5,5,rsig1,5,0)
	
	else

	    do i=1,5
	      mean2(i)= ave(i)
          enddo
	    do i=1,5
	      do j=1,5
	        var2(i,j)=var(i,j)
            enddo
	    enddo
		TOL = 100.0*AMACH(4)
	 	call  dchfac (5,var2,5,tol,irank,rsig2,5)   
c		write(22,*)'rsig2',rsig2
c		write(22,*)'var2',var2
	    write(2,139)mean2(1),mean2(2),mean2(3),mean2(4),mean2(5)
	    write(2,140)var2(1,1),var2(1,2),var2(1,3),var2(1,4),var2(1,5)
	    write(2,140)var2(2,1),var2(2,2),var2(2,3),var2(2,4),var2(2,5)
	    write(2,140)var2(3,1),var2(3,2),var2(3,3),var2(3,4),var2(3,5)
	    write(2,140)var2(4,1),var2(4,2),var2(4,3),var2(4,4),var2(4,5)
	    write(2,140)var2(5,1),var2(5,2),var2(5,3),var2(5,4),var2(5,5)


139	    format('mean2  ',5f10.6)
140	    format('var2   ',5f10.6)
c		call wrrrn('mean2',5,1,mean2,5,0)   
c	    call wrrrn('var2',5,5,var2,5,0)   
c		call wrrrn('rsig2',5,5,rsig2,5,0)
	
	endif

	return

	end  subroutine s_cov


******* This is used to compute the log of multivariate normal density
******* -.5*(x-mu)'Sigma^{-1}(x-mu)

	subroutine mnden(dim, mean, var, x, logden)
	implicit none
	integer  i, dim
	real*8   mean(5), var(5,5), logden, x(5), diff(5), dblinf, 
     *		varinv(5,5)

	external dblinf

	do i=1, dim
	  diff(i)= x(i) - mean(i)
	enddo

	call dlinrg(dim, var, dim, varinv, dim)

	logden= dblinf(dim, dim, varinv, dim, diff, diff)

	logden= -.5d0*logden

	return
	end  subroutine mnden
***************************************************************************************
       subroutine drawmu1(a_1,a_2,th_v,lagd,mu1,delta)
	  implicit none
	  integer n, m, lag,lagd, nob 
	  integer d
	  real*8 y(8800),a_1(5), a_2(5), h1, lik1, lik2, stepch
	  real*8 sig(8800),delta
        real*8 at(8800)
        real*8 wt(8800),ztt(8800)
        integer  cnt(2),p(2),t,npar(2),idx(8800)

	  common /obs/ y,at,d,lag,sig
        common /index/ nob,idx
	  common /exogenous/ wt,ztt

	  integer acceptmu1
	  real th_v
	  real*8 stepmu1
        real*8 prob(1),prob2,aa
	  real*8 ga_a,ga_b,mu1,mu1_2

	 data ga_a, ga_b /5.0d0,1.0d0/
	
        common /mu1_inf/ acceptmu1
        common /mu1_inf2/ stepmu1



	call loglik (a_1,a_2,th_v,lagd,mu1,lik1,delta)
       lik1=lik1+(ga_a-1.0d0)*dlog(mu1)-(ga_b*mu1)


200	call rnopt (6)
c 	call drnstt (1,10.0,aa)
 	call drnnor (1,aa)

          mu1_2  = mu1  +aa* stepmu1
	if (mu1_2 .le. 0.0d0 ) goto 200

      call loglik (a_1,a_2,th_v,lagd,mu1_2,lik2,delta)
       lik2=lik2+(ga_a-1.0d0)*dlog(mu1_2)-(ga_b*mu1_2)


      prob2= lik2 - lik1
   
  !    prob2=lik2/lik1
	call rnopt (6)
      call drnun (1,prob)
	prob(1)=dlog(prob(1))
!		prob(1)=prob(1)


	if ( prob2 .gt. prob(1) ) then

	   mu1= mu1_2
	   acceptmu1= acceptmu1 + 1
	
	endif
c       write (11,*) mu1_2, lik1, lik2, acceptmu1
      
	return
      end	
***************************************************************************************
       subroutine prob (a_1,a_2,th_v,lagd,mu1,delta)
	  implicit none
	  integer n, m, lag,lagd, nob 
	  integer d
	  real*8 y(8800),a_1(5), a_2(5), h1, lik1, lik2
	  real*8 sig(8800),mu1
        real*8 at(8800)
        real*8 wt(8800),ztt(8800)
        integer  cnt(2),p(2),t,npar(2),idx(8800)

	  common /obs/ y,at,d,lag,sig
        common /index/ nob,idx
	  common /exogenous/ wt,ztt

	  integer iac_del
	  real th_v
	  real*8 step_d
        real*8 prob1,prob2,prob3,aa
	  real*8 ga_a,ga_b,delta,delta_1,new

	 data ga_a, ga_b /25.0d0, 5.0d0/  !10,1
	
        common /ac_del/ iac_del
        common /blk12/ step_d



	call loglik (a_1,a_2,th_v,lagd,h1,lik1,delta)

       lik1=lik1+(ga_a-1.0d0)*dlog(delta)-(ga_b*delta)


200	call rnopt (6)
c 	call drnstt (1,10.0,aa)
 	call drnnor (1,aa)

          delta_1  = delta  +aa* step_d

	if (delta_1 .lt. 1.0d0 ) goto 200

      call loglik (a_1,a_2,th_v,lagd,h1,lik2,delta_1)
       lik2=lik2+(ga_a-1.0d0)*dlog(delta_1)-(ga_b*delta_1)


      prob3= lik2 - lik1
   
  !    prob2=lik2/lik1
	call rnopt (6)
      call drnun (1,prob2)
c	prob(1)=dlog(prob(1))
!		prob(1)=prob(1)


	if ( prob3 .gt. dlog(prob2) ) then

	   delta = delta_1
	   iac_del = iac_del +1
	
	endif
      
	return
      end	

*************************

