plot.sop <- function(x, rug = TRUE, pages = 0, select = NULL, grid , ...) {
	if (missing(grid))   ngrid <- 100

	b.fixed <- x$b.fixed
	b.random<- x$b.random
	
	nlin <- x$nterms[1]
	nre <- x$nterms[2]
	nfun <- x$nterms[3]

	dim.fixed <- c(if(nlin > 0) x$lin$dim, if(nfun > 0) unlist(lapply(x$f, function(x) x$Xmat$dim$fixed)))
	dim.random <- c(if(nre > 0) x$random$dim, if(nfun > 0) unlist(lapply(x$f, function(x) x$Xmat$dim$random)))

	e.f <- cumsum(dim.fixed)
	s.f <- e.f - dim.fixed + 1

	e.r <- cumsum(dim.random)
	s.r <- e.r - dim.random + 1

	jit <- FALSE
	n.plots <- nfun + nlin + nre
 	if (pages == 1) par(mfrow = c(1,1))
	if (n.plots == 0) { 
		stop("No terms to plot - nothing for plot.sop() to do.")
	}
	if (pages > n.plots) 
		pages <- n.plots
	if (pages < 0) 
		pages <- 0
	if (pages != 0) {
		ppp <- n.plots%/%pages
		if (n.plots%%pages != 0) {
			ppp <- ppp + 1
			while (ppp * (pages - 1) >= n.plots) pages <- pages - 1   
		}
		c <- r <- trunc(sqrt(ppp))
		if (c < 1)       r <- c <- 1
		if (c * r < ppp) c <- c + 1
		if (c * r < ppp) r <- r + 1
		oldpar <- par(mfrow = c(r, c))
	} else {
		ppp <- 1
		oldpar <- par()
	}
	if ((pages == 0 && prod(par("mfcol")) < n.plots && dev.interactive()) || pages > 1 && dev.interactive()) {
		ask <- TRUE
	} else { 
		ask <- FALSE
	}
	if (!is.null(select)) {
		ask <- FALSE
	}
	if (ask) {
		oask <- devAskNewPage(TRUE)
		on.exit(devAskNewPage(oask))
	}
	output <- list()
	cnames <- x$model.terms
	if (!is.null(select)) {
		terms <- cnames[select]
	} else {
		terms <- cnames
	}	
	if (nlin > 0) {
		lab <- x$lin$vars
		for (i.lin in 1:length(lab)) {
			if ((cnames[i.lin] %in% terms) & attr(x$lin$terms,"dataClasses")[i.lin] != "factor")  {
				x0 <- x$dat[,cnames[i.lin]]
				xseq <- seq(min(x0 ),max(x0), l = ngrid)
				vcum <- s.f[i.lin]:e.f[i.lin]
				yt <- b.fixed[vcum + 1]*xseq
				plot(xseq , yt, xlab = lab[i.lin], type = "l", ylab = paste("Partial for ", lab[i.lin], sep=""), ...)
				if (rug) {
					if (jit) 
						 rug(jitter(as.numeric(xseq )), ...)
					else rug(as.numeric(xseq ), ...)
				}
			}
		}
	}
	if (nre > 0){ 
		aa <- construct.random.prediction.matrix(x, x$data) 
		lab <- x$random$vars
		for (i.re in 1:length(lab)) {
			if ((cnames[i.re + nlin] %in% terms))  {
				vcum <- s.r[i.re]:e.r[i.re]
				yt <- as.vector(aa[,vcum, drop = FALSE]%*%b.random[vcum])
				qqnorm(yt, main = lab[i.re], xlab = "Gaussian quantiles", ylab = "Effects",...)
				qqline(yt)   
			}
		}
	}
	if (nfun > 0) { 
		for (i.fun in 1:nfun) {
			nseg <- x$f[[i.fun]]$nseg
			bdeg <- x$f[[i.fun]]$degree
			pord <- x$f[[i.fun]]$pord
			lab <- x$f[[i.fun]]$label
			if (x$f[[i.fun]]$dim == 1) {   
				if ((is.null(select) || (i.fun + nre + nlin) == select)) {
					lab <- paste(x$f[[i.fun]]$label,", edf = ",round(x$out$edf[x$nterms[2] + i.fun],2),sep="")    
					xlab <- x$f[[i.fun]]$vars
					x0 <- x$dat[,xlab]
					xseq <- seq(min(x0),max(x0), l = ngrid)
					Bp <- spline.bbase(x$f[[i.fun]]$Xmat$terms$MM$knots, xseq , bdeg)
					Xp <- Bp%*%x$f[[i.fun]]$Xmat$terms$MM$U.X
					Zp <- Bp%*%x$f[[i.fun]]$Xmat$terms$MM$U.Z

					vcum.f <- s.f[i.fun + nlin]:e.f[i.fun + nlin]
					vcum.r <- s.r[i.fun + nre]:e.r[i.fun + nre]
					output[[i.fun]] <- Xp[,-1, drop = FALSE]%*%b.fixed[vcum.f + 1] + Zp%*%b.random[vcum.r]

					plot(xseq , output[[i.fun]], xlab = xlab, ylab = lab, type = "l", ...)
					if (rug) {
						if (jit) 
							rug(jitter(as.numeric(xseq )), ...)
						else rug(as.numeric(xseq ), ...)
					}
				}
			} else {
				if (x$f[[i.fun]]$dim == 2) { 
					if ((is.null(select) || i.fun == select)) {
						xlab <- x$f[[i.fun]]$vars
						x1 <- x$dat[,xlab[1]]
						x2 <- x$dat[,xlab[2]]
						x1seq <- seq(min(x1), max(x1), l = ngrid)
						x2seq <- seq(min(x2), max(x2), l = ngrid)
						B1p <- spline.bbase(x$f[[i.fun]]$Xmat$terms$MM$MM1$knots, x1seq, bdeg[1])
						B2p <- spline.bbase(x$f[[i.fun]]$Xmat$terms$MM$MM2$knots, x2seq, bdeg[2])    
						X1p <- B1p%*%x$f[[i.fun]]$Xmat$terms$MM$MM1$U.X
						X2p <- B2p%*%x$f[[i.fun]]$Xmat$terms$MM$MM2$U.X  
						Z1p <- B1p%*%x$f[[i.fun]]$Xmat$terms$MM$MM1$U.Z
						Z2p <- B2p%*%x$f[[i.fun]]$Xmat$terms$MM$MM2$U.Z    
						Xp = Rten2(X2p, X1p)
						Xp <- Xp[,-1,drop = FALSE]    
						Zp = cbind(Rten2(X2p, Z1p), Rten2(Z2p, X1p), Rten2(Z2p, Z1p))  
												
						vcum.f <- s.f[i.fun + nlin]:e.f[i.fun + nlin]
						vcum.r <- s.r[i.fun + nre]:e.r[i.fun + nre]

						p <- Xp[,-1, drop = FALSE]%*%b.fixed[vcum.f + 1] + Zp%*%b.random[vcum.r]
						output[[i.fun]] =  matrix(p, ngrid, ngrid)
						image(x1seq, x2seq, output[[i.fun]], main = lab, col = topo.colors(ngrid))  
					}
				} else {
					if ((is.null(select) || i.fun == select)) {
						print("No 3D plot implemented")
					}
				}
			}
		}
	}
	if (pages > 0)   par(oldpar)
	invisible(output)
}


