sop <- function(formula, data = list(),  family = gaussian(), weights = NULL, offset = NULL, etastart, mustart, control = sop.control() ) {
	control <- do.call("sop.control", control)	
	tf <- terms.formula(formula, specials = c("f","re"))
	terms <- attr(tf, "term.labels")
	nt <- length(terms)     
	if (attr(tf, "response") > 0) {
		response <- as.character(attr(tf, "variables")[2])
	}
	ifun <- attr(tf,"specials")$f
	ire <- attr(tf,"specials")$re
	if(response != 0) { 
		ifun <- ifun - 1
		ire <- ire - 1
	}
	nfun <- length(ifun)
	smooth <- terms[ifun]

	nre <- length(ire)
	random <- terms[ire]

	fixed <- terms[-c(ifun,ire)]
	ilin <- (1:nt)[-c(ifun,ire)]
	nlin <- length(fixed)

	nterms <- c(nlin,nre,nfun) 

	l.f <- l.lin <- l.re <- NULL
	np <- Z <- X <- NULL
	gg <- init.var <- dim <- list()
	var.re <- character(nre)
	Xnames <- "(Intercept)"
	model.terms <- NULL
	names.terms <- terms[c(ilin,ire,ifun)]
	
	nobs <- nrow(data)
	if (is.null(offset)) {
		offset <- rep.int(0, nobs)
	}
	if (is.null(weights)) {
		weights <- rep.int(1, nobs)
	}

	# TRUE/FALSE para observacion con dato perdido no pemitido
	na.ind <- apply(is.na(data[, all.vars(tf)]), 1, any)
	weights = weights*(!na.ind)
	data.na <- data[!na.ind,]
	weights.na <- weights[!na.ind]
	offset.na <-  offset[!na.ind]
	y <- data.na[,response]
	na.action <- (1:nrow(data))[na.ind]

	########################## Linear effects and factors ############################
	if (nlin != 0) {
		var.lin <- terms[ilin]
		formula.lin <- formula(paste("~", paste(var.lin, collapse = "+")))
		l.lin <- construct.fixed.part(formula.lin, data.na)
		l.lin$vars <- var.lin
		l.lin$form   <- formula.lin  
		
		X <- cbind(X, l.lin$X)
		Xnames <- c(Xnames, colnames(l.lin$X))
		model.terms <- c(model.terms, var.lin)
		attr(names.terms,"type") <- c(attr(names.terms,"type"), attr(l.lin$terms,"dataClasses"))
	}
	########################## Random effects #######################################
	if (nre != 0) {
		for (i in 1:nre) {
    		var.re[i] <- as.character(eval(parse(text = terms[ire[i]])))
  		}
		formula.re <- formula(paste("~", paste(var.re, collapse = "+")))
		l.re <- construct.random.part(formula.re, data.na)
		l.re$vars <- var.re
		l.re$form <- formula.re

		np <- c(np, l.re$dim)
		Z <- cbind(Z, l.re$Z)
		init.var <- c(init.var, list(l.re$init.var))
		dim <- c(dim, list(l.re$dim))
		gg <- list(l.re$g)
		model.terms <- c(model.terms, var.re)
		attr(names.terms,"type") <- c(attr(names.terms,"type"),rep("random", length = nre))
	}
	############################# Smooth functions ################################  
	if (nfun > 0){
		for (i in 1:nfun) {
			l.f[[i]] <- eval(parse(text = terms[ifun[i]]))
			form <- as.formula(paste("~", terms[ifun[i]],sep=""))
			aa <- switch(as.character(l.f[[i]]$dim),
			"3" = {  				
				l.f[[i]]$Xmat <- construct.3D.pspline(form, data.na) 				
			}, "2"= {            				
				l.f[[i]]$Xmat <- construct.2D.pspline(form, data.na)				
			}, "1" = {				
				l.f[[i]]$Xmat <- construct.1D.pspline(form, data.na) 				
			})

			np <- c(np, l.f[[i]]$Xmat$dim$random)		
			X <- cbind(X,l.f[[i]]$Xmat$X)		
			Z <- cbind(Z,l.f[[i]]$Xmat$Z)
			gg <- c(gg, list(l.f[[i]]$Xmat$g))										
			init.var <- c(init.var, list(l.f[[i]]$Xmat$init.var))
			dim <- c(dim, list(l.f[[i]]$Xmat$dim))
			Xnames <- c(Xnames, colnames(l.f[[i]]$Xmat$X))	
			model.terms <- c(model.terms,l.f[[i]]$vars)
			attr(names.terms,"type") <- c(attr(names.terms,"type"), rep("smooth",length = length(l.f[[i]]$label)))
			
		}
	}
	X <- as.matrix(cbind(rep(1, lenght = nrow(X)), X)) #  Intercept
	colnames(X) <- Xnames
	np <- c(ncol(X), np)
	if (length(gg) == 1 & length(gg[[1]]) == 1) {
		G <- list(unlist(gg))
		names(G) <- names(gg[[1]])
	} else {
		G <- construct.capital.lambda(gg)
		# cat("G tipo", typeof(G), "\n")
		# cat("G[[1]]", G[[1]], "\n")
		# cat("length G[[1]]", length(G[[1]]), "\n")
		# cat("G", G[[2]], "\n")
		# cat("length G[[2]]", length(G[[2]]), "\n")
		
	}
	#################################
	start <- mustart <- etastart <- NULL
	#################################
	fit <- sop.fit(X, y, Z,  weights = weights.na, G = G,
				etastart = etastart, mustart = mustart,
				offset = offset.na, 
				family = family, control = control)
	fit$call<- match.call()
	fit[["random"]] <- l.re
	fit[["f"]] <- l.f
	fit[["lin"]] <- l.lin
	fit$G <- G
	fit$y <- y
	fit$formula <- formula
	fit$vars <- Xnames
	fit$terms <- terms
	fit$na.action <- na.action 
	fit$names.terms <- names.terms # The same as terms, but ordered: fixed, random and smooth
	fit$model.terms <- model.terms # The name of the variables (not the terms), ordered: fixed, random and smooth  
	fit$data <- data
	fit$gg <- gg
	fit$np <- np
	fit$nterms <- nterms
	fit$componentes =l.f
	class(fit) <- "sop"
	invisible(fit)
	
}