library(nimble)
library(coda)


##### nimble code of the proposed model #####
DPcode <- nimbleCode({
  for (i in 1:N) {
    y1[i] ~ dbern(mu_y1[i])
    logit(mu_y1[i]) <- b0 + b1[1] * x1[i] + b1[2] * x2[i] + L[i]

    y2[i] ~ dnorm(mu_y2[i], tau = tau_y2)
    mu_y2[i] <- b2[1] * x1[i] + b2[2] * x2[i] + L[i]

    x1[i] ~ dnorm(mu_x1[i], tau = tau_x1)
    mu_x1[i] <- a[1] + a[2] * x2[i] + a[3] * x3[i]
    
    # DPMM
    L[i] ~ dnorm(mu_L0[i], tau = tau_L0[i])
    mu_L0[i] <- mu_L[latent[i]]
    tau_L0[i] <- tau_L[latent[i]]

    R[i] ~ dbern(prob = pR[i])
    logit(pR[i]) <- phi[1] + phi[2] * x1[i] + phi[3] * x2[i]   # nonignorable R model
  }
  
  b0 ~ dnorm(0, 1)
  for (j in 1:2) {
    b1[j] ~ dnorm(0, 0.001)
    b2[j] ~ dnorm(0, 0.001)
  }
  
  for (j in 1:3) {
    a[j] ~ dnorm(0, 0.001)
  }
  
  for (j in 1:3) {
    phi[j] ~ dnorm(0, 1)
  }
  
  ## CRP
  latent[1:N] ~ dCRP(alpha, size=N)
  alpha ~ dgamma(1, 1)
  for (j in 1:Kmax){
    mu_L[j] ~ dnorm(0, 1)
    tau_L[j] ~ dgamma(1, 1)
  }
  
  tau_y2 ~ dgamma(1, 1)
  tau_x1 ~ dgamma(0.001, 0.001)
})

