ginv<-function(X, tol = sqrt(.Machine$double.eps))
{
## Generalized Inverse of a Matrix
  dnx <- dimnames(X)
  if(is.null(dnx)) dnx <- vector("list", 2)
  s <- svd(X)
  nz <- s$d > tol * s$d[1]
  structure(
    if(any(nz)) s$v[, nz] %*% (t(s$u[, nz])/s$d[nz]) else X,
    dimnames = dnx[2:1])
}

Sigma.infinity.copula<-function(param, mask, y, threshold, xcoords, ycoords, tcoords,
                                delta,  ncores, nsites,ntimes, 
                                block.number=100, block.size =1000,
                                eps=1.0e-4) {
  
  if (block.size > ntimes)
    stop("block.size is too big")
  # y=(data[s_1,t_1],data[s_2,t_1,..., data[s_nsites,t_1], ..., data[s_nsites,t_ntimes])'
  # k number 
  # m number of times
  # k m-k overlapping observations  
  # g gradient
  lag<-delta[2]
  if (block.size < lag)
    stop("block.size is too small")
  theta<-param[mask]
  ntheta<-length(theta)
  loglik<-rep(0,block.number)
  npairs<-rep(0,block.number)
  start<-sample(lag:(ntimes-block.size),replace = TRUE,size = block.number)
  mat<-foreach(i=1:block.number,.combine=rbind) %dopar%{ 
    sel <- (start[i]*nsites+1):((start[i]+block.size)*nsites)
    
    y1<-y[sel]
    nobs<-length(y1)
    loglik[i]<-npairs[i]<-0
    
    val<-.C("pwl_copula_parallel",y=as.double(y1), nobs=as.integer(nobs), 
            nsites=as.integer(nsites), nblocks=as.integer(block.size), 
            lag=as.integer(lag),
            theta=as.double(param[-c(1:4)]), 
            alpha=as.double(param[1]), lambda=as.double(param[2]),
            velocity=as.double(param[3:4]),
            loglik=as.double(loglik[i]), 
            threshold=as.double(threshold), xcoords=as.double(xcoords[sel]), 
            ycoords=as.double(ycoords[sel]), tcoords=as.double(tcoords[sel]), 
            delta = as.double(delta[1]), corrmodel =as.integer(corrmodel),count=as.double(npairs[i]), 
            NAOK = TRUE,  DUP =FALSE)	
    
    
    ntot<-val$count    
    g<-rep(-val$loglik,ntheta)
    for (k in 1:ntheta) {
      dtheta <- theta
      dtheta[k] <- dtheta[k] + eps
      param[mask]<-dtheta
      loglik[i]<-npairs[i]<-0
      pip<-0
      
      
      val<-.C("pwl_copula_parallel",y=as.double(y1), nobs=as.integer(nobs), 
              nsites=as.integer(nsites), nblocks=as.integer(block.size), 
              lag=as.integer(lag),             
              theta=as.double(param[-c(1:4)]), 
				alpha=as.double(param[1]), lambda=as.double(param[2]),
				velocity=as.double(param[3:4]),
              loglik=as.double(loglik[i]),  
              threshold=as.double(threshold), xcoords=as.double(xcoords[sel]), 
              ycoords=as.double(ycoords[sel]), tcoords=as.double(tcoords[sel]), 
              delta = as.double(delta[1]), corrmodel =as.integer(corrmodel),count=as.double(npairs[i]), 
              NAOK = TRUE,  DUP =FALSE)	 
      g[k]<-(-val$loglik-g[k])/eps # gradient      
    }
    c(g,ntot)
  }
  Sigma.infinity<-crossprod(as.matrix(mat[,1:ntheta]/sqrt(mat[,(ntheta+1)])))/block.number
  return(Sigma.infinity=Sigma.infinity)
}


spt.censgauss.fit<-function(ydata, coords, init.phi, init.aniso=c(0,1), 
                            init.velocity=c(0,0), delta.s = NULL, delta.t=NULL,  
                           threshold =0,mask.phi= NULL,  mask.aniso=rep(FALSE,2), mask.velocity=rep(FALSE,2), ncores = 1, 
                            corrmodel = 4, maxit.NM=200,block.number=100,block.size=1000,estimation=TRUE, std.error=FALSE,trace=FALSE)                 

{

nsites<-ncol(ydata)
ntimes<-nrow(ydata)  
xy<-rep(1,ntimes)%x%as.matrix(coords)
xcoords<-xy[,1]
ycoords<-xy[,2]
tcoords<-(1:ntimes)%x%rep(1,nsites)
  
# we transpose because we use the parallel version of the program
# data enter in this order y[t1,s1],y[t1,s2],y[t1,s3], ....
  ydata<-t(ydata)
  y<-as.numeric(ydata)
  param<-c(init.aniso,init.velocity,init.phi)
  mask<-c(mask.aniso,mask.velocity,mask.phi)         
  delta<-c(delta.s,delta.t)
  velocityvar<-NULL
  for (i in 1 : 2)
		velocityvar<-c(velocityvar,paste("velocity",i,sep=""))
		phivar<-NULL
  for (i in 1 : length(init.phi))
    phivar<-c(phivar,paste("phi",i,sep=""))
    parnames<-c("alpha","lambda",velocityvar,phivar)		
    res<-list()
    res$nsites<-nsites	
    res$ntimes<-ntimes
    res$init.aniso<-init.aniso
    res$init.velocity<-init.velocity
    res$init.phi<-init.phi
    res$mask.aniso<-mask.aniso
    res$mask.velocity<-mask.velocity
    res$mask.phi<-mask.phi
    res$delta<-delta
    res$threshold<-threshold
    res$corrmodel<-corrmodel
    res$start<-theta<-param[mask]
    res$mask<-mask
    res$ncores<-ncores    
    ptm <- proc.time()
    
    parscale<-10^floor(log10(abs(theta+1e-4))) 
    if (estimation == TRUE) {
	  if (trace) print("estimation step")
      # registerDoParallel(cores=ncores) old
      my.cluster <- parallel::makeCluster(
        ncores, 
        type = "FORK"
      )
      
      #register it to be used by %dopar%
      doParallel::registerDoParallel(cl = my.cluster)
	    a <-optim(par=theta, fn=PLneg.spt.censgauss, method = "Nelder-Mead", control=list(maxit=maxit.NM,parscale=parscale),
               y = y, xcoords = xcoords, ycoords= ycoords,tcoords =tcoords,delta = delta, 
              threshold =threshold, param=param,mask=mask,ncores = ncores, nsites = nsites, 
              ntimes = ntimes, corrmodel = corrmodel)
      # stopImplicitCluster()
	    parallel::stopCluster(cl = my.cluster)
          
	  res$thetahat<-param[mask]<-as.numeric(a$par)	           
	  res$param<-param
	  res$negplik <- a$value	
	  res$elapsed<-proc.time() - ptm
	  res$delta<-delta
	  names(res$param)<-parnames
	  names(res$thetahat)<-parnames[res$mask]
	  res$convergence<- a$convergence
    }
    if (std.error) {
      if (trace) print("standard error step")
      #registerDoParallel(cores=ncores) old
      if (estimation == TRUE) {
        if (trace) print("estimation step")
        # registerDoParallel(cores=ncores) old
        my.cluster <- parallel::makeCluster(ncores, type = "FORK")
        
        #register it to be used by %dopar%
        doParallel::registerDoParallel(cl = my.cluster)
        
      tmp<-PLneg.spt.censgauss.wrap(theta=res$param[res$mask],y=y,threshold =threshold,xcoords = xcoords, ycoords =ycoords, tcoords=tcoords,  
                                 delta=delta, param=res$param, 
                                 mask=res$mask, ncores=ncores,
                                 nsites=nsites,  ntimes=ntimes, 
                                 corrmodel =corrmodel)
      res$negplik<-tmp$val
      res$npairs<-tmp$npairs
      res$block.number<-block.number
      res$block.size<-block.size
      
      if(is.null(res$h.hat)) {
        b<-gHgen(par=res$param[res$mask], fn=PLneg.spt.censgauss, 
                 y = y, xcoords = xcoords, ycoords= ycoords,tcoords =tcoords,delta = delta, 
                 threshold =threshold, param=param,mask=mask,ncores = ncores, nsites = nsites, 
                 ntimes = ntimes, corrmodel = corrmodel)
        res$grad<-b$gn
        res$h.hat<-b$Hn
      }
      Sigma.infinity<-Sigma.infinity.copula(param = res$param, mask = res$mask,
                                            y=y, threshold=res$threshold, 
                                            xcoords =xcoords, ycoords =ycoords, 
                                            tcoords=tcoords, 
                                            delta =res$delta, 
                                            ncores=ncores,
                                            nsites = nsites,ntimes=ntimes, 
                                            block.number = block.number,
                                            block.size = block.size) 
      # stopImplicitCluster() 
      
      parallel::stopCluster(cl = my.cluster)
      
      j.hat<-Sigma.infinity*res$npairs
      res$j.hat<-j.hat
      colnames(res$j.hat)<-parnames[res$mask]
      rownames(res$j.hat)<-parnames[res$mask]
      pen<-sum(diag(j.hat%*%inv.h.hat))
      res$pen<-pen
      var.hat<-inv.h.hat%*%j.hat%*%inv.h.hat
      res$var.hat<-var.hat	
      colnames(res$var.hat)<-parnames[res$mask]
      rownames(res$var.hat)<-parnames[res$mask]
      res$std.err<-sqrt(diag(res$var.hat))
      res$clic<-res$negplik+pen # + because we have considered the negative value of cl		
      res$ncores<-ncores
      }
    }
    res$elapsed<-proc.time() - ptm
return(res)
}


