
my.fmadogram<-function(data,coords, nbreaks=13,  max.dist=NULL){
    n<-length(data)	
    p<-rank(data)/(n+1)
    d<-as.numeric(dist(coords))
    z<-as.numeric(dist(p))
    if (is.null(max.dist)) 
      max.dist<-max(d) 
     
    sel<- (d <= max.dist) 
    d<-d[sel]
    z<-z[sel]
    breaks<-seq(0,max.dist,length=nbreaks)
    centers<-(breaks[-1]+ breaks[-length(breaks)])/2
    
    bins<-cut(d,breaks)
    nbins<-as.numeric(table(cut(d,breaks)))
    
    
    fmad<-0.5*as.numeric(by(z,bins,mean))
    ext.coeff<-(1 + 2 *fmad) / (1 - 2*fmad)
    return(list(fmad=fmad,centers=centers,ext.coeff=ext.coeff, nbins=nbins,max.dist=max.dist))				
}


mytaildep<-function (x, y, u) 
{


    bivariate <- na.omit(cbind(x,y))   
    n<-dim(bivariate)[1]	
    xun <- sort(bivariate[,1])[floor(n * u)]
    yun <- sort(bivariate[,2])[floor(n * u)]
    id <- (bivariate[,1] > xun) & (  bivariate[,2] > yun)
        chi <- sum(id)/(n * (1 - u))
        chibar <- 2 * log(1 - u)/log(mean(id)) - 1
        if (chibar == -1)
            chibar <- NA
        res <- c(chi, chibar)
    return(res)
}



extremal.variogram.func<-function(x,y,prob)
{
  
  x.f<-mygev2frech(x,emp=TRUE)
  y.f<-mygev2frech(y,emp=TRUE)
  T<-pmin(x.f,y.f)
  u<-quantile(T, prob=prob)
  sel<-T > u
  eta.hat<-mean(log(T[sel]/u))
  ev<-2*(1-eta.hat)
  se<-2*eta.hat/sqrt(sum(sel))
  return(c(ev,se,eta.hat))
}
extremal.variogram<-function(data, locations, prob=0.90)
{
  nsites<-dim(data)[2]
  d<-as.numeric(dist(locations))
  u<--1/log(prob)
  val<-NULL
  for (i in 1:(nsites-1)) {
    for (j in (i+1):nsites)
        
        val<-rbind(val,extremal.variogram.func(data[,i],data[,j], prob=prob))
  }
  plot(d,val[,1],pch=20,ylim=c(0,2))
  return(list(d=d,val=val))
}





chi.spatial.emp<-function(data,coords,u=0.90,maxdist=NULL, omnidirectional=TRUE, ang.rad=pi/4,tol.rad =pi/8,lag =0, nbreaks =13){
  
  nsites <- dim(data)[2]
  ntimes <- dim(data)[1]
	d<-as.numeric(dist(coords))
  
  if (!omnidirectional) {
	  u.ang <- .C("tgangle", as.double(as.vector(coords[, 1])), 
            as.double(as.vector(coords[, 2])), as.integer(nsites), 
            res = as.double(rep(0, length(d))), PACKAGE = "geoR")$res
	  u.ang <- atan(u.ang)
	  u.ang[u.ang < 0] <- u.ang[u.ang < 0] + pi
	  ang.lower <- ang.rad - tol.rad
	  ang.upper <- ang.rad + tol.rad
	  if (ang.lower >= 0 & ang.upper < pi) 
	    ang.ind <- (!is.na(u.ang) & ((u.ang >= ang.lower) & 
                                 (u.ang <= ang.upper)))
	  if (ang.lower < 0) 
	    ang.ind <- (!is.na(u.ang) & ((u.ang < ang.upper) | 
                                 (u.ang > (pi + ang.lower))))
	  if (ang.upper >= pi) 
		  ang.ind <- (!is.na(u.ang) & ((u.ang > ang.lower) | 
                                 (u.ang < (ang.upper - pi))))
  } else {
	ang.ind<-rep(TRUE,length(d))
  }

  sel<- (d <= maxdist) & ang.ind
  d<-d[sel]
  index<-NULL
  for ( i in 1:(nsites-1)) {
        index<-rbind(index,cbind(i,(i+1):nsites))
  }
  index<-index[sel,]
  
  results<-foreach(i=1:nrow(index),.combine=rbind) %dopar%{ 
       mytaildep(x=data[1:(ntimes-lag),index[i,1]], y=data[(lag+1):ntimes,index[i,2]],u=u)
  }
  res<-cbind(d,results)
    colnames(res)<-c("distance","chi","chibar")
  clusters<-as.numeric(cut(d,breaks=seq(0,max(d),l=nbreaks)))
  return(invisible(cbind(res,index,clusters)))
  
}

chi.spatial.emp.cloud<-function(data,coords,u=0.90){
  
  nsites <- dim(data)[2]
  ntimes <- dim(data)[1]
  res<-NULL
  for ( i in 1:(nsites-1))
      {
      results<-foreach(k=(i+1):nsites,.combine=rbind) %dopar%{ 
        mytaildep(x=data[,i], y=data[,k],u=u)
      }
     
  res<-rbind(res,results)    
  }
  colnames(res)<-c("chi","chi.bar")
  rownames(res)<-NULL #1:(nsites*(nsites-1)/2)
  return(invisible(res))
}
chi.temporal.emp<-function(data,u=0.90,maxlag =1){
  
  nsites <- dim(data)[2]
  ntimes <- dim(data)[1]
  
  
  res.chi<-matrix(0,nsites,maxlag)
  res.chibar<-matrix(0,nsites,maxlag)
  for ( i in 1:nsites) {
    
    for (lag in 1:maxlag) {  
      a<-mytaildep(x=data[1:(ntimes-lag),i], y=data[(lag+1):ntimes,i],u=u)
      res.chi[i,lag]<-a[1]
      res.chibar[i,lag]<-a[2]
    }
    
  }
  res<-cbind(res.chi,res.chibar)
  return(invisible(res))
  
}



mytaildep2<-function (x, y, u,method="first") 
{
  bivariate <- na.omit(cbind(x, y))
  n <- nrow(bivariate)[1]
  id <- (rank(bivariate[, 1],ties.method = method)/(n+1) >u) & (rank(bivariate[, 2],ties.method = method)/(n+1) >u)
  chi <- mean(id)/((1 - u))
  chibar <- 2 * log(1 - u)/log(mean(id)) - 1
  if (chibar == -1) 
    chibar <- NA
  res <- c(chi, chibar)
  return(res)
}

chi.censgauss<-function(param,prob, x1,y1,t1,x2,y2,t2,corrmodel) {
  
  alpha<-param[1]
  lambda<-param[2]
  velocity<-param[c(3,4)]
  theta<-param[-(1:4)]
  n<-length(x1)
  val<-numeric(n)
  q<-qnorm(prob)
  a<-.C("chi_u_wrap", q=as.double(q),p=as.double(prob), n=as.integer(n),
            x1 = as.double(x1), y1 = as.double(y1), t1 = as.double(t1),
            x2 = as.double(x2), y2 = as.double(y2), t2 = as.double(t2),
            theta=as.double(theta),  corrmodel =as.integer(corrmodel), 
            alpha=as.double(alpha),  lambda =as.double(lambda),velocity =as.double(velocity),  
            val=as.double(val),NAOK = TRUE,  DUP =FALSE)	
  return(a$val)	
}


