#### Splus functions for smooth estimation of correlation
#### and variance structure in an AR(1) process.
#### Description is provided in the Splus help file
#### "smooth.cor"
#### Principles of this function are described in
#### "Modelling Data from Inside of  Earth: 
#### Local Smoothing of Mean and Dispersion Structure
#### in Deep Drill Data" by Kauermann and Kuechenhoff 


auto.cor _ function( resid, deltau ,  x = null())
  {
    ## Estimation of correlation adjusted
    ## for unequal spacing of x covariates
    resid _ matrix(resid)
    ni _ dim(resid)[1]
    resid2 _ resid[1:(ni-1)]
    resid1 _ resid[2:(ni)]
    rhohat _ cor(resid1,resid2)
    deltabar _  mean(deltau)
    if (length(na.omit(rhohat))==0)
      {
        rho _ 1
      } else {
        if (rhohat <= 0)
          {
            signrho _ -1
            rhohat _ -rhohat
          } else {
            signrho _ 1
          }
        rho _ rhohat
        for (i in 1: 10)
          {
        ## 10 loops to solve equation (6) in paper 
            rho _ rhohat / (1+  log(rho**(1/deltabar))**2
                            * mean ((deltau-deltabar)**2))
          }
        rho _ rho * signrho
      }
    return(rho**(1/deltabar))
  }


smooth.cor _ function (x,y, h, epsilon = 0.000001)
  {
    ## Smooth estimation of correlation and variance structure
    ## in an AR(1) process
    ## For description see Splus help file "smooth.cor"
    ## which should be copied to the .Data/.Help directory
    ## and can then be opened under Splus with
    ## help(smooth.cor)
    N _ length(x)
    u _ x
    help _ c()
    helpvar _ c()
    u.rho.points _ c()
    k _ floor(length(y)/(h))
    for( i in 1:(k-1))
      {
        j _ i*h
        yii _ y[max(1,(j-h)):min((j+h),N)]
        yii _ yii - mean(yii)
        uii _ u[max(1,(j-h)):min((j+h),N)]
        nii _ length(uii)
        deltauii _ -(uii[1:(nii-1)]-uii[2:(nii)])
        help2 _ auto.cor(yii,deltauii ,x=uii)
        if ( (length(na.omit(help2)) > 0)&
            (( var(yii[1:(nii-1)])> epsilon) &
             ( var(yii[2:nii])> epsilon)))
          {
            help _ c(help, help2)
            u.rho.points _ c( u.rho.points,u[j])
            IP _ diag(nii) - matrix(1/nii,nii,nii)
            Delta _ abs((kronecker(matrix(uii),matrix(1,1,nii))) -
                        (kronecker(matrix(1,nii,1),t(matrix(uii)))))
            R _ help2**(Delta)
            shat _ var(yii) *(nii-1) / sum(diag( (IP)%*%  R%*%(IP) ))
            if ( shat<0) { print(i)}
            helpvar _ c(helpvar, shat)
          }
      }
    return(list(cor=help, var=helpvar, x.points=u.rho.points))
  }



