
c ESTIMATE THE PARAMETERS OF BARTLETT-LEWIS MODEL ( COX AND ISHAM, 1980) FROM A DATASET.
c THE ESTIMATION IS DONE USING ML METHOD BY ASSUMING THE DATA COME FROM A MULTIVARIATE NORMAL DISTRIBUTION.
c TO ESTIMATE MEAN AND COVARIANCE FUNCTION OF EACH SET OF PARAMETERS WE USE MONTE-CARLO INFERENCE
c BY GENERATING RAINFALL DATA (TYPICALLY OVER 40 YRS) ACCORDING TO BL MODEL.

c	INPUT: MIN, MAX = BOUNDARY FOR SEARCHING THE ESTIMATES
c	NSAMPL = NUMBER OF POINTS TO BE SAMPLED FOR GLOBAL SUBROUTINE
c	NSEL,IPR,NSIG = PARAMETERS OF GLOBAL SUBROUTINE
c	NOP = THE DIMENSION OF THE PARAMETER SPACE
c	X0 = EACH ROW OF IT STORES PARAMETERS WITH OPTIMUM OBJECTIVE FUNCTION VALUES
c	F0 = OPTIMUM OBJECTIVE FUNCTION VALUES WHOSE PARAMETERS ARE STORED IN X0
c		(SEE GLOBAL SUBROUTINE FOR DETAILS)

	  PARAMETER(NOP=5)
	  real min(nop),max(nop)
	  character*19 outfile
	  data nsampl/150/
	  data m/10/
	  data nsel/2/
	  data ipr/6/
	  data nsig/5/
	  real X0(15,20),F0(20)


c	parameter boundary for search routine
	  data min/10.,0.5,1.0,4.0,0.1/
	  data max/50.,2.0,10.,20.,0.8/

	  external global

c	UNITS 7 AND 8 ARE FILES TO STORE THE LIST OF LOCAL MINIMA AND 
c	AND ITS ASSOCIATED VALUES OF OBJEVTIVE FUNCTION. 
c	OUTFILE RECORDS GLOBAL SUBROUTINE ACTIVITY DURING OPTIMIZATION STEP.

	outfile="trackL1e2.txt"	
	open(7,file='parm.l1e2')
	open(8,file='func.l1e2')
	open(ipr,file=outfile)
	
c	CALL GLOBAL ROUTINE FOR GLOBAL OPTIMIZATION
	call global(min,max,nop,m,nsampl,nsel,ipr,nsig,x0,nc,f0)

c	write the optimum objective values and parameter 
c	with optimum objective values.

	write(7,*) x0
	write(8,*) f0
	write(ipr,*)'MINIMUM',MIN
	write(ipr,*)'MAXIMUM',MAX
	write(ipr,*)'SOLUTION',f0(1)


      end

c	MAIN PROGRAM

c	ESTIMATING PARAMETERS OF BARTLETT-LEWIS(BL) MODEL WITH EXPONENTIAL 
c	STORM INTER-ARRIVAL TIME USING MULTIVARIATE NORMAL LIKELIHOOD
c	THE MULTIVARIATE NORMAL LIKELIHOOD IS USED
c	TO FIT THE FIRST AND SECOND ORDER PROPERTIES OF THE MODEL
c
c	LOGLIK = -0.5*N*LOG |DET(SIGMA)|-.5*TR(SIGMA^-1 OBSCOV)
c	WHERE: SIGMA IS THE THEORETICAL COV MATRIX

c	THE SIZE OF COVARIANCE MATRIX IS P X P WHERE P IS THE #HOURS
c	IN 1 TRACE. IN OUR CASE IS 72 HOURS.

      subroutine funct(p,func,nparm,m)
	PARAMETER(NUMHRS=72,MAXLEN=40920,MAXN=568,NP=72)
	character*19 infile
	real p(nparm),func
	real*4 actual(maxlen)
	double precision matrain(maxn,numhrs),model(maxlen),meansim
	double precision obscov(numhrs,numhrs),mean
	double precision out(numhrs,numhrs),cov(maxlen),theocov(numhrs)
	double precision modcov(numhrs,numhrs),inv(numhrs,numhrs)
	double precision fnlres,det,temp(numhrs,numhrs)
	integer indx(numhrs)
	real fixmin(5),fixmax(5)

c	LIST OF CALLED SUBROUTINES
	external bartlew
	external covar
	external matrix
	external quadfrm
	external meanfit
	external invert

c	parameter boundary for search routine (HAS TO BE THE SAME AS THE ONES IN MAIN PROGRAM)
	data fixmin/10.0,0.5,1.0,4.0,0.1/
	data fixmax/50.,2.0,10.0,20.,0.8/

c	INFILE contains the observed data
	LEN=40920	
	N=568
	INFILE="rain53jan.bin"


c	CHECKING IF THE CURRENT PARAMETERS OUT OF BOUNDARY, IF YES GIVE A PENALTY TO KEEP
c	THE SEARCH WITHIN THE SPECIFIED BOUNDARY

	do i=1,nparm
		if (p(i).gt.fixmax(i).OR.p(i).lt.fixmin(i)) then
			func=10000000+100*abs(p(i))
			goto 100
		endif
	enddo


	meansim=(p(2)/p(1))*(1+p(4)/p(5))/p(3)

	if (meansim.gt.1) then
		func=1000000000000
		goto 100
	endif


c	READ the observed data

		open(unit=14, file=infile, form='unformatted'
     &      ,recl=4*len,access='direct',status='OLD')

	read(14,rec=1) actual

	call matrix(actual,n,numhrs,matrain)


c	GENERATE THE RAINFALL DATA TO ESTIMATE THE MEAN AND COV FUNCTION

	 do i=1,len
		model(i)=0.
	 enddo

	call bartlew(p,len,model)

	meansim=0
	do i=1,len
		meansim=meansim+model(i)
	enddo
	meansim=meansim/len

c	THEORETICAL AND OBSERVED COV MATRICES ARE ASSUMED TO TOEPTLITZ
	indtoep=1

c	COMPUTE OBSERVED COV MATRIX
	call quadfrm(matrain,n,numhrs,obscov,meansim,indtoep)


c	COMPUTE THEORETICAL COV MATRIX
	call covar(len,model,numhrs,cov)


	do i=1,numhrs
		theocov(i)=cov(i)
	enddo

	call toep(theocov,modcov,numhrs)
	call invert(modcov,numhrs,NP,INDX,TEMP,INV,DET)

c	IF COV MATRIX IS SINGULAR, GIVE PENALTY TO THE OBJ FUNCTION VALUE, WE DON'T WANT SINGULAR COV MATRIX
	IF (DET.EQ.2.) THEN
		FUNC=1000000000000
		GO TO 100
	ENDIF


	call sumtr(inv,obscov,fnlres,numhrs)

c	SOMETIMES THE TRACE IS VERY BIG OR NEGATIVE IT CAN CAUSE OVERFLOW!!!
	if (fnlres.gt.1e12.OR.fnlres.le.0.) then
		func=1000000000000
		goto 100
	endif

c	COMPUTE THE NEGATIVE LOG-LIKELIHOOD 
	func= real(.5*n*(det)+.5*fnlres)

100	return
	end



