c SUBROUTINE TO ESTIMATE THE PARAMETERS OF MULTI-LAYER BARTLETT-LEWIS MODEL 
c WITH EXPONENTIAL STORM INTER-ARRIVAL TIME (SALIM AND PAWITAN, 2002) 
c THE ESTIMATION IS DONE USING ML METHOD BY ASSUMING THE DATA COME FROM A MULTIVARIATE NORMAL DISTRIBUTION.
c TO ESTIMATE MEAN AND COVARIANCE FUNCTION OF EACH SET OF PARAMETERS WE USE MONTE-CARLO INFERENCE
c BY GENERATING RAINFALL DATA (TYPICALLY OVER 40 YRS) ACCORDING TO BL MODEL.

c	INPUT: MIN, MAX = BOUNDARY FOR SEARCHING THE ESTIMATES
c	NSAMPL = NUMBER OF POINTS IN THE PARAMETER SPACE TO BE SAMPLED BY GLOBAL SUBROUTINE
c	NSEL,IPR,NSIG = PARAMETERS OF GLOBAL SUBROUTINE
c	NOP = THE DIMENSION OF THE PARAMETER SPACE
c	X0 = EACH ROW OF IT STORES PARAMETERS WITH OPTIMUM OBJECTIVE FUNCTION VALUES
c	F0 = OPTIMUM OBJECTIVE FUNCTION VALUES WHOSE PARAMETERS ARE STORED IN X0
c		(SEE GLOBAL SUBROUTINE FOR DETAILS)

	  PARAMETER(NOP=7)
	  character*19 outfile
	  real min(nop),max(nop)
	  data m/10/
	  data nsampl/1000/
	  data nsel/2/
	  data ipr/6/
	  data nsig/5/
	  real X0(15,20),F0(20)

c	parameter boundary for search routine
	data min/100.0,0.3,3.0,0.01,0.006,3.0,0.2/
	data max/180.0,2.0,15.,0.20,0.020,15.,1.0/


	external global

c	WE ANALYSE DATA FROM EACH MONTH SEPARATELY.
c	'M' IS INDICATOR FOR THE SITE WE WANT TO ANALYSE,
c	M = 1 IS VALENTIA, 2 IS BELMULLET.

c	UNITS 7 AND 8 ARE FILES TO STORE THE LIST OF LOCAL MINIMA AND 
c	AND ITS ASSOCIATED VALUES OF OBJEVTIVE FUNCTION. 
c	OUTFILE RECORDS GLOBAL SUBROUTINE ACTIVITY DURING OPTIMIZATION STEP.

	DO 10 M=2,2
		IF (M.EQ.1) THEN
			outfile="trackL1e3.val"	
			open(7,file='parm.L1e3val')
			open(8,file='func.L1e3val')
		ELSE IF (M.EQ.2) THEN
			outfile="trackL1e3.bel"	
			open(7,file='parm.L1e3bel')
			open(8,file='func.L1e3bel')
		ENDIF


	open(ipr,file=outfile)

c	CALL GLOBAL ROUTINE FOR GLOBAL OPTIMIZATION
	 call global(min,max,nop,m,nsampl,nsel,ipr,nsig,x0,nc,f0)

c	write the optimum objective values and parameter 
c	with optimum objective values.

	write(7,*) x0
	write(8,*) f0
	write(ipr,*)'MINIMUM',MIN
	write(ipr,*)'MAXIMUM',MAX
	write(ipr,*)'SOLUTION',f0(1)

10	ENDDO 

      end

c 	MAIN PROGRAM

c	ESTIMATING 3 LAYERS BL MODEL USING MULTIVARIATE NORMAL LIKELIHOOD
c	THE MULTIVARIATE NORMAL LIKELIHOOD WAS USED
c	TO FIT THE FIRST AND SECOND ORDER PROPERTIES OF THE MODEL
c
c	WISHART LOGLIK = -0.5*N*LOG |DET(SIGMA)|-.5*TR(SIGMA^-1 OBSCOV)
c	WHERE: SIGMA IS THE THEORETICAL COV MATRIX
	
c	THE SIZE OF COVARIANCE MATRIX IS P X P WHERE P IS THE #HOURS
c	IN 1 TRACE. IN OUR CASE IS 72 HOURS.
  
	subroutine funct(p,func,nparm,m)
	PARAMETER(NUMHRS=72,MAXLEN=40920,MAXN=568,NP=72)
	character*19 infile
	real p(nparm),func
	real*4 actual(maxlen)
	double precision matrain(maxn,numhrs),model(maxlen),meansim
	double precision obscov(numhrs,numhrs),mean(numhrs)
	double precision out(numhrs,numhrs),cov(maxlen),theocov(numhrs)
	double precision modcov(numhrs,numhrs),inv(numhrs,numhrs)
	double precision fnlres,det,temp(numhrs,numhrs)
	integer indx(numhrs)
	real fixmin(7),fixmax(7)

c	LIST OF CALLED SUBROUTINES
	external exp3lyr
	external covar
	external matrix
	external quadfrm
	external meanfit
	external invert


c	parameter boundary for search routine (HAS TO BE THE SAME AS THE ONES IN MAIN PROGRAM)
	data fixmin/100.0,0.3,3.0,0.01,0.006,3.0,0.2/
	data fixmax/180.0,2.0,15.,0.20,0.020,15.,1.0/


c	WE ANALYSE THE DATA FROM EACH MONTH SEPARATELY.
c	INFILE contains the observed data

	 IF (M.EQ.1) THEN
			LEN=40920	
			N=568
			INFILE="rain53jan.bin"
	 ELSE IF (M.EQ.2) THEN
			LEN=29760
			N=413
			INFILE="rain76mar.bin"
	 ENDIF


c	TO MAKE THE GLOBAL SEARCH EASIER IF THE SIMULATED MEAN FOR A PARTICULAR SET OF PARAMETERS
c	IS VERY DIFFERENT FROM THE OBSERVED MEAN,
c	WE DECIDE TO GIVE A PENALTY TO THE OBJECTIVE FUNCTION SO THAT THE PARTICULAR PARAMETERS WILL
c	BE IGNORED IN GLOBAL SEARCH PROCESS.

	meansim=(p(2)/p(1))*(1+p(4)/p(5))*(p(6)/p(7))/p(3)

	if (meansim.gt.1) then
		func=1000000000000
		goto 100
	endif


c	CHECKING IF THE CURRENT PARAMETERS OUT OF BOUNDARY, IF YES GIVE A PENALTY TO KEEP
c	THE SEARCH WITHIN THE SPECIFIED BOUNDARY

	do i=1,nparm
		if (p(i).gt.fixmax(i).OR.p(i).lt.fixmin(i)) then
			func=10000000+100*abs(p(i))
			goto 100
		endif
	enddo


c	READ the observed data
	open(unit=14, file=infile, form='unformatted'
     &      ,recl=4*len,access='direct',status='OLD')


	read(14,rec=1) actual

	call matrix(actual,n,numhrs,matrain)

c	GENERATE THE RAINFALL DATA TO ESTIMATE MEAN AND COV FUNCTION
	do i=1,len
		model(i)=0.
	enddo

	call EXP3LYR(p,len,model)

	meansim=0
	do i=1,len
		meansim=meansim+model(i)
	enddo

	meansim=meansim/len
	if (meansim.gt.1) then
		func=1000000000000
		goto 100
	endif

c	THEORETICAL AND OBSERVED COV MATRIX IS ASSUMED TO BE TOEPTLITZ
	indtoep=1

c	COMPUTE OBSERVED COV MATRIX
	call quadfrm(matrain,n,numhrs,obscov,meansim,indtoep)

c	COMPUTE THEORETICAL COV MATRIX
	call covar(len,model,numhrs,cov)
		
	do i=1,numhrs
		theocov(i)=cov(i)
	enddo

	call toep(theocov,modcov,numhrs)
	call invert(modcov,numhrs,NP,INDX,TEMP,INV,DET)

c	IF MATRIX IS SINGULAR, GIVE PENALTY TO THE OBJ FUNCTION VALUE, WE DON'T WANT SINGULAR COV MATRIX
	IF (DET.EQ.2.) THEN
		FUNC=1000000000000
		GO TO 100
	ENDIF

	call sumtr(inv,obscov,fnlres,numhrs)

	if (fnlres.gt.1e20.OR.fnlres.le.0.) then
		func=1000000000000
		goto 100
	endif

c	COMPUTE THE NEGATIVE LOG-LIKELIHOOD 
	func= real(.5*n*(det)+.5*fnlres)
100	return
	end



