c SUBROUTINE TO ESTIMATE PARAMETERS OF A MULTI-LAYER BARTLETT-LEWIS MODEL WITH EXPONENTIAL 
c STORM INTER-ARRIVAL TIME(SALIM AND PAWITAN, 2002).
c THE ESTIMATION IS DONE USING ML METHOD BY USING THE WHITTLE LIKELIHOOD. 

c TO ESTIMATE THE THEORETICAL SPECTRUM FOR A PARTICULAR SET OF PARAMETERS 
c WE GENERATE RAINFALL DATA (TYPICALLY OVER 40 YRS) ACCORDING TO MODEL AND
c THE SPECTRUM ESTIMATE IS COMPUTED AS A FUNCTION OF THE COVARIANCE ESTIMATES
c OBTAINED FROM SIMULATED DATA.

c	INPUT: MIN, MAX = BOUNDARY FOR SEARCHING THE ESTIMATES
c	NSAMPL = NUMBER OF POINTS IN THE PARAMETER SPACE TO BE SAMPLED BY GLOBAL SUBROUTINE
c	NSEL,IPR,NSIG = PARAMETERS OF GLOBAL SUBROUTINE
c	NOP = THE DIMENSION OF THE PARAMETER SPACE
c	X0 = EACH ROW OF IT STORES PARAMETERS WITH OPTIMUM OBJECTIVE FUNCTION VALUES
c	F0 = OPTIMUM OBJECTIVE FUNCTION VALUES WHOSE PARAMETERS ARE STORED IN X0
c		(SEE GLOBAL SUBROUTINE FOR DETAILS)

	  PARAMETER(NOP=8)
	  character*19 outfile
	  real min(nop),max(nop)
	  data m/10/
	  data nsampl/2500/
	  data nsel/2/
	  data ipr/6/
	  data nsig/5/
	  real X0(15,20),F0(20)

c	parameter boundary for search routine
	data min/0.015,130.0,0.5,3.0,0.01,0.006,3.0,0.2/
	data max/0.020,200.0,2.0,15.,0.20,0.020,15.,1.0/

	external global


c	UNITS 7 AND 8 ARE FILES TO STORE THE LIST OF LOCAL MINIMA AND 
c	AND ITS ASSOCIATED VALUES OF OBJEVTIVE FUNCTION. 
c	OUTFILE RECORDS GLOBAL SUBROUTINE ACTIVITY DURING OPTIMIZATION STEP.

	outfile="trackL2p3.txt"	
	open(7,file='parm.l2p3')
	open(8,file='func.l1p3')
	open(ipr,file=outfile)

c	CALL GLOBAL ROUTINE FOR GLOBAL OPTIMIZATION	
	call global(min,max,nop,m,nsampl,nsel,ipr,nsig,x0,nc,f0)

c	write the list of local minima and its associated values of 
c     objective function.

	write(7,*) x0
	write(8,*) f0
	write(ipr,*)'MINIMUM',MIN
	write(ipr,*)'MAXIMUM',MAX
	write(ipr,*)'SOLUTION',f0(1)

      end

c	  ESTIMATING THE PARAMETERS OF MULTI-LAYER BARTLETT-LEWIS (BL) RAINFALL MODEL WITH 
c	  PARETO STORM INTER-ARRIVAL (SALIM AND PAWITAN,2003). 
c	  THE WHITTLE LIKELIHOOD WAS USED TO ESTIMATE THE PARAMETERS

      subroutine funct(p,func,nparm,m)
	PARAMETER(NMAX=40920)
	character*19 infile
	real P(nparm),func,fixmin(8),fixmax(8)
	INTEGER LAG
	DOUBLE PRECISION RAIN(NMAX),COV(NMAX)
	REAL*4 ACTUAL(NMAX),DATA(NMAX),DATA2(NMAX)
	real*4 xc(NMAX)
	DOUBLE PRECISION mean,meansim
	real*4 wsave(4*NMAX+15),periodo(NMAX),spec(NMAX)   
	complex xc2(NMAX)                 

c LIST OF CALLED SUBROUTINES (incl those to perform FFT)   
	external prt3lyr
	external covar
	external cfftf
	external rffti
	external rfftf

c	INFILE contains the observed data in binary format.
	N=40920
	INFILE="rain53jan.bin"


c	CHECKING IF THE CURRENT PARAMETERS OUT OF BOUNDARY, IF YES GIVE A PENALTY TO KEEP
c	THE SEARCH WITHIN THE SPECIFIED BOUNDARY

	data fixmin/0.015,130.0,0.5,3.0,0.01,0.006,3.0,0.2/
	data fixmax/0.020,200.0,2.0,15.,0.20,0.020,15.,1.0/

	do i=1,nparm
		if (p(i).gt.fixmax(i).OR.p(i).lt.fixmin(i)) then
			func=10000000000+100*abs(p(i))
			goto 100
		endif
	enddo

	meansim=(p(3)/p(2))*(1+p(5)/p(6))*(p(7)/p(8))/p(4)

	if (meansim.gt.1) then
		func=1000000000000
		goto 100
	endif

c READ THE OBSERVED DATA
	open(unit=14, file=infile, form='unformatted'
     &      ,recl=4*n,access='direct',status='OLD')

	read(14,rec=1) actual
					
	mean=0
	do i=1,n
		mean=mean+actual(i)
	enddo

	mean=mean/n

	do i=1,n
		rain(i)=0
	enddo
		
c	GENERATE THE RAINFALL DATA TO ESTIMATE THE THEORETICAL MEAN AND COV MATRIX
	call prt3lyr(p,N,RAIN)
		
	meansim=0.
	do i=1,n
		meansim=meansim+rain(i)
	enddo

	meansim=meansim/n

c SPECIFY LAG IN THE COVARIANCE FUNCTION TO BE USED TO COMPUTE THE THEORETICAL LOG SPECTRUM.
	lag=16
	
	call covar(n,rain,lag,cov)

	read(14,rec=1) actual


c Transfer values and Compute
c  xc is the covariance
c  xc2 is the real rainfall

        do i=1,N 
		xc(i) =REAL(COV(i))
		xc2(i)=cmplx(ACTUAL(i))
	enddo

C COMPUTE THE PERIODOGRAM
	call cffti(N,wsave)
	call cfftf(N,xc2,wsave)

        do i=1,n 
		periodo(i)= abs(xc2(i))*abs(xc2(i))/n
	enddo
	  
c COMPUTE AND TRANSFER THE SPECTRUM VALUE	  
	call rffti(n,wsave)
      call rfftf(n,xc,wsave) 

	do i=1,n
		xc(i)=real(xc(i))
	enddo
	
	spec(1)=xc(1)

	do i=2,(n/2+1)
		spec(i)=xc(2*i-2)
	enddo
	  
	do i=1,(n/2-1)
		spec(i+n/2+1)=spec(n/2+1-i)
	enddo	   

C COMPUTE THE OBJECTIVE FUNCTION
	func=(log(abs(spec(1)))+(N*(mean-meansim)**2/abs(spec(1))))

	do i=2,n

c IF THE SPECTRUM ESTIMATES IS 0, GIVE A VERY SMALL VALUES TO AVOID DIVISION BY ZERO.
	if (spec(i).EQ.0) then
		spec(i)=1e-20
	endif
	func=func+(log(abs(spec(i)))+(periodo(i)/abs(spec(i))))
	enddo
c ALSO IF THE OBJECTIVE FUNCTION IS RIDICOULUSLY SMALL, GIVE PENALTY
	if (func.lt.-100000000) then
		func=1e12
	endif

100	return
	end



