      REAL FUNCTION UNIDEV(IX,IY,IZ)                                      
         IX = MOD(171*IX , 30269)                                    
         IY = MOD(172*IY , 30307)                                    
         IZ = MOD(170*IZ , 30323)                                    
         UNIDEV = AMOD(FLOAT(IX)/30269.0 + FLOAT(IY)/30307.0 +       
     +            FLOAT(IZ)/30323.0, 1.0)                            
      RETURN                                                         
      END     

	SUBROUTINE UNIF(IX,IY,IZ,N,OUT)
	EXTERNAL UNIDEV
	real OUT(N)

	DO I=1,N
		OUT(I)=UNIDEV(IX,IY,IZ)
	ENDDO
	RETURN
	END

	FUNCTION POIDEV(XM,IX,IY,IZ)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	PARAMETER (PI=3.141592654)
	real UNIDEV
	DOUBLE PRECISION GAMMLN
	DATA OLDM/-1./
	IF (XM.LT.12.) THEN
c		IF (XM.NE.OLDM) THEN
			OLDM=XM
			G=EXP(-XM)
c		ENDIF
		EM=-1
		T=1.
 2		EM=EM+1
		T=T*DBLE(UNIDEV(IX,IY,IZ))	
		IF (T.GT.G) GO TO 2
	ELSE
c		IF (XM.NE.OLDM) THEN
			OLDM=XM
			SQ=SQRT(2.*XM)
			ALXM=DLOG(XM)
			G=XM*ALXM-GAMMLN(XM+1.)
c		ENDIF
 1		Y=TAN(PI*DBLE(UNIDEV(IX,IY,IZ)))
		EM=SQ*Y+XM
		IF (EM.LT.0.) GO TO 1
		EM=IDINT(EM)
		T=0.9*(1.+Y**2)*EXP(EM*ALXM-GAMMLN(EM+1.)-G)
		IF (UNIDEV(IX,IY,IZ).GT.T) GO TO 1
	ENDIF
	POIDEV=EM
	RETURN
	END
	                                                       
	SUBROUTINE POIS(XM,IX,IY,IZ,N,OUT)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	DOUBLE PRECISION POIDEV
	EXTERNAL POIDEV
	DOUBLE PRECISION OUT(N)

	DO I=1,N
		OUT(I)=POIDEV(XM,IX,IY,IZ)
	ENDDO
	RETURN
	END


	double precision function gammln(xx)
c ********* return ln(gamma(xx)) for xx>0. 
	implicit double precision (a-h,o-z)
	dimension cof(6)
	data cof,stp/76.18009173d0,-86.50532033d0,24.01409822d0,
     *       -1.231739516d0,.120858003d-2,-.536382d-5,2.50662827465d0/
	data half,one,fpf,pi/0.5d0,1.0d0,5.5d0,3.14159265d0/
	if (xx .lt. one) then
            x = one - xx
	else
            x = xx - one
	endif
	tmp = x + fpf
	tmp= (x+half)*log(tmp) - tmp
	ser = one
	do 11 j=1,6
	    x=x+one
	    ser =ser+cof(j)/x
 11	continue
	gammln = tmp + log(stp*ser)
c
c for xx < 1
c
	pix  = pi*(one-xx)
	sinpix = sin(pix)
	if (xx .lt. one)  then
	  gammln=log(pix)-gammln-log(sinpix)
	endif 
	return
	end


C FUNC. FOR GENERATING NORMAL VARIATE

	DOUBLE PRECISION FUNCTION GASDEV(IX,IY,IZ)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	REAL UNIDEV

	DATA ISET/0/
	SAVE ISET,GSET
	IF (ISET.EQ.0) THEN
 11		V1=2*DBLE(UNIDEV(IX,IY,IZ))-1
		V2=2*DBLE(UNIDEV(IX,IY,IZ))-1
		R=V1**2+V2**2
		IF (R.GE.1..OR.R.EQ.0.) GO TO 11
		FAC=SQRT(-2*DLOG(R)/R)
		GSET=V1*FAC
		GASDEV=V2*FAC
		ISET=1
	ELSE
		GASDEV=GSET
		ISET=0
	ENDIF
	RETURN
	END


	SUBROUTINE NORM(IX,IY,IZ,N,OUT)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	EXTERNAL GASDEV
	DOUBLE PRECISION OUT(N)

	DO I=1,N
		OUT(I)=DBLE(GASDEV(IX,IY,IZ))
	ENDDO
	RETURN
	END



      DOUBLE PRECISION FUNCTION ZBQLGAM(G,H,IX,IY,IZ)
*
*       Returns a random number with a gamma distribution with mean
*       G/H and variance G/(H^2). (ie. shape parameter G & scale
*       parameter H)
*

      REAL UNIDEV	
      DOUBLE PRECISION C,D,R,G,H,A,z1,z2,B1,B2,M
      DOUBLE PRECISION U1,U2,U,V,TEST,X
      double precision c1,c2,c3,c4,c5,w
      INTEGER IX,IY,IZ	

      ZBQLGAM = 0.0

      IF ( (G.LE.0.0D0).OR.(H.LT.0.0D0) ) THEN
       WRITE(*,1)
       RETURN
      ENDIF

      IF (G.LT.1.0D0) THEN
889    u=DBLE(UNIDEV(IX,IY,IZ))
       v=DBLE(UNIDEV(IX,IY,IZ))
       if (u.gt.exp(1.0d0)/(g+exp(1.0d0))) goto 891
       ZBQLGAM=((g+exp(1.0d0))*u/exp(1.0d0))**(1.0d0/g)
       if (v.gt.exp(-ZBQLGAM)) then
        goto 889
       else
        goto 892
       endif
891    ZBQLGAM=-log((g+exp(1.0d0))*(1.0d0-u)/(g*exp(1.0d0)))
       if (v.gt.ZBQLGAM**(g-1.0)) goto 889
892    ZBQLGAM=ZBQLGAM/h
       RETURN
      ELSEIF (G.LT.2.0D0) THEN
       M = 0.0D0
      elseif (g.gt.10.0d0) then
       c1=g-1.0d0
       c2=(g-1.0d0/(6.0d0*g))/c1
       c3=2.0d0/c1
       c4=c3+2.0d0
       c5=1.0d0/sqrt(g)
777    u=DBLE(UNIDEV(IX,IY,IZ))
       v=DBLE(UNIDEV(IX,IY,IZ))
       if (g.gt.2.50d0) then
        u=v+c5*(1.0d0-1.860d0*u)
       endif 
       if (u.le.0.0d0.or.u.ge.1.0d0) goto 777 
       w=c2*v/u 
       if (c3*u+w+1.0d0/w.le.c4) goto 778 
       if (c3*log(u)-log(w)+w.ge.1.0d0) goto 777
778    ZBQLGAM=c1*w/h 
       return
      ELSE
       M = -(G-2.0D0) 
      ENDIF
      R = 0.50D0
      a = ((g-1.0d0)/exp(1.0d0))**((g-1.0d0)/(r+1.0d0))
      C = (R*(M+G)+1.0D0)/(2.0D0*R)
      D = M*(R+1.0D0)/R
      z1 = C-DSQRT(C*C-D)
      z2 = C+DSQRT(C*C-D)
      B1=(z1*(z1-M)**(R*(G-1.0D0)/(R+1.0D0)))*DEXP(-R*(z1-M)/(R+1.0D0))
      B2=(z2*(z2-M)**(R*(G-1.0D0)/(R+1.0D0)))*DEXP(-R*(z2-M)/(R+1.0D0))
50    U1=DBLE(UNIDEV(IX,IY,IZ))
      U2=DBLE(UNIDEV(IX,IY,IZ))
      U=A*U1
      V=B1+(B2-B1)*U2
      X=V/(U**R)
      IF (X.LE.M) GOTO 50
      TEST = ((X-M)**((G-1)/(R+1)))*EXP(-(X-M)/(R+1.0D0))
      IF (U.LE.TEST) THEN
       ZBQLGAM = (X-M)/H
      ELSE
       GOTO 50
      ENDIF
 1    FORMAT(/5X,'****ERROR**** Illegal parameter value in ',
     +' ZBQLGAM',/5X, '(both parameters must be positive)',/)
      RETURN
      END
***************************************************************


