c FORTRAN PROGRAM FOR GENERATING RAINFALL DATA BASED ON BARTLETT-LEWIS MODEL
c WITH EXPONENTIAL STORM INTER-ARRIVAL TIME (SALIM AND PAWITAN,2002).

	SUBROUTINE BARTLEW(PARM,N,RAIN)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c VARIABLES:
c	PARM(5) = THE PARAMETERS OF THE MODEL
c		(1)= THE MEAN OF STORM INTER-ARRIVAL TIME (EXP)
c		(2)= MEAN CELL INTENSITY (EXP)
c		(3)= 1/MEAN CELL DURATION (EXP)
c		(4)= RATE OF RAINCELL/STOTM (POISSON)
c		(5)= 1/MEAN LENGTH OF STORM (EXP)

c	POSTORM(N) = POSITION OF THE STORMS
c	NSTORM	 = NUMBER OF STORMS TO BE SIMULATED
c	CLDPOST	 = POSITION OF RAINCELLS INSIDE A STORM
c	CHILD    = NUMBER OF RAINCELLS INSIDE A STORM
c	LENGTH	 = LENGTH OF STORM
c	IX,IY,IZ = SEED FOR RND NUMBER GENERATION
c	N = LENGTH OF RAINFALL DATA TO BE GENERATED
c	RAIN(N)  = OUTPUT VECTOR CONTAINS SIMULATED RAINFALL DATA

c EXTERNAL SUBROUTINES NEEDED
c	UNIDEV = GENERATE UNIFORM (0,1) R.V.
c	POIDEV = GENERATE POISSON R.V.		
	
	REAL PARM(5)
	DOUBLE PRECISION RAIN(N),POSTORM(N)
	INTEGER N,NSTORM
	
	REAL UNIDEV
	EXTERNAL UNIDEV
	EXTERNAL POIDEV
	
	INTEGER CHILD,IX,IY,IZ,P
	DOUBLE PRECISION LENGTH,INTENS(5000)
	DOUBLE PRECISION DURAT(5000),CLDPOST(5000)
	DOUBLE PRECISION FINISH(5000)


c SEED FOR RANDOM NUMBER GENERATION
	ix=10
	iy=11
	iz=12

c START GENERATING RAINFALL DATA
	I=1
	POSTORM(1)=1
	
 10	IF (POSTORM(I).LT.(N+1)) THEN
		POSTORM(I+1)=POSTORM(I)-PARM(1)*DLOG(1-DBLE(UNIDEV(IX,IY,IZ)))
		I=I+1
		GO TO 10
	ENDIF

		
	NSTORM=I-1

c FOR EACH STORM GENERATE THE FOLLOWING:
c (1) LENGTH OF STORM
c (2) NO. OF RAINCELLS INSIDE THE STORM

	DO I=1,NSTORM
	   LENGTH=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(5)	
	   CHILD=IDINT(POIDEV(PARM(4)*LENGTH,IX,IY,IZ))
	   DURAT(1)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(3)
	   INTENS(1)=-PARM(2)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
	   CLDPOST(1)=POSTORM(I) 
	   FINISH(1)=CLDPOST(1)+DURAT(1)	

  	   IF (CHILD.LT.1) GO TO 11	

c FOR EACH RAINCELL, GENERATE THE FOLLOWING:
c (1) DURATION OF THE RAINCELL
c (2) INTENSITY OF THE RAINCELL

	   DO J=2,CHILD+1
		DURAT(J)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(3)			   	
		INTENS(J)=-PARM(2)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
      			  
		CLDPOST(J)=CLDPOST(1)+DBLE(UNIDEV(IX,IY,IZ))*LENGTH
		FINISH(J)=CLDPOST(J)+DURAT(J)
		IF (FINISH(J).GT.(N+1)) GO TO 20
	   ENDDO

 
c FILLED-IN THE RAIN

 11	   DO 12 J=1,CHILD+1	

		IF (FINISH(J).GT.(N+1)) THEN
			FINISH(J)=N+0.99
		ENDIF

		IF (CLDPOST(J).GT.(N+1)) THEN
			CLDPOST(J)=N+0.9
		ENDIF
c IF THE RAINCELL DOES NOT GO OVER THE HOUR
	      	IF ((FINISH(J)-IDINT(CLDPOST(J))).LE. 1.0) THEN
                	K=IDINT(CLDPOST(J))
          		RAIN(K)=RAIN(K)+(INTENS(J)*DURAT(J))  
c IF RAINCELL FINISHES AT THE NEXT HOUR
		ELSE
     			K=IDINT(CLDPOST(J))
     			P=IDINT(FINISH(J))
			RAIN(K)=RAIN(K)+(INTENS(J)*(1.0-(CLDPOST(J)-K)))
			IF (P.gt.N) THEN 
			   P=N
			ENDIF
			IF((K+1).gt.P) GO TO 13

			DO M=(K+1),P
			   RAIN(M)=DBLE(RAIN(M))+INTENS(J)
			ENDDO
			RAIN(P)=RAIN(P)-(1.0-FINISH(J)+P)*INTENS(J)
 13		ENDIF
 12        ENDDO
      ENDDO
c END OF FILLED-IN PROCESS
 20   RETURN
      END		


