c FORTRAN PROGRAM FOR GENERATING RAINFALL DATA BASED ON MULTI-LAYER BARTLETT-LEWIS MODEL
c WITH EXPONENTIAL STORM INTER-ARRIVAL TIME (SALIM AND PAWITAN,2002).

	SUBROUTINE EXP3LYR(PARM,N,RAIN)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c VARIABLES:
c	PARM(7) = THE PARAMETERS OF THE MODEL
c		(1)= MEAN OF STORM INTER-ARRIVAL TIME (EXP)
c		(2)= MEAN RAINCELL INTENSITY (EXP)
c		(3)= 1/MEAN RAINCELL DURATION (EXP)
c		(4)= RATE OF SUB-STORM/STORM (POISSON)
c		(5)= 1/MEAN LENGTH OF STORM (EXP)
c		(6)= RATE OF RAINCELL/SUB-STORM (POISSON)
c		(7)= 1/MEAN LENGTH OF SUB-STORM (EXP)

c	POSTORM(N)	= POSITION OF THE STORMS
c	NSTORM	= NUMBER OF STORMS TO BE SIMULATED
c	CLDPOS	= POSITION OF SUB-STORMS INSIDE A STORM
c	CELLPOS	= POSITION OF RAINCELLS INSIDE A SUB-STORM
c	CHILD 	= NUMBER OF SUB-STORM INSIDE A STORM
c	CELL	= NUMBER OF CELLS INSIDE A SUB-STORM
c	LENGTH	= LENGTH OF STORM
c	LENCLD	= LENGTH OF A SUB-STORM INSIDE A STORM
c	IX,IY,IZ= SEED FOR RND NUMBER GENERATION
c	N	= LENGTH OF RAINFALL DATA TO BE GENERATED
c	RAIN(N)	= OUTPUT VECTOR CONTAINS SIMULATED RAINFALL DATA

c EXTERNAL SUBROUTINES NEEDED
c	UNIDEV = GENERATE UNIFORM (0,1) R.V.
c	POIDEV = GENERATE POISSON R.V.	
	

	REAL PARM(7)
	DOUBLE PRECISION RAIN(N),POSTORM(N)
	INTEGER N,NSTORM

	DOUBLE PRECISION CELLPOS(5000),CLDPOS(5000)
	DOUBLE PRECISION LENGTH,LENCLD
	
	REAL UNIDEV
	EXTERNAL UNIDEV
	EXTERNAL POIDEV
	
	INTEGER CHILD,CELL,IX,IY,IZ,P
	DOUBLE PRECISION INTENS(5000)
	DOUBLE PRECISION DURAT(5000)
	DOUBLE PRECISION FINISH(5000)


c SEED FOR RANDOM NUMBER GENERATION
	ix=10
	iy=11
	iz=12

c START GENERATING RAINFALL DATA
	I=1
	POSTORM(1)=1
	
 10	IF (POSTORM(I).LT.(N+1)) THEN
		U=UNIDEV(IX,IY,IZ)
		POSTORM(I+1)=POSTORM(I)-PARM(1)*DLOG(1-U)
		I=I+1
		GO TO 10
	ENDIF

		
	NSTORM=I-1

c FOR EACH STORM GENERATE THE FOLLOWING:
c (1) LENGTH OF STORM
c (2) NO. OF SUB-STORM


	DO 13 I=1,NSTORM
	   LENGTH=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(5)	
	   CHILD=1+IDINT(POIDEV(PARM(4)*LENGTH,IX,IY,IZ))
  	   IF (CHILD.LT.1) GO TO 13

c THERE IS A SUB-STORM ASSOCIATED WITH STORM ORIGIN.
	   
	   CLDPOS(1)=POSTORM(I)

c FOR EACH SUB-STORM, GENERATE THE FOLLOWING:
c (1) LENGTH OF SUB-STORM
c (2) NO. OF RAINCELLS INSIDE THE SUB-STORM
	   DO 12 L=1,CHILD

	   	LENCLD=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(7)
		CELL=IDINT(POIDEV(PARM(6)*LENCLD,IX,IY,IZ))

		IF (CELL.LT.1) GO TO 12

c FOR EACH RAINCELL, GENERATE THE FOLLOWING:
c (1) DURATION OF THE RAINCELL
c (2) INTENSITY OF THE RAINCELL
		DURAT(1)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(3)			   	
		INTENS(1)=-PARM(2)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
      			  
		CELLPOS(1)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
		FINISH(1)=CELLPOS(1)+DURAT(1)

		IF (CELL.GT.1) THEN
			DO K=2,CELL
				CELLPOS(K)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
				DURAT(K)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(3)
				INTENS(K)=-PARM(2)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
     				FINISH(K)=CELLPOS(K)+DURAT(K)
			ENDDO
		ENDIF
 
c BEGIN TO "FILLED-IN" THE RAINFALL

 			DO 11 J=1,CELL	
			   IF (FINISH(J).GT.(N+1)) THEN
			      FINISH(J)=N+0.99
			   ENDIF

			   IF (CELLPOS(J).GT.(N+1)) THEN
			      CELLPOS(J)=N+0.99
			   ENDIF

c IF THE RAINCELL DOES NOT GO OVER THE HOUR
			   IF ((FINISH(J)-IDINT(CELLPOS(J))).LE. 1.0) THEN
			      K=IDINT(CELLPOS(J))
			      RAIN(K)=RAIN(K)+(INTENS(J)*DURAT(J))  
c IF RAINCELL FINISHES AT THE NEXT HOUR
			   ELSE
     			      K=IDINT(CELLPOS(J))
     			      P=IDINT(FINISH(J))
 			      RAIN(K)=RAIN(K)+(INTENS(J)*(1.0-CELLPOS(J)+K))
			      IF (P.gt.N) THEN 
				P=N
			      ENDIF

			      IF ((K+1).gt.P) GO TO 14
       			      DO M=(K+1),P					  
      			         RAIN(M)=RAIN(M)+INTENS(J)
       			      ENDDO 
       			      RAIN(P)=RAIN(P)-(1.0-FINISH(J)+P)*INTENS(J)
 14      	     	   ENDIF
c END OF FILLED-IN PROCESS
 11			ENDDO
c DETERMINE POSITION OF THE NEXT SUB-STORM
	   	CLDPOS(L+1)=POSTORM(I)+DBLE(UNIDEV(IX,IY,IZ))*LENGTH
 12	   ENDDO
 13	ENDDO 
 20   RETURN
      END		


