c FORTRAN PROGRAM FOR GENERATING RAINFALL DATA BASED ON 
c NON-HOMOGENEOUS MULTI-LAYER BARTLETT-LEWIS MODEL
c WITH EXPONENTIAL STORM INTER-ARRIVAL TIME. 
c THE MEAN STORM INTER-ARRIVAL TIME IS FUNCTION OF A COVARIATE 
c (SALIM AND PAWITAN,2002).

c IF LAMBDA(T) IS THE MEAN STORM INTER-ARRIVAL TIME AT TIME T, THEN
c LAMBDA(T) = EXP(B0 + B1 X(T) ), WHERE X(T) IS THE EXTERNAL COVARIATE

	SUBROUTINE EXP3LYRNH(PARM,N,RAIN,XVAR)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c VARIABLES:
c	PARM(8) = THE PARAMETERS OF THE MODEL
c		(1)= B0 PARAMETER (SEE ABOVE)
c		(2)= B1 PARAMETER (SEE ABOVE)
c		(3)= MEAN RAINCELL INTENSITY (EXP)
c		(4)= 1/MEAN RAINCELL DURATION (EXP)
c		(5)= RATE OF SUB-STORM/STORM (POISSON)
c		(6)= 1/MEAN LENGTH OF STORM (EXP)
c		(7)= RATE OF RAINCELLS/SUB-STORM (POISSON)
c		(8)= 1/MEAN LENGTH OF SUB-STORM (EXP)
c	POSTORM(N)	= POSITION OF THE STORMS
c	NSTORM	= NUMBER OF STORMS TO BE SIMULATED
c	CLDPOS	= POSITION OF SUB-STORMS INSIDE A STORM
c	CELLPOS	= POSITION OF RAINCELLS INSIDE A SUB-STORM
c	CHILD 	= NUMBER OF SUB-STORM INSIDE A STORM
c	CELL	= NUMBER OF CELLS INSIDE A SUB-STORM
c	LENGTH	= LENGTH OF STORM
c	LENCLD	= LENGTH OF A SUB-STORM INSIDE A STORM
c	IX,IY,IZ= SEED FOR RND NUMBER GENERATION
c	N	= LENGTH OF RAINFALL DATA TO BE GENERATED
c	RAIN(N)	= OUTPUT VECTOR CONTAINS SIMULATED RAINFALL DATA
c	XVAR(N) = EXTERNAL COVARIATE 

c EXTERNAL SUBROUTINES NEEDED
c	UNIDEV = GENERATE UNIFORM (0,1) R.V.
c	POIDEV = GENERATE POISSON R.V.	

	REAL PARM(8)
	DOUBLE PRECISION RAIN(N),POSTORM(N)
	INTEGER N,NSTORM
	REAL*4 XVAR(N)


	DOUBLE PRECISION CELLPOS(500),CLDPOS(500)
	DOUBLE PRECISION LENGTH,LENCLD
	
	REAL UNIDEV
	EXTERNAL UNIDEV
	EXTERNAL POIDEV
	
	INTEGER CHILD,CELL,IX,IY,IZ,P
	DOUBLE PRECISION INTENS(500)
	DOUBLE PRECISION DURAT(500)
	DOUBLE PRECISION FINISH(500)

c PARAMETER BOUND; LOWER BOUND OF PARAMETER SPACES WHICH WE BELIEVE IS PLAUSIBLE
	IF (PARM(1).LT.4.0) PARM(1)=4.
	IF (PARM(2).LT.-0.25) PARM(2)=-0.25
	IF (PARM(3).LT.0.3) PARM(3)=0.3
	IF (PARM(4).LT.3.) PARM(4)=3.
	IF (PARM(5).LT.0.01) PARM(5)=0.01
	IF (PARM(6).LT.0.006) PARM(6)=0.006
	IF (PARM(7).LT.3.) PARM(7)=3.
	IF (PARM(8).LT.0.2) PARM(8)=0.2


c SEED FOR RANDOM NUMBER GENERATION
	ix=10
	iy=11
	iz=12

c START GENERATING RAINFALL DATA


c STORM POSITION
	I=1
	POSTORM(1)=1
	
 10	IF (POSTORM(I).LT.(N+1)) THEN
          	MXVAR=IDINT(POSTORM(I))
		U=UNIDEV(IX,IY,IZ)
		POSTORM(I+1)=POSTORM(I)-EXP(PARM(1)+PARM(2)*XVAR(MXVAR))*
     &		         DLOG(1-U)
		I=I+1
		GO TO 10
	ENDIF

		
	NSTORM=I-1


c FOR EACH STORM GENERATE THE FOLLOWING:
c (1) LENGTH OF STORM
c (2) NO. OF SUB-STORM

	DO 13 I=1,NSTORM
	   LENGTH=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(6)	
	   CHILD=1+IDINT(POIDEV(PARM(5)*LENGTH,IX,IY,IZ))
  	   IF (CHILD.LT.1) GO TO 13

c THERE IS A SUB-STORM ASSOCIATED WITH STORM ORIGIN.
	   
	   CLDPOS(1)=POSTORM(I)

c FOR EACH SUB-STORM, GENERATE THE FOLLOWING:
c (1) LENGTH OF SUB-STORM
c (2) NO. OF RAINCELLS INSIDE THE SUB-STORM
	   DO 12 L=1,CHILD

		LENCLD=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(8)
		CELL=IDINT(POIDEV(PARM(7)*LENCLD,IX,IY,IZ))

		IF (CELL.LT.1) GO TO 12

		DURAT(1)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(4)			   	
		INTENS(1)=-PARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
      			  
		CELLPOS(1)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
		FINISH(1)=CELLPOS(1)+DURAT(1)

		IF (CELL.GT.1) THEN
			DO K=2,CELL
				CELLPOS(K)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
				DURAT(K)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(4)
				INTENS(K)=-PARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
     				FINISH(K)=CELLPOS(K)+DURAT(K)
			ENDDO
		ENDIF
 
c FILLED-IN THE RAIN

 			DO 11 J=1,CELL	

			   IF (FINISH(J).GT.(N+1)) THEN
				FINISH(J)=N+0.99
			   ENDIF

			   IF (CELLPOS(J).GT.(N+1)) THEN
				CELLPOS(J)=N+0.99
			   ENDIF

c IF THE RAINCELL DOES NOT GO OVER THE HOUR
	      	   	   IF ((FINISH(J)-IDINT(CELLPOS(J))).LE. 1.0) THEN
                		K=IDINT(CELLPOS(J))
             	    		RAIN(K)=RAIN(K)+(INTENS(J)*DURAT(J))  
			   ELSE

c IF RAINCELL FINISHES AT THE NEXT HOUR
     			  	K=IDINT(CELLPOS(J))
     				P=IDINT(FINISH(J))

     				RAIN(K)=RAIN(K)+(INTENS(J)*(1.0-CELLPOS(J)+K))

				IF (P.gt.N) THEN 
				   P=N
				ENDIF

				IF ((K+1).gt.P) GO TO 14
				DO M=(K+1),P
				   RAIN(M)=RAIN(M)+INTENS(J)
				ENDDO
				RAIN(P)=RAIN(P)-(1.0-FINISH(J)+P)*INTENS(J)
 14      	     	   ENDIF
 11			ENDDO

c DETERMINE POSITION OF THE NEXT SUB-STORM
	   	CLDPOS(L+1)=POSTORM(I)+DBLE(UNIDEV(IX,IY,IZ))*LENGTH
 12	   ENDDO
 13	ENDDO 
c END OF FILLED-IN PROCESS
 20   RETURN
      END		


