C   ROUTINE NAME	- GLOBAL
C
C-----------------------------------------------------------------------
C
C   COMPUTER           	- IBM PC/SINGLE
C
C   LATEST REVISION	- OKTOBER 23, 1986
C
C   PURPOSE		- GLOBAL MINIMUM OF FUNCTION OF	N VARIABLES
C			    USING A LOCAL SEARCH METHOD
C
C   USAGE		- CALL GLOBAL (AMIN,AMAX,NPARM,M,N100,NG0,IPR,
C			    NSIG,X0,NC,F0)
C
C   ARGUMENTS   AMIN    - VECTOR OF LENGTH NPARM CONTAINING THE LOWER
C                           BOUNDS OF THE PARAMETERS, SO X(I) IS
C			    SEARCHED IN	THE INTERVAL (AMIN(I),AMAX(I)).
C			    (INPUT)
C		AMAX	- VECTOR OF LENGTH NPARM CONTAINING THE	UPPER
C			    BOUNDS OF THE PARAMETERS. (INPUT)
C	       NPARM	- NUMBER OF PARAMETERS,	1<=NPARM<=15. (INPUT)
C		   M	- NUMBER OF RESIDUAL FUNCTIONS,	WHEN THE
C			    OBJECTIVE FUNCTION IS OF THE FORM F1**2+
C			    F2**2+...+FM**2, 1<=M<=100.	(INPUT)
C		N100	- NUMBER OF SAMPLE POINTS TO BE	DRAWN UNIFORMLY
C			    IN ONE CYCLE, 20<=N100<=10000. THE SUGGES-
C			    TED	VALUE IS 100*NPARM. (INPUT)
C		 NG0	- NUMBER OF BEST POINTS	SELECTED FROM THE ACTUAL
C			    SAMPLE, 1<=NG0<=20.	THE SUGGESTED VALUE IS
C			    TWICE THE EXPECTED NUMBER OF LOCAL MINIMA.
C			    (INPUT)
C		 IPR	- FORTRAN DATA SET REFERENCE NUMBER WHERE THE
C			    PRINTED OUTPUT BE SENT. (INPUT)
C		NSIG	- CONVERGENCE CRITERION, THE ACCURACY REQUIRED
C			    IN THE PARAMETER ESTIMATES. THIS CONVERGENCE
C			    CRITERION IS SATISFIED IF ON TWO SUCCESSIVE
C			    ITERATIONS THE PARAMETER ESTIMATES AGREE,
C			    COMPONENT BY COMPONENT, TO NSIG DIGITS.
C			    THE SUGGESTED VALUE IS 6. (INPUT)
C		   X0	- OUTPUT 15 BY 20 MATRIX CONTAINING NC (UP TO
C                      	    20)	LOCAL MINIMIZERS FOUND.
C		   NC	- NUMBER OF DIFFERENT LOCAL MINIMIZERS FOUND.
C			    (OUTPUT)
C		   F0	- OUTPUT VECTOR	OF NC (UP TO 20) OBJECTIVE
C			    FUNCTION VALUES, F0(I) BELONGS TO THE
C			    PARAMETERS X0(1,I),X0(2,I),...,X0(NPARM,I).
C
C   PRECISION/HARDWARE	- SINGLE AND DOUBLE/H32
C			- SINGLE/H36,H48,H60
C
C   REQUIRED ROUTINES	- URDMN,FUN,LOCAL
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GLOBAL(AMIN,AMAX,NPARM,M,N100,NG0,IPR,NSIG,X0,NC,F0)
      DIMENSION	X(15,100),X0(15,20),X1(15,20),X2(15,20),XCL(15,100)
      DIMENSION  IC(100),IC1(20),R(100,15),W(15),AMIN(nparm),AMAX(nparm)
      REAL F(100),F0(20),F1(20),FCL(100),Y(15),MIN(15),MAX(15),B
	EXTERNAL UNIF
	INTEGER IX,IY,IZ
      REAL ZERO,ONE,TWO,TEN
      DATA ZERO/0.0/,ONE/1.0/,TWO/2.0/,TEN/10.0/
	DATA IX/100/,IY/151/,IZ/245/
c	print*,ix
      IF (NPARM.LE.0) GO TO 460
      IF (NPARM.GT.15) GO TO 455
      IF (M.GT.100) GO TO 460
      DO 5 I=1,NPARM
         MIN(I) = AMIN(I)
         MAX(I) = AMAX(I)
	 IF (MIN(I).EQ.MAX(I)) GO TO 460
    5 CONTINUE
      D	= (TWO*SQRT(FLOAT(NPARM)))*.000001
      B1 = ONE/FLOAT(NPARM)
      IF (NG0.LT.1) NG0	= 1
      IF (NG0.GT.20) NG0 = 20
      IF (N100.LT.20) N100 = 20
      IF (N100.GT.10000) N100 =	10000
      IF (N100.GE.100) GO TO 10
      NN100 = N100
      N	= 1
      GO TO 15
   10 NN100 = 100
      N	= N100/100
      N100 = N*100
   15 NG10 = 100
      DO 16 I=1,NG10
	 F(I) =	9.9E10
	 IC(I) = 0
   16 CONTINUE
      DO 17 I=1,NPARM
	 MAX(I)	= (MAX(I)-MIN(I))/TWO
	 MIN(I)	= MIN(I)+MAX(I)
   17 CONTINUE
      ALFA = .01
      NFE = 0
      NG = 0
      NS = 0
      NC = 0
      NCP = 1
      N0 = 0
      N1 = 0
      IM = 1
      IG = 0
      FM = 9.9E10
      MAXFN = 500*NPARM
      RELCON = TEN**(-NSIG)
C			      SAMPLING
c	print*,n0 
   20 N0 = N0+N100
      NM = N0-1
      NG = NG+NG0
      NS = NS+1
      IF (NS*NG0.GT.100) GO TO 465
      B	= (ONE-ALFA**(ONE/FLOAT(NM)))**B1
      BB = 0.1*B
      DO 40 I1=1,N
	 CALL UNIF(IX,IY,IZ,1500,R)
	 DO 40 J=1,NN100
	    DO 25 I=1,NPARM
   25	       Y(I) = TWO*R(J,I)-ONE
	    CALL FUN(Y,FC,NPARM,M,MIN,MAX)
	    IF (FC.GE.FM) GO TO	40
	    F(IM) = FC
	    DO 30 I=1,NPARM
   30	       X(I,IM) = Y(I)
	    IF (IM.LE.NG.AND.IC(IM).GT.0) IG = IG-1
	    IC(IM) = 0
	    IM = 1
	    FM = F(1)
	    DO 35 I=2,NG10
	       IF (F(I).LT.FM) GO TO 35
	       IM = I
	       FM = F(I)
   35	    CONTINUE
   40 CONTINUE
      NFE = NFE+N100
      WRITE(IPR,901) N100
      WRITE(*,901) N100
  901 FORMAT(/1X,I5,' FUNCTION EVALUATIONS USED FOR SAMPLING')
C			     SORTING
      INUM = NG10-1
      DO 75 I=1,INUM
	 IM = I
	 FM = F(I)
	 INUM1 = I+1
	 DO 45 J=INUM1,NG10
	    IF (F(J).GE.FM) GO TO 45
	    IM = J
	    FM = F(J)
   45	 CONTINUE
	 IF (IM.LE.I) GO TO 75
	 A = FM
	 DO 50 J=1,NPARM
   50	    Y(J) = X(J,IM)
	 IF (I.GT.NG.OR.IM.LE.NG) GO TO	55
	 IF (IC(NG).EQ.0.AND.IC(IM).GT.0) IG = IG+1
	 IF (IC(NG).GT.0.AND.IC(IM).EQ.0) IG = IG-1
   55	 ICC = IC(IM)
	 INUM1 = IM-I
	 DO 65 J=1,INUM1
	    INUM2 = IM-J
	    F(INUM2+1) = F(INUM2)
	    IC(INUM2+1)	= IC(INUM2)
	    DO 60 JJ=1,NPARM
   60	       X(JJ,INUM2+1) = X(JJ,INUM2)
   65	 CONTINUE
	 F(I) =	A
	 DO 70 J=1,NPARM
   70	    X(J,I) = Y(J)
	 IC(I) = ICC
   75 CONTINUE
      IF (NC.LE.0) GO TO 200
C			  CLUSTERING TO	X*
      DO 145 III=1,NC
	 I = 1
	 IN1 = I
	 FCL(I)	= F0(III)
	 DO 80 J=1,NPARM
   80	    XCL(J,I) = X0(J,III)
	 DO 90 J=1,NG
	 IF (IC(J).NE.III) GO TO 90
	 IN1 = IN1+1
	 DO 85 II=1,NPARM
   85	    XCL(II,IN1)	= X(II,J)
   90	 CONTINUE
   95	 DO 140	J=1,NG
	    IF (IC(J).NE.0) GO TO 140
	    IF (FCL(I).GE.F(J))	GO TO 140
	    DO 100 L1=1,NPARM
	       W(L1) = ABS(XCL(L1,I)-X(L1,J))
  100	    CONTINUE
	    A =	ZERO
	    DO 110 L1=1,NPARM
	       IF (W(L1).GT.A) A=W(L1)
  110	    CONTINUE
	    IF (A.GE.B)	GO TO 140
	    WRITE(IPR,902) III
            WRITE(*,902) III
  902	    FORMAT(' SAMPLE POINT ADDED TO THE CLUSTER NO. ',I2)
	    DO 130 II=1,NPARM
  130	       W(II)=X(II,J)*MAX(II)+MIN(II)
	    WRITE(IPR,903) F(J),(W(II), II=1,NPARM)
            WRITE (*,903) F(J),(W(II), II=1,NPARM)
  903	    FORMAT(1X,G14.8,3(/4X,5(G14.8,1X)))
	    IG = IG+1
	    IF (IG.GE.NG) GO TO	395
	    IN1	= IN1+1
	    FCL(IN1) = F(J)
	    DO 135 II=1,NPARM
  135	       XCL(II,IN1)=X(II,J)
	    IC(J) = III
  140	 CONTINUE
	 I = I+1
	 IF (I.LE.IN1) GO TO 95
  145 CONTINUE
      IF (N1.LE.0) GO TO 200
C			  CLUSTERING TO	X1
      DO 195 III=1,N1
	 I = 1
	 IN1 = I
	 FCL(I)	= F1(III)
	 DO 150	J=1,NPARM
  150	    XCL(J,I) = X1(J,III)
  155	 DO 190	J=1,NG
	    IF (IC(J).NE.0) GO TO 190
	    IF (FCL(I).GE.F(J))	GO TO 190
	    DO 160 L1=1,NPARM
	       W(L1) = ABS(XCL(L1,I)-X(L1,J))
  160	    CONTINUE
	    A =	ZERO
	    DO 165 L1=1,NPARM
	       IF (W(L1).GT.A) A=W(L1)
  165	    CONTINUE
	    IF (A.GE.B)	GO TO 190
	    WRITE(IPR,902) IC1(III)
            WRITE(*,902) IC1(III)
	    DO 180 II=1,NPARM
  180	    W(II) = X(II,J)*MAX(II)+MIN(II)
	    WRITE(IPR,903) F(J),(W(II), II=1,NPARM)
            WRITE(*,903) F(J),(W(II), II=1,NPARM)
	    IG = IG+1
	    IF (IG.GE.NG) GO TO	395
	    IN1	= IN1+1
	    FCL(IN1) = F(J)
	    DO 185 II=1,NPARM
  185	       XCL(II,IN1) = X(II,J)
	    IC(J)=IC1(III)
  190	 CONTINUE
	 I = I+1
	 IF (I.LE.IN1) GO TO 155
  195 CONTINUE
C			  LOCAL	SEARCH
  200 IT = 0
      DO 386 I1=1,NG
	 IF (IC(I1).NE.0) GO TO	386
	 DO 205	I=1,NPARM
  205	    Y(I) = X(I,I1)
	 FF = F(I1)
	 CALL LOCAL(M,NPARM,RELCON,MAXFN,Y,FF,NFE1,R,MIN,MAX)
  220	 IF (NC.LE.0) GO TO 290
	 DO 250	IV=1,NC
	    DO 225 L1=1,NPARM
	       W(L1) = ABS(X0(L1,IV)-Y(L1))
  225	    CONTINUE
	    A =	ZERO
	    DO 235 L1=1,NPARM
	       IF (W(L1).GT.A) A=W(L1)
  235	    CONTINUE
	    IF (A.LT.BB) GO TO 255
  250	 CONTINUE
	 GO TO 290
C			    NEW	SEED-POINT
  255	 N1 = N1+1
	 WRITE(IPR,905)	IV,NFE1
         WRITE(*,905) IV,NFE1
  905	 FORMAT(' NEW SEED POINT ADDED TO THE CLUSTER NO. ',
     1	        I2,', NFEV=',I5)
	 DO 265	II=1,NPARM
  265	    W(II) = X(II,I1)*MAX(II)+MIN(II)
	 WRITE(IPR,903)	FF,(W(II), II=1,NPARM)
         WRITE(*,903) FF,(W(II), II=1,NPARM)
	 IF (FF.GE.F0(IV)) GO TO 280
	 WRITE(IPR,906)	IV,F0(IV),FF
         WRITE(*,906) IV,F0(IV),FF
  906	 FORMAT(' *** IMPROVEMENT ON THE LOCAL MINIMUM NO. ',
     1		I2,':',G14.8,' FOR ',G14.8)
	 DO 270	II=1,NPARM
  270	    W(II) = Y(II)*MAX(II)+MIN(II)
	 WRITE(IPR,903)	FF,(W(II), II=1,NPARM)
         WRITE(*,903) FF,(W(II), II=1,NPARM)
	 F0(IV)	= FF
	 DO 275	II=1,NPARM
  275	    X0(II,IV) =	Y(II)
  280	 IF (N1.GT.20) GO TO 470
	 DO 285	II=1,NPARM
	    X1(II,N1) =	X(II,I1)
  285	    XCL(II,1) =	X(II,I1)
	 F1(N1)	= F(I1)
	 FCL(1)	= F(I1)
	 IC1(N1) = IV
	 ICJ = IV
	 GO TO 305
C			  NEW LOCAL MINIMUM
  290	 NC = NC+1
	 NCP = NCP+1
	 WRITE(IPR,907)	NC,FF,NFE1
         WRITE(*,907) NC,FF,NFE1
  907	 FORMAT(' *** THE LOCAL MINIMUM NO. ',I2,': ',G14.8,
     1		', NFEV=',I5)
	 DO 295	II=1,NPARM
  295	    W(II) = Y(II)*MAX(II)+MIN(II)
	 WRITE(IPR,903)	FF,(W(II), II=1,NPARM)
         WRITE(*,903) FF,(W(II), II=1,NPARM)
	 DO 300	II=1,NPARM
	    X0(II,NC) =	Y(II)
  300	    XCL(II,1) =	Y(II)
	 FCL(1)	= FF
	 F0(NC)	= FF
	 IF (NC.GE.20) GO TO 475
	 IT = 1
	 ICJ = NC
C			 CLUSTERING TO THE NEW POINT
  305	 NFE = NFE+NFE1
	 IC(I1)	= ICJ
	 IG = IG+1
	 IF (IG.GE.NG) GO TO 390
	 I = 1
	 IN1 = I
  310	 DO 385	J=1,NG
	 IF (IC(J).NE.0) GO TO 385
	 IF (FCL(I).GE.F(J)) GO	TO 385
	 DO 315	L1=1,NPARM
	    W(L1) = ABS(XCL(L1,I)-X(L1,J))
  315	 CONTINUE
	 A = ZERO
	 DO 325	L1=1,NPARM
	    IF (W(L1).GT.A) A=W(L1)
  325	 CONTINUE
	 IF (A.GE.B) GO	TO 385
	 IN1 = IN1+1
	 DO 380	II=1,NPARM
  380	    XCL(II,IN1)	= X(II,J)
	 FCL(IN1) = F(J)
	 IC(J) = ICJ
	 WRITE(IPR,902)	ICJ
         WRITE(*,902) ICJ
	 DO 701	II=1,NPARM
	    W(II) = X(II,J)*MAX(II)+MIN(II)
  701	 CONTINUE
	 WRITE(IPR,903)	F(J),(W(II), II=1,NPARM)
         WRITE(*,903) F(J),(W(II), II=1,NPARM)
	 IG = IG+1
	 IF (IG.GE.NG) GO TO 390
  385 CONTINUE
      I	= I+1
      IF (I.LT.IN1) GO TO 310
  386 CONTINUE
  390 IF (IT.NE.0) GO TO 20
C			   PRINT RESULTS
  395 WRITE(IPR,908)
      WRITE(*,908)
  908 FORMAT(/////,' LOCAL MINIMA FOUND:'//)
      IF (NC.LE.1) GO TO 430
      INUM = NC-1
      DO 425 I=1,INUM
	 IM = I
	 FM = F0(I)
	 INUM1 = I+1
	 DO 400	J=INUM1,NC
	    IF (F0(J).GE.FM) GO	TO 400
	    IM = J
	    FM = F0(J)
  400	 CONTINUE
	 IF (IM.LE.I) GO TO 425
	 A = FM
	 DO 405	J=1,NPARM
  405	    Y(J) = X0(J,IM)
	 INUM1 = IM-I
	 DO 415	J=1,INUM1
	    INUM2 = IM-J
	    F0(INUM2+1)	= F0(INUM2)
	    DO 410 JJ=1,NPARM
  410	       X0(JJ,INUM2+1) =	X0(JJ,INUM2)
  415	 CONTINUE
	 F0(I) = A
	 DO 420	J=1,NPARM
  420	    X0(J,I) = Y(J)
  425 CONTINUE
  430 IF (NC.LE.0) GO TO 445
      DO 440 I=1,NC
	 DO 435	II=1,NPARM
  435	    X0(II,I) = X0(II,I)*MAX(II)+MIN(II)
	 WRITE(IPR,903)	F0(I),(X0(II,I), II=1,NPARM)
         WRITE(*,903) F0(I),(X0(II,I), II=1,NPARM)
  440 CONTINUE
  445 WRITE(IPR,911) NFE
      WRITE(*,911) NFE
  911 FORMAT(///,' NORMAL TERMINATION AFTER ',I5,' FUNCTION ',
     1	     'EVALUATIONS',///)
      RETURN
  455 WRITE(IPR,913)
      WRITE(*,913)
  913 FORMAT(' ***   TOO MANY PARAMETERS',//,' ABNORMAL TERMINATION')
      STOP
  460 WRITE(IPR,914)
      WRITE(*,914)
	write(6,*) ipr
  914 FORMAT(' ***   DATA ERROR')
      STOP
  465 WRITE(IPR,915)
      WRITE(*,915)
  915 FORMAT(' ***   TOO MANY SAMPLING')
      GO TO 395
  470 WRITE(IPR,916)
      WRITE(*,916)
  916 FORMAT(' ***   TOO MANY NEW SEED POINTS')
      GO TO 395
  475 WRITE(IPR,917)
      WRITE(*,917)
  917 FORMAT(' ***   TOO MANY CLUSTERS')
      GO TO 395
      END
      SUBROUTINE FUN(R,F,NPARM,M,MIN,MAX)
      REAL X(15),R(1),MIN(15),MAX(15)
      DO 10 I=1,NPARM
	 X(I) =	MAX(I)*R(I)+MIN(I)
   10 CONTINUE
      CALL FUNCT(X,F,NPARM,M)
      RETURN
      END
