c	LIST OF HELPERS SUBROUTINES USE TO COMPUTE THE LOG-LIKELIHOOD OF MULTIVARIATE NORMAL DIST

	subroutine matrix(x,n,p,y)

c   X is a series of length n x p
c   p is the number of columm in the resultant matrix Y

	integer p,counter
        real*4 x(n*p)
	double precision y(n,p)

	counter=1
	do i=1,n*p
		if (mod(i,p).eq.0) then
			y(counter,p)=dble(x(i))
			counter=counter+1
		else
			y(counter,mod(i,p))=dble(x(i))
		endif
	enddo
	
	return
	end

	subroutine quadfrm(y,n,p,z,mean,indtoep)
	PARAMETER(LAG=16)
	integer p,count(p)
	double precision mean
	double precision y(n,p),z(p,p),avgz(p)
	external toep

c --- Z is the p x p covariance matrix * n

	do i=1,p
		do j=1,p
			z(i,j)=0.
		enddo
	enddo


	do i=1,n
		do j=1,p
			y(i,j)=y(i,j)-mean
		enddo
	enddo


c --- END OF centering

	do i=1,n
		do j=1,p
			do k=1,p
			   z(j,k)=z(j,k)+y(i,j)*y(i,k)
			enddo
		enddo
	enddo
c ---- IF the matrix is toeplitz

	if (indtoep.eq.1) then

		do i=1,p
			count(i)=0
			avgz(i)=0.
		enddo

		do i=1,p
			do j=1,p
				ind=abs(i-j)+1
				avgz(ind)=avgz(ind)+z(i,j)
				count(ind)=count(ind)+1
			enddo
		enddo

		do i=1,p
			avgz(i)=avgz(i)/count(i)
		enddo
	    call toep(avgz,z,p)
	endif

	return 
	end 

	
	subroutine meanfit(a,b,n,p,out)

c --- a is the theoretical mean (model)
c --- b is 1 x p vector of observed mean

	integer p
	double precision a,b(p),out(p,p)

	do i=1,p
		do j=1,p
			out(i,j)=n*(b(i)-a)*(b(j)-a)
		enddo
	enddo

	return
	end

	subroutine toep(x,y,p)
	integer p
	double precision x(p),y(p,p)

	do i=1,p
		do j=1,p
			ind=abs(i-j)+1 
			y(i,j)=x(ind)
		enddo
	enddo

	return
	end

	subroutine addmat(x,y,p)
	integer p
	double precision x(p,p),y(p,p),temp(p,p)

	do i=1,p
		do j=1,p
			temp(i,j)=0.
		enddo
	enddo 

	do i=1,p
		do j=1,p
			temp(i,j)=x(i,j)+y(i,j)
		enddo
	enddo

	do i=1,p
		do j=1,p
			x(i,j)=temp(i,j)
		enddo
	enddo
	return
	end


	subroutine subsmat(x,y,p)
	integer p
	double precision x(p,p),y(p,p),temp(p,p)

	do i=1,p
		do j=1,p
			temp(i,j)=0.
		enddo
	enddo 

	do i=1,p
		do j=1,p
			temp(i,j)=x(i,j)-y(i,j)
		enddo
	enddo

	do i=1,p
		do j=1,p
			x(i,j)=temp(i,j)
		enddo
	enddo
	return
	end


	subroutine sumtr(x,y,tr,p)
	integer p
	double precision x(p,p),y(p,p)
	double precision dum(p,p),tr

	do i=1,p
		do j=1,p
			dum(i,j)=0.
		enddo
	enddo

	do i=1,p
		do j=1,p
			do k=1,p
				dum(i,j)=dum(i,j)+y(i,k)*x(k,j)
			enddo
		enddo
	enddo

	tr=0.

	do i=1,p
		tr=tr+dum(i,i)
		if (tr.ge.1e50) then
			tr=1e50
			goto 100
		endif
	enddo

100	return
	end 


