C   ROUTINE NAME	- LOCAL
C
C-----------------------------------------------------------------------
C
C   COMPUTER            - IBM PC/SINGLE
C
C   LATEST REVISION	- JULY 31, 1986
C
C   PURPOSE		- MINIMUM OF A FUNCTION	OF N VARIABLES USING
C			    A QUASI-NEWTON METHOD
C
C   USAGE		- CALL LOCAL (M,N,EPS,MAXFN,X,F,NFEV,W,MIN,MAX)
C
C   ARGUMENTS	 M	- THE NUMBER OF	RESIDUAL FUNCTIONS (INPUT)
C			    NOT	USED IN	THIS ROUTINE.
C		 N	- THE NUMBER OF	PARAMETERS (I.E., THE LENGTH
C			    OF X) (INPUT)
C		 EPS	- CONVERGENCE CRITERION. (INPUT). THE ACCURACY
C			    REQUIRED IN	THE PARAMETER ESTIMATES
C			    THIS CONVERGENCE CONDITION IS SATISFIED IF
C			    ON TWO SUCCESSIVE ITERATIONS, THE PARAMETER
C			    ESTIMATES (I.E.,X(I), I=1,...,N) DIFFERS,
C			    COMPONENT BY COMPONENT, BY AT MOST EPS.
C		 MAXFN	- MAXIMUM NUMBER OF FUNCTION EVALUATIONS (I.E.,
C			    CALLS TO SUBROUTINE	FUN) ALLOWED. (INPUT)
C		 X	- VECTOR OF LENGTH N CONTAINING	PARAMETER
C			    VALUES.
C			  ON INPUT, X MUST CONTAIN THE INITIAL
C			    PARAMETER ESTIMATES.
C			  ON OUTPUT, X CONTAINS	THE FINAL PARAMETER
C			    ESTIMATES AS DETERMINED BY LOCAL.
C		 F	- A SCALAR CONTAINING THE VALUE	OF THE FUNCTION
C			    AT THE FINAL PARAMETER ESTIMATES. (OUTPUT)
C		 NFEV	- THE NUMBER OF	FUNCTION EVALUATIONS (OUTPUT)
C		 W	- A VECTOR OF LENGTH 3*N USED AS WORKING SPACE.
C                MIN    - A VECTOR OF LENGTH N CONTAINING THE LOWER
C                           BOUNDS OF THE PARAMETERS, SO X(I) IS
C                           SEARCHED IN THE INTERVAL (MIN(I),MAX(I)).
C                           (INPUT)
C                MAX    - A VECTOR OF LENGTH N CONTAINING THE UPPER
C                           BOUNDS OF THE PARAMETERS. (INPUT)
C
C   PRECISION/HARDWARE	- SINGLE AND DOUBLE/H32
C			- SINGLE/H36,H48,H60
C
C   REQUIRED ROUTINES	- UPDATE,FUN
C
C		 FUN  	- A USER SUPPLIED SUBROUTINE WHICH CALCULATES
C			    THE	FUNCTION F FOR GIVEN PARAMETER VALUES
C			    X(1),X(2),...,X(N).
C			    THE	CALLING	SEQUENCE HAS THE FOLLOWING FORM
C			    CALL FUN(X,F,N,M,MIN,MAX)
C			    WHERE X IS A VEKTOR	OF LENGTH N.
C			    FUN MUST APPEAR IN AN EXTERNAL STATEMENT
C			    IN THE CALLING PROGRAM. FUN MUST NOT
C			    ALTER THE VALUES OF	X(I),I=1,...,N OR N.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE LOCAL (M,N,EPS,MAXFN,X,F,NFEV,W,MIN,MAX)
C				   SPECIFICATIONS FOR ARGUMENTS
      INTEGER            M,N,MAXFN,NFEV
      REAL		 EPS,X(N),F,W(1),MIN(1),MAX(1)
C				   SPECIFICATIONS FOR LOCAL VARIABLES
      INTEGER            IG,IGG,IS,IDIFF,IR,IJ,I,J,NM1,JJ,JP1,L,KJ,
     1			 K,LINK,ITN,II,IM1,JNT,NP1,JB,NJ,IER
      REAL		 REPS,AX,ZERO,ONE,HALF,SEVEN,FIVE,TWELVE,TEN,
     1			 HH,HJJ,V,DF,RELX,GS0,DIFF,AEPS,ALPHA,FF,
     2			 TOT,F1,F2,Z,GYS,DGS,SIG,ZZ,GNRM,P1,HHH,GHH,
     3			 G(15),D2,TWO,H(120)
      DATA		 REPS/1.1921E-07/,AX/0.1/,ZERO/0.0/,ONE/1.0/,
     1			 HALF/0.5/,SEVEN/7.0/,FIVE/5.0/,TWO/2.0/,
     2			 TWELVE/12.0/,TEN/10.0/,P1/0.1/
C				   INITIALIZATION
C				   FIRST EXECUTABLE STATEMENT
      IOPT = 0
C		 IOPT	- OPTIONS SELECTOR. (INPUT)
C			  IOPT = 0 CAUSES LOCAL	TO INITIALIZE THE
C			    HESSIAN MATRIX H TO	THE IDENTITY MATRIX.
C			  IOPT = 1 INDICATES THAT H HAS	BEEN INITIALIZED
C			    BY THE USER	TO A POSITIVE DEFINITE MATRIX.
C			  IOPT = 2 CAUSES LOCAL	TO COMPUTE THE DIAGONAL
C			    VALUES OF THE HESSIAN MATRIX AND SET H TO
C			    A DIAGONAL MATRIX CONTAINING THESE VALUES.
C			  IOPT = 3 CAUSES LOCAL	TO COMPUTE AN ESTIMATE
C			    OF THE HESSIAN IN H.
      IER = 0
      HH = SQRT(REPS)
      IG = N
      IGG = N+N
      IS = IGG
      IDIFF = 1
      IR = N
      W(1) = -ONE
      W(2) = ZERO
      W(3) = ZERO
C				   EVALUATE FUNCTION AT	STARTING POINT
      DO 5 I=1,N
	 G(I) =	X(I)
    5 CONTINUE
      CALL FUN (G,F,N,M,MIN,MAX)
      NFEV = 1
      IF (IOPT.EQ.1) GO	TO 45
C				   SET OFF-DIAGONAL ELEMENTS OF	H TO 0.0
      IF (N.EQ.1) GO TO	25
      IJ = 2
      DO 15 I=2,N
	 DO 10 J=2,I
	    H(IJ) = ZERO
	    IJ = IJ+1
   10	 CONTINUE
	 IJ = IJ+1
   15 CONTINUE
      IF (IOPT.NE.0) GO	TO 25
C				   SET DIAGONAL	ELEMENTS OF H TO ONE
      IJ = 0
      DO 20 I=1,N
	 IJ = IJ+I
	 H(IJ) = ONE
   20 CONTINUE
      GO TO 80
C				   GET DIAGONAL	ELEMENTS OF HESSIAN
   25 IM1 = 1
      NM1 = 1
      NP1 = N+1
      DO 30 I=2,NP1
	 HHH = HH*AMAX1(ABS(X(IM1)),AX)
	 G(IM1)	= X(IM1)+HHH
	 CALL FUN (G,F2,N,M,MIN,MAX)
	 G(IM1)	= G(IM1)+HHH
	 CALL FUN (G,FF,N,M,MIN,MAX)
	 H(NM1)	= (FF-F2+F-F2)/(HHH*HHH)
	 G(IM1)	= X(IM1)
	 IM1 = I
	 NM1 = I+NM1
   30 CONTINUE
      NFEV = NFEV+N+N
      IF (IOPT.NE.3.OR.N.EQ.1) GO TO 45
C				   GET THE REST	OF THE HESSIAN
      JJ = 1
      II = 2
      DO 40 I=2,N
	 GHH = HH*AMAX1(ABS(X(I)),AX)
	 G(I) =	X(I)+GHH
	 CALL FUN (G,F2,N,M,MIN,MAX)
	 DO 35 J=1,JJ
	    HHH	= HH*AMAX1(ABS(X(J)),AX)
	    G(J) = X(J)+HHH
	    CALL FUN (G,FF,N,M,MIN,MAX)
	    G(I) = X(I)
	    CALL FUN (G,F1,N,M,MIN,MAX)
C	    H(II) = (FF-F1-F2+F)*SQREPS
	    H(II) = (FF-F1-F2+F)/(HHH*GHH)
	    II = II+1
	    G(J) = X(J)
   35	 CONTINUE
	 JJ = JJ+1
	 II = II+1
   40 CONTINUE
      NFEV = NFEV+((N*N-N)/2)
C				   FACTOR H TO L*D*L-TRANSPOSE
   45 IR = N
      IF (N.GT.1) GO TO	50
      IF (H(1).GT.ZERO)	GO TO 80
      H(1) = ZERO
      IR = 0
      GO TO 75
   50 NM1 = N-1
      JJ = 0
      DO 70 J=1,N
	 JP1 = J+1
	 JJ = JJ+J
	 HJJ = H(JJ)
	 IF (HJJ.GT.ZERO) GO TO	55
	 H(JJ) = ZERO
	 IR = IR-1
	 GO TO 70
   55	 IF (J.EQ.N) GO	TO 70
	 IJ = JJ
	 L = 0
	 DO 65 I=JP1,N
	    L =	L+1
	    IJ = IJ+I-1
	    V =	H(IJ)/HJJ
	    KJ = IJ
	    DO 60 K=I,N
	       H(KJ+L) = H(KJ+L)-H(KJ)*V
	       KJ = KJ+K
   60	    CONTINUE
	    H(IJ) = V
   65	 CONTINUE
   70 CONTINUE
   75 IF (IR.EQ.N) GO TO 80
      IER = 129
      GO TO 9000
   80 ITN = 0
      DF = -ONE
C				   EVALUATE GRADIENT W(IG+I),I=1,...,N
   85 LINK = 1
      GO TO 260
   90 CONTINUE
C				   BEGIN ITERATION LOOP
      IF (NFEV.GE.MAXFN) GO TO 225
      ITN = ITN+1
      DO 95 I=1,N
	 W(I) =	-W(IG+I)
   95 CONTINUE
C				   DETERMINE SEARCH DIRECTION W
C				     BY	SOLVING	H*W = -G WHERE
C				     H = L*D*L-TRANSPOSE
      IF (IR.LT.N) GO TO 125
C				   N .EQ. 1
      G(1) = W(1)
      IF (N.GT.1) GO TO	100
      W(1) = W(1)/H(1)
      GO TO 125
C				   N .GT. 1
  100 II = 1
C				   SOLVE L*W = -G
      DO 110 I=2,N
	 IJ = II
	 II = II+I
	 V = W(I)
	 IM1 = I-1
	 DO 105	J=1,IM1
	    IJ = IJ+1
	    V =	V-H(IJ)*W(J)
  105	 CONTINUE
	 G(I) =	V
	 W(I) =	V
  110 CONTINUE
C				   SOLVE (D*LT)*Z = W WHERE
C                                    LT = L-TRANSPOSE
      W(N) = W(N)/H(II)
      JJ = II
      NM1 = N-1
      DO 120 NJ=1,NM1
C				   J = N-1,N-2,...,1
	 J = N-NJ
	 JP1 = J+1
	 JJ = JJ-JP1
	 V = W(J)/H(JJ)
	 IJ = JJ
	 DO 115	I=JP1,N
	    IJ = IJ+I-1
	    V =	V-H(IJ)*W(I)
  115	 CONTINUE
	 W(J) =	V
  120 CONTINUE
C				   DETERMINE STEP LENGTH ALPHA
  125 RELX = ZERO
      GS0 = ZERO
      DO 130 I=1,N
	 W(IS+I) = W(I)
	 DIFF =	ABS(W(I))/AMAX1(ABS(X(I)),AX)
	 RELX =	AMAX1(RELX,DIFF)
	 GS0 = GS0+W(IG+I)*W(I)
  130 CONTINUE
      IF (RELX.EQ.ZERO)	GO TO 230
      AEPS = EPS/RELX
      IER = 130
      IF (GS0.GE.ZERO) GO TO 230
      IF (DF.EQ.ZERO) GO TO 230
      IER = 0
      ALPHA = (-DF-DF)/GS0
      IF (ALPHA.LE.ZERO) ALPHA = ONE
      ALPHA = AMIN1(ALPHA,ONE)
      IF (IDIFF.EQ.2) ALPHA = AMAX1(P1,ALPHA)
      FF = F
      TOT = ZERO
      JNT = 0
C				   SEARCH ALONG	X+ALPHA*W
  135 IF (NFEV.GE.MAXFN) GO TO 225
      DO 140 I=1,N
	 W(I) =	X(I)+ALPHA*W(IS+I)
  140 CONTINUE
      CALL FUN (W,F1,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F1.GE.F) GO TO 165
      F2 = F
      TOT = TOT+ALPHA
  145 IER = 0
      F	= F1
      DO 150 I=1,N
	 X(I) =	W(I)
  150 CONTINUE
      IF (JNT-1) 155,185,190
  155 IF (NFEV.GE.MAXFN) GO TO 225
      DO 160 I=1,N
	 W(I) =	X(I)+ALPHA*W(IS+I)
  160 CONTINUE
      CALL FUN (W,F1,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F1.GE.F) GO TO 190
      IF (F1+F2.GE.F+F.AND.SEVEN*F1+FIVE*F2.GT.TWELVE*F) JNT = 2
      TOT = TOT+ALPHA
      ALPHA = ALPHA+ALPHA
      GO TO 145
  165 CONTINUE
      IF (F.EQ.FF.AND.IDIFF.EQ.2.AND.RELX.GT.EPS) IER = 130
      IF (ALPHA.LT.AEPS) GO TO 230
      IF (NFEV.GE.MAXFN) GO TO 225
      ALPHA = HALF*ALPHA
      DO 170 I=1,N
	 W(I) =	X(I)+ALPHA*W(IS+I)
  170 CONTINUE
      CALL FUN (W,F2,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F2.GE.F) GO TO 180
      TOT = TOT+ALPHA
      IER = 0
      F	= F2
      DO 175 I=1,N
	 X(I) =	W(I)
  175 CONTINUE
      GO TO 185
  180 Z	= P1
      IF (F1+F.GT.F2+F2) Z = ONE+HALF*(F-F1)/(F+F1-F2-F2)
      Z	= AMAX1(P1,Z)
      ALPHA = Z*ALPHA
      JNT = 1
      GO TO 135
  185 IF (TOT.LT.AEPS) GO TO 230
  190 ALPHA = TOT
C				   SAVE	OLD GRADIENT
      DO 195 I=1,N
	 W(I) =	W(IG+I)
  195 CONTINUE
C				   EVALUATE GRADIENT W(IG+I), I=1,...,N
      LINK = 2
      GO TO 260
  200 IF (NFEV.GE.MAXFN) GO TO 225
      GYS = ZERO
      DO 205 I=1,N
	 GYS = GYS+W(IG+I)*W(IS+I)
	 W(IGG+I) = W(I)
  205 CONTINUE
      DF = FF-F
      DGS = GYS-GS0
      IF (DGS.LE.ZERO) GO TO 90
      IF (DGS+ALPHA*GS0.GT.ZERO) GO TO 215
C				   UPDATE HESSIAN H USING
C				     COMPLEMENTARY DFP FORMULA
      SIG = ONE/GS0
      IR = -IR
      CALL UPDATE (H,N,W,SIG,G,IR,0,ZERO)
      DO 210 I=1,N
	 G(I) =	W(IG+I)-W(IGG+I)
  210 CONTINUE
      SIG = ONE/(ALPHA*DGS)
      IR = -IR
      CALL UPDATE (H,N,G,SIG,W,IR,0,ZERO)
      GO TO 90
C				   UPDATE HESSIAN USING
C				     DFP FORMULA
  215 ZZ = ALPHA/(DGS-ALPHA*GS0)
      SIG = -ZZ
      CALL UPDATE (H,N,W,SIG,G,IR,0,REPS)
      Z	= DGS*ZZ-ONE
      DO 220 I=1,N
	 G(I) =	W(IG+I)+Z*W(IGG+I)
  220 CONTINUE
      SIG = ONE/(ZZ*DGS*DGS)
      CALL UPDATE (H,N,G,SIG,W,IR,0,ZERO)
      GO TO 90
  225 CONTINUE
C				   MAXFN FUNCTION EVALUATIONS
      GO TO 235
  230 IF (IDIFF.EQ.2) GO TO 235
C				   CHANGE TO CENTRAL DIFFERENCES
      IDIFF = 2
      GO TO 85
  235 IF (RELX.GT.EPS.AND.IER.EQ.0) GO TO 85
C				   COMPUTE H = L*D*L-TRANSPOSE AND
C				     OUTPUT
      IF (N.EQ.1) GO TO	9000
      NP1 = N+1
      NM1 = N-1
      JJ = (N*(NP1))/2
      DO 255 JB=1,NM1
	 JP1 = NP1-JB
	 JJ = JJ-JP1
	 HJJ = H(JJ)
	 IJ = JJ
	 L = 0
	 DO 250	I=JP1,N
	    L =	L+1
	    IJ = IJ+I-1
	    V =	H(IJ)*HJJ
	    KJ = IJ
	    DO 245 K=I,N
	       H(KJ+L) = H(KJ+L)+H(KJ)*V
	       KJ = KJ+K
  245	    CONTINUE
	    H(IJ) = V
  250	 CONTINUE
	 HJJ = H(JJ)
  255 CONTINUE
      GO TO 9000
C				    EVALUATE GRADIENT
  260 IF (IDIFF.EQ.2) GO TO 270
C				   FORWARD DIFFERENCES
C				     GRADIENT =	W(IG+I), I=1,...,N
      DO 265 I=1,N
	 Z = HH*AMAX1(ABS(X(I)),AX)
	 ZZ = X(I)
	 X(I) =	ZZ+Z
	 CALL FUN (X,F1,N,M,MIN,MAX)
	 W(IG+I) = (F1-F)/Z
	 X(I) =	ZZ
  265 CONTINUE
      NFEV = NFEV+N
      GO TO (90,200), LINK
C				   CENTRAL DIFFERENCES
C				     GRADIENT =	W(IG+I), I=1,...,N
  270 DO 275 I=1,N
	 Z = HH*AMAX1(ABS(X(I)),AX)
	 ZZ = X(I)
	 X(I) =	ZZ+Z
	 CALL FUN (X,F1,N,M,MIN,MAX)
	 X(I) =	ZZ-Z
	 CALL FUN (X,F2,N,M,MIN,MAX)
	 W(IG+I) = (F1-F2)/(Z+Z)
	 X(I) =	ZZ
  275 CONTINUE
      NFEV = NFEV+N+N
      GO TO (90,200), LINK
C				   RETURN
 9000 RETURN
      END
C   ROUTINE NAME	- UPDATE
C
C-----------------------------------------------------------------------
C
C   COMPUTER		- IBM PC/SINGLE
C
C   LATEST REVISION     - JULY 31, 1986
C			  (CHANGES IN COMMENTS)
C
C   PURPOSE		- NUCLEUS CALLED ONLY BY ROUTINE LOCAL
C
C   PRECISION/HARDWARE	- SINGLE AND DOUBLE/H32
C			- DOUBLE/H36,H48,H60
C
C   REQD. ROUTINES	- NONE REQUIRED
C
C-----------------------------------------------------------------------
C
      SUBROUTINE UPDATE	(A,N,Z,SIG,W,IR,MK,EPS)
C				   SPECIFICATIONS FOR ARGUMENTS
      INTEGER  		N,IR,MK
      REAL		A(1),Z(N),SIG,W(N),EPS
C				   SPECIFICATIONS FOR LOCAL VARIABLES
      INTEGER  		J,JJ,IJ,JP1,I,II,MM
      REAL		ZERO,ONE,FOUR,TI,V,TIM,AL,R,B,GM,Y
      DATA		ZERO/0.0/,ONE/1.0/,FOUR/4.0/
C				   UPDATE FACTORS GIVEN	IN A
C				     SIG*Z*Z-TRANSPOSE IS ADDED
C				   FIRST EXECUTABLE STATEMENT
      IF (N.GT.1) GO TO	5
C				   N .EQ. 1
      A(1) = A(1)+SIG*Z(1)*Z(1)
      IR = 1
      IF (A(1).GT.ZERO)	GO TO 9005
      A(1) = ZERO
      IR = 0
      GO TO 9005
C				   N .GT. 1
    5 IF (SIG.GT.ZERO) GO TO 65
      IF (SIG.EQ.ZERO.OR.IR.EQ.0) GO TO	9005
      TI = ONE/SIG
      JJ = 0
      IF (MK.EQ.0) GO TO 15
C				   L*W = Z ON INPUT
      DO 10 J=1,N
	 JJ = JJ+J
	 IF (A(JJ).NE.ZERO) TI = TI+(W(J)*W(J))/A(JJ)
   10 CONTINUE
      GO TO 40
C				   SOLVE L*W = Z
   15 DO 20 J=1,N
	 W(J) =	Z(J)
   20 CONTINUE
      DO 35 J=1,N
	 JJ = JJ+J
	 V = W(J)
	 IF (A(JJ).GT.ZERO) GO TO 25
	 W(J) =	ZERO
	 GO TO 35
   25	 TI = TI+(V*V)/A(JJ)
	 IF (J.EQ.N) GO	TO 35
	 IJ = JJ
	 JP1 = J+1
	 DO 30 I=JP1,N
	    IJ = IJ+I-1
	    W(I) = W(I)-V*A(IJ)
   30	 CONTINUE
   35 CONTINUE
C				    SET	TI, TIM	AND W
   40 IF (IR.LE.0) GO TO 45
      IF (TI.GT.ZERO) GO TO 50
      IF (MK-1)	65,65,55
   45 TI = ZERO
      IR = -IR-1
      GO TO 55
   50 TI = EPS/SIG
      IF (EPS.EQ.ZERO) IR = IR-1
   55 TIM = TI
      II = JJ
      I	= N
      DO 60 J=1,N
	 IF (A(II).NE.ZERO) TIM	= TI-(W(I)*W(I))/A(II)
	 W(I) =	TI
	 TI = TIM
	 II = II-I
	 I = I-1
   60 CONTINUE
      MM = 1
      GO TO 70
   65 MM = 0
      TIM = ONE/SIG
   70 JJ = 0
C				   UPDATE A
      DO 110 J=1,N
	 JJ = JJ+J
	 IJ = JJ
	 JP1 = J+1
C				   UPDATE A(J,J)
	 V = Z(J)
	 IF (A(JJ).GT.ZERO) GO TO 85
C				   A(J,J) .EQ. ZERO
	 IF (IR.GT.0.OR.SIG.LT.ZERO.OR.V.EQ.ZERO) GO TO	80
	 IR = 1-IR
	 A(JJ) = (V*V)/TIM
	 IF (J.EQ.N) GO	TO 9005
	 DO 75 I=JP1,N
	    IJ = IJ+I-1
	    A(IJ) = Z(I)/V
   75	 CONTINUE
	 GO TO 9005
   80	 TI = TIM
	 GO TO 110
C				   A(J,J) .GT. ZERO
   85	 AL = V/A(JJ)
	 TI = W(J)
	 IF (MM.EQ.0) TI = TIM+V*AL
	 R = TI/TIM
	 A(JJ) = R*A(JJ)
	 IF (R.EQ.ZERO)	GO TO 115
	 IF (J.EQ.N) GO	TO 115
C				   UPDATE REMAINDER OF COLUMN J
	 B = AL/TI
	 IF (R.GT.FOUR)	GO TO 95
	 DO 90 I=JP1,N
	    IJ = IJ+I-1
	    Z(I) = Z(I)-V*A(IJ)
	    A(IJ) = A(IJ)+B*Z(I)
   90	 CONTINUE
	 GO TO 105
   95	 GM = TIM/TI
	 DO 100	I=JP1,N
	    IJ = IJ+I-1
	    Y =	A(IJ)
	    A(IJ) = B*Z(I)+Y*GM
	    Z(I) = Z(I)-V*Y
  100	 CONTINUE
  105	 TIM = TI
  110 CONTINUE
  115 IF (IR.LT.0) IR =	-IR
 9005 CONTINUE
      RETURN
      END
