 	SUBROUTINE LUDCMP(A,N,NP,INDX,D)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	IMPLICIT INTEGER (I-N)
	PARAMETER (NMAX=100,TINY=1.0E-20)
	DIMENSION A(NP,NP),INDX(N),VV(NMAX)
	D=1.0
	DO 12 I=1,N
		AAMAX=0.0
		DO 11 J=1,N
			IF (ABS(A(I,J)).GT.AAMAX) AAMAX=ABS(A(I,J))
 11			CONTINUE
	IF (AAMAX.EQ.0.0) PAUSE 'SINGLUAR MATRIX'
	VV(I)=1.0/AAMAX
 12	CONTINUE
	DO 19 J=1,N
		DO 14 I=1,J-1		
			SUM=A(I,J)
			DO 13 K=1,I-1
				temp=A(I,K)*A(K,J)
				SUM=SUM-TEMP
				if (sum.gt.1e180) then
					d=2.
					goto 20
				endif
 13			CONTINUE
		A(I,J)=SUM
 14		CONTINUE
	AAMAX=0.0
	DO 16 I=J,N
		SUM=A(I,J)
		DO 15 K=1,J-1
			SUM=SUM-A(I,K)*A(K,J)
			if (sum.gt.1e180) then
				d=2.
				goto 20
		    endif

 15		CONTINUE
	
		A(I,J)=SUM
		DUM=VV(I)*ABS(SUM)
		IF (DUM.GE.AAMAX) THEN
			IMAX=I
			AAMAX=DUM
		ENDIF
 16	CONTINUE
	IF (J.NE.IMAX) THEN
		DO 17 K=1,N
			UM=A(IMAX,K)
			A(IMAX,K)=A(J,K)
			A(J,K)=DUM
 17		CONTINUE
		D=-D
		VV(IMAX)=VV(J)
	ENDIF
	INDX(J)=IMAX
	IF(A(J,J).EQ.0.0) A(J,J)=TINY
	
	IF(J.NE.N) THEN
		DUM=1./A(J,J)
		DO 18 I=J+1,N
			A(I,J)=A(I,J)*DUM
 18		CONTINUE
	ENDIF
 19	CONTINUE
 20	RETURN
	END		
		

 	SUBROUTINE LUBKSB(A,N,NP,INDX,B)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	IMPLICIT INTEGER (I-N)
	DIMENSION A(NP,NP),INDX(N),B(N)
	II=0
	DO 12 I=1,N
		LL=INDX(I)
		SUM=B(LL)
		B(LL)=B(I)
		IF (II.NE.0) THEN
			DO 11 J=II,I-1
				SUM=SUM-A(I,J)*B(J)
 11			CONTINUE
		ELSE IF (SUM.NE.0.0) THEN
			II=1
		ENDIF
		B(I)=SUM
 12	CONTINUE

	DO 14 I=N,1,-1
		SUM=B(I)
		DO 13 J=I+1,N
			SUM=SUM-A(I,J)*B(J)
 13		CONTINUE
	B(I)=SUM/A(I,I)
 14	CONTINUE

	RETURN
	END		

C SUBROUTINE TO INVERT MATRIX A. THE RESULT IS PUT IN MATRIX Y.         
c det = determinant, 
c but be careful, as it might underflow!!
      SUBROUTINE INVERT(A,N,NP,INDX,TEMP,Y,det)                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
      DIMENSION A(NP,NP),TEMP(NP,NP),INDX(N),Y(NP,NP)  
      DO 12 I=1,N                                                       
         DO 11 J=1,N                                                    
            Y(I,J)=0.0                                                  
            TEMP(I,J) = A(I,J)                                          
  11     CONTINUE                                                       
         Y(I,I)=1.                                                      
  12  CONTINUE
      CALL LUDCMP(TEMP,N,NP,INDX,D)
	IF (D.EQ.2.) THEN
	 DET=2.
	 GO TO 14 	     
	ENDIF
	                               
      DO 13 J=1,N
        d = d+log(abs(temp(j,j)))
        CALL LUBKSB(TEMP,N,NP,INDX,Y(1,J)) 
  13  CONTINUE        
      det = d
  14  RETURN                                                            
      END 

	SUBROUTINE DET(A,N,NP,INDX,D)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	IMPLICIT INTEGER (I-N)

	DIMENSION A(NP,NP),INDX(NP)

	CALL LUDCMP(A,N,NP,INDX,D)
	D=0.
	DO 11 J=1,N
		D=D+LOG(A(J,J))
 11	CONTINUE
	RETURN
	END

	

 
